/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.menus;

import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.lib.LibFile;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.dialogs.About;
import com.sun.electric.tool.user.help.ManualViewer;
import com.sun.electric.tool.user.menus.FileMenu;
import com.sun.electric.tool.user.menus.MenuBar;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;

public class HelpMenu {
    protected static MenuBar.Menu addHelpMenu(MenuBar menuBar) {
        int buckyBit = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        MenuBar.Menu helpMenu = MenuBar.makeMenu("_Help");
        menuBar.add(helpMenu);
        if (TopLevel.getOperatingSystem() != TopLevel.OS.MACINTOSH) {
            helpMenu.addMenuItem("_About Electric...", null, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    HelpMenu.aboutCommand();
                }
            });
            helpMenu.addSeparator();
        }
        helpMenu.addMenuItem("_User's Manual...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ManualViewer.userManualCommand();
            }
        });
        MenuBar.Menu samplesSubMenu = MenuBar.makeMenu("_Samples");
        helpMenu.add(samplesSubMenu);
        samplesSubMenu.addMenuItem("_Load Library", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ManualViewer.loadSamplesLibrary();
            }
        });
        samplesSubMenu.addMenuItem("_3D View of Sample Cell", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ManualViewer.open3DSample();
            }
        });
        samplesSubMenu.addMenuItem("_Animate Sample Cell", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ManualViewer.animate3DSample();
            }
        });
        MenuBar.Menu builtInLibSubMenu = MenuBar.makeMenu("Load _Built-in Libraries");
        helpMenu.add(builtInLibSubMenu);
        builtInLibSubMenu.addMenuItem("_MOSIS CMOS Pads", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelpMenu.loadBuiltInLibraryCommand("pads4u");
            }
        });
        builtInLibSubMenu.addMenuItem("MI_PS Cells", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelpMenu.loadBuiltInLibraryCommand("mipscells");
            }
        });
        return helpMenu;
    }

    public static void aboutCommand() {
        About dialog = new About((Frame)TopLevel.getCurrentJFrame(), true);
        dialog.setVisible(true);
    }

    private static void loadBuiltInLibraryCommand(String libName) {
        if (Library.findLibrary(libName) != null) {
            return;
        }
        URL url = LibFile.getLibFile(libName + ".jelib");
        FileMenu.ReadLibrary job = new FileMenu.ReadLibrary(url, FileType.JELIB, null);
    }
}

