/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.Tech;
import com.sun.electric.tool.generator.layout.TrackRouter;
import com.sun.electric.tool.generator.layout.ViaStack;

public class TrackRouterV
extends TrackRouter {
    public TrackRouterV(ArcProto lay, double wid, Cell parnt) {
        super(lay, wid, parnt);
    }

    public TrackRouterV(ArcProto lay, double wid, double centerVal, Cell parnt) {
        super(lay, wid, centerVal, parnt);
    }

    public void connect(PortInst newPort, double viaOffset, double wireOffset) {
        TrackRouterV.error(newPort == null, "can't connect to null port");
        if (this.center == null) {
            this.center = new Double(LayoutLib.roundCenterX(newPort));
        }
        ArcProto portLyr = Tech.closestLayer(newPort.getPortProto(), this.layer);
        double newWid = LayoutLib.widestWireWidth(newPort);
        if (newWid == -1.0) {
            newWid = portLyr.getWidth();
        }
        double y = LayoutLib.roundCenterY(newPort) + viaOffset;
        PortInst lastPort = null;
        ViaStack closeVia = this.findClosestVia(y, portLyr);
        if (closeVia != null) {
            lastPort = closeVia.getPort2();
        } else {
            ViaStack vs = new ViaStack(this.layer, portLyr, this.center, y, this.width, newWid, this.parent);
            this.insertVia(vs);
            lastPort = vs.getPort2();
        }
        if (wireOffset != 0.0) {
            PrimitiveNode pin = portLyr.findOverridablePinProto();
            double defSz = Double.POSITIVE_INFINITY;
            NodeInst pinInst = LayoutLib.newNodeInst(pin, this.center + wireOffset, LayoutLib.roundCenterY(lastPort), defSz, defSz, 0.0, this.parent);
            PortInst jog = pinInst.getOnlyPortInst();
            LayoutLib.newArcInst(portLyr, newWid, lastPort, jog);
            lastPort = jog;
        }
        LayoutLib.newArcInst(portLyr, newWid, lastPort, newPort);
    }
}

