/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.menus;

import com.sun.electric.database.Cell_;
import com.sun.electric.database.DatabaseChangeThread;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.geometry.PolyMerge;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.NodeUsage;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.ImmutableTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.MoCMOS;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.erc.ERCWellCheck;
import com.sun.electric.tool.generator.layout.GateRegression;
import com.sun.electric.tool.generator.layout.IvanFlat;
import com.sun.electric.tool.generator.layout.LayFlat;
import com.sun.electric.tool.generator.layout.Test;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.logicaleffort.LENetlister1;
import com.sun.electric.tool.simulation.AnalogSignal;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.simulation.interval.Diode;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.Clipboard;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.ExecDialog;
import com.sun.electric.tool.user.menus.MenuBar;
import com.sun.electric.tool.user.menus.ToolMenu;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WaveformWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.tool.user.ui.ZoomAndPanListener;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;

public class DebugMenus {
    private static ArrayList sharedList = new ArrayList();
    private static int[] objs;
    private static int[] vobjs;
    private static int[] vobjs1;
    private static int[] vcnt;
    private static int numPoints;
    private static HashSet points;
    private static HashSet descriptors;

    protected static void addDebugMenus(MenuBar menuBar, MenuBar.Menu helpMenu) {
        helpMenu.addSeparator();
        helpMenu.addMenuItem("Make fake circuitry MoCMOS", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenus.makeFakeCircuitryCommand("mocmos", true);
            }
        });
        if (Technology.getTSMC90Technology() != null) {
            helpMenu.addMenuItem("Make fake circuitry TSMC90", null, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DebugMenus.makeFakeCircuitryCommand("tsmc90", true);
                }
            });
        }
        helpMenu.addMenuItem("Make fake analog simulation window", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenus.makeFakeWaveformCommand();
            }
        });
        helpMenu.addMenuItem("Make fake interval simulation window", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenus.makeFakeIntervalWaveformCommand();
            }
        });
        MenuBar.Menu russMenu = MenuBar.makeMenu("_Russell");
        menuBar.add(russMenu);
        russMenu.addMenuItem("Gate Generator Regression (MoCMOS)", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new GateRegression(MoCMOS.tech);
            }
        });
        if (Technology.getTSMC90Technology() != null) {
            russMenu.addMenuItem("Gate Generator Regression (TSMC90)", null, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    new GateRegression(Technology.getTSMC90Technology());
                }
            });
        }
        russMenu.addMenuItem("create flat netlists for Ivan", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new IvanFlat();
            }
        });
        russMenu.addMenuItem("layout flat", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new LayFlat();
            }
        });
        russMenu.addMenuItem("Random Test", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new Test();
            }
        });
        MenuBar.Menu jongMenu = MenuBar.makeMenu("_JonG");
        menuBar.add(jongMenu);
        jongMenu.addMenuItem("Describe Vars", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenus.listVarsOnObject(false);
            }
        });
        jongMenu.addMenuItem("Describe Proto Vars", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenus.listVarsOnObject(true);
            }
        });
        jongMenu.addMenuItem("Describe Current Library Vars", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenus.listLibVars();
            }
        });
        jongMenu.addMenuItem("Eval Vars", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenus.evalVarsOnObject();
            }
        });
        jongMenu.addMenuItem("LE test1", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LENetlister1.test1();
            }
        });
        jongMenu.addMenuItem("Display shaker", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenus.shakeDisplay();
            }
        });
        jongMenu.addMenuItem("Run command", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenus.runCommand();
            }
        });
        jongMenu.addMenuItem("Start defunct Job", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenus.startDefunctJob();
            }
        });
        jongMenu.addMenuItem("Add String var", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenus.addStringVar();
            }
        });
        jongMenu.addMenuItem("Edit clipboard", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Clipboard.editClipboard();
            }
        });
        jongMenu.addMenuItem("Cause stack overflow", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenus.causeStackOverflow(true, false, "blah", 234, "xvsdf");
            }
        });
        jongMenu.addMenuItem("Cause stack overflow in Job", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenus.causeStackOverflowJob();
            }
        });
        jongMenu.addMenuItem("Time method calls", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenus.timeMethodCalls();
            }
        });
        jongMenu.addMenuItem("Delete layout cells in current library", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenus.deleteCells(View.LAYOUT);
            }
        });
        if (Technology.getTSMC90Technology() != null) {
            jongMenu.addMenuItem("fill generator 90nm test", null, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DebugMenus.invokeTSMC90FillGenerator();
                }
            });
        }
        MenuBar.Menu gildaMenu = MenuBar.makeMenu("_Gilda");
        menuBar.add(gildaMenu);
        gildaMenu.addMenuItem("DRC QTree", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DRC.checkHierarchically(false, 1);
            }
        });
        gildaMenu.addMenuItem("DRC Sweep", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DRC.checkHierarchically(false, 2);
            }
        });
        gildaMenu.addMenuItem("Test Bash", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenus.testBash();
            }
        });
        gildaMenu.addMenuItem("3D View", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenus.threeViewCommand();
            }
        });
        gildaMenu.addMenuItem("Parasitic", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.parasiticCommand();
            }
        });
        gildaMenu.addMenuItem("Check Wells Sweep", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ERCWellCheck.analyzeCurCell(2);
            }
        });
        gildaMenu.addMenuItem("Check Wells Orig", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ERCWellCheck.analyzeCurCell(0);
            }
        });
        gildaMenu.addMenuItem("Check Wells QTree", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ERCWellCheck.analyzeCurCell(1);
            }
        });
        gildaMenu.addMenuItem("List Geometry on Network SWEEP", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.listGeometryOnNetworkCommand(2);
            }
        });
        gildaMenu.addMenuItem("Merge Polyons qTree", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.layerCoverageCommand(Job.Type.CHANGE, 1, 1);
            }
        });
        gildaMenu.addMenuItem("Merge Polyons Sweep", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.layerCoverageCommand(Job.Type.CHANGE, 1, 2);
            }
        });
        gildaMenu.addMenuItem("Covering Implants qTree", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.layerCoverageCommand(Job.Type.CHANGE, 2, 1);
            }
        });
        gildaMenu.addMenuItem("Covering Implants Sweep", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.layerCoverageCommand(Job.Type.CHANGE, 2, 2);
            }
        });
        gildaMenu.addMenuItem("Covering Implants Old", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenus.implantGeneratorCommand(false, false);
            }
        });
        gildaMenu.addMenuItem("Generate Fake Nodes", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenus.genFakeNodes();
            }
        });
        gildaMenu.addMenuItem("List Layer Coverage", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.layerCoverageCommand(Job.Type.EXAMINE, 0, 2);
            }
        });
        MenuBar.Menu dimaMenu = MenuBar.makeMenu("_Dima");
        menuBar.add(dimaMenu);
        dimaMenu.addMenuItem("Plot diode", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Diode.plotDiode(User.getWorkingDirectory() + File.separator + "diode.raw");
            }
        });
        dimaMenu.addMenuItem("Var stat", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenus.varStatistics();
            }
        });
        dimaMenu.addMenuItem("Transactional", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenus.transactionalTest();
            }
        });
    }

    public static void makeFakeCircuitryCommand(String tech, boolean asJob) {
        if (asJob) {
            MakeFakeCircuitry makeFakeCircuitry = new MakeFakeCircuitry(tech);
        } else {
            MakeFakeCircuitry.doItInternal(tech);
        }
    }

    public static void makeFakeCircuitryForCoverageCommand(String tech, boolean asJob) {
        if (asJob) {
            FakeCoverageCircuitry fakeCoverageCircuitry = new FakeCoverageCircuitry(tech);
        } else {
            FakeCoverageCircuitry.doItInternal(tech);
        }
    }

    public static void makeFakeWaveformCommand() {
        int i;
        Stimuli sd = new Stimuli();
        double timeStep = 1.0E-10;
        sd.buildCommonTime(100);
        for (i = 0; i < 100; ++i) {
            sd.setCommonTime(i, (double)i * timeStep);
        }
        for (i = 0; i < 18; ++i) {
            AnalogSignal as = new AnalogSignal(sd);
            as.setSignalName("Signal" + (i + 1));
            as.buildValues(100);
            for (int k = 0; k < 100; ++k) {
                as.setValue(k, Math.sin((double)(k + i * 10) / (2.0 + (double)(i * 2))) * 4.0);
            }
        }
        sd.setCell(null);
        WindowFrame wf = WindowFrame.createWaveformWindow(sd);
        WaveformWindow ww = (WaveformWindow)wf.getContent();
        ww.setMainTimeCursor(timeStep * 22.0);
        ww.setExtensionTimeCursor(timeStep * 77.0);
        ww.setDefaultTimeRange(0.0, timeStep * 100.0);
        for (int i2 = 0; i2 < 6; ++i2) {
            WaveformWindow.Panel wp = new WaveformWindow.Panel(ww, true);
            wp.setValueRange(-5.0, 5.0);
            for (int j = 0; j < (i2 + 1) * 3; ++j) {
                AnalogSignal as = (AnalogSignal)sd.getSignals().get(j);
                WaveformWindow.WaveSignal wsig = new WaveformWindow.WaveSignal(wp, as);
            }
        }
    }

    private static void makeFakeIntervalWaveformCommand() {
        int k;
        int i;
        Stimuli sd = new Stimuli();
        double timeStep = 1.0E-10;
        sd.buildCommonTime(100);
        for (i = 0; i < 100; ++i) {
            sd.setCommonTime(i, (double)i * timeStep);
        }
        for (i = 0; i < 6; ++i) {
            AnalogSignal as = new AnalogSignal(sd);
            as.setSignalName("Signal" + (i + 1));
            as.buildIntervalValues(100);
            for (k = 0; k < 100; ++k) {
                double lowValue = Math.sin((double)(k + i * 10) / (2.0 + (double)(i * 2))) * 4.0;
                double increment = Math.sin((double)(k + i * 5) / (2.0 + (double)i));
                as.setIntervalValue(k, lowValue, lowValue + increment);
            }
        }
        sd.setCell(null);
        WindowFrame wf = WindowFrame.createWaveformWindow(sd);
        WaveformWindow ww = (WaveformWindow)wf.getContent();
        ww.setMainTimeCursor(timeStep * 22.0);
        ww.setExtensionTimeCursor(timeStep * 77.0);
        ww.setDefaultTimeRange(0.0, timeStep * 100.0);
        k = 0;
        for (int i2 = 0; i2 < 3; ++i2) {
            WaveformWindow.Panel wp = new WaveformWindow.Panel(ww, true);
            wp.setValueRange(-5.0, 5.0);
            for (int j = 0; j <= i2; ++j) {
                AnalogSignal as = (AnalogSignal)sd.getSignals().get(k++);
                WaveformWindow.WaveSignal wsig = new WaveformWindow.WaveSignal(wp, as);
            }
        }
    }

    public static void testBash() {
        System.out.println("Num Log" + Input.errorLogger.getNumLogs() + NetworkTool.errorLogger.getNumLogs());
    }

    public static void threeViewCommand() {
        Class three3DViewDialog = Resources.get3DClass("J3DViewDialog");
        if (three3DViewDialog == null) {
            return;
        }
        try {
            Method createDialog = three3DViewDialog.getDeclaredMethod("create3DViewDialog", Frame.class);
            createDialog.invoke((Object)three3DViewDialog, TopLevel.getCurrentJFrame());
        }
        catch (Exception e) {
            System.out.println("Can't open 3D Dialog window: " + e.getMessage());
            ActivityLogger.logException(e);
        }
    }

    public static void genFakeNodes() {
        DebugMenus.makeFakeCircuitryForCoverageCommand("tsmc90", true);
    }

    public static void implantGeneratorCommand(boolean newIdea, boolean test) {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        CoverImplantOld job = new CoverImplantOld(curCell, wnd.getHighlighter());
    }

    private static void invokeTSMC90FillGenerator() {
        try {
            Class<?> tsmc90FillGeneratorClass = Class.forName("com.sun.electric.plugins.tsmc90.fill90nm.FillGenerator90");
            Class[] parameterTypes = new Class[]{};
            Method testMethod = tsmc90FillGeneratorClass.getDeclaredMethod("test", parameterTypes);
            testMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            System.out.println("ERROR invoking the Fill Generator test");
        }
    }

    public static void listVarsOnObject(boolean useproto) {
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        if (wnd.getHighlighter().getNumHighlights() == 0) {
            WindowFrame wf = WindowFrame.getCurrentWindowFrame();
            if (wf == null) {
                return;
            }
            Cell cell = wf.getContent().getCell();
            cell.getInfo();
            return;
        }
        Iterator it = wnd.getHighlighter().getHighlights().iterator();
        while (it.hasNext()) {
            Highlight h = (Highlight)it.next();
            if (h.getType() != Highlight.Type.EOBJ) continue;
            ElectricObject eobj = h.getElectricObject();
            if (eobj instanceof PortInst) {
                PortInst pi = (PortInst)eobj;
                pi.getInfo();
                eobj = pi.getNodeInst();
            }
            if (!(eobj instanceof NodeInst)) continue;
            NodeInst ni = (NodeInst)eobj;
            if (useproto) {
                System.out.println("using prototype");
                if (!(ni.getProto() instanceof Cell)) continue;
                ((Cell)ni.getProto()).getInfo();
                continue;
            }
            ni.getInfo();
        }
    }

    public static void evalVarsOnObject() {
        EditWindow curEdit = EditWindow.needCurrent();
        if (curEdit == null) {
            return;
        }
        if (curEdit.getHighlighter().getNumHighlights() == 0) {
            return;
        }
        Iterator it = curEdit.getHighlighter().getHighlights().iterator();
        while (it.hasNext()) {
            Highlight h = (Highlight)it.next();
            if (h.getType() != Highlight.Type.EOBJ) continue;
            ElectricObject eobj = h.getElectricObject();
            Iterator itVar = eobj.getVariables();
            while (itVar.hasNext()) {
                Variable var = (Variable)itVar.next();
                Object obj = curEdit.getVarContext().evalVar(var);
                System.out.print(var.getKey().getName() + ": ");
                System.out.println(obj);
            }
        }
    }

    public static void listLibVars() {
        Library lib = Library.getCurrent();
        Iterator itVar = lib.getVariables();
        System.out.println("----------" + lib + " Vars-----------");
        while (itVar.hasNext()) {
            Variable var = (Variable)itVar.next();
            Object obj = VarContext.globalContext.evalVar(var);
            System.out.println(var.getKey().getName() + ": " + obj);
        }
    }

    public static void addStringVar() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        if (wnd.getHighlighter().getNumHighlights() == 0) {
            return;
        }
        Iterator it = wnd.getHighlighter().getHighlights().iterator();
        while (it.hasNext()) {
            Highlight h = (Highlight)it.next();
            if (h.getType() != Highlight.Type.EOBJ) continue;
            ElectricObject eobj = h.getElectricObject();
            AddStringVar job = new AddStringVar(eobj);
            break;
        }
    }

    public static void causeStackOverflow(boolean x, boolean y, String l, int r, String f) {
        DebugMenus.causeStackOverflow(x, y, l, r, f);
    }

    public static void causeStackOverflowJob() {
        StackOverflowJob job = new StackOverflowJob();
    }

    public static void shakeDisplay() {
        long startTime = System.currentTimeMillis();
        EditWindow wnd = EditWindow.getCurrent();
        for (int i = 0; i < 100; ++i) {
        }
        long endTime = System.currentTimeMillis();
        StringBuffer buf = new StringBuffer();
        Date start = new Date(startTime);
        buf.append("  start time: " + start + "\n");
        Date end = new Date(endTime);
        buf.append("  end time: " + end + "\n");
        long time = endTime - startTime;
        buf.append("  time taken: " + TextUtils.getElapsedTime(time) + "\n");
        System.out.println(buf.toString());
    }

    public static void startDefunctJob() {
        DefunctJob j = new DefunctJob();
    }

    private static void changeSharedList() {
        Object o = sharedList.get(0);
    }

    public static void timeMethodCalls() {
        int i;
        TestObject obj = new TestObject();
        int limit = 500000;
        long start = System.currentTimeMillis();
        for (i = 0; i < limit; ++i) {
            obj.getCount();
        }
        System.out.println("Baseline case: " + TextUtils.getElapsedTime(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        for (i = 0; i < limit; ++i) {
            obj.getCountSync();
        }
        System.out.println("Synchronized case: " + TextUtils.getElapsedTime(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        for (i = 0; i < limit; ++i) {
            obj.getCountExamineCheck();
        }
        System.out.println("Checking case (no sync): " + TextUtils.getElapsedTime(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        for (i = 0; i < limit; ++i) {
            obj.getCountExamineLock();
        }
        System.out.println("Locking case (no sync): " + TextUtils.getElapsedTime(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        for (i = 0; i < limit; ++i) {
            obj.getCountJob();
        }
        System.out.println("Job case: " + TextUtils.getElapsedTime(System.currentTimeMillis() - start));
    }

    public static void runCommand() {
        ExecDialog d = new ExecDialog((Frame)TopLevel.getCurrentJFrame(), false);
        File dir = new File("/home/gainsley");
        d.startProcess("/bin/tcsh", null, dir);
    }

    public static void deleteCells(View view) {
        Library lib = Library.getCurrent();
        int deleted = 0;
        int notDeleted = 0;
        Iterator it = lib.getCells();
        while (it.hasNext()) {
            Cell cell = (Cell)it.next();
            if (cell.getView() != view) continue;
            if (CircuitChanges.deleteCell(cell, false)) {
                ++deleted;
                continue;
            }
            ++notDeleted;
        }
        System.out.println("Deleted: " + deleted);
        System.out.println("Not deleted: " + notDeleted);
    }

    private static void varStatistics() {
        int subCells = 0;
        int cellUsages = 0;
        long cellSqr = 0L;
        int primUsages = 0;
        long primSqr = 0L;
        int namedArcs = 0;
        int namedNodes = 0;
        int sameLocations = 0;
        objs = new int[96];
        vobjs = new int[96];
        vobjs1 = new int[96];
        vcnt = new int[96];
        points = new HashSet();
        descriptors = new HashSet();
        numPoints = 0;
        TreeSet nodeNames = new TreeSet();
        TreeSet arcNames = new TreeSet();
        Iterator lIt = Library.getLibraries();
        while (lIt.hasNext()) {
            Library lib = (Library)lIt.next();
            DebugMenus.countVars('H', lib);
            Iterator cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = (Cell)cIt.next();
                DebugMenus.countVars('C', cell);
                TreeSet<String> cellNodes = new TreeSet<String>();
                TreeSet<String> cellArcs = new TreeSet<String>();
                Iterator uIt = cell.getUsagesIn();
                while (uIt.hasNext()) {
                    NodeUsage nu = (NodeUsage)uIt.next();
                    if (nu.getProto() instanceof Cell) {
                        ++cellUsages;
                        cellSqr += (long)(nu.getNumInsts() * nu.getNumInsts());
                        continue;
                    }
                    ++primUsages;
                    primSqr += (long)(nu.getNumInsts() * nu.getNumInsts());
                }
                Iterator nIt = cell.getNodes();
                while (nIt.hasNext()) {
                    NodeInst ni = (NodeInst)nIt.next();
                    DebugMenus.countVars('N', ni);
                    if (ni.getProto() instanceof Cell) {
                        ++subCells;
                    }
                    if (ni.isUsernamed()) {
                        ++namedNodes;
                    }
                    cellNodes.add(ni.getName());
                    if (ni.isUsernamed()) {
                        DebugMenus.countDescriptor(ni.getTextDescriptor(NodeInst.NODE_NAME_TD), true, null);
                    }
                    if (ni.getProto() instanceof Cell) {
                        DebugMenus.countDescriptor(ni.getTextDescriptor(NodeInst.NODE_PROTO_TD), true, null);
                    }
                    DebugMenus.countPoint(ni.getAnchorCenter());
                    Iterator pIt = ni.getPortInsts();
                    while (pIt.hasNext()) {
                        PortInst pi = (PortInst)pIt.next();
                        DebugMenus.countVars('P', pi);
                    }
                }
                Iterator aIt = cell.getArcs();
                while (aIt.hasNext()) {
                    ArcInst ai = (ArcInst)aIt.next();
                    DebugMenus.countVars('A', ai);
                    if (ai.isUsernamed()) {
                        ++namedArcs;
                    }
                    cellArcs.add(ai.getName());
                    if (ai.isUsernamed()) {
                        DebugMenus.countDescriptor(ai.getTextDescriptor(ArcInst.ARC_NAME_TD), true, null);
                    }
                    for (int i = 0; i < 2; ++i) {
                        EPoint p = ai.getLocation(i);
                        if (ai.getPortInst(i).getNodeInst().getAnchorCenter().equals(p)) {
                            ++sameLocations;
                        }
                        DebugMenus.countPoint(p);
                    }
                }
                Iterator eIt = cell.getPorts();
                while (eIt.hasNext()) {
                    Export e = (Export)eIt.next();
                    DebugMenus.countDescriptor(e.getTextDescriptor(Export.EXPORT_NAME_TD), true, null);
                    DebugMenus.countVars('E', e);
                }
                nodeNames.addAll(cellNodes);
                arcNames.addAll(cellArcs);
            }
        }
        int o = 0;
        int v = 0;
        int v1 = 0;
        int c = 0;
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] == 0) continue;
            System.out.println((char)i + " " + objs[i] + " " + vobjs[i] + " " + vobjs1[i] + " " + vcnt[i]);
            o += objs[i];
            v += vobjs[i];
            v1 += vobjs1[i];
            c += vcnt[i];
        }
        System.out.println(o + " " + v + " " + v1 + " " + c);
        if (cellUsages != 0) {
            System.out.println(subCells + " subcells " + cellUsages + " cellUsages " + (double)subCells / (double)cellUsages + " " + Math.sqrt((double)cellSqr / (double)cellUsages));
        }
        int prims = objs[78] - subCells;
        if (primUsages != 0) {
            System.out.println(prims + " prims " + primUsages + " primUsages " + (double)prims / (double)primUsages + " " + Math.sqrt((double)primSqr / (double)primUsages));
        }
        System.out.println(namedNodes + " named nodes " + nodeNames.size());
        System.out.println(namedArcs + " named arcs " + arcNames.size());
        System.out.println(sameLocations + " same locations");
        System.out.println(numPoints + " points " + points.size());
        HashSet<Double> doubles = new HashSet<Double>();
        Iterator it = points.iterator();
        while (it.hasNext()) {
            Point2D point = (Point2D)it.next();
            doubles.add(new Double(point.getX()));
            doubles.add(new Double(point.getY()));
        }
        int whole = 0;
        int quarter = 0;
        Iterator it2 = doubles.iterator();
        while (it2.hasNext()) {
            double d = (Double)it2.next();
            double rd = Math.rint(d);
            if (d == Math.rint(d)) {
                ++whole;
                continue;
            }
            if (d * 4.0 != Math.rint(d * 4.0)) continue;
            ++quarter;
        }
        System.out.println(doubles.size() + " doubles " + whole + " whole " + quarter + " quarter");
        System.out.println(descriptors.size() + " descriptors. cacheSize=" + ImmutableTextDescriptor.cacheSize());
    }

    private static void countVars(char type, ElectricObject eObj) {
        char c;
        char c2 = c = type;
        objs[c2] = objs[c2] + 1;
        int numVars = eObj.getNumVariables();
        if (numVars == 0) {
            return;
        }
        char c3 = c;
        vobjs[c3] = vobjs[c3] + 1;
        if (numVars == 1) {
            char c4 = c;
            vobjs1[c4] = vobjs1[c4] + 1;
        }
        char c5 = c;
        vcnt[c5] = vcnt[c5] + numVars;
        Iterator it = eObj.getVariables();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            DebugMenus.countDescriptor(var.getTextDescriptor(), var.isDisplay(), var.getCode());
            Object value = var.getObject();
            if (value instanceof Point2D) {
                DebugMenus.countPoint((Point2D)value);
                continue;
            }
            if (!(value instanceof Point2D[])) continue;
            Point2D[] points = (Point2D[])value;
            for (int i = 0; i < points.length; ++i) {
                DebugMenus.countPoint(points[i]);
            }
        }
    }

    private static void countPoint(Point2D point) {
        double x = DBMath.round(point.getX());
        if (x == 0.0) {
            x = 0.0;
        }
        double y = DBMath.round(point.getY());
        if (x == 0.0) {
            x = 0.0;
        }
        point = new Point2D.Double(x, y);
        ++numPoints;
        points.add(point);
    }

    private static void countDescriptor(TextDescriptor td, boolean display, TextDescriptor.Code code) {
        if (code == null) {
            code = TextDescriptor.Code.NONE;
        }
        descriptors.add(td);
    }

    private static void transactionalTest() {
        new DatabaseTestThread().start();
    }

    private static void print(Snapshot s) {
        PrintWriter out = new PrintWriter(System.out, true);
        int maxCellId = s.maxCellId();
        for (int cellId = 0; cellId <= maxCellId; ++cellId) {
            ImmutableCell cell = s.getCellById(cellId);
            if (cell == null) continue;
            out.println(cellId + " cell " + cell.name);
            int maxNodeId = cell.maxNodeId();
            for (int nodeId = 0; nodeId <= maxNodeId; ++nodeId) {
                ImmutableNodeInst node = cell.getNodeById(nodeId);
                if (node == null) continue;
                out.println(nodeId + "\tnode " + node.name + " " + node.protoId + " " + node.anchor);
            }
        }
        out.println("----");
        out.flush();
    }

    private static class DatabaseTestThread
    extends DatabaseChangeThread {
        private Snapshot s = null;

        private DatabaseTestThread() {
        }

        private void show() {
            this.check();
            this.s = this.backup(this.s);
            DebugMenus.print(this.s);
        }

        public void run() {
            Cell_ cell = Cell_.newInstance("c0");
            this.show();
            Cell_ cell1 = Cell_.newInstance("c1");
            this.show();
            cell.setName("c2");
            this.show();
            cell.newNode(cell1, Name.findName("n0"), EPoint.ORIGIN);
            this.show();
        }
    }

    private static class TestObject {
        private int count = 0;
        private final Object mutex = new Object();

        private TestObject() {
        }

        private final int getCount() {
            return this.count;
        }

        private synchronized int getCountSync() {
            return this.count;
        }

        private int getCountExamineCheck() {
            Job.checkExamine();
            return this.count;
        }

        private int getCountExamineLock() {
            Job.acquireExamineLock(false);
            try {
                Job.releaseExamineLock();
            }
            catch (Error e) {
                Job.releaseExamineLock();
            }
            return this.count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getCountJob() {
            CountJob job = new CountJob(this.mutex);
            Object object = this.mutex;
            synchronized (object) {
                job.startJob(false, true);
                try {
                    this.mutex.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.count;
        }

        private static class CountJob
        extends Job {
            private final Object mutex;

            private CountJob(Object mutex) {
                super("CountJob", User.getUserTool(), Job.Type.EXAMINE, null, null, Job.Priority.USER);
                this.mutex = mutex;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean doIt() {
                Object object = this.mutex;
                synchronized (object) {
                    this.mutex.notify();
                }
                return true;
            }
        }
    }

    private static class DefunctJob
    extends Job {
        public DefunctJob() {
            super("Defunct Job", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.startJob();
        }

        public boolean doIt() {
            while (true) {
                DebugMenus.changeSharedList();
            }
        }
    }

    private static class RedisplayTest
    extends Job {
        private long delayTimeMS;

        private RedisplayTest(long delayTimeMS) {
            super("RedisplayTest", User.getUserTool(), Job.Type.EXAMINE, null, null, Job.Priority.USER);
            this.delayTimeMS = delayTimeMS;
            this.startJob();
        }

        public boolean doIt() {
            Random rand = new Random(143137493L);
            for (int i = 0; i < 200; ++i) {
                if (this.getScheduledToAbort()) {
                    return false;
                }
                WindowFrame wf = WindowFrame.getCurrentWindowFrame();
                int next = i % 4;
                switch (next) {
                    case 0: {
                        ZoomAndPanListener.panXOrY(0, wf, 1);
                        break;
                    }
                    case 1: {
                        ZoomAndPanListener.panXOrY(1, wf, 1);
                        break;
                    }
                    case 2: {
                        ZoomAndPanListener.panXOrY(0, wf, -1);
                        break;
                    }
                    case 3: {
                        ZoomAndPanListener.panXOrY(1, wf, -1);
                    }
                }
                this.doWait();
            }
            System.out.println(this.getInfo());
            return true;
        }

        private void doWait() {
            try {
                boolean donesleeping = false;
                while (!donesleeping) {
                    Thread.sleep(this.delayTimeMS);
                    donesleeping = true;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static class RedrawTest
    extends Job {
        private RedrawTest() {
            super("RedrawTest", User.getUserTool(), Job.Type.EXAMINE, null, null, Job.Priority.USER);
            this.startJob();
        }

        public boolean doIt() {
            long startTime = System.currentTimeMillis();
            EditWindow wnd = EditWindow.getCurrent();
            for (int i = 0; i < 100; ++i) {
                if (!this.getScheduledToAbort()) continue;
                return false;
            }
            long endTime = System.currentTimeMillis();
            StringBuffer buf = new StringBuffer();
            Date start = new Date(startTime);
            buf.append("  start time: " + start + "\n");
            Date end = new Date(endTime);
            buf.append("  end time: " + end + "\n");
            long time = endTime - startTime;
            buf.append("  time taken: " + TextUtils.getElapsedTime(time) + "\n");
            System.out.println(buf.toString());
            return true;
        }

        private void doWait() {
            try {
                boolean donesleeping = false;
                while (!donesleeping) {
                    Thread.sleep(100L);
                    donesleeping = true;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static class StackOverflowJob
    extends Job {
        private StackOverflowJob() {
            super("overflow", User.getUserTool(), Job.Type.EXAMINE, null, null, Job.Priority.USER);
            this.startJob();
        }

        public boolean doIt() {
            this.dosomething(true, "asfjka;dj");
            return true;
        }

        private void dosomething(boolean b, String str) {
            this.dosomething(b, str);
        }
    }

    private static class AddStringVar
    extends Job {
        private ElectricObject eobj;

        private AddStringVar(ElectricObject eobj) {
            super("AddStringVar", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.eobj = eobj;
            this.startJob();
        }

        public boolean doIt() {
            this.eobj.newVar("ATTR_XXX", (Object)"1");
            System.out.println("Added var ATTR_XXX as String \"1\"");
            return true;
        }
    }

    private static class CoverImplantOld
    extends Job {
        private Cell curCell;
        private Highlighter highlighter;

        protected CoverImplantOld(Cell cell, Highlighter highlighter) {
            super("Coverage Implant Old", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.curCell = cell;
            this.highlighter = highlighter;
            this.setReportExecutionFlag(true);
            this.startJob();
        }

        public boolean doIt() {
            PolyBase poly;
            Poly[] polyList;
            Technology tech;
            PolyMerge merge = new PolyMerge();
            ArrayList<NodeInst> deleteList = new ArrayList<NodeInst>();
            HashMap<Layer, ArrayList<PolyBase>> allLayers = new HashMap<Layer, ArrayList<PolyBase>>();
            Iterator it = this.curCell.getArcs();
            while (it.hasNext()) {
                ArcInst arc = (ArcInst)it.next();
                ArcProto arcType = arc.getProto();
                tech = arcType.getTechnology();
                polyList = tech.getShapeOfArc(arc);
                for (int i = 0; i < polyList.length; ++i) {
                    Poly poly2 = polyList[i];
                    Layer layer = poly2.getLayer();
                    Layer.Function func = layer.getFunction();
                    if (!func.isSubstrate()) continue;
                    merge.addPolygon(layer, poly2);
                    ArrayList<Poly> rectList = (ArrayList<Poly>)allLayers.get(layer);
                    if (rectList == null) {
                        rectList = new ArrayList<Poly>();
                        allLayers.put(layer, rectList);
                    }
                    rectList.add(poly2);
                }
            }
            it = this.curCell.getNodes();
            while (it.hasNext()) {
                NodeInst node = (NodeInst)it.next();
                if (node.isPrimtiveSubstrateNode()) {
                    deleteList.add(node);
                    continue;
                }
                NodeProto protoType = node.getProto();
                if (protoType instanceof Cell) continue;
                tech = protoType.getTechnology();
                polyList = tech.getShapeOfNode(node);
                AffineTransform transform = node.rotateOut();
                for (int i = 0; i < polyList.length; ++i) {
                    poly = polyList[i];
                    Layer layer = poly.getLayer();
                    Layer.Function func = layer.getFunction();
                    if (!func.isSubstrate()) continue;
                    poly.transform(transform);
                    merge.addPolygon(layer, poly);
                    ArrayList<PolyBase> rectList = (ArrayList<PolyBase>)allLayers.get(layer);
                    if (rectList == null) {
                        rectList = new ArrayList<PolyBase>();
                        allLayers.put(layer, rectList);
                    }
                    rectList.add(poly);
                }
            }
            this.highlighter.clear();
            ArrayList<NodeInst> nodesList = new ArrayList<NodeInst>();
            Iterator it2 = merge.getKeyIterator();
            while (it2.hasNext()) {
                Rectangle2D rect;
                Layer layer = (Layer)it2.next();
                List list = merge.getMergedPoints(layer, true);
                List rectList = (List)allLayers.get(layer);
                ArrayList<PolyBase> delList = new ArrayList<PolyBase>();
                Iterator iter = rectList.iterator();
                while (iter.hasNext()) {
                    PolyBase p = (PolyBase)iter.next();
                    rect = p.getBounds2D();
                    Iterator i = list.iterator();
                    while (i.hasNext()) {
                        PolyBase poly3 = (PolyBase)i.next();
                        Rectangle2D r = poly3.getBounds2D();
                        if (!r.equals(rect)) continue;
                        delList.add(poly3);
                    }
                }
                iter = delList.iterator();
                while (iter.hasNext()) {
                    list.remove(iter.next());
                }
                Iterator i = list.iterator();
                while (i.hasNext()) {
                    poly = (PolyBase)i.next();
                    rect = poly.getBounds2D();
                    Point2D.Double center = new Point2D.Double(rect.getCenterX(), rect.getCenterY());
                    PrimitiveNode priNode = layer.getPureLayerNode();
                    NodeInst node = NodeInst.makeInstance(priNode, center, rect.getWidth(), rect.getHeight(), this.curCell);
                    this.highlighter.addElectricObject(node, this.curCell);
                    node.setHardSelect();
                    nodesList.add(node);
                }
            }
            this.highlighter.finished();
            it2 = deleteList.iterator();
            while (it2.hasNext()) {
                NodeInst node = (NodeInst)it2.next();
                node.kill();
            }
            if (nodesList.isEmpty()) {
                System.out.println("No implant areas added");
            }
            return true;
        }
    }

    private static class FakeCoverageCircuitry
    extends Job {
        private String theTechnology;

        protected FakeCoverageCircuitry(String tech) {
            super("Make fake circuitry for coverage tests", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.theTechnology = tech;
            this.startJob();
        }

        public boolean doIt() {
            return FakeCoverageCircuitry.doItInternal(this.theTechnology);
        }

        private static boolean doItInternal(String technology) {
            Technology tech = Technology.findTechnology(technology);
            if (tech == null) {
                System.out.println("Technology not found in createCoverageTestCells");
                return false;
            }
            tech.setCurrent();
            WindowFrame wf = WindowFrame.getCurrentWindowFrame(false);
            if (wf != null) {
                wf.loadComponentMenuForTechnology();
            }
            NodeProto m1NodeProto = Cell.findNodeProto(technology + ":Metal-1-Node");
            NodeProto m2NodeProto = Cell.findNodeProto(technology + ":Metal-2-Node");
            NodeProto m3NodeProto = Cell.findNodeProto(technology + ":Metal-3-Node");
            NodeProto m4NodeProto = Cell.findNodeProto(technology + ":Metal-4-Node");
            NodeProto invisiblePinProto = Cell.findNodeProto("generic:Invisible-Pin");
            ArcProto m1ArcProto = ArcProto.findArcProto(technology + ":Metal-1");
            Library mainLib = Library.getCurrent();
            Cell m1Cell = Cell.makeInstance(mainLib, technology + "Metal1Test{lay}");
            NodeInst metal1Node = NodeInst.newInstance(m1NodeProto, new Point2D.Double(0.0, 0.0), m1NodeProto.getDefWidth(), m1NodeProto.getDefHeight(), m1Cell);
            Cell myCell = Cell.makeInstance(mainLib, technology + "M1M2Test{lay}");
            NodeInst node = NodeInst.newInstance(m1NodeProto, new Point2D.Double(-m1NodeProto.getDefWidth() / 2.0, -m1NodeProto.getDefHeight() / 2.0), m1NodeProto.getDefWidth(), m1NodeProto.getDefHeight(), myCell);
            node = NodeInst.newInstance(m2NodeProto, new Point2D.Double(-m2NodeProto.getDefWidth() / 2.0, m2NodeProto.getDefHeight() / 2.0), m2NodeProto.getDefWidth(), m2NodeProto.getDefHeight(), myCell);
            node = NodeInst.newInstance(m3NodeProto, new Point2D.Double(m3NodeProto.getDefWidth() / 2.0, -m3NodeProto.getDefHeight() / 2.0), m3NodeProto.getDefWidth(), m3NodeProto.getDefHeight(), myCell);
            node = NodeInst.newInstance(m4NodeProto, new Point2D.Double(m4NodeProto.getDefWidth() / 2.0, m4NodeProto.getDefHeight() / 2.0), m4NodeProto.getDefWidth(), m4NodeProto.getDefHeight(), myCell);
            Cell higherCell = Cell.makeInstance(mainLib, "higher{lay}");
            Rectangle2D bounds = myCell.getBounds();
            double myWidth = myCell.getDefWidth();
            double myHeight = myCell.getDefHeight();
            NodeInst instance1Node = NodeInst.newInstance(myCell, new Point2D.Double(0.0, 0.0), myWidth, myHeight, higherCell);
            instance1Node.setExpanded();
            NodeInst instance2Node = NodeInst.newInstance(myCell, new Point2D.Double(myWidth, 0.0), myWidth, myHeight, higherCell, 0, null, 0);
            instance2Node.setExpanded();
            NodeInst instance3Node = NodeInst.newInstance(myCell, new Point2D.Double(2.0 * myWidth, 0.0), myWidth, myHeight, higherCell, 1800, null, 0);
            instance3Node.setExpanded();
            NodeInst instance4Node = NodeInst.newInstance(myCell, new Point2D.Double(3.0 * myWidth, 0.0), myWidth, myHeight, higherCell, 2700, null, 0);
            instance4Node.setExpanded();
            NodeInst instance5Node = NodeInst.newInstance(myCell, new Point2D.Double(0.0, myHeight), -myWidth, myHeight, higherCell);
            instance5Node.setExpanded();
            NodeInst instance6Node = NodeInst.newInstance(myCell, new Point2D.Double(myWidth, myHeight), -myWidth, myHeight, higherCell, 900, null, 0);
            instance6Node.setExpanded();
            NodeInst instance7Node = NodeInst.newInstance(myCell, new Point2D.Double(2.0 * myWidth, myHeight), -myWidth, myHeight, higherCell, 1800, null, 0);
            instance7Node.setExpanded();
            NodeInst instance8Node = NodeInst.newInstance(myCell, new Point2D.Double(3.0 * myWidth, myHeight), -myWidth, myHeight, higherCell, 2700, null, 0);
            instance8Node.setExpanded();
            System.out.println("Created " + higherCell);
            WindowFrame.createEditWindow(myCell);
            return true;
        }
    }

    private static class MakeFakeCircuitry
    extends Job {
        private String theTechnology;

        protected MakeFakeCircuitry(String tech) {
            super("Make fake circuitry", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.theTechnology = tech;
            this.startJob();
        }

        public boolean doIt() {
            return MakeFakeCircuitry.doItInternal(this.theTechnology);
        }

        private static boolean doItInternal(String technology) {
            ArcInst metal2Arc;
            PortInst transRPortR;
            Technology tech = Technology.findTechnology(technology);
            if (tech == null) {
                System.out.println("Technology not found in MakeFakeCircuitry");
                return false;
            }
            tech.setCurrent();
            WindowFrame wf = WindowFrame.getCurrentWindowFrame(false);
            if (wf != null) {
                wf.loadComponentMenuForTechnology();
            }
            StringBuffer polyName = new StringBuffer("Polysilicon");
            String lateral = "top";
            if (technology.equals("mocmos")) {
                polyName.append("-1");
                lateral = "right";
            }
            NodeProto m1m2Proto = Cell.findNodeProto(technology + ":Metal-1-Metal-2-Con");
            NodeProto m2PinProto = Cell.findNodeProto(technology + ":Metal-2-Pin");
            NodeProto p1PinProto = Cell.findNodeProto(technology + ":" + polyName + "-Pin");
            NodeProto m1PolyConProto = Cell.findNodeProto(technology + ":Metal-1-" + polyName + "-Con");
            NodeProto pTransProto = Cell.findNodeProto(technology + ":P-Transistor");
            NodeProto nTransProto = Cell.findNodeProto(technology + ":N-Transistor");
            NodeProto invisiblePinProto = Cell.findNodeProto("generic:Invisible-Pin");
            ArcProto m1Proto = ArcProto.findArcProto(technology + ":Metal-1");
            ArcProto m2Proto = ArcProto.findArcProto(technology + ":Metal-2");
            ArcProto p1Proto = ArcProto.findArcProto(technology + ":" + polyName);
            Library mainLib = Library.getCurrent();
            Cell myCell = Cell.makeInstance(mainLib, technology + "test{lay}");
            NodeInst metal12Via = NodeInst.newInstance(m1m2Proto, new Point2D.Double(-20.0, 20.0), m1m2Proto.getDefWidth(), m1m2Proto.getDefHeight(), myCell);
            NodeInst contactNode = NodeInst.newInstance(m1PolyConProto, new Point2D.Double(20.0, 20.0), m1PolyConProto.getDefWidth(), m1PolyConProto.getDefHeight(), myCell);
            NodeInst metal2Pin = NodeInst.newInstance(m2PinProto, new Point2D.Double(-20.0, 10.0), m2PinProto.getDefWidth(), m2PinProto.getDefHeight(), myCell);
            NodeInst poly1PinA = NodeInst.newInstance(p1PinProto, new Point2D.Double(20.0, -20.0), p1PinProto.getDefWidth(), p1PinProto.getDefHeight(), myCell);
            NodeInst poly1PinB = NodeInst.newInstance(p1PinProto, new Point2D.Double(20.0, -10.0), p1PinProto.getDefWidth(), p1PinProto.getDefHeight(), myCell);
            NodeInst transistor = NodeInst.newInstance(pTransProto, new Point2D.Double(0.0, -20.0), pTransProto.getDefWidth(), pTransProto.getDefHeight(), myCell);
            NodeInst rotTrans = NodeInst.newInstance(nTransProto, new Point2D.Double(0.0, 10.0), nTransProto.getDefWidth(), nTransProto.getDefHeight(), myCell, 3150, "rotated", 0);
            if (metal12Via == null || contactNode == null || metal2Pin == null || poly1PinA == null || poly1PinB == null || transistor == null || rotTrans == null) {
                return false;
            }
            PortInst m1m2Port = metal12Via.getOnlyPortInst();
            PortInst contactPort = contactNode.getOnlyPortInst();
            PortInst m2Port = metal2Pin.getOnlyPortInst();
            PortInst p1PortA = poly1PinA.getOnlyPortInst();
            PortInst p1PortB = poly1PinB.getOnlyPortInst();
            PortInst transPortR = transistor.findPortInst("poly-" + lateral);
            if (transPortR == null) {
                transPortR = transistor.findPortInst("p-trans-poly-" + lateral);
            }
            if ((transRPortR = rotTrans.findPortInst("poly-" + lateral)) == null) {
                transRPortR = rotTrans.findPortInst("n-trans-poly-" + lateral);
            }
            if ((metal2Arc = ArcInst.makeInstance(m2Proto, m2Proto.getWidth(), m2Port, m1m2Port)) == null) {
                return false;
            }
            metal2Arc.setRigid(true);
            ArcInst metal1Arc = ArcInst.makeInstance(m1Proto, m1Proto.getWidth(), contactPort, m1m2Port);
            if (metal1Arc == null) {
                return false;
            }
            ArcInst polyArc1 = ArcInst.makeInstance(p1Proto, p1Proto.getWidth(), contactPort, p1PortB);
            if (polyArc1 == null) {
                return false;
            }
            ArcInst polyArc3 = ArcInst.makeInstance(p1Proto, p1Proto.getWidth(), p1PortB, p1PortA);
            if (polyArc3 == null) {
                return false;
            }
            ArcInst polyArc2 = ArcInst.makeInstance(p1Proto, p1Proto.getWidth(), transPortR, p1PortA);
            if (polyArc2 == null) {
                return false;
            }
            ArcInst polyArc4 = ArcInst.makeInstance(p1Proto, p1Proto.getWidth(), transRPortR, p1PortB);
            if (polyArc4 == null) {
                return false;
            }
            Export m1Export = Export.newInstance(myCell, m1m2Port, "in");
            m1Export.setCharacteristic(PortCharacteristic.IN);
            Export p1Export = Export.newInstance(myCell, p1PortA, "out");
            p1Export.setCharacteristic(PortCharacteristic.OUT);
            System.out.println("Created " + myCell);
            Cell higherCell = Cell.makeInstance(mainLib, "higher{lay}");
            Rectangle2D bounds = myCell.getBounds();
            double myWidth = myCell.getDefWidth();
            double myHeight = myCell.getDefHeight();
            NodeInst instance1Node = NodeInst.newInstance(myCell, new Point2D.Double(0.0, 0.0), myWidth, myHeight, higherCell);
            instance1Node.setExpanded();
            NodeInst instance1UNode = NodeInst.newInstance(myCell, new Point2D.Double(0.0, 100.0), myWidth, myHeight, higherCell);
            NodeInst instance2Node = NodeInst.newInstance(myCell, new Point2D.Double(100.0, 0.0), myWidth, myHeight, higherCell, 900, null, 0);
            instance2Node.setExpanded();
            NodeInst instance2UNode = NodeInst.newInstance(myCell, new Point2D.Double(100.0, 100.0), myWidth, myHeight, higherCell, 900, null, 0);
            NodeInst instance3Node = NodeInst.newInstance(myCell, new Point2D.Double(200.0, 0.0), myWidth, myHeight, higherCell, 1800, null, 0);
            instance3Node.setExpanded();
            NodeInst instance3UNode = NodeInst.newInstance(myCell, new Point2D.Double(200.0, 100.0), myWidth, myHeight, higherCell, 1800, null, 0);
            NodeInst instance4Node = NodeInst.newInstance(myCell, new Point2D.Double(300.0, 0.0), myWidth, myHeight, higherCell, 2700, null, 0);
            instance4Node.setExpanded();
            NodeInst instance4UNode = NodeInst.newInstance(myCell, new Point2D.Double(300.0, 100.0), myWidth, myHeight, higherCell, 2700, null, 0);
            NodeInst instance5Node = NodeInst.newInstance(myCell, new Point2D.Double(0.0, 200.0), -myWidth, myHeight, higherCell);
            instance5Node.setExpanded();
            NodeInst instance5UNode = NodeInst.newInstance(myCell, new Point2D.Double(0.0, 300.0), -myWidth, myHeight, higherCell);
            NodeInst instance6Node = NodeInst.newInstance(myCell, new Point2D.Double(100.0, 200.0), -myWidth, myHeight, higherCell, 900, null, 0);
            instance6Node.setExpanded();
            NodeInst instance6UNode = NodeInst.newInstance(myCell, new Point2D.Double(100.0, 300.0), -myWidth, myHeight, higherCell, 900, null, 0);
            NodeInst instance7Node = NodeInst.newInstance(myCell, new Point2D.Double(200.0, 200.0), -myWidth, myHeight, higherCell, 1800, null, 0);
            instance7Node.setExpanded();
            NodeInst instance7UNode = NodeInst.newInstance(myCell, new Point2D.Double(200.0, 300.0), -myWidth, myHeight, higherCell, 1800, null, 0);
            NodeInst instance8Node = NodeInst.newInstance(myCell, new Point2D.Double(300.0, 200.0), -myWidth, myHeight, higherCell, 2700, null, 0);
            instance8Node.setExpanded();
            NodeInst instance8UNode = NodeInst.newInstance(myCell, new Point2D.Double(300.0, 300.0), -myWidth, myHeight, higherCell, 2700, null, 0);
            PortInst instance1Port = instance1Node.findPortInst("in");
            PortInst instance2Port = instance1UNode.findPortInst("in");
            ArcInst instanceArc = ArcInst.makeInstance(m1Proto, m1Proto.getWidth(), instance1Port, instance2Port);
            System.out.println("Created " + higherCell);
            Cell rotTestCell = Cell.makeInstance(mainLib, "rotationTest{lay}");
            NodeInst r0Node = NodeInst.newInstance(myCell, new Point2D.Double(0.0, 0.0), myWidth, myHeight, rotTestCell);
            r0Node.setExpanded();
            NodeInst nodeLabel = NodeInst.newInstance(invisiblePinProto, new Point2D.Double(0.0, -35.0), 0.0, 0.0, rotTestCell);
            Variable var = nodeLabel.newDisplayVar(Artwork.ART_MESSAGE, "Rotated 0");
            var.setRelSize(10.0);
            NodeInst r90Node = NodeInst.newInstance(myCell, new Point2D.Double(100.0, 0.0), myWidth, myHeight, rotTestCell, 900, null, 0);
            r90Node.setExpanded();
            nodeLabel = NodeInst.newInstance(invisiblePinProto, new Point2D.Double(100.0, -35.0), 0.0, 0.0, rotTestCell);
            var = nodeLabel.newDisplayVar(Artwork.ART_MESSAGE, "Rotated 90");
            var.setRelSize(10.0);
            NodeInst r180Node = NodeInst.newInstance(myCell, new Point2D.Double(200.0, 0.0), myWidth, myHeight, rotTestCell, 1800, null, 0);
            r180Node.setExpanded();
            nodeLabel = NodeInst.newInstance(invisiblePinProto, new Point2D.Double(200.0, -35.0), 0.0, 0.0, rotTestCell);
            var = nodeLabel.newDisplayVar(Artwork.ART_MESSAGE, "Rotated 180");
            var.setRelSize(10.0);
            NodeInst r270Node = NodeInst.newInstance(myCell, new Point2D.Double(300.0, 0.0), myWidth, myHeight, rotTestCell, 2700, null, 0);
            r270Node.setExpanded();
            nodeLabel = NodeInst.newInstance(invisiblePinProto, new Point2D.Double(300.0, -35.0), 0.0, 0.0, rotTestCell);
            var = nodeLabel.newDisplayVar(Artwork.ART_MESSAGE, "Rotated 270");
            var.setRelSize(10.0);
            NodeInst r0MXNode = NodeInst.newInstance(myCell, new Point2D.Double(0.0, 100.0), -myWidth, myHeight, rotTestCell);
            r0MXNode.setExpanded();
            nodeLabel = NodeInst.newInstance(invisiblePinProto, new Point2D.Double(0.0, 65.0), 0.0, 0.0, rotTestCell);
            var = nodeLabel.newDisplayVar(Artwork.ART_MESSAGE, "Rotated 0 MX");
            var.setRelSize(10.0);
            NodeInst r90MXNode = NodeInst.newInstance(myCell, new Point2D.Double(100.0, 100.0), -myWidth, myHeight, rotTestCell, 900, null, 0);
            r90MXNode.setExpanded();
            nodeLabel = NodeInst.newInstance(invisiblePinProto, new Point2D.Double(100.0, 65.0), 0.0, 0.0, rotTestCell);
            var = nodeLabel.newDisplayVar(Artwork.ART_MESSAGE, "Rotated 90 MX");
            var.setRelSize(10.0);
            NodeInst r180MXNode = NodeInst.newInstance(myCell, new Point2D.Double(200.0, 100.0), -myWidth, myHeight, rotTestCell, 1800, null, 0);
            r180MXNode.setExpanded();
            nodeLabel = NodeInst.newInstance(invisiblePinProto, new Point2D.Double(200.0, 65.0), 0.0, 0.0, rotTestCell);
            var = nodeLabel.newDisplayVar(Artwork.ART_MESSAGE, "Rotated 180 MX");
            var.setRelSize(10.0);
            NodeInst r270MXNode = NodeInst.newInstance(myCell, new Point2D.Double(300.0, 100.0), -myWidth, myHeight, rotTestCell, 2700, null, 0);
            r270MXNode.setExpanded();
            nodeLabel = NodeInst.newInstance(invisiblePinProto, new Point2D.Double(300.0, 65.0), 0.0, 0.0, rotTestCell);
            var = nodeLabel.newDisplayVar(Artwork.ART_MESSAGE, "Rotated 270 MX");
            var.setRelSize(10.0);
            NodeInst r0MYNode = NodeInst.newInstance(myCell, new Point2D.Double(0.0, 200.0), myWidth, -myHeight, rotTestCell);
            r0MYNode.setExpanded();
            nodeLabel = NodeInst.newInstance(invisiblePinProto, new Point2D.Double(0.0, 165.0), 0.0, 0.0, rotTestCell);
            var = nodeLabel.newDisplayVar(Artwork.ART_MESSAGE, "Rotated 0 MY");
            var.setRelSize(10.0);
            NodeInst r90MYNode = NodeInst.newInstance(myCell, new Point2D.Double(100.0, 200.0), myWidth, -myHeight, rotTestCell, 900, null, 0);
            r90MYNode.setExpanded();
            nodeLabel = NodeInst.newInstance(invisiblePinProto, new Point2D.Double(100.0, 165.0), 0.0, 0.0, rotTestCell);
            var = nodeLabel.newDisplayVar(Artwork.ART_MESSAGE, "Rotated 90 MY");
            var.setRelSize(10.0);
            NodeInst r180MYNode = NodeInst.newInstance(myCell, new Point2D.Double(200.0, 200.0), myWidth, -myHeight, rotTestCell, 1800, null, 0);
            r180MYNode.setExpanded();
            nodeLabel = NodeInst.newInstance(invisiblePinProto, new Point2D.Double(200.0, 165.0), 0.0, 0.0, rotTestCell);
            var = nodeLabel.newDisplayVar(Artwork.ART_MESSAGE, "Rotated 180 MY");
            var.setRelSize(10.0);
            NodeInst r270MYNode = NodeInst.newInstance(myCell, new Point2D.Double(300.0, 200.0), myWidth, -myHeight, rotTestCell, 2700, null, 0);
            r270MYNode.setExpanded();
            nodeLabel = NodeInst.newInstance(invisiblePinProto, new Point2D.Double(300.0, 165.0), 0.0, 0.0, rotTestCell);
            var = nodeLabel.newDisplayVar(Artwork.ART_MESSAGE, "Rotated 270 MY");
            var.setRelSize(10.0);
            NodeInst r0MXYNode = NodeInst.newInstance(myCell, new Point2D.Double(0.0, 300.0), -myWidth, -myHeight, rotTestCell);
            r0MXYNode.setExpanded();
            nodeLabel = NodeInst.newInstance(invisiblePinProto, new Point2D.Double(0.0, 265.0), 0.0, 0.0, rotTestCell);
            var = nodeLabel.newDisplayVar(Artwork.ART_MESSAGE, "Rotated 0 MXY");
            var.setRelSize(10.0);
            NodeInst r90MXYNode = NodeInst.newInstance(myCell, new Point2D.Double(100.0, 300.0), -myWidth, -myHeight, rotTestCell, 900, null, 0);
            r90MXYNode.setExpanded();
            nodeLabel = NodeInst.newInstance(invisiblePinProto, new Point2D.Double(100.0, 265.0), 0.0, 0.0, rotTestCell);
            var = nodeLabel.newDisplayVar(Artwork.ART_MESSAGE, "Rotated 90 MXY");
            var.setRelSize(10.0);
            NodeInst r180MXYNode = NodeInst.newInstance(myCell, new Point2D.Double(200.0, 300.0), -myWidth, -myHeight, rotTestCell, 1800, null, 0);
            r180MXYNode.setExpanded();
            nodeLabel = NodeInst.newInstance(invisiblePinProto, new Point2D.Double(200.0, 265.0), 0.0, 0.0, rotTestCell);
            var = nodeLabel.newDisplayVar(Artwork.ART_MESSAGE, "Rotated 180 MXY");
            var.setRelSize(10.0);
            NodeInst r270MXYNode = NodeInst.newInstance(myCell, new Point2D.Double(300.0, 300.0), -myWidth, -myHeight, rotTestCell, 2700, null, 0);
            r270MXYNode.setExpanded();
            nodeLabel = NodeInst.newInstance(invisiblePinProto, new Point2D.Double(300.0, 265.0), 0.0, 0.0, rotTestCell);
            var = nodeLabel.newDisplayVar(Artwork.ART_MESSAGE, "Rotated 270 MXY");
            var.setRelSize(10.0);
            System.out.println("Created " + rotTestCell);
            Cell bigCell = Cell.makeInstance(mainLib, "big{lay}");
            int arraySize = 20;
            for (int y = 0; y < arraySize; ++y) {
                for (int x = 0; x < arraySize; ++x) {
                    String theName = "arr[" + x + "][" + y + "]";
                    NodeInst instanceNode = NodeInst.newInstance(myCell, new Point2D.Double((double)x * (myWidth + 2.0), (double)y * (myHeight + 2.0)), myWidth, myHeight, bigCell, 0, theName, 0);
                    instanceNode.setOff(NodeInst.NODE_NAME_TD, 0.0, 8.0);
                    if (x % 2 != y % 2) continue;
                    instanceNode.setExpanded();
                }
            }
            System.out.println("Created " + bigCell);
            WindowFrame.createEditWindow(myCell);
            return true;
        }
    }

    private static class SaveLibraryJob
    extends Job {
        private String fileName;

        public SaveLibraryJob(String fileName) {
            super("Save Library", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.fileName = fileName;
            this.startJob();
        }

        public boolean doIt() {
            Library lib = Library.getCurrent();
            Cell cell = lib.getCurCell();
            cell.lowLevelSetRevisionDate(new Date(0L));
            URL outURL = TextUtils.makeURLToFile(this.fileName);
            lib.setLibFile(outURL);
            lib.setName(TextUtils.getFileNameWithoutExtension(outURL));
            Output.writeLibrary(lib, FileType.JELIB, false);
            return true;
        }
    }

    private static class SetCellJob
    extends Job {
        private String cellName;

        public SetCellJob(String cellName) {
            super("Set current cell", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cellName = cellName;
            this.startJob();
        }

        public boolean doIt() {
            Library lib = Library.getCurrent();
            lib.setCurCell(lib.findNodeProto(this.cellName));
            return true;
        }
    }

    private static class FrankJob
    extends Job {
        protected FrankJob() {
            super("Make fake circuitry", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.startJob();
        }

        public boolean doIt() {
            Export e;
            Cell lay = WindowFrame.getCurrentCell();
            ArrayList<Export> aList = new ArrayList<Export>();
            ArrayList<Export> bList = new ArrayList<Export>();
            Iterator it = lay.getPorts();
            while (it.hasNext()) {
                e = (Export)it.next();
                if (e.getName().startsWith("a")) {
                    aList.add(e);
                }
                if (!e.getName().startsWith("b")) continue;
                bList.add(e);
            }
            it = aList.iterator();
            while (it.hasNext()) {
                e = (Export)it.next();
                PortInst pi = e.getOriginalPort();
                Poly poly = pi.getPoly();
                double x = poly.getCenterX();
                double y = poly.getCenterY();
                ArcProto[] possibilities = pi.getPortProto().getBasePort().getConnections();
                ArcProto desired = possibilities[0];
                ArcProto.Function fun = desired.getFunction();
                if (!fun.isMetal()) {
                    System.out.println("HEY, not metal");
                }
                int level = fun.getLevel();
                ArcProto.Function nextFun = ArcProto.Function.getMetal(level + 1);
                ArcProto nextLevel = null;
                Iterator tIt = desired.getTechnology().getArcs();
                while (tIt.hasNext()) {
                    ArcProto other = (ArcProto)tIt.next();
                    if (other.getFunction() != nextFun) continue;
                    nextLevel = other;
                    break;
                }
                PrimitiveNode pinType = desired.findPinProto();
                PrimitiveNode contact = null;
                Iterator cIt = desired.getTechnology().getNodes();
                while (cIt.hasNext()) {
                    PrimitivePort pp;
                    PrimitiveNode np = (PrimitiveNode)cIt.next();
                    if (np.getFunction() != PrimitiveNode.Function.CONTACT || !(pp = (PrimitivePort)np.getPort(0)).connectsTo(desired) || !pp.connectsTo(nextLevel)) continue;
                    contact = np;
                    break;
                }
                NodeInst pin = NodeInst.makeInstance(contact, new Point2D.Double(x, y - 10.0), contact.getDefWidth(), contact.getDefHeight(), lay);
                ArcInst arc = ArcInst.makeInstance(desired, desired.getDefaultWidth(), pi, pin.getOnlyPortInst());
                System.out.println("'A' export: " + e.getName() + " at (" + x + "," + y + ")");
            }
            return true;
        }
    }
}

