/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.io.output.Output;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public abstract class Topology
extends Output {
    protected Cell topCell;
    private HashMap cellTopos;
    private HashMap cellNameMap;

    public boolean writeCell(Cell cell, VarContext context) {
        this.writeCell(cell, context, new Visitor(this));
        return false;
    }

    public boolean writeCell(Cell cell, VarContext context, Visitor visitor) {
        this.topCell = cell;
        this.cellTopos = new HashMap();
        this.makeCellNameMap();
        this.start();
        HierarchyEnumerator.enumerateCell(cell, context, null, visitor);
        this.done();
        return false;
    }

    protected abstract void start();

    protected abstract void done();

    protected abstract void writeCellTopology(Cell var1, CellNetInfo var2, VarContext var3);

    protected abstract String getSafeNetName(String var1, boolean var2);

    protected abstract String getSafeCellName(String var1);

    protected abstract String getPowerName(Network var1);

    protected abstract String getGroundName(Network var1);

    protected abstract String getGlobalName(Global var1);

    protected abstract boolean isNetworksUseExportedNames();

    protected abstract boolean isLibraryNameAlwaysAddedToCellName();

    protected abstract boolean isAggregateNamesSupported();

    protected abstract boolean isSeparateInputAndOutput();

    protected boolean skipCellAndSubcells(Cell cell) {
        return false;
    }

    protected boolean canParameterizeNames() {
        return false;
    }

    protected int maxNameLength() {
        return 0;
    }

    protected abstract Netlist getNetlistForCell(Cell var1);

    protected CellNetInfo getCellNetInfo(String cellName) {
        CellNetInfo cni = (CellNetInfo)this.cellTopos.get(cellName);
        return cni;
    }

    private CellNetInfo getNetworkInformation(Cell cell, boolean quiet, String paramName, boolean useExportedName) {
        CellNetInfo cni = this.doGetNetworks(cell, quiet, paramName, useExportedName);
        return cni;
    }

    private CellNetInfo doGetNetworks(Cell cell, boolean quiet, String paramName, boolean useExportedName) {
        CellSignal cs;
        CellSignal cs2;
        CellNetInfo cni = new CellNetInfo();
        cni.paramName = paramName;
        cni.netList = this.getNetlistForCell(cell);
        Global.Set globals = cni.netList.getGlobals();
        int globalSize = globals.size();
        cni.cellSignals = new HashMap();
        int nullNameCount = 1;
        Iterator it = cni.netList.getNetworks();
        while (it.hasNext()) {
            Network net = (Network)it.next();
            CellSignal cs3 = new CellSignal();
            cs3.pp = null;
            cs3.descending = !NetworkTool.isBusAscending();
            cs3.power = false;
            cs3.ground = false;
            cs3.net = net;
            cs3.globalSignal = null;
            for (int j = 0; j < globalSize; ++j) {
                Global global = globals.get(j);
                if (cni.netList.getNetwork(global) != net) continue;
                cs3.globalSignal = global;
                break;
            }
            if (cs3.globalSignal != null) {
                cs3.name = this.getGlobalName(cs3.globalSignal);
            } else if (net.hasNames()) {
                if (useExportedName && net.getExportedNames().hasNext()) {
                    cs3.name = (String)net.getExportedNames().next();
                } else {
                    cs3.name = (String)net.getNames().next();
                }
            } else {
                cs3.name = net.describe(false);
                if (cs3.name.equals("")) {
                    cs3.name = "UNCONNECTED" + nullNameCount++;
                }
            }
            cni.cellSignals.put(net, cs3);
        }
        it = cell.getPorts();
        while (it.hasNext()) {
            Export pp = (Export)it.next();
            int portWidth = cni.netList.getBusWidth(pp);
            for (int i = 0; i < portWidth; ++i) {
                int openPos;
                Network net = cni.netList.getNetwork(pp, i);
                cs2 = (CellSignal)cni.cellSignals.get(net);
                if (cs2 == null) continue;
                if (cs2.pp != null) {
                    int oldPortWidth = cni.netList.getBusWidth(cs2.pp);
                    if (this.isAggregateNamesSupported() ? oldPortWidth >= portWidth : oldPortWidth == 1 || portWidth != 1 && oldPortWidth >= portWidth) continue;
                }
                cs2.pp = pp;
                cs2.ppIndex = i;
                if (!useExportedName) continue;
                String rootName = pp.getName();
                if (portWidth == 1) {
                    cs2.name = rootName;
                }
                if ((openPos = rootName.indexOf(91)) <= 0) continue;
                rootName = rootName.substring(0, openPos);
                Iterator nIt = net.getExportedNames();
                while (nIt.hasNext()) {
                    String exportNetName = (String)nIt.next();
                    String exportRootName = exportNetName;
                    openPos = exportRootName.indexOf(91);
                    if (openPos <= 0 || !rootName.equals(exportRootName = exportRootName.substring(0, openPos))) continue;
                    cs2.name = rootName + exportNetName.substring(openPos);
                }
            }
            if (portWidth <= 1) continue;
            Network[] nets = new Network[portWidth];
            for (int i = 0; i < portWidth; ++i) {
                nets[i] = cni.netList.getNetwork(pp, i);
            }
            this.setBusDirectionality(nets, cni);
        }
        Iterator aIt = cell.getArcs();
        while (aIt.hasNext()) {
            ArcInst ai = (ArcInst)aIt.next();
            int width = cni.netList.getBusWidth(ai);
            if (width < 2) continue;
            Network[] nets = new Network[width];
            for (int i = 0; i < width; ++i) {
                nets[i] = cni.netList.getNetwork(ai, i);
            }
            this.setBusDirectionality(nets, cni);
        }
        cni.pwrNet = (cni.gndNet = null);
        boolean multiPwr = false;
        boolean multiGnd = false;
        Iterator eIt = cell.getPorts();
        while (eIt.hasNext()) {
            Export pp = (Export)eIt.next();
            int portWidth = cni.netList.getBusWidth(pp);
            if (portWidth > 1) continue;
            Network subNet = cni.netList.getNetwork(pp, 0);
            if (pp.isPower()) {
                if (cni.pwrNet != null && cni.pwrNet != subNet && !multiPwr) {
                    if (!quiet) {
                        System.out.println("Warning: multiple power networks in " + cell);
                    }
                    multiPwr = true;
                }
                cni.pwrNet = subNet;
            }
            if (!pp.isGround()) continue;
            if (cni.gndNet != null && cni.gndNet != subNet && !multiGnd) {
                if (!quiet) {
                    System.out.println("Warning: multiple ground networks in " + cell);
                }
                multiGnd = true;
            }
            cni.gndNet = subNet;
        }
        Iterator<Object> it2 = cni.netList.getNetworks();
        while (it2.hasNext()) {
            Network net = (Network)it2.next();
            CellSignal cs4 = (CellSignal)cni.cellSignals.get(net);
            if (cs4.globalSignal == null) continue;
            if (cs4.globalSignal == Global.power) {
                if (cni.pwrNet != null && cni.pwrNet != net && !multiPwr) {
                    if (!quiet) {
                        System.out.println("Warning: multiple power networks in " + cell);
                    }
                    multiPwr = true;
                }
                cni.pwrNet = net;
            }
            if (cs4.globalSignal != Global.ground) continue;
            if (cni.gndNet != null && cni.gndNet != net && !multiGnd) {
                if (!quiet) {
                    System.out.println("Warning: multiple ground networks in " + cell);
                }
                multiGnd = true;
            }
            cni.gndNet = net;
        }
        it2 = cell.getNodes();
        while (it2.hasNext()) {
            NodeInst ni = (NodeInst)it2.next();
            PrimitiveNode.Function fun = ni.getFunction();
            if (fun != PrimitiveNode.Function.CONPOWER && fun != PrimitiveNode.Function.CONGROUND) continue;
            Iterator cIt = ni.getConnections();
            while (cIt.hasNext()) {
                Connection con = (Connection)cIt.next();
                ArcInst ai = con.getArc();
                Network subNet = cni.netList.getNetwork(ai, 0);
                if (fun == PrimitiveNode.Function.CONPOWER) {
                    if (cni.pwrNet != null && cni.pwrNet != subNet && !multiPwr) {
                        if (!quiet) {
                            System.out.println("Warning: multiple power networks in " + cell);
                        }
                        multiPwr = true;
                    }
                    cni.pwrNet = subNet;
                    continue;
                }
                if (cni.gndNet != null && cni.gndNet != subNet && !multiGnd) {
                    if (!quiet) {
                        System.out.println("Warning: multiple ground networks in " + cell);
                    }
                    multiGnd = true;
                }
                cni.gndNet = subNet;
            }
        }
        if (cni.pwrNet != null) {
            cs = (CellSignal)cni.cellSignals.get(cni.pwrNet);
            String powerName = this.getPowerName(cni.pwrNet);
            if (powerName != null) {
                cs.name = powerName;
            }
            cs.power = true;
        }
        if (cni.gndNet != null) {
            cs = (CellSignal)cni.cellSignals.get(cni.gndNet);
            String groundName = this.getGroundName(cni.gndNet);
            if (groundName != null) {
                cs.name = groundName;
            }
            cs.ground = true;
        }
        cni.cellSignalsSorted = new ArrayList();
        it2 = cni.cellSignals.values().iterator();
        while (it2.hasNext()) {
            cni.cellSignalsSorted.add(it2.next());
        }
        Collections.sort(cni.cellSignalsSorted, new SortNetsByName(this.isSeparateInputAndOutput()));
        if (this.isAggregateNamesSupported()) {
            cni.cellAggretateSignals = new ArrayList();
            int total = cni.cellSignalsSorted.size();
            boolean emptyName = true;
            for (int i = 0; i < total; ++i) {
                cs2 = (CellSignal)cni.cellSignalsSorted.get(i);
                CellAggregateSignal cas = new CellAggregateSignal();
                cas.name = Topology.unIndexedName(cs2.name);
                cas.pp = cs2.pp;
                cas.ppIndex = cs2.ppIndex;
                cas.supply = cs2.power | cs2.ground;
                cas.descending = cs2.descending;
                cas.flags = 0;
                cs2.aggregateSignal = cas;
                if (cs2.name.equals(cas.name)) {
                    cas.low = 1;
                    cas.high = 0;
                    CellAggregateSignal.access$2602(cas, new CellSignal[1]);
                    ((CellAggregateSignal)cas).signals[0] = cs2;
                } else {
                    int index;
                    String endName;
                    String ept;
                    CellSignal csEnd;
                    cas.high = (cas.low = TextUtils.atoi(cs2.name.substring(cas.name.length() + 1)));
                    int start = i;
                    int j = i + 1;
                    while (j < total && (csEnd = (CellSignal)cni.cellSignalsSorted.get(j)).descending == cs2.descending && csEnd.pp == cs2.pp && csEnd.globalSignal == cs2.globalSignal && !(ept = Topology.unIndexedName(endName = csEnd.name)).equals(endName) && (index = TextUtils.atoi(endName.substring(ept.length() + 1))) == cas.high + 1) {
                        if (index > cas.high) {
                            cas.high = index;
                        }
                        i = j++;
                        csEnd.aggregateSignal = cas;
                    }
                    CellAggregateSignal.access$2602(cas, new CellSignal[i - start + 1]);
                    for (j = start; j <= i; ++j) {
                        ((CellAggregateSignal)cas).signals[j - start] = csEnd = (CellSignal)cni.cellSignalsSorted.get(j);
                    }
                }
                cni.cellAggretateSignals.add(cas);
            }
            Iterator it3 = cni.cellAggretateSignals.iterator();
            while (it3.hasNext()) {
                CellAggregateSignal cas = (CellAggregateSignal)it3.next();
                cas.name = this.getSafeNetName(cas.name, true);
            }
            int numNameList = cni.cellAggretateSignals.size();
            block17: for (int i = 1; i < numNameList; ++i) {
                CellAggregateSignal cas = (CellAggregateSignal)cni.cellAggretateSignals.get(i);
                for (int k = 0; k < 1000; ++k) {
                    String ninName = cas.name;
                    if (k > 0) {
                        ninName = ninName + "_" + k;
                    }
                    boolean found = false;
                    for (int j = 0; j < i; ++j) {
                        CellAggregateSignal oCas = (CellAggregateSignal)cni.cellAggretateSignals.get(j);
                        if (!ninName.equals(oCas.name)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    if (k <= 0) continue block17;
                    cas.name = ninName;
                    continue block17;
                }
            }
            Iterator it4 = cni.cellAggretateSignals.iterator();
            while (it4.hasNext()) {
                CellAggregateSignal cas = (CellAggregateSignal)it4.next();
                if (cas.low > cas.high) {
                    CellSignal cs5 = cas.signals[0];
                    cs5.name = cas.name;
                    continue;
                }
                for (int k = cas.low; k <= cas.high; ++k) {
                    CellSignal cs6 = cas.signals[k - cas.low];
                    cs6.name = this.getSafeNetName(cas.name + "[" + k + "]", false);
                }
            }
        } else {
            it2 = cni.cellSignalsSorted.iterator();
            while (it2.hasNext()) {
                CellSignal cs7 = (CellSignal)it2.next();
                cs7.name = this.getSafeNetName(cs7.name, false);
            }
        }
        return cni;
    }

    private void setBusDirectionality(Network[] nets, CellNetInfo cni) {
        Network subNet;
        int i;
        boolean upDir = false;
        boolean downDir = false;
        boolean randomDir = false;
        int last = 0;
        int width = nets.length;
        for (i = 0; i < width; ++i) {
            subNet = nets[i];
            if (subNet == null) continue;
            if (!subNet.hasNames()) break;
            String firstName = (String)subNet.getNames().next();
            int index = -1;
            int charPos = 0;
            while ((charPos = firstName.indexOf(91, charPos)) >= 0) {
                if (!TextUtils.isDigit(firstName.charAt(++charPos))) continue;
                index = TextUtils.atoi(firstName.substring(charPos));
                break;
            }
            if (index < 0) break;
            if (i != 0) {
                if (index == last - 1) {
                    downDir = true;
                } else if (index == last + 1) {
                    upDir = true;
                } else {
                    randomDir = true;
                }
            }
            last = index;
        }
        if (randomDir) {
            return;
        }
        if (upDir && downDir) {
            return;
        }
        if (!upDir && !downDir) {
            return;
        }
        for (i = 0; i < width; ++i) {
            subNet = nets[i];
            CellSignal cs = (CellSignal)cni.cellSignals.get(subNet);
            cs.descending = downDir;
        }
    }

    protected static String unIndexedName(String name) {
        char theChr;
        int i;
        int len = name.length();
        if (len == 0) {
            return name;
        }
        if (name.charAt(len - 1) != ']') {
            return name;
        }
        for (i = len - 2; i > 0 && (theChr = name.charAt(i)) != '[' && (theChr == ':' || theChr == ',' || TextUtils.isDigit(theChr)); --i) {
        }
        if (name.charAt(i) != '[') {
            return name;
        }
        return name.substring(0, i);
    }

    protected String parameterizedName(Nodable no, VarContext context) {
        int limit;
        Cell cell = (Cell)no.getProto();
        String uniqueCellName = this.getUniqueCellName(cell);
        if (this.canParameterizeNames() && no.getProto() instanceof Cell) {
            HashMap<Variable.Key, Variable> paramValues = new HashMap<Variable.Key, Variable>();
            Iterator it = no.getVariables();
            while (it.hasNext()) {
                Variable var = (Variable)it.next();
                if (!var.isParam()) continue;
                paramValues.put(var.getKey(), var);
            }
            it = paramValues.keySet().iterator();
            while (it.hasNext()) {
                Variable.Key key = (Variable.Key)it.next();
                Variable var = no.getVar(key.getName());
                String eval = var.describe(context, no.getNodeInst());
                if (eval == null) continue;
                uniqueCellName = uniqueCellName + "-" + eval.toString();
            }
        }
        if ((limit = this.maxNameLength()) > 0 && uniqueCellName.length() > limit) {
            int ckSum = 0;
            for (int i = 0; i < uniqueCellName.length(); ++i) {
                ckSum += uniqueCellName.charAt(i);
            }
            uniqueCellName = uniqueCellName.substring(0, limit - 10) + "-TRUNC" + (ckSum %= 9999);
        }
        return this.getSafeCellName(uniqueCellName);
    }

    protected String getUniqueCellName(Cell cell) {
        String name = (String)this.cellNameMap.get(cell);
        return name;
    }

    private void makeCellNameMap() {
        this.cellNameMap = new HashMap();
        Iterator lIt = Library.getLibraries();
        while (lIt.hasNext()) {
            Library lib = (Library)lIt.next();
            if (lib.isHidden()) continue;
            Iterator cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = (Cell)cIt.next();
                if (this.isLibraryNameAlwaysAddedToCellName()) {
                    this.cellNameMap.put(cell, lib.getName() + "__" + cell.getName());
                    continue;
                }
                boolean duplicate = false;
                Iterator oLIt = Library.getLibraries();
                while (oLIt.hasNext()) {
                    Library oLib = (Library)oLIt.next();
                    if (oLib.isHidden() || oLib == lib) continue;
                    Iterator oCIt = oLib.getCells();
                    while (oCIt.hasNext()) {
                        Cell oCell = (Cell)oCIt.next();
                        if (!cell.getName().equalsIgnoreCase(oCell.getName())) continue;
                        duplicate = true;
                        break;
                    }
                    if (!duplicate) continue;
                    break;
                }
                if (duplicate) {
                    this.cellNameMap.put(cell, lib.getName() + "__" + cell.getName());
                    continue;
                }
                this.cellNameMap.put(cell, cell.getName());
            }
        }
    }

    private static class SortNetsByName
    implements Comparator {
        private boolean separateInputAndOutput;

        SortNetsByName(boolean separateInputAndOutput) {
            this.separateInputAndOutput = separateInputAndOutput;
        }

        public int compare(Object o1, Object o2) {
            PortCharacteristic ch2;
            PortCharacteristic ch1;
            CellSignal cs1 = (CellSignal)o1;
            CellSignal cs2 = (CellSignal)o2;
            if (cs1.pp == null != (cs2.pp == null)) {
                return cs1.pp == null ? 1 : -1;
            }
            if (cs1.pp != null && cs2.pp != null && this.separateInputAndOutput && (ch1 = cs1.pp.getCharacteristic()) != (ch2 = cs2.pp.getCharacteristic())) {
                return ch1.getOrder() - ch2.getOrder();
            }
            if (cs1.descending != cs2.descending) {
                return cs1.descending ? 1 : -1;
            }
            return TextUtils.nameSameNumeric(cs1.name, cs2.name);
        }
    }

    protected static class CellNetInfo {
        private String paramName;
        private HashMap cellSignals;
        private List cellSignalsSorted;
        private List cellAggretateSignals;
        private Network pwrNet;
        private Network gndNet;
        private Netlist netList;

        protected CellNetInfo() {
        }

        protected CellSignal getCellSignal(Network net) {
            return (CellSignal)this.cellSignals.get(net);
        }

        protected Iterator getCellSignals() {
            return this.cellSignalsSorted.iterator();
        }

        protected Iterator getCellAggregateSignals() {
            return this.cellAggretateSignals.iterator();
        }

        protected String getParameterizedName() {
            return this.paramName;
        }

        protected Network getPowerNet() {
            return this.pwrNet;
        }

        protected Network getGroundNet() {
            return this.gndNet;
        }

        protected Netlist getNetList() {
            return this.netList;
        }
    }

    protected static class CellAggregateSignal {
        private String name;
        private Export pp;
        private int ppIndex;
        private int low;
        private int high;
        private boolean supply;
        private boolean descending;
        private CellSignal[] signals;
        private int flags;

        protected CellAggregateSignal() {
        }

        protected String getName() {
            return this.name;
        }

        protected String getNameWithIndices() {
            if (this.low > this.high) {
                return this.name;
            }
            int lowIndex = this.low;
            int highIndex = this.high;
            if (this.descending) {
                lowIndex = this.high;
                highIndex = this.low;
            }
            return this.name + "[" + lowIndex + ":" + highIndex + "]";
        }

        protected CellSignal getSignal(int index) {
            return this.signals[index];
        }

        protected boolean isDescending() {
            return this.descending;
        }

        protected boolean isSupply() {
            return this.supply;
        }

        protected Export getExport() {
            return this.pp;
        }

        protected int getExportIndex() {
            return this.ppIndex;
        }

        protected int getLowIndex() {
            return this.low;
        }

        protected int getHighIndex() {
            return this.high;
        }

        protected int getFlags() {
            return this.flags;
        }

        protected void setFlags(int flags) {
            this.flags = flags;
        }

        protected boolean isGlobal() {
            int numGlobal = 0;
            for (int i = 0; i < this.signals.length; ++i) {
                CellSignal cs = this.signals[i];
                if (!cs.isGlobal()) continue;
                ++numGlobal;
            }
            return numGlobal > 0 && numGlobal == this.signals.length;
        }

        static /* synthetic */ CellSignal[] access$2602(CellAggregateSignal x0, CellSignal[] x1) {
            x0.signals = x1;
            return x1;
        }
    }

    protected static class CellSignal {
        private String name;
        private Network net;
        private CellAggregateSignal aggregateSignal;
        private Export pp;
        private int ppIndex;
        private boolean descending;
        private boolean power;
        private boolean ground;
        private Global globalSignal;

        protected CellSignal() {
        }

        protected String getName() {
            return this.name;
        }

        protected Network getNetwork() {
            return this.net;
        }

        protected Export getExport() {
            return this.pp;
        }

        protected int getExportIndex() {
            return this.ppIndex;
        }

        protected CellAggregateSignal getAggregateSignal() {
            return this.aggregateSignal;
        }

        protected boolean isDescending() {
            return this.descending;
        }

        protected boolean isGlobal() {
            return this.globalSignal != null;
        }

        protected Global getGlobal() {
            return this.globalSignal;
        }

        protected boolean isPower() {
            return this.power;
        }

        protected boolean isGround() {
            return this.ground;
        }

        protected boolean isExported() {
            return this.pp != null;
        }
    }

    public class Visitor
    extends HierarchyEnumerator.Visitor {
        private Topology outGeom;

        public Visitor(Topology outGeom) {
            this.outGeom = outGeom;
        }

        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            return !Topology.this.skipCellAndSubcells(info.getCell());
        }

        public void exitCell(HierarchyEnumerator.CellInfo info) {
            Cell cell = info.getCell();
            CellNetInfo cni = null;
            if (info.isRootCell()) {
                cni = Topology.this.getNetworkInformation(cell, false, cell.getName(), Topology.this.isNetworksUseExportedNames());
            } else {
                MyCellInfo mci = (MyCellInfo)info;
                mci = (MyCellInfo)mci.getParentInfo();
                cni = Topology.this.getCellNetInfo(mci.currentInstanceParametizedName);
            }
            this.outGeom.writeCellTopology(cell, cni, info.getContext());
        }

        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            NodeProto np = no.getProto();
            if (np instanceof PrimitiveNode) {
                return false;
            }
            MyCellInfo mci = (MyCellInfo)info;
            VarContext context = info.getContext();
            mci.currentInstanceParametizedName = Topology.this.parameterizedName(no, context);
            if (Topology.this.cellTopos.containsKey(mci.currentInstanceParametizedName)) {
                return false;
            }
            Cell cell = (Cell)np;
            Netlist netList = Topology.this.getNetlistForCell(cell);
            CellNetInfo cni = Topology.this.getNetworkInformation(cell, false, mci.currentInstanceParametizedName, Topology.this.isNetworksUseExportedNames());
            Topology.this.cellTopos.put(mci.currentInstanceParametizedName, cni);
            return true;
        }

        public HierarchyEnumerator.CellInfo newCellInfo() {
            return new MyCellInfo();
        }
    }

    public class MyCellInfo
    extends HierarchyEnumerator.CellInfo {
        String currentInstanceParametizedName;
    }
}

