/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.user.User;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

public class ArchSim
extends Output {
    public static void writeArchSimFile(Output.OutputCellInfo cellJob) {
        ArchSim out = new ArchSim();
        if (out.openTextOutputStream(cellJob.filePath)) {
            return;
        }
        out.writeFlatCell(cellJob.cell);
        if (out.closeTextOutputStream()) {
            return;
        }
        System.out.println(cellJob.filePath + " written");
    }

    ArchSim() {
    }

    private void writeFlatCell(Cell cell) {
        this.printWriter.println("<?xml version='1.0' encoding='utf-8'?>");
        this.printWriter.println();
        this.printWriter.println("<!DOCTYPE model SYSTEM \"ArchSimModel.dtd\">");
        this.printWriter.println();
        this.printWriter.println("<!-- Cell: " + cell.describe(true) + " -->");
        this.emitCopyright("<!-- ", " -->");
        if (User.isIncludeDateAndVersionInOutput()) {
            this.printWriter.println("<!-- Created on " + TextUtils.formatDate(cell.getCreationDate()) + " -->");
            this.printWriter.println("<!-- Last revised on " + TextUtils.formatDate(cell.getRevisionDate()) + " -->");
            this.printWriter.println("<!-- Written on " + TextUtils.formatDate(new Date()) + " by Electric VLSI Design System, version " + Version.getVersion() + " -->");
        } else {
            this.printWriter.println("<!-- Written by Electric VLSI Design System -->");
        }
        this.printWriter.println();
        this.printWriter.println("<model name= \"" + cell.getName() + "\">");
        this.printWriter.println();
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            if (!(ni.getProto() instanceof Cell) || ni.isIconOfParent()) continue;
            Cell subCell = (Cell)ni.getProto();
            this.printWriter.println("<component name= \"" + ni.getName() + "\" type= \"" + subCell.getName() + "\" />");
        }
        this.printWriter.println();
        Netlist netlist = cell.acquireUserNetlist();
        if (netlist == null) {
            System.out.println("Sorry, a deadlock aborted netlisting (network information unavailable).  Please try again");
            return;
        }
        Iterator it2 = netlist.getNetworks();
        while (it2.hasNext()) {
            PortInst pi;
            Network net = (Network)it2.next();
            ArrayList<PortInst> inputs = new ArrayList<PortInst>();
            ArrayList<PortInst> outputs = new ArrayList<PortInst>();
            Iterator oIt = cell.getNodes();
            while (oIt.hasNext()) {
                NodeInst ni = (NodeInst)oIt.next();
                if (!(ni.getProto() instanceof Cell) || ni.isIconOfParent()) continue;
                Iterator cIt = ni.getConnections();
                while (cIt.hasNext()) {
                    Connection con = (Connection)cIt.next();
                    PortInst pi2 = con.getPortInst();
                    Network nodeNet = netlist.getNetwork(pi2);
                    if (nodeNet != net) continue;
                    PortCharacteristic pc = pi2.getPortProto().getCharacteristic();
                    if (pc == PortCharacteristic.IN) {
                        inputs.add(pi2);
                        continue;
                    }
                    if (pc == PortCharacteristic.OUT) {
                        outputs.add(pi2);
                        continue;
                    }
                    System.out.println("Export " + pi2.getPortProto().getName() + " of " + ni.getProto() + " is neither input or output (it is " + pc.getFullName() + ")");
                }
            }
            if (inputs.size() == 0 && outputs.size() == 0) continue;
            String netName = null;
            Iterator nIt = net.getNames();
            netName = nIt.hasNext() ? (String)nIt.next() : net.describe(true);
            this.printWriter.println();
            this.printWriter.println("<connection name= \"" + netName + "\">");
            Iterator pIt = outputs.iterator();
            while (pIt.hasNext()) {
                pi = (PortInst)pIt.next();
                this.printWriter.println("\t<from component= \"" + pi.getNodeInst().getName() + "\" terminal=\"" + pi.getPortProto().getName() + "\" />");
            }
            pIt = inputs.iterator();
            while (pIt.hasNext()) {
                pi = (PortInst)pIt.next();
                this.printWriter.println("\t<to component= \"" + pi.getNodeInst().getName() + "\" terminal=\"" + pi.getPortProto().getName() + "\" />");
            }
            this.printWriter.println("</connection>");
        }
        this.printWriter.println();
        this.printWriter.println("</model>");
    }
}

