/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology.technologies.utils;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.DRCRules;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MOSRules
implements DRCRules {
    private Technology tech;
    public int numLayers;
    public int uTSize;
    public Double wideLimit;
    public String[] layerNames;
    public Double[] minWidth;
    public String[] minWidthRules;
    public Double[] conList;
    public String[] conListRules;
    public Double[] unConList;
    public String[] unConListRules;
    public Double[] conListWide;
    public String[] conListWideRules;
    public Double[] unConListWide;
    public String[] unConListWideRules;
    public Double[] conListMulti;
    public String[] conListMultiRules;
    public Double[] unConListMulti;
    public String[] unConListMultiRules;
    public Double[] edgeList;
    public String[] edgeListRules;
    public int numNodes;
    public String[] nodeNames;
    public Double[] minNodeSize;
    public String[] minNodeSizeRules;
    public Double[] cutNodeSize;
    public String[] cutNodeSizeRules;
    private int numberOfRules;
    private static final int MOSNORULE = -1;

    public MOSRules() {
    }

    private void setMinNodeSize(int index, String name, double width, double height) {
        this.minNodeSizeRules[index] = name;
        this.minNodeSize[index * 2] = new Double(width);
        this.minNodeSize[index * 2 + 1] = new Double(height);
    }

    public DRCTemplate getMinNodeSize(int index, int when) {
        DRCTemplate rule = new DRCTemplate(this.minNodeSizeRules[index], when, 2, 0.0, 0.0, null, null, this.minNodeSize[index * 2], false);
        rule.value2 = this.minNodeSize[index * 2 + 1];
        return rule;
    }

    public MOSRules(Technology tech) {
        int i;
        PrimitiveNode np;
        this.numLayers = tech.getNumLayers();
        this.numNodes = tech.getNumNodes();
        int numIndices = this.numLayers + this.numNodes;
        this.uTSize = (numIndices * numIndices + numIndices) / 2;
        this.wideLimit = new Double(0.0);
        this.tech = tech;
        this.layerNames = new String[this.numLayers];
        int j = 0;
        Iterator it = tech.getLayers();
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            this.layerNames[j++] = layer.getName();
        }
        this.nodeNames = new String[this.numNodes];
        j = 0;
        it = tech.getNodes();
        while (it.hasNext()) {
            np = (PrimitiveNode)it.next();
            this.nodeNames[j++] = np.getName();
        }
        this.conList = new Double[this.uTSize];
        this.conListRules = new String[this.uTSize];
        this.unConList = new Double[this.uTSize];
        this.unConListRules = new String[this.uTSize];
        this.conListWide = new Double[this.uTSize];
        this.conListWideRules = new String[this.uTSize];
        this.unConListWide = new Double[this.uTSize];
        this.unConListWideRules = new String[this.uTSize];
        this.conListMulti = new Double[this.uTSize];
        this.conListMultiRules = new String[this.uTSize];
        this.unConListMulti = new Double[this.uTSize];
        this.unConListMultiRules = new String[this.uTSize];
        this.edgeList = new Double[this.uTSize];
        this.edgeListRules = new String[this.uTSize];
        this.minWidth = new Double[this.numLayers];
        this.minWidthRules = new String[this.numLayers];
        for (i = 0; i < this.uTSize; ++i) {
            this.conList[i] = new Double(-1.0);
            this.conListRules[i] = "";
            this.unConList[i] = new Double(-1.0);
            this.unConListRules[i] = "";
            this.conListWide[i] = new Double(-1.0);
            this.conListWideRules[i] = "";
            this.unConListWide[i] = new Double(-1.0);
            this.unConListWideRules[i] = "";
            this.conListMulti[i] = new Double(-1.0);
            this.conListMultiRules[i] = "";
            this.unConListMulti[i] = new Double(-1.0);
            this.unConListMultiRules[i] = "";
            this.edgeList[i] = new Double(-1.0);
            this.edgeListRules[i] = "";
        }
        for (i = 0; i < this.numLayers; ++i) {
            this.minWidth[i] = new Double(-1.0);
            this.minWidthRules[i] = "";
        }
        this.minNodeSize = new Double[this.numNodes * 2];
        this.minNodeSizeRules = new String[this.numNodes];
        this.cutNodeSize = new Double[this.numNodes];
        this.cutNodeSizeRules = new String[this.numNodes];
        j = 0;
        it = tech.getNodes();
        while (it.hasNext()) {
            np = (PrimitiveNode)it.next();
            this.minNodeSize[j * 2] = new Double(np.getMinWidth());
            this.minNodeSize[j * 2 + 1] = new Double(np.getMinHeight());
            this.minNodeSizeRules[j] = np.getMinSizeRule();
            this.cutNodeSizeRules[j] = "";
            this.cutNodeSize[j] = new Double(-1.0);
            ++j;
        }
    }

    public boolean isForbiddenNode(int nodeIndex, int type, int techMode) {
        return false;
    }

    public static DRCRules makeSimpleRules(Technology tech, double[] conDist, double[] unConDist) {
        int i;
        MOSRules rules = new MOSRules(tech);
        if (conDist != null) {
            for (i = 0; i < conDist.length; ++i) {
                rules.conList[i] = new Double(conDist[i]);
            }
        }
        if (unConDist != null) {
            for (i = 0; i < unConDist.length; ++i) {
                rules.unConList[i] = new Double(unConDist[i]);
            }
        }
        return rules;
    }

    public double getWorstSpacingDistance() {
        double worstInteractionDistance = 0.0;
        for (int i = 0; i < this.uTSize; ++i) {
            double dist = this.unConList[i];
            if (dist > worstInteractionDistance) {
                worstInteractionDistance = dist;
            }
            if ((dist = this.unConListWide[i].doubleValue()) > worstInteractionDistance) {
                worstInteractionDistance = dist;
            }
            if (!((dist = this.unConListMulti[i].doubleValue()) > worstInteractionDistance)) continue;
            worstInteractionDistance = dist;
        }
        return worstInteractionDistance;
    }

    public double getMaxSurround(Technology tech, Layer layer, double maxSize) {
        double worstLayerRule = -1.0;
        int layerIndex = layer.getIndex();
        int tot = tech.getNumLayers();
        double wide = this.wideLimit;
        for (int i = 0; i < tot; ++i) {
            int pIndex = tech.getRuleIndex(layerIndex, i);
            double dist = this.unConList[pIndex];
            if (dist > worstLayerRule) {
                worstLayerRule = dist;
            }
            if (!(maxSize > wide) || !((dist = this.unConListWide[pIndex].doubleValue()) > worstLayerRule)) continue;
            worstLayerRule = dist;
        }
        return worstLayerRule;
    }

    public DRCTemplate getExtensionRule(Technology tech, Layer layer1, Layer layer2, int techMode, boolean isGateExtension) {
        return null;
    }

    public DRCTemplate getEdgeRule(Technology tech, Layer layer1, Layer layer2, int techMode) {
        int pIndex = tech.getRuleIndex(layer1.getIndex(), layer2.getIndex());
        double dist = this.edgeList[pIndex];
        if (dist < 0.0) {
            return null;
        }
        return new DRCTemplate(this.edgeListRules[pIndex], techMode, 11, 0.0, 0.0, null, null, dist, false);
    }

    public DRCTemplate getSpacingRule(Technology tech, Layer layer1, Layer layer2, boolean connected, boolean multiCut, double wideS, double length, int techMode) {
        double dist;
        int pIndex = tech.getRuleIndex(layer1.getIndex(), layer2.getIndex());
        double bestDist = -1.0;
        String rule = null;
        if (connected) {
            dist = this.conList[pIndex];
            if (dist >= 0.0) {
                bestDist = dist;
                rule = this.conListRules[pIndex];
            }
        } else {
            dist = this.unConList[pIndex];
            if (dist >= 0.0) {
                bestDist = dist;
                rule = this.unConListRules[pIndex];
            }
        }
        if (wideS > this.wideLimit) {
            if (connected) {
                dist = this.conListWide[pIndex];
                if (dist >= 0.0) {
                    bestDist = dist;
                    rule = this.conListWideRules[pIndex];
                }
            } else {
                dist = this.unConListWide[pIndex];
                if (dist >= 0.0) {
                    bestDist = dist;
                    rule = this.unConListWideRules[pIndex];
                }
            }
        }
        if (multiCut) {
            if (connected) {
                dist = this.conListMulti[pIndex];
                if (dist >= 0.0) {
                    bestDist = dist;
                    rule = this.conListMultiRules[pIndex];
                }
            } else {
                dist = this.unConListMulti[pIndex];
                if (dist >= 0.0) {
                    bestDist = dist;
                    rule = this.unConListMultiRules[pIndex];
                }
            }
        }
        if (bestDist < 0.0) {
            return null;
        }
        return new DRCTemplate(rule, techMode, 8, 0.0, 0.0, bestDist, false);
    }

    public boolean isAnyRule(Technology tech, Layer layer1, Layer layer2) {
        int pIndex = tech.getRuleIndex(layer1.getIndex(), layer2.getIndex());
        if (this.conList[pIndex] >= 0.0) {
            return true;
        }
        if (this.unConList[pIndex] >= 0.0) {
            return true;
        }
        if (this.conListWide[pIndex] >= 0.0) {
            return true;
        }
        if (this.unConListWide[pIndex] >= 0.0) {
            return true;
        }
        if (this.conListMulti[pIndex] >= 0.0) {
            return true;
        }
        if (this.unConListMulti[pIndex] >= 0.0) {
            return true;
        }
        return this.edgeList[pIndex] >= 0.0;
    }

    public boolean doesAllowMultipleWideRules(int index) {
        return this.unConListWide[index] == -1.0;
    }

    public int getNumberOfRules() {
        return this.numberOfRules;
    }

    public String[] getNodesWithRules() {
        return this.nodeNames;
    }

    public void addRule(int index, DRCTemplate rule, int spacingCase) {
        if (rule.ruleType == 2) {
            this.setMinNodeSize(index, rule.ruleName, rule.value1, rule.value2);
        } else {
            if (rule.value1 <= 0.0) {
                rule.value1 = -1.0;
            }
            block0 : switch (rule.ruleType) {
                case 12: {
                    switch (spacingCase) {
                        case 8: {
                            this.conList[index] = new Double(rule.value1);
                            this.conListRules[index] = rule.ruleName;
                            if (!(rule.maxWidth > 0.0)) break block0;
                            this.wideLimit = new Double(rule.maxWidth);
                            break;
                        }
                        case 10: {
                            this.conListWide[index] = new Double(rule.value1);
                            this.conListWideRules[index] = rule.ruleName;
                            break;
                        }
                        case 14: {
                            this.conListMulti[index] = new Double(rule.value1);
                            this.conListMultiRules[index] = rule.ruleName;
                            break;
                        }
                        case 11: {
                            this.edgeList[index] = new Double(rule.value1);
                            this.edgeListRules[index] = rule.ruleName;
                            break;
                        }
                        default: {
                            System.out.println("Error in MOSRules.setSpacingRules");
                            break;
                        }
                    }
                    break;
                }
                case 13: {
                    switch (spacingCase) {
                        case 8: {
                            this.unConList[index] = new Double(rule.value1);
                            this.unConListRules[index] = rule.ruleName;
                            break block0;
                        }
                        case 10: {
                            this.unConListWide[index] = new Double(rule.value1);
                            this.unConListWideRules[index] = rule.ruleName;
                            break block0;
                        }
                        case 14: {
                            this.unConListMulti[index] = new Double(rule.value1);
                            this.unConListMultiRules[index] = rule.ruleName;
                            break block0;
                        }
                    }
                    System.out.println("Error in MOSRules.setSpacingRules");
                    break;
                }
                default: {
                    System.out.println("Error in MOSRules.setSpacingRules");
                }
            }
        }
    }

    public void deleteRule(int index, DRCTemplate rule) {
        this.conListWide[index] = new Double(-1.0);
        this.conListWideRules[index] = "";
        this.unConListWide[index] = new Double(-1.0);
        this.unConListWideRules[index] = "";
    }

    public void setSpacingRules(int index, List newRules, int spacingCase) {
        for (int i = 0; i < newRules.size(); ++i) {
            DRCTemplate rule = (DRCTemplate)newRules.get(i);
            this.addRule(index, rule, spacingCase);
        }
    }

    public List getSpacingRules(int index, int type, int techMode) {
        ArrayList<DRCTemplate> list = new ArrayList<DRCTemplate>(2);
        switch (type) {
            case 8: {
                double dist = this.conList[index];
                if (dist >= 0.0) {
                    list.add(new DRCTemplate(this.conListRules[index], techMode, 12, 0.0, 0.0, null, null, dist, false));
                }
                if (!((dist = this.unConList[index].doubleValue()) >= 0.0)) break;
                list.add(new DRCTemplate(this.unConListRules[index], techMode, 13, 0.0, 0.0, null, null, dist, false));
                break;
            }
            case 10: {
                double dist = this.conListWide[index];
                if (dist >= 0.0) {
                    list.add(new DRCTemplate(this.conListWideRules[index], techMode, 12, this.wideLimit, 0.0, null, null, dist, false));
                }
                if (!((dist = this.unConListWide[index].doubleValue()) >= 0.0)) break;
                list.add(new DRCTemplate(this.unConListWideRules[index], techMode, 13, this.wideLimit, 0.0, null, null, dist, false));
                break;
            }
            case 14: {
                double dist = this.conListMulti[index];
                if (dist >= 0.0) {
                    list.add(new DRCTemplate(this.conListMultiRules[index], techMode, 12, 0.0, 0.0, null, null, dist, true));
                }
                if (!((dist = this.unConListMulti[index].doubleValue()) >= 0.0)) break;
                list.add(new DRCTemplate(this.unConListMultiRules[index], techMode, 13, 0.0, 0.0, null, null, dist, true));
                break;
            }
            case 11: {
                double dist = this.edgeList[index];
                if (!(dist >= 0.0)) break;
                list.add(new DRCTemplate(this.edgeListRules[index], techMode, 11, 0.0, 0.0, null, null, dist, false));
                break;
            }
            default: {
                System.out.println("Error in MOSRules.getSpacingRules");
            }
        }
        return list;
    }

    public void calculateNumberOfRules() {
        int i;
        int count = 0;
        for (i = 0; i < this.uTSize; ++i) {
            if (this.unConList[i] > -1.0) {
                ++count;
            }
            if (this.unConListWide[i] > -1.0) {
                ++count;
            }
            if (this.unConListMulti[i] > -1.0) {
                ++count;
            }
            if (this.conList[i] > -1.0) {
                ++count;
            }
            if (this.conListWide[i] > -1.0) {
                ++count;
            }
            if (this.conListMulti[i] > -1.0) {
                ++count;
            }
            if (!(this.edgeList[i] > -1.0)) continue;
            ++count;
        }
        for (i = 0; i < this.numLayers; ++i) {
            if (!(this.minWidth[i] > -1.0)) continue;
            ++count;
        }
        for (i = 0; i < this.minNodeSize.length; ++i) {
            if (!(this.minNodeSize[i] > -1.0)) continue;
            ++count;
        }
        this.numberOfRules = count;
    }

    public DRCTemplate getMinValue(Layer layer, int type, int techMode) {
        if (type != 1) {
            return null;
        }
        int index = layer.getIndex();
        double dist = this.minWidth[index];
        if (dist < 0.0) {
            return null;
        }
        return new DRCTemplate(this.minWidthRules[index], techMode, 1, 0.0, 0.0, null, null, dist, false);
    }

    public DRCTemplate getCutRule(int index, int type, int techMode) {
        if (type != 16) {
            return null;
        }
        double cutSize = this.minWidth[index];
        if (cutSize < 0.0) {
            return null;
        }
        return new DRCTemplate(this.cutNodeSizeRules[index], techMode, 16, 0.0, 0.0, null, null, cutSize, false);
    }

    public void setMinValue(Layer layer, String name, double value, int type, int techMode) {
        if (type != 1) {
            return;
        }
        int index = layer.getIndex();
        if (value <= 0.0) {
            value = -1.0;
        }
        this.minWidth[index] = new Double(value);
        this.minWidthRules[index] = name;
    }

    public void applyDRCOverrides(String override, Technology tech) {
        int startKey;
        int endKey;
        int pos = 0;
        int len = override.length();
        while (pos < len && (endKey = override.indexOf(58, startKey = pos)) >= 0) {
            int index;
            String key = override.substring(startKey, endKey);
            if (key.equals("c") || key.equals("cr") || key.equals("u") || key.equals("ur") || key.equals("cw") || key.equals("cwr") || key.equals("uw") || key.equals("uwr") || key.equals("cm") || key.equals("cmr") || key.equals("um") || key.equals("umr") || key.equals("e") || key.equals("er")) {
                Layer layer2;
                startKey = endKey + 1;
                Layer layer1 = Technology.getLayerFromOverride(override, startKey, '/', tech);
                if (layer1 == null || (startKey = override.indexOf(47, startKey)) < 0 || (layer2 = Technology.getLayerFromOverride(override, startKey + 1, '=', tech)) == null || (startKey = override.indexOf(61, startKey)) < 0 || (endKey = override.indexOf(59, startKey)) < 0) break;
                String newValue = override.substring(startKey + 1, endKey);
                index = tech.getRuleIndex(layer1.getIndex(), layer2.getIndex());
                if (key.equals("c")) {
                    this.conList[index] = new Double(TextUtils.atof(newValue));
                } else if (key.equals("cr")) {
                    this.conListRules[index] = newValue;
                } else if (key.equals("u")) {
                    this.unConList[index] = new Double(TextUtils.atof(newValue));
                } else if (key.equals("ur")) {
                    this.unConListRules[index] = newValue;
                } else if (key.equals("cw")) {
                    this.conListWide[index] = new Double(TextUtils.atof(newValue));
                } else if (key.equals("cwr")) {
                    this.conListWideRules[index] = newValue;
                } else if (key.equals("uw")) {
                    this.unConListWide[index] = new Double(TextUtils.atof(newValue));
                } else if (key.equals("uwr")) {
                    this.unConListWideRules[index] = newValue;
                } else if (key.equals("cm")) {
                    this.conListMulti[index] = new Double(TextUtils.atof(newValue));
                } else if (key.equals("cmr")) {
                    this.conListMultiRules[index] = newValue;
                } else if (key.equals("um")) {
                    this.unConListMulti[index] = new Double(TextUtils.atof(newValue));
                } else if (key.equals("umr")) {
                    this.unConListMultiRules[index] = newValue;
                } else if (key.equals("e")) {
                    this.edgeList[index] = new Double(TextUtils.atof(newValue));
                } else if (key.equals("er")) {
                    this.edgeListRules[index] = newValue;
                }
                pos = endKey + 1;
                continue;
            }
            if (key.equals("m") || key.equals("mr")) {
                startKey = endKey + 1;
                Layer layer = Technology.getLayerFromOverride(override, startKey, '=', tech);
                if (layer == null || (startKey = override.indexOf(61, startKey)) < 0 || (endKey = override.indexOf(59, startKey)) < 0) break;
                String newValue = override.substring(startKey + 1, endKey);
                int index2 = layer.getIndex();
                if (key.equals("m")) {
                    this.minWidth[index2] = new Double(TextUtils.atof(newValue));
                } else if (key.equals("mr")) {
                    this.minWidthRules[index2] = newValue;
                }
                pos = endKey + 1;
                continue;
            }
            if (key.equals("n") || key.equals("nr")) {
                PrimitiveNode oNp;
                String nodeName;
                PrimitiveNode np;
                startKey = endKey + 1;
                int endPos = override.indexOf(61, startKey);
                if (endPos < 0 || (np = tech.findNodeProto(nodeName = override.substring(startKey, endPos))) == null) break;
                index = 0;
                Iterator it = tech.getNodes();
                while (it.hasNext() && (oNp = (PrimitiveNode)it.next()) != np) {
                    ++index;
                }
                if (key.equals("n")) {
                    if ((startKey = override.indexOf(61, startKey)) < 0 || (endKey = override.indexOf(47, startKey)) < 0) break;
                    String newValue1 = override.substring(startKey + 1, endKey);
                    int otherEndKey = override.indexOf(59, startKey);
                    if (otherEndKey < 0) break;
                    String newValue2 = override.substring(endKey + 1, otherEndKey);
                    this.minNodeSize[index * 2] = new Double(TextUtils.atof(newValue1));
                    this.minNodeSize[index * 2 + 1] = new Double(TextUtils.atof(newValue2));
                } else if (key.equals("nr")) {
                    String newValue;
                    if ((startKey = override.indexOf(61, startKey)) < 0 || (endKey = override.indexOf(59, startKey)) < 0) break;
                    this.minNodeSizeRules[index] = newValue = override.substring(startKey + 1, endKey);
                }
                pos = endKey + 1;
                continue;
            }
            if (key.equals("w")) {
                startKey = endKey + 1;
                if ((endKey = override.indexOf(59, startKey)) < 0) break;
                String newValue = override.substring(startKey, endKey);
                this.wideLimit = new Double(TextUtils.atof(newValue));
                pos = endKey + 1;
                continue;
            }
            endKey = override.indexOf(59, startKey);
            pos = endKey + 1;
        }
    }
}

