/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.hierarchy;

import com.sun.electric.database.change.Undo;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.ImmutableTextDescriptor;
import com.sun.electric.database.variable.MutableTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ViewChanges;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Iterator;

public class Export
extends ElectricObject
implements PortProto,
Comparable {
    public static final String EXPORT_NAME_TD;
    public static final Variable.Key EXPORT_REFERENCE_NAME;
    private static final int PORTDRAWN = 0x4000000;
    private static final int BODYONLY = 0x8000000;
    private static final int STATEBITS = -268435456;
    private static final int STATEBITSSHIFTED = 30;
    private static final int STATEBITSSH = 27;
    private static final int EXPORT_BITS = -67108864;
    private Name name;
    private int userBits;
    private Cell parent;
    private int portIndex;
    private ImmutableTextDescriptor descriptor;
    private PortInst originalPort;
    private Undo.Change change;
    static final /* synthetic */ boolean $assertionsDisabled;

    private Export(Cell parent, String protoName, ImmutableTextDescriptor nameTextDescriptor, PortInst originalPort, int userBits) {
        if (!$assertionsDisabled && parent != originalPort.getNodeInst().getParent()) {
            throw new AssertionError();
        }
        this.parent = parent;
        this.name = Name.findName(protoName);
        if (nameTextDescriptor == null) {
            nameTextDescriptor = ImmutableTextDescriptor.getExportTextDescriptor();
        }
        this.descriptor = nameTextDescriptor.withDisplayWithoutParamAndCode();
        this.originalPort = originalPort;
        this.userBits = userBits & 0xFC000000;
    }

    public static Export newInstance(Cell parent, PortInst portInst, String protoName) {
        return Export.newInstance(parent, portInst, protoName, true);
    }

    public static Export newInstance(Cell parent, PortInst portInst, String protoName, boolean createOnIcon) {
        Cell icon;
        PortProto originalProto;
        if (parent.findExport(protoName) != null) {
            String oldName = protoName;
            protoName = ElectricObject.uniqueObjectName(protoName, parent, PortProto.class);
            System.out.println(parent + " already has an export named " + oldName + ", making new export named " + protoName);
            if (!$assertionsDisabled && parent.findExport(protoName) != null) {
                throw new AssertionError();
            }
        }
        int userBits = (originalProto = portInst.getPortProto()) instanceof Export ? ((Export)originalProto).userBits : originalProto.getCharacteristic().getBits() << 27;
        Export pp = Export.newInstance(parent, protoName, Export.smartPlacement(portInst), portInst, userBits);
        if (createOnIcon && (icon = parent.iconView()) != null && icon.findExport(protoName) == null) {
            Rectangle2D bounds = parent.getBounds();
            double locX = portInst.getPoly().getCenterX();
            double locY = portInst.getPoly().getCenterY();
            Rectangle2D iconBounds = icon.getBounds();
            double newlocX = (locX - bounds.getMinX()) / bounds.getWidth() * iconBounds.getWidth() + iconBounds.getMinX();
            double bodyDX = 1.0;
            double distToXEdge = locX - bounds.getMinX();
            if (locX >= bounds.getCenterX()) {
                bodyDX = -1.0;
                distToXEdge = bounds.getMaxX() - locX;
            }
            double newlocY = (locY - bounds.getMinY()) / bounds.getHeight() * iconBounds.getHeight() + iconBounds.getMinY();
            double bodyDY = 1.0;
            double distToYEdge = locY - bounds.getMinY();
            if (locY >= bounds.getCenterY()) {
                bodyDY = -1.0;
                distToYEdge = bounds.getMaxY() - locY;
            }
            if (distToXEdge > distToYEdge) {
                bodyDX = 0.0;
            } else {
                bodyDY = 0.0;
            }
            Point2D.Double point = new Point2D.Double(newlocX, newlocY);
            EditWindow.gridAlign(point);
            newlocX = ((Point2D)point).getX();
            newlocY = ((Point2D)point).getY();
            if (!ViewChanges.makeIconExport(pp, 0, newlocX, newlocY, newlocX + bodyDX, newlocY + bodyDY, icon)) {
                System.out.println("Warning: Failed to create associated export in icon " + icon.describe(true));
            }
        }
        return pp;
    }

    public static Export newInstance(Cell parent, String name, ImmutableTextDescriptor nameTextDescriptor, PortInst originalPort, int userBits) {
        if (originalPort == null) {
            System.out.println("Null port on Export " + name + " in " + parent);
            return null;
        }
        NodeInst ni = originalPort.getNodeInst();
        PortProto subpp = originalPort.getPortProto();
        if (ni.getParent() != parent || subpp.getParent() != ni.getProto()) {
            System.out.println("Bad port on Export " + name + " in " + parent);
            return null;
        }
        Export e = new Export(parent, name, nameTextDescriptor, originalPort, userBits);
        if (e.lowLevelLink(null)) {
            return null;
        }
        Undo.newObject(e);
        return e;
    }

    public void kill() {
        if (!this.isLinked()) {
            System.out.println("Export already killed");
            return;
        }
        this.checkChanging();
        Iterator it = this.parent.getInstancesOf();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            PortInst pi = ni.findPortInstFromProto(this);
            pi.disconnect();
        }
        Collection oldPortInsts = this.lowLevelUnlink();
        Undo.killExport(this, oldPortInsts);
    }

    public void rename(String newName) {
        String dupName;
        this.checkChanging();
        Cell cell = this.originalPort.getNodeInst().getParent();
        if (!(this.getName().equalsIgnoreCase(newName) && !this.getName().equals(newName) || (dupName = ElectricObject.uniqueObjectName(newName, cell, PortProto.class)).equals(newName))) {
            System.out.println(cell + " already has an export named " + newName + ", making new export named " + dupName);
            newName = dupName;
        }
        Name oldName = this.getNameKey();
        this.lowLevelRename(Name.findName(newName));
        Undo.renameObject(this, oldName);
        Cell iconCell = cell.iconView();
        if (iconCell != null && iconCell != cell) {
            Iterator it = iconCell.getPorts();
            while (it.hasNext()) {
                Export pp = (Export)it.next();
                if (!pp.getName().equals(oldName.toString())) continue;
                pp.rename(newName);
                break;
            }
        }
    }

    public boolean move(PortInst newPi) {
        this.checkChanging();
        NodeInst newno = newPi.getNodeInst();
        PortProto newsubpt = newPi.getPortProto();
        if (newno.getParent() != this.parent) {
            return true;
        }
        if (newsubpt.getParent() != newno.getProto()) {
            return true;
        }
        if (this.doesntConnect(newsubpt.getBasePort())) {
            return true;
        }
        PortInst oldPi = this.getOriginalPort();
        this.lowLevelModify(newPi);
        Undo.modifyExport(this, oldPi);
        return false;
    }

    public void lowLevelRename(Name newName) {
        if (!$assertionsDisabled && !this.isLinked()) {
            throw new AssertionError();
        }
        this.parent.moveExport(this.portIndex, newName.toString());
        this.name = newName;
    }

    public boolean lowLevelLink(Collection oldPortInsts) {
        if (!$assertionsDisabled && !this.parent.isLinked()) {
            throw new AssertionError();
        }
        NodeInst originalNode = this.originalPort.getNodeInst();
        originalNode.addExport(this);
        this.parent.addExport(this, oldPortInsts);
        return false;
    }

    public Collection lowLevelUnlink() {
        if (!$assertionsDisabled && !this.isLinked()) {
            throw new AssertionError();
        }
        NodeInst originalNode = this.originalPort.getNodeInst();
        originalNode.removeExport(this);
        return this.parent.removeExport(this);
    }

    public void lowLevelModify(PortInst newPi) {
        NodeInst origNode = this.getOriginalPort().getNodeInst();
        origNode.removeExport(this);
        NodeInst newNodeInst = newPi.getNodeInst();
        PortProto newPortProto = newPi.getPortProto();
        newNodeInst.addExport(this);
        this.originalPort = newNodeInst.findPortInstFromProto(newPortProto);
        this.changeallports();
    }

    void setPortIndex(int portIndex) {
        this.portIndex = portIndex;
    }

    public int lowLevelGetUserbits() {
        return this.userBits;
    }

    public void lowLevelSetUserbits(int userBits) {
        this.checkChanging();
        this.userBits = userBits & 0xFC000000;
        Undo.otherChange(this);
    }

    public Poly getNamePoly() {
        Poly poly = this.getOriginalPort().getPoly();
        double cX = poly.getCenterX();
        double cY = poly.getCenterY();
        ImmutableTextDescriptor td = this.getTextDescriptor(EXPORT_NAME_TD);
        double offX = td.getXOff();
        double offY = td.getYOff();
        TextDescriptor.Position pos = td.getPos();
        Poly.Type style = pos.getPolyType();
        Point2D[] pointList = new Point2D.Double[1];
        NodeInst ni = this.getOriginalPort().getNodeInst();
        if (ni.getAngle() != 0 || ni.isMirroredAboutXAxis() || ni.isMirroredAboutYAxis()) {
            pointList[0] = new Point2D.Double(cX, cY);
            AffineTransform trans = ni.rotateIn();
            trans.transform(pointList[0], pointList[0]);
            pointList[0].setLocation(pointList[0].getX() + offX, pointList[0].getY() + offY);
            trans = ni.rotateOut();
            trans.transform(pointList[0], pointList[0]);
        } else {
            pointList[0] = new Point2D.Double(cX + offX, cY + offY);
        }
        poly = new Poly(pointList);
        poly.setStyle(style);
        poly.setPort(this);
        poly.setString(this.getName());
        poly.setTextDescriptor(td);
        return poly;
    }

    public Cell whichCell() {
        return this.parent;
    }

    public NodeProto getParent() {
        return this.parent;
    }

    public int getPortIndex() {
        return this.portIndex;
    }

    public ImmutableTextDescriptor getTextDescriptor(String varName) {
        if (varName == EXPORT_NAME_TD) {
            return this.descriptor;
        }
        return super.getTextDescriptor(varName);
    }

    public ImmutableTextDescriptor lowLevelSetTextDescriptor(String varName, ImmutableTextDescriptor td) {
        if (varName == EXPORT_NAME_TD) {
            ImmutableTextDescriptor oldDescriptor = this.descriptor;
            this.descriptor = td.withDisplayWithoutParamAndCode();
            return oldDescriptor;
        }
        return super.lowLevelSetTextDescriptor(varName, td);
    }

    private static ImmutableTextDescriptor smartPlacement(PortInst originalPort) {
        int smartVertical = User.getSmartVerticalPlacement();
        int smartHorizontal = User.getSmartHorizontalPlacement();
        if (smartVertical == 0 && smartHorizontal == 0) {
            return ImmutableTextDescriptor.getExportTextDescriptor();
        }
        double dx = 0.0;
        double dy = 0.0;
        NodeInst ni = originalPort.getNodeInst();
        Rectangle2D nodeBounds = ni.getBounds();
        Iterator it = originalPort.getConnections();
        while (it.hasNext()) {
            Connection con = (Connection)it.next();
            ArcInst ai = con.getArc();
            Rectangle2D arcBounds = ai.getBounds();
            dx = arcBounds.getCenterX() - nodeBounds.getCenterX();
            dy = arcBounds.getCenterY() - nodeBounds.getCenterY();
        }
        if (smartHorizontal == 2) {
            dx = -dx;
        } else if (smartHorizontal != 1) {
            dx = 0.0;
        }
        if (smartVertical == 2) {
            dy = -dy;
        } else if (smartVertical != 1) {
            dy = 0.0;
        }
        MutableTextDescriptor td = MutableTextDescriptor.getExportTextDescriptor();
        td.setPos(td.getPos().align(Double.compare(dx, 0.0), Double.compare(dy, 0.0)));
        return ImmutableTextDescriptor.newImmutableTextDescriptor(td);
    }

    public Name getNameKey() {
        return this.name;
    }

    public String getName() {
        return this.name.toString();
    }

    public String getShortName() {
        String name = this.getNameKey().toString();
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char ch = name.charAt(i);
            if (TextUtils.isLetterOrDigit(ch)) continue;
            return name.substring(0, i);
        }
        return name;
    }

    public int compareTo(Object obj) {
        int cmp;
        Export that = (Export)obj;
        if (this.parent != that.parent && (cmp = this.parent.compareTo(that.parent)) != 0) {
            return cmp;
        }
        return this.name.toString().compareTo(that.name.toString());
    }

    public String toString() {
        return "export '" + this.getName() + "'";
    }

    public PortInst getOriginalPort() {
        return this.originalPort;
    }

    public PrimitivePort getBasePort() {
        PortProto pp = this.originalPort.getPortProto();
        return pp.getBasePort();
    }

    public boolean connectsTo(ArcProto arc) {
        return this.getBasePort().connectsTo(arc);
    }

    public PortCharacteristic getCharacteristic() {
        PortCharacteristic characteristic = PortCharacteristic.findCharacteristic(this.userBits >> 27 & 0x1E);
        return characteristic;
    }

    public void setCharacteristic(PortCharacteristic characteristic) {
        this.checkChanging();
        if (characteristic == null) {
            characteristic = PortCharacteristic.UNKNOWN;
        }
        this.userBits = this.userBits & 0xFFFFFFF | characteristic.getBits() << 27;
        Undo.otherChange(this);
    }

    public boolean isPower() {
        PortCharacteristic ch = this.getCharacteristic();
        if (ch == PortCharacteristic.PWR) {
            return true;
        }
        if (ch != PortCharacteristic.UNKNOWN) {
            return false;
        }
        return this.isNamedPower();
    }

    public boolean isNamedPower() {
        String name = this.getName().toLowerCase();
        if (name.indexOf("vdd") >= 0) {
            return true;
        }
        if (name.indexOf("vcc") >= 0) {
            return true;
        }
        if (name.indexOf("pwr") >= 0) {
            return true;
        }
        return name.indexOf("power") >= 0;
    }

    public boolean isGround() {
        PortCharacteristic ch = this.getCharacteristic();
        if (ch == PortCharacteristic.GND) {
            return true;
        }
        if (ch != PortCharacteristic.UNKNOWN) {
            return false;
        }
        return this.isNamedGround();
    }

    public boolean isNamedGround() {
        String name = this.getName().toLowerCase();
        if (name.indexOf("vss") >= 0) {
            return true;
        }
        if (name.indexOf("gnd") >= 0) {
            return true;
        }
        return name.indexOf("ground") >= 0;
    }

    public boolean isGlobalPartition() {
        return this.originalPort.getNodeInst().getProto() == Schematics.tech.globalPartitionNode;
    }

    public void setAlwaysDrawn() {
        this.checkChanging();
        this.userBits |= 0x4000000;
        Undo.otherChange(this);
    }

    public void clearAlwaysDrawn() {
        this.checkChanging();
        this.userBits &= 0xFBFFFFFF;
        Undo.otherChange(this);
    }

    public boolean isAlwaysDrawn() {
        return (this.userBits & 0x4000000) != 0;
    }

    public void setBodyOnly() {
        this.checkChanging();
        this.userBits |= 0x8000000;
        Undo.otherChange(this);
    }

    public void clearBodyOnly() {
        this.checkChanging();
        this.userBits &= 0xF7FFFFFF;
        Undo.otherChange(this);
    }

    public boolean isBodyOnly() {
        return (this.userBits & 0x8000000) != 0;
    }

    public static int parseJelibUserBits(String jelibUserBits) {
        PortCharacteristic ch;
        int userBits = 0;
        int slashPos = jelibUserBits.indexOf(47);
        if (slashPos >= 0) {
            String extras = jelibUserBits.substring(slashPos);
            jelibUserBits = jelibUserBits.substring(0, slashPos);
            while (extras.length() > 0) {
                switch (extras.charAt(1)) {
                    case 'A': {
                        userBits |= 0x4000000;
                        break;
                    }
                    case 'B': {
                        userBits |= 0x8000000;
                    }
                }
                extras = extras.substring(2);
            }
        }
        if ((ch = PortCharacteristic.findCharacteristicShort(jelibUserBits)) != null) {
            userBits |= ch.getBits() << 27;
        }
        return userBits;
    }

    public boolean isLinked() {
        try {
            return this.parent.isLinked() && this.parent.getPort(this.portIndex) == this;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    void check() {
        if (!$assertionsDisabled && this.originalPort == null) {
            throw new AssertionError();
        }
        NodeInst ni = this.originalPort.getNodeInst();
        PortProto pp = this.originalPort.getPortProto();
        if (!($assertionsDisabled || ni.getParent() == this.parent && ni.isLinked())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && ni.getProto() != pp.getParent()) {
            throw new AssertionError();
        }
        if (pp instanceof Export && !$assertionsDisabled && !((Export)pp).isLinked()) {
            throw new AssertionError();
        }
    }

    public void setChange(Undo.Change change) {
        this.change = change;
    }

    public Undo.Change getChange() {
        return this.change;
    }

    public PortProto getEquivalent() {
        Cell equiv = this.parent.getEquivalent();
        if (equiv == this.parent) {
            return this;
        }
        if (equiv == null) {
            return null;
        }
        return equiv.findPortProto(this.getNameKey());
    }

    public Export getEquivalentPort(Cell otherCell) {
        if (this.parent == otherCell) {
            return this;
        }
        return otherCell.findExport(this.getName());
    }

    public boolean doesntConnect(PrimitivePort newPP) {
        Iterator it = this.parent.getInstancesOf();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            PortInst pi = ni.findPortInstFromProto(this);
            Iterator cIt = pi.getConnections();
            while (cIt.hasNext()) {
                Connection con = (Connection)cIt.next();
                if (newPP.connectsTo(con.getArc().getProto())) continue;
                System.out.println(con.getArc() + " in " + ni.getParent() + " cannot connect to port " + this.getName());
                return true;
            }
            Iterator eIt = ni.getExports();
            while (eIt.hasNext()) {
                Export oPP = (Export)eIt.next();
                if (oPP.getOriginalPort().getPortProto() != this || !oPP.doesntConnect(newPP)) continue;
                return true;
            }
        }
        return false;
    }

    private void changeallports() {
        Export opp;
        this.recursivelyChangeAllPorts();
        if (this.parent.isIcon()) {
            Export opp2;
            Cell onp = this.parent.contentsView();
            if (onp != null && (opp2 = this.getEquivalentPort(onp)) != null) {
                opp2.setCharacteristic(this.getCharacteristic());
                opp2.recursivelyChangeAllPorts();
            }
            return;
        }
        Cell onp = this.parent.iconView();
        if (onp != null && (opp = this.getEquivalentPort(onp)) != null) {
            opp.setCharacteristic(this.getCharacteristic());
            opp.recursivelyChangeAllPorts();
        }
    }

    private void recursivelyChangeAllPorts() {
        Iterator it = this.parent.getInstancesOf();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            Iterator pIt = ni.getExports();
            while (pIt.hasNext()) {
                Export upPP = (Export)pIt.next();
                if (upPP.getOriginalPort().getPortProto() != this) continue;
                if (upPP.lowLevelGetUserbits() != this.lowLevelGetUserbits()) {
                    upPP.lowLevelSetUserbits(this.lowLevelGetUserbits());
                }
                upPP.recursivelyChangeAllPorts();
            }
        }
    }

    public boolean compare(Object obj, StringBuffer buffer) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PortProto no = (PortProto)obj;
        if (!this.getNameKey().equals(no.getNameKey())) {
            if (buffer != null) {
                buffer.append("'" + this + "' and '" + no + "' do not have same name\n");
            }
            return false;
        }
        PortCharacteristic noC = no.getCharacteristic();
        if (!this.getCharacteristic().getName().equals(noC.getName())) {
            if (buffer != null) {
                buffer.append("'" + this + "' and '" + no + "' do not have same characteristic\n");
            }
            return false;
        }
        return true;
    }

    static {
        $assertionsDisabled = !Export.class.desiredAssertionStatus();
        EXPORT_NAME_TD = new String("EXPORT_name");
        EXPORT_REFERENCE_NAME = ElectricObject.newKey("EXPORT_reference_name");
    }
}

