/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry;

import com.sun.electric.database.geometry.GeometryHandler;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.technology.Layer;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class PolySweepMerge
extends GeometryHandler {
    public static final int ONE_FRONTIER_MODE = 1;
    public static final int TWO_FRONTIER_MODE = 2;

    public PolySweepMerge() {
    }

    public PolySweepMerge(int initialSize) {
        super(initialSize);
    }

    public void setMode(int mode) {
    }

    public void add(Object key, Object element, boolean fasterAlgorithm) {
        PolySweepContainer container = (PolySweepContainer)this.layers.get(key);
        if (container == null) {
            container = new PolySweepContainer(true);
            this.layers.put(key, container);
        }
        container.add(element);
    }

    public void subtract(Object key, Object element) {
        PolySweepContainer container = (PolySweepContainer)this.layers.get(key);
        if (container == null) {
            return;
        }
        container.subtract(element);
    }

    public void subtractAll(HashMap map) {
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            List list = (List)map.get(key);
            PolySweepContainer container = (PolySweepContainer)this.layers.get(key);
            if (container == null) continue;
            for (int i = 0; i < list.size(); ++i) {
                container.subtract(list.get(i));
            }
        }
    }

    public void addAll(GeometryHandler subMerge, AffineTransform tTrans) {
        PolySweepMerge other = (PolySweepMerge)subMerge;
        ArrayList<Area> list = new ArrayList<Area>();
        Iterator it = other.layers.keySet().iterator();
        while (it.hasNext()) {
            Area area;
            int i;
            Object layer = it.next();
            PolySweepContainer container = (PolySweepContainer)this.layers.get(layer);
            PolySweepContainer otherContainer = (PolySweepContainer)other.layers.get(layer);
            if (container == null) {
                container = new PolySweepContainer(false);
                this.layers.put(layer, container);
                container.areas = new ArrayList(otherContainer.areas.size());
            }
            ArrayList<Object> otherAreas = new ArrayList<Object>(otherContainer.areas.size());
            for (i = 0; i < otherContainer.areas.size(); ++i) {
                area = (Area)otherContainer.areas.get(i);
                otherAreas.add(area.clone());
            }
            Collections.sort(otherAreas, areaSort);
            Collections.sort(container.areas, areaSort);
            for (i = 0; i < otherAreas.size(); ++i) {
                area = (Area)otherAreas.get(i);
                if (tTrans != null) {
                    area.transform(tTrans);
                }
                Rectangle2D rect = area.getBounds2D();
                double areaMinX = rect.getMinX();
                double areaMaxX = rect.getMaxX();
                boolean done = false;
                list.clear();
                for (int j = 0; j < container.areas.size() && !done; ++j) {
                    Area thisArea = (Area)container.areas.get(j);
                    Rectangle2D thisRect = thisArea.getBounds2D();
                    if (areaMaxX < thisRect.getMinX()) {
                        done = true;
                        break;
                    }
                    if (!(areaMinX <= thisRect.getMaxX())) continue;
                    list.add(thisArea);
                    area.add(thisArea);
                }
                container.areas.removeAll(list);
                container.areas.add(area);
            }
            otherAreas = null;
        }
    }

    public Collection getKeySet() {
        return this.layers.keySet();
    }

    public Iterator getKeyIterator() {
        return this.getKeySet().iterator();
    }

    public void postProcess(boolean merge) {
        if (merge) {
            this.mergeProcess();
        } else {
            this.disjointProcess();
        }
    }

    private void disjointProcess() {
        Iterator it = this.getKeyIterator();
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            PolySweepContainer container = (PolySweepContainer)this.layers.get(layer);
            if (container == null) continue;
            Collections.sort(container.areas, areaSort);
            double maxXSweep = -1.7976931348623157E308;
            Area areaXTmp = null;
            ArrayList twoFrontierAreas = new ArrayList();
            ArrayList<Area> tmp = new ArrayList<Area>();
            for (int i = 0; i < container.areas.size(); ++i) {
                Area geomArea = (Area)container.areas.get(i);
                Rectangle2D rectX = geomArea.getBounds2D();
                double minX = rectX.getX();
                double maxX = rectX.getMaxX();
                if (minX > maxXSweep) {
                    if (areaXTmp != null) {
                        PolySweepMerge.sweepYFrontier(twoFrontierAreas, tmp, false);
                        areaXTmp = null;
                    }
                    tmp.clear();
                }
                tmp.add(geomArea);
                if (areaXTmp == null) {
                    areaXTmp = geomArea;
                }
                if (!(maxX > maxXSweep)) continue;
                maxXSweep = maxX;
            }
            PolySweepMerge.sweepYFrontier(twoFrontierAreas, tmp, false);
            container.areas = twoFrontierAreas;
        }
    }

    private void mergeProcess() {
        Iterator it = this.getKeyIterator();
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            PolySweepContainer container = (PolySweepContainer)this.layers.get(layer);
            if (container == null) continue;
            Collections.sort(container.areas, areaSort);
            double maxXSweep = -1.7976931348623157E308;
            Area areaXTmp = null;
            ArrayList<Area> areas = new ArrayList<Area>();
            for (int i = 0; i < container.areas.size(); ++i) {
                Area geom = (Area)container.areas.get(i);
                Rectangle2D rectX = geom.getBounds2D();
                double minX = rectX.getX();
                double maxX = rectX.getMaxX();
                if (minX > maxXSweep && areaXTmp != null) {
                    if (!areas.contains(areaXTmp)) {
                        areas.add(areaXTmp);
                    }
                    areaXTmp = null;
                }
                if (areaXTmp == null) {
                    areaXTmp = geom;
                    areas.add(areaXTmp);
                } else {
                    areaXTmp.add(geom);
                }
                if (!(maxX > maxXSweep)) continue;
                maxXSweep = maxX;
            }
            if (areaXTmp != null && !areas.contains(areaXTmp)) {
                areas.add(areaXTmp);
            }
            container.areas = areas;
        }
    }

    private static void sweepYFrontier(List twoFrontierAreas, List tmp, boolean merge) {
        if (merge) {
            return;
        }
        Collections.sort(tmp, areaSort);
        double maxYSweep = -1.7976931348623157E308;
        Area areaYTmp = null;
        for (int j = 0; j < tmp.size(); ++j) {
            Area area = (Area)tmp.get(j);
            Rectangle2D rectY = area.getBounds2D();
            double minY = rectY.getY();
            double maxY = rectY.getMaxY();
            if (minY > maxYSweep) {
                if (areaYTmp != null && !twoFrontierAreas.contains(areaYTmp)) {
                    twoFrontierAreas.add(areaYTmp);
                }
                areaYTmp = null;
            }
            if (areaYTmp == null) {
                if (!merge) {
                    areaYTmp = (Area)area.clone();
                    twoFrontierAreas.add(area);
                } else {
                    areaYTmp = area;
                    twoFrontierAreas.add(areaYTmp);
                }
            } else if (merge) {
                areaYTmp.add(area);
            } else {
                Area clone = (Area)area.clone();
                clone.intersect(areaYTmp);
                if (!clone.isEmpty()) {
                    area.subtract(areaYTmp);
                }
                if (!area.isEmpty()) {
                    twoFrontierAreas.add(area);
                    areaYTmp.add(area);
                }
            }
            if (!(maxY > maxYSweep)) continue;
            maxYSweep = maxY;
        }
        if (areaYTmp != null && merge && !twoFrontierAreas.contains(areaYTmp)) {
            twoFrontierAreas.add(areaYTmp);
        }
    }

    public Collection getObjects(Object layer, boolean modified, boolean simple) {
        PolySweepContainer container = (PolySweepContainer)this.layers.get(layer);
        if (container == null) {
            return null;
        }
        ArrayList list = new ArrayList();
        Iterator it = container.areas.iterator();
        while (it.hasNext()) {
            Area area = (Area)it.next();
            PolyBase.getPointsInArea(area, (Layer)layer, simple, false, list);
        }
        return list;
    }

    private static class PolySweepContainer {
        private List areas = null;

        public PolySweepContainer(boolean createPolyList) {
            this.areas = createPolyList ? new ArrayList() : null;
        }

        public void add(Object value) {
            if (value instanceof Shape) {
                value = new Area((Shape)value);
            } else {
                System.out.println("Error: invalid class for addition in PolySweepMerge");
            }
            this.areas.add(value);
        }

        public void subtract(Object element) {
            Area elem = null;
            if (element instanceof Shape) {
                elem = new Area((Shape)element);
            } else {
                System.out.println("Error: invalid class for subtraction in PolySweepMerge");
            }
            for (int i = 0; i < this.areas.size(); ++i) {
                Area a = (Area)this.areas.get(i);
                a.subtract(elem);
            }
        }
    }
}

