/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.Layer;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.output.GDS;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class GDSTab
extends PreferencePanel {
    private boolean initialGDSOutputMergesBoxes;
    private boolean initialGDSOutputWritesExportPins;
    private boolean initialGDSOutputUpperCase;
    private boolean initialGDSInputIncludesText;
    private boolean initialGDSInputExpandsCells;
    private boolean initialGDSInputInstantiatesArrays;
    private boolean initialGDSInputIgnoresUnknownLayers;
    private int initialGDSTextLayer;
    private JList gdsLayersList;
    private DefaultListModel gdsLayersModel;
    private boolean changingGDS = false;
    private JPanel gds;
    private JTextField gdsDefaultTextLayer;
    private JCheckBox gdsInputExpandsCells;
    private JCheckBox gdsInputIgnoresUnknownLayers;
    private JCheckBox gdsInputIncludesText;
    private JCheckBox gdsInputInstantiatesArrays;
    private JScrollPane gdsLayerList;
    private JTextField gdsLayerNumber;
    private JCheckBox gdsOutputMergesBoxes;
    private JCheckBox gdsOutputUpperCase;
    private JCheckBox gdsOutputWritesExportPins;
    private JTextField gdsPinLayer;
    private JLabel gdsTechName;
    private JTextField gdsTextLayer;
    private JLabel jLabel29;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;

    public GDSTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.gds;
    }

    public String getName() {
        return "GDS";
    }

    public void init() {
        this.gdsTechName.setText("Technology " + this.curTech.getTechName() + ":");
        this.initialGDSOutputMergesBoxes = IOTool.isGDSOutMergesBoxes();
        this.gdsOutputMergesBoxes.setSelected(this.initialGDSOutputMergesBoxes);
        this.initialGDSOutputWritesExportPins = IOTool.isGDSOutWritesExportPins();
        this.gdsOutputWritesExportPins.setSelected(this.initialGDSOutputWritesExportPins);
        this.initialGDSOutputUpperCase = IOTool.isGDSOutUpperCase();
        this.gdsOutputUpperCase.setSelected(this.initialGDSOutputUpperCase);
        this.initialGDSTextLayer = IOTool.getGDSOutDefaultTextLayer();
        this.gdsDefaultTextLayer.setText(Integer.toString(this.initialGDSTextLayer));
        this.initialGDSInputIncludesText = IOTool.isGDSInIncludesText();
        this.gdsInputIncludesText.setSelected(this.initialGDSInputIncludesText);
        this.initialGDSInputExpandsCells = IOTool.isGDSInExpandsCells();
        this.gdsInputExpandsCells.setSelected(this.initialGDSInputExpandsCells);
        this.initialGDSInputInstantiatesArrays = IOTool.isGDSInInstantiatesArrays();
        this.gdsInputInstantiatesArrays.setSelected(this.initialGDSInputInstantiatesArrays);
        this.initialGDSInputIgnoresUnknownLayers = IOTool.isGDSInIgnoresUnknownLayers();
        this.gdsInputIgnoresUnknownLayers.setSelected(this.initialGDSInputIgnoresUnknownLayers);
        this.gdsLayersModel = new DefaultListModel();
        this.gdsLayersList = new JList(this.gdsLayersModel);
        this.gdsLayersList.setSelectionMode(0);
        this.gdsLayerList.setViewportView(this.gdsLayersList);
        this.gdsLayersList.clearSelection();
        this.gdsLayersList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                GDSTab.this.gdsClickLayer();
            }
        });
        this.gdsLayersModel.clear();
        Iterator it = this.curTech.getLayers();
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            String str = layer.getName();
            String gdsLayer = layer.getGDSLayer();
            if (gdsLayer != null) {
                str = str + " (" + gdsLayer + ")";
            }
            this.gdsLayersModel.addElement(str);
        }
        this.gdsLayersList.setSelectedIndex(0);
        this.gdsClickLayer();
        GDSDocumentListener myDocumentListener = new GDSDocumentListener(this);
        this.gdsLayerNumber.getDocument().addDocumentListener(myDocumentListener);
        this.gdsPinLayer.getDocument().addDocumentListener(myDocumentListener);
        this.gdsTextLayer.getDocument().addDocumentListener(myDocumentListener);
    }

    private void gdsClickLayer() {
        this.changingGDS = true;
        String str = (String)this.gdsLayersList.getSelectedValue();
        GDS.GDSLayers numbers = this.gdsGetNumbers(str);
        if (numbers == null) {
            return;
        }
        if (numbers.normal < 0) {
            this.gdsLayerNumber.setText("");
        } else {
            this.gdsLayerNumber.setText(Integer.toString(numbers.normal));
        }
        if (numbers.pin < 0) {
            this.gdsPinLayer.setText("");
        } else {
            this.gdsPinLayer.setText(Integer.toString(numbers.pin));
        }
        if (numbers.text < 0) {
            this.gdsTextLayer.setText("");
        } else {
            this.gdsTextLayer.setText(Integer.toString(numbers.text));
        }
        this.changingGDS = false;
    }

    private GDS.GDSLayers gdsGetNumbers(String str) {
        int openParen = str.indexOf(40);
        if (openParen < 0) {
            return null;
        }
        int closeParen = str.lastIndexOf(41);
        if (closeParen < 0) {
            return null;
        }
        String gdsNumbers = str.substring(openParen + 1, closeParen);
        GDS.GDSLayers numbers = GDS.parseLayerString(gdsNumbers);
        return numbers;
    }

    private Layer gdsGetLayer(String str) {
        int openParen = str.indexOf(40);
        if (openParen < 0) {
            return null;
        }
        String layerName = str.substring(0, openParen - 1);
        Layer layer = this.curTech.findLayer(layerName);
        return layer;
    }

    private void gdsNumbersChanged() {
        String textLayer;
        if (this.changingGDS) {
            return;
        }
        String str = (String)this.gdsLayersList.getSelectedValue();
        Layer layer = this.gdsGetLayer(str);
        if (layer == null) {
            return;
        }
        String newLine = layer.getName() + " (" + this.gdsLayerNumber.getText().trim();
        String pinLayer = this.gdsPinLayer.getText().trim();
        if (pinLayer.length() > 0) {
            newLine = newLine + "," + pinLayer + "p";
        }
        if ((textLayer = this.gdsTextLayer.getText().trim()).length() > 0) {
            newLine = newLine + "," + textLayer + "t";
        }
        newLine = newLine + ")";
        int index = this.gdsLayersList.getSelectedIndex();
        this.gdsLayersModel.set(index, newLine);
    }

    public void term() {
        boolean currentInputIgnoresUnknownLayers;
        boolean currentInputInstantiatesArrays;
        boolean currentInputExpandsCells;
        boolean currentInputIncludesText;
        int currentTextLayer;
        boolean currentOutputUpperCase;
        boolean currentOutputWritesExportPins;
        for (int i = 0; i < this.gdsLayersModel.getSize(); ++i) {
            GDS.GDSLayers numbers;
            String str = (String)this.gdsLayersModel.getElementAt(i);
            Layer layer = this.gdsGetLayer(str);
            if (layer == null || (numbers = this.gdsGetNumbers(str)) == null) continue;
            String currentGDSNumbers = "";
            if (numbers.normal >= 0) {
                currentGDSNumbers = currentGDSNumbers + Integer.toString(numbers.normal);
            }
            if (numbers.pin >= 0) {
                currentGDSNumbers = currentGDSNumbers + "," + numbers.pin + "p";
            }
            if (numbers.text >= 0) {
                currentGDSNumbers = currentGDSNumbers + "," + numbers.text + "t";
            }
            if (currentGDSNumbers.equalsIgnoreCase(layer.getGDSLayer())) continue;
            layer.setGDSLayer(currentGDSNumbers);
        }
        boolean currentOutputMergesBoxes = this.gdsOutputMergesBoxes.isSelected();
        if (currentOutputMergesBoxes != this.initialGDSOutputMergesBoxes) {
            IOTool.setGDSOutMergesBoxes(currentOutputMergesBoxes);
        }
        if ((currentOutputWritesExportPins = this.gdsOutputWritesExportPins.isSelected()) != this.initialGDSOutputWritesExportPins) {
            IOTool.setGDSOutWritesExportPins(currentOutputWritesExportPins);
        }
        if ((currentOutputUpperCase = this.gdsOutputUpperCase.isSelected()) != this.initialGDSOutputUpperCase) {
            IOTool.setGDSOutUpperCase(currentOutputUpperCase);
        }
        if ((currentTextLayer = TextUtils.atoi(this.gdsDefaultTextLayer.getText())) != this.initialGDSTextLayer) {
            IOTool.setGDSOutDefaultTextLayer(currentTextLayer);
        }
        if ((currentInputIncludesText = this.gdsInputIncludesText.isSelected()) != this.initialGDSInputIncludesText) {
            IOTool.setGDSInIncludesText(currentInputIncludesText);
        }
        if ((currentInputExpandsCells = this.gdsInputExpandsCells.isSelected()) != this.initialGDSInputExpandsCells) {
            IOTool.setGDSInExpandsCells(currentInputExpandsCells);
        }
        if ((currentInputInstantiatesArrays = this.gdsInputInstantiatesArrays.isSelected()) != this.initialGDSInputInstantiatesArrays) {
            IOTool.setGDSInInstantiatesArrays(currentInputInstantiatesArrays);
        }
        if ((currentInputIgnoresUnknownLayers = this.gdsInputIgnoresUnknownLayers.isSelected()) != this.initialGDSInputIgnoresUnknownLayers) {
            IOTool.setGDSInIgnoresUnknownLayers(currentInputIgnoresUnknownLayers);
        }
    }

    private void initComponents() {
        this.gds = new JPanel();
        this.gdsLayerList = new JScrollPane();
        this.jLabel6 = new JLabel();
        this.gdsLayerNumber = new JTextField();
        this.jLabel7 = new JLabel();
        this.gdsPinLayer = new JTextField();
        this.jLabel8 = new JLabel();
        this.gdsTextLayer = new JTextField();
        this.gdsInputIncludesText = new JCheckBox();
        this.gdsInputExpandsCells = new JCheckBox();
        this.gdsInputInstantiatesArrays = new JCheckBox();
        this.gdsInputIgnoresUnknownLayers = new JCheckBox();
        this.gdsOutputMergesBoxes = new JCheckBox();
        this.gdsOutputWritesExportPins = new JCheckBox();
        this.gdsOutputUpperCase = new JCheckBox();
        this.jLabel9 = new JLabel();
        this.gdsDefaultTextLayer = new JTextField();
        this.gdsTechName = new JLabel();
        this.jLabel29 = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("IO Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                GDSTab.this.closeDialog(evt);
            }
        });
        this.gds.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)this.gdsLayerList, gridBagConstraints);
        this.jLabel6.setText("GDS Layer(s):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.gds.add((Component)this.jLabel6, gridBagConstraints);
        this.gdsLayerNumber.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)this.gdsLayerNumber, gridBagConstraints);
        this.jLabel7.setText("Pin layer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.gds.add((Component)this.jLabel7, gridBagConstraints);
        this.gdsPinLayer.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)this.gdsPinLayer, gridBagConstraints);
        this.jLabel8.setText("Text layer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.gds.add((Component)this.jLabel8, gridBagConstraints);
        this.gdsTextLayer.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)this.gdsTextLayer, gridBagConstraints);
        this.gdsInputIncludesText.setText("Input includes Text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.gds.add((Component)this.gdsInputIncludesText, gridBagConstraints);
        this.gdsInputExpandsCells.setText("Input expands cells");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.gds.add((Component)this.gdsInputExpandsCells, gridBagConstraints);
        this.gdsInputInstantiatesArrays.setText("Input instantiates Arrays");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.gds.add((Component)this.gdsInputInstantiatesArrays, gridBagConstraints);
        this.gdsInputIgnoresUnknownLayers.setText("Input ignores unknown layers");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 6, 4);
        this.gds.add((Component)this.gdsInputIgnoresUnknownLayers, gridBagConstraints);
        this.gdsOutputMergesBoxes.setText("Output merges Boxes");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 4, 2, 4);
        this.gds.add((Component)this.gdsOutputMergesBoxes, gridBagConstraints);
        this.gdsOutputWritesExportPins.setText("Output writes export Pins");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.gds.add((Component)this.gdsOutputWritesExportPins, gridBagConstraints);
        this.gdsOutputUpperCase.setText("Output all upper-case");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.gds.add((Component)this.gdsOutputUpperCase, gridBagConstraints);
        this.jLabel9.setText("Output default text layer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.gds.add((Component)this.jLabel9, gridBagConstraints);
        this.gdsDefaultTextLayer.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)this.gdsDefaultTextLayer, gridBagConstraints);
        this.gdsTechName.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)this.gdsTechName, gridBagConstraints);
        this.jLabel29.setText("Negative layer values generate no GDS");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 3;
        this.gds.add((Component)this.jLabel29, gridBagConstraints);
        this.getContentPane().add((Component)this.gds, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class GDSDocumentListener
    implements DocumentListener {
        GDSTab dialog;

        GDSDocumentListener(GDSTab dialog) {
            this.dialog = dialog;
        }

        public void changedUpdate(DocumentEvent e) {
            this.dialog.gdsNumbersChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            this.dialog.gdsNumbersChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            this.dialog.gdsNumbersChanged();
        }
    }
}

