/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.DRCRules;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.utils.MOSRules;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DesignRulesTab
extends PreferencePanel {
    private JList designRulesFromList;
    private JList designRulesToList;
    private DefaultListModel designRulesFromModel;
    private DefaultListModel designRulesToModel;
    private MOSRules drRules;
    private boolean designRulesUpdating = false;
    private boolean designRulesFactoryReset = false;
    private boolean[] designRulesValidLayers;
    private JPanel designRules;
    private JScrollPane drFromList;
    private ButtonGroup drLayerOrNode;
    private JRadioButton drLayers;
    private JTextField drMinHeight;
    private JTextField drMinWidth;
    private JTextField drMinWidthRule;
    private JTextField drMultiConnected;
    private JTextField drMultiConnectedRule;
    private JTextField drMultiUnconnected;
    private JTextField drMultiUnconnectedRule;
    private JRadioButton drNodes;
    private JTextField drNormalConnected;
    private JTextField drNormalConnectedRule;
    private JTextField drNormalEdge;
    private JTextField drNormalEdgeRule;
    private JTextField drNormalUnconnected;
    private JTextField drNormalUnconnectedRule;
    private JCheckBox drShowOnlyLinesWithRules;
    private JLabel drTechName;
    private JScrollPane drToList;
    private JTextField drWideConnected;
    private JTextField drWideConnectedRule;
    private JTextField drWideLimit;
    private JTextField drWideUnconnected;
    private JTextField drWideUnconnectedRule;
    private JButton factoryReset;
    private JLabel jLabel35;
    private JLabel jLabel37;
    private JLabel jLabel38;
    private JLabel jLabel39;
    private JLabel jLabel40;
    private JLabel jLabel41;
    private JLabel jLabel42;
    private JLabel jLabel43;
    private JLabel jLabel44;
    private JLabel jLabel45;
    private JLabel jLabel46;
    private JLabel jLabel47;
    private JLabel jLabel48;
    private JLabel jLabel49;
    private JLabel jLabel50;
    private JLabel jLabel51;
    private JLabel jLabel52;
    private JLabel jLabel53;

    public DesignRulesTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.designRules;
    }

    public String getName() {
        return "Design Rules";
    }

    public void init() {
        Layer layer;
        int i;
        Object[] layers;
        DRCRules rules = DRC.getRules(this.curTech);
        if (rules == null || !(rules instanceof MOSRules)) {
            if (rules == null) {
                this.drTechName.setText(this.curTech.getTechName() + " HAS NO DESIGN RULES");
            } else {
                this.drTechName.setText(this.curTech.getTechName() + ": UNDER CONSTRUCTION");
            }
            this.drLayers.setEnabled(false);
            this.drNodes.setEnabled(false);
            this.drShowOnlyLinesWithRules.setEnabled(false);
            this.drMinWidth.setEnabled(false);
            this.drMinWidthRule.setEnabled(false);
            this.drMinHeight.setEnabled(false);
            this.drNormalConnected.setEnabled(false);
            this.drNormalConnectedRule.setEnabled(false);
            this.drNormalUnconnected.setEnabled(false);
            this.drNormalUnconnectedRule.setEnabled(false);
            this.drNormalEdge.setEnabled(false);
            this.drNormalEdgeRule.setEnabled(false);
            this.drWideConnected.setEnabled(false);
            this.drWideConnectedRule.setEnabled(false);
            this.drWideUnconnected.setEnabled(false);
            this.drWideUnconnectedRule.setEnabled(false);
            this.drMultiConnected.setEnabled(false);
            this.drMultiConnectedRule.setEnabled(false);
            this.drMultiUnconnected.setEnabled(false);
            this.drMultiUnconnectedRule.setEnabled(false);
            this.drWideLimit.setEnabled(false);
            this.factoryReset.setEnabled(false);
            return;
        }
        this.drRules = (MOSRules)rules;
        this.drLayers.setSelected(true);
        this.designRulesFromModel = new DefaultListModel();
        this.designRulesFromList = new JList(this.designRulesFromModel);
        this.designRulesFromList.setSelectionMode(0);
        this.drFromList.setViewportView(this.designRulesFromList);
        this.designRulesFromList.clearSelection();
        this.designRulesFromList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                DesignRulesTab.this.designRulesGetSelectedLayerLoadDRCToList();
            }
        });
        this.designRulesToModel = new DefaultListModel();
        this.designRulesToList = new JList(this.designRulesToModel);
        this.designRulesToList.setSelectionMode(0);
        this.drToList.setViewportView(this.designRulesToList);
        this.designRulesToList.clearSelection();
        this.designRulesToList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                DesignRulesTab.this.designRulesShowSelectedLayerRules();
            }
        });
        this.drShowOnlyLinesWithRules.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                DesignRulesTab.this.designRulesGetSelectedLayerLoadDRCToList();
            }
        });
        this.drLayers.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                DesignRulesTab.this.designRulesWhichSetChanged();
            }
        });
        this.drNodes.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                DesignRulesTab.this.designRulesWhichSetChanged();
            }
        });
        DRCDocumentListener myDocumentListener = new DRCDocumentListener(this);
        this.drMinWidth.getDocument().addDocumentListener(myDocumentListener);
        this.drMinWidthRule.getDocument().addDocumentListener(myDocumentListener);
        this.drMinHeight.getDocument().addDocumentListener(myDocumentListener);
        this.drNormalConnected.getDocument().addDocumentListener(myDocumentListener);
        this.drNormalConnectedRule.getDocument().addDocumentListener(myDocumentListener);
        this.drNormalUnconnected.getDocument().addDocumentListener(myDocumentListener);
        this.drNormalUnconnectedRule.getDocument().addDocumentListener(myDocumentListener);
        this.drNormalEdge.getDocument().addDocumentListener(myDocumentListener);
        this.drNormalEdgeRule.getDocument().addDocumentListener(myDocumentListener);
        this.drWideConnected.getDocument().addDocumentListener(myDocumentListener);
        this.drWideConnectedRule.getDocument().addDocumentListener(myDocumentListener);
        this.drWideUnconnected.getDocument().addDocumentListener(myDocumentListener);
        this.drWideUnconnectedRule.getDocument().addDocumentListener(myDocumentListener);
        this.drMultiConnected.getDocument().addDocumentListener(myDocumentListener);
        this.drMultiConnectedRule.getDocument().addDocumentListener(myDocumentListener);
        this.drMultiUnconnected.getDocument().addDocumentListener(myDocumentListener);
        this.drMultiUnconnectedRule.getDocument().addDocumentListener(myDocumentListener);
        this.drWideLimit.getDocument().addDocumentListener(myDocumentListener);
        int numLayers = this.curTech.getNumLayers();
        this.designRulesValidLayers = new boolean[numLayers];
        for (int i2 = 0; i2 < numLayers; ++i2) {
            this.designRulesValidLayers[i2] = false;
        }
        Iterator it = this.curTech.getNodes();
        while (it.hasNext()) {
            PrimitiveNode np = (PrimitiveNode)it.next();
            if (np.isNotUsed()) continue;
            layers = np.getLayers();
            for (i = 0; i < layers.length; ++i) {
                Technology.NodeLayer nl = layers[i];
                layer = nl.getLayer();
                this.designRulesValidLayers[layer.getIndex()] = true;
            }
        }
        it = this.curTech.getArcs();
        while (it.hasNext()) {
            PrimitiveArc ap = (PrimitiveArc)it.next();
            if (ap.isNotUsed()) continue;
            layers = ap.getLayers();
            for (i = 0; i < layers.length; ++i) {
                Object al = layers[i];
                layer = ((Technology.ArcLayer)al).getLayer();
                this.designRulesValidLayers[layer.getIndex()] = true;
            }
        }
        this.factoryReset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DesignRulesTab.this.factoryResetDRCActionPerformed(evt);
            }
        });
        this.drTechName.setText("'" + this.curTech.getTechName() + "'");
        this.designRulesSetupForLayersOrNodes();
        this.designRulesGetSelectedLayerLoadDRCToList();
    }

    private void factoryResetDRCActionPerformed(ActionEvent evt) {
        int response = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), "Are you sure you want to do a factory reset of these design rules?");
        if (response != 0) {
            return;
        }
        this.designRulesFactoryReset = true;
    }

    private void designRulesWhichSetChanged() {
        this.designRulesSetupForLayersOrNodes();
        this.designRulesGetSelectedLayerLoadDRCToList();
    }

    private void designRulesEditChanged() {
        if (this.designRulesUpdating) {
            return;
        }
        if (this.drNodes.isSelected()) {
            int lineNo = this.designRulesFromList.getSelectedIndex();
            if (lineNo < 0) {
                return;
            }
            String nName = (String)this.designRulesFromList.getSelectedValue();
            for (int node = 0; node < this.drRules.numNodes; ++node) {
                if (!nName.equals(this.drRules.nodeNames[node])) continue;
                String a = this.drMinWidth.getText();
                this.drRules.minNodeSize[node * 2] = a.length() == 0 ? new Double(-1.0) : new Double(TextUtils.atof(a));
                a = this.drMinHeight.getText();
                this.drRules.minNodeSize[node * 2 + 1] = a.length() == 0 ? new Double(-1.0) : new Double(TextUtils.atof(a));
                this.drRules.minNodeSizeRules[node] = this.drMinWidthRule.getText();
                break;
            }
        } else {
            int layer1 = this.designRulesGetSelectedLayer(this.designRulesFromList);
            if (layer1 < 0) {
                return;
            }
            int layer2 = this.designRulesGetSelectedLayer(this.designRulesToList);
            if (layer2 < 0) {
                return;
            }
            int dindex = this.curTech.getLayerIndex(layer1, layer2);
            String a = this.drNormalConnected.getText();
            this.drRules.conList[dindex] = a.length() == 0 ? new Double(-1.0) : new Double(TextUtils.atof(a));
            this.drRules.conListRules[dindex] = this.drNormalConnectedRule.getText();
            a = this.drNormalUnconnected.getText();
            this.drRules.unConList[dindex] = a.length() == 0 ? new Double(-1.0) : new Double(TextUtils.atof(a));
            this.drRules.unConListRules[dindex] = this.drNormalUnconnectedRule.getText();
            a = this.drWideConnected.getText();
            this.drRules.conListWide[dindex] = a.length() == 0 ? new Double(-1.0) : new Double(TextUtils.atof(a));
            this.drRules.conListWideRules[dindex] = this.drWideConnectedRule.getText();
            a = this.drWideUnconnected.getText();
            this.drRules.unConListWide[dindex] = a.length() == 0 ? new Double(-1.0) : new Double(TextUtils.atof(a));
            this.drRules.unConListWideRules[dindex] = this.drWideUnconnectedRule.getText();
            a = this.drMultiConnected.getText();
            this.drRules.conListMulti[dindex] = a.length() == 0 ? new Double(-1.0) : new Double(TextUtils.atof(a));
            this.drRules.conListMultiRules[dindex] = this.drMultiConnectedRule.getText();
            a = this.drMultiUnconnected.getText();
            this.drRules.unConListMulti[dindex] = a.length() == 0 ? new Double(-1.0) : new Double(TextUtils.atof(a));
            this.drRules.unConListMultiRules[dindex] = this.drMultiUnconnectedRule.getText();
            a = this.drNormalEdge.getText();
            this.drRules.edgeList[dindex] = a.length() == 0 ? new Double(-1.0) : new Double(TextUtils.atof(a));
            this.drRules.edgeListRules[dindex] = this.drNormalEdgeRule.getText();
            a = this.drWideLimit.getText();
            double value = TextUtils.atof(a);
            this.drRules.wideLimit = new Double(TextUtils.atof(a));
            int lineNo = this.designRulesToList.getSelectedIndex();
            String line = this.drMakeToListLine(dindex, lineNo, false);
            this.designRulesToModel.setElementAt(line, lineNo);
            a = this.drMinWidth.getText();
            this.drRules.minWidth[layer1] = a.length() == 0 ? new Double(-1.0) : new Double(TextUtils.atof(a));
            this.drRules.minWidthRules[layer1] = this.drMinWidthRule.getText();
        }
    }

    private void designRulesSetupForLayersOrNodes() {
        this.designRulesFromModel.clear();
        this.designRulesUpdating = true;
        if (this.drNodes.isSelected()) {
            for (int i = 0; i < this.drRules.numNodes; ++i) {
                this.designRulesFromModel.addElement(this.drRules.nodeNames[i]);
            }
            this.drMinHeight.setEditable(true);
            this.drNormalConnected.setText("");
            this.drNormalConnected.setEditable(false);
            this.drNormalConnectedRule.setText("");
            this.drNormalConnectedRule.setEditable(false);
            this.drNormalUnconnected.setText("");
            this.drNormalUnconnected.setEditable(false);
            this.drNormalUnconnectedRule.setText("");
            this.drNormalUnconnectedRule.setEditable(false);
            this.drNormalEdge.setText("");
            this.drNormalEdge.setEditable(false);
            this.drNormalEdgeRule.setText("");
            this.drNormalEdgeRule.setEditable(false);
            this.drWideLimit.setText("");
            this.drWideLimit.setEditable(false);
            this.drWideConnected.setText("");
            this.drWideConnected.setEditable(false);
            this.drWideConnectedRule.setText("");
            this.drWideConnectedRule.setEditable(false);
            this.drWideUnconnected.setText("");
            this.drWideUnconnected.setEditable(false);
            this.drWideUnconnectedRule.setText("");
            this.drWideUnconnectedRule.setEditable(false);
            this.drMultiConnected.setText("");
            this.drMultiConnected.setEditable(false);
            this.drMultiConnectedRule.setText("");
            this.drMultiConnectedRule.setEditable(false);
            this.drMultiUnconnected.setText("");
            this.drMultiUnconnected.setEditable(false);
            this.drMultiUnconnectedRule.setText("");
            this.drMultiUnconnectedRule.setEditable(false);
            this.drShowOnlyLinesWithRules.setEnabled(false);
            this.drToList.setEnabled(false);
        } else {
            for (int i = 0; i < this.drRules.numLayers; ++i) {
                if (!this.designRulesValidLayers[i]) continue;
                this.designRulesFromModel.addElement(this.drRules.layerNames[i]);
            }
            this.drMinHeight.setText("");
            this.drMinHeight.setEditable(false);
            this.drNormalConnected.setEditable(true);
            this.drNormalConnectedRule.setEditable(true);
            this.drNormalUnconnected.setEditable(true);
            this.drNormalUnconnectedRule.setEditable(true);
            this.drNormalEdge.setEditable(true);
            this.drNormalEdgeRule.setEditable(true);
            this.drWideLimit.setEditable(true);
            this.drWideLimit.setText(this.drRules.wideLimit.toString());
            this.drWideConnected.setEditable(true);
            this.drWideConnectedRule.setEditable(true);
            this.drWideUnconnected.setEditable(true);
            this.drWideUnconnectedRule.setEditable(true);
            this.drMultiConnected.setEditable(true);
            this.drMultiConnectedRule.setEditable(true);
            this.drMultiUnconnected.setEditable(true);
            this.drMultiUnconnectedRule.setEditable(true);
            this.drShowOnlyLinesWithRules.setEnabled(true);
            this.drToList.setEnabled(true);
        }
        this.designRulesFromList.setSelectedIndex(0);
        this.designRulesUpdating = false;
    }

    private void designRulesGetSelectedLayerLoadDRCToList() {
        this.designRulesUpdating = true;
        if (this.drNodes.isSelected()) {
            int j = this.designRulesFromList.getSelectedIndex();
            double wid = this.drRules.minNodeSize[j * 2];
            if (wid < 0.0) {
                this.drMinWidth.setText("");
            } else {
                this.drMinWidth.setText(TextUtils.formatDouble(wid));
            }
            double hei = this.drRules.minNodeSize[j * 2 + 1];
            if (hei < 0.0) {
                this.drMinHeight.setText("");
            } else {
                this.drMinHeight.setText(Double.toString(hei));
            }
            this.drMinWidthRule.setText(this.drRules.minNodeSizeRules[j]);
        } else {
            boolean onlyvalid = this.drShowOnlyLinesWithRules.isSelected();
            int j = this.designRulesGetSelectedLayer(this.designRulesFromList);
            if (j >= 0) {
                if (this.drRules.minWidth[j] < 0.0) {
                    this.drMinWidth.setText("");
                } else {
                    this.drMinWidth.setText(this.drRules.minWidth[j].toString());
                }
                this.drMinWidthRule.setText(this.drRules.minWidthRules[j]);
                this.designRulesToModel.clear();
                int count = 0;
                for (int i = 0; i < this.drRules.numLayers; ++i) {
                    if (!this.designRulesValidLayers[i]) continue;
                    int layer1 = j;
                    int layer2 = i;
                    if (layer1 > layer2) {
                        int temp = layer1;
                        layer1 = layer2;
                        layer2 = temp;
                    }
                    int dindex = (layer1 + 1) * (layer1 / 2) + (layer1 & 1) * ((layer1 + 1) / 2);
                    String line = this.drMakeToListLine(dindex = layer2 + this.drRules.numLayers * layer1 - dindex, i, onlyvalid);
                    if (line.length() == 0) continue;
                    this.designRulesToModel.addElement(line);
                    ++count;
                }
                if (count > 0) {
                    this.designRulesToList.setSelectedIndex(0);
                }
            }
        }
        this.designRulesUpdating = false;
        this.designRulesShowSelectedLayerRules();
    }

    private String drMakeToListLine(int dindex, int lindex, boolean onlyValid) {
        String conDist = "";
        if (this.drRules.conList[dindex] >= 0.0) {
            conDist = this.drRules.conList[dindex].toString();
        }
        String unConDist = "";
        if (this.drRules.unConList[dindex] >= 0.0) {
            unConDist = this.drRules.unConList[dindex].toString();
        }
        String conDistWide = "";
        if (this.drRules.conListWide[dindex] >= 0.0) {
            conDistWide = this.drRules.conListWide[dindex].toString();
        }
        String unConDistWide = "";
        if (this.drRules.unConListWide[dindex] >= 0.0) {
            unConDistWide = this.drRules.unConListWide[dindex].toString();
        }
        String conDistMulti = "";
        if (this.drRules.conListMulti[dindex] >= 0.0) {
            conDistMulti = this.drRules.conListMulti[dindex].toString();
        }
        String unConDistMulti = "";
        if (this.drRules.unConListMulti[dindex] >= 0.0) {
            unConDistMulti = this.drRules.unConListMulti[dindex].toString();
        }
        String edgeDist = "";
        if (this.drRules.edgeList[dindex] >= 0.0) {
            edgeDist = this.drRules.edgeList[dindex].toString();
        }
        if (onlyValid && conDist.length() == 0 && unConDist.length() == 0 && conDistWide.length() == 0 && unConDistWide.length() == 0 && conDistMulti.length() == 0 && unConDistMulti.length() == 0 && edgeDist.length() == 0) {
            return "";
        }
        String ret = this.drRules.layerNames[lindex] + " (" + conDist + "/" + unConDist + "/" + conDistWide + "/" + unConDistWide + "/" + conDistMulti + "/" + unConDistMulti + "/" + edgeDist + ")";
        return ret;
    }

    private int designRulesGetSelectedLayer(JList theList) {
        int lineNo = theList.getSelectedIndex();
        if (lineNo < 0) {
            return -1;
        }
        String lName = (String)theList.getSelectedValue();
        int termPos = lName.indexOf(" (");
        if (termPos >= 0) {
            lName = lName.substring(0, termPos);
        }
        for (int layer = 0; layer < this.drRules.numLayers; ++layer) {
            if (!lName.equals(this.drRules.layerNames[layer])) continue;
            return layer;
        }
        return -1;
    }

    private void designRulesShowSelectedLayerRules() {
        if (this.designRulesUpdating) {
            return;
        }
        if (this.drNodes.isSelected()) {
            return;
        }
        this.designRulesUpdating = true;
        this.drNormalConnected.setText("");
        this.drNormalConnectedRule.setText("");
        this.drNormalUnconnected.setText("");
        this.drNormalUnconnectedRule.setText("");
        this.drWideConnected.setText("");
        this.drWideConnectedRule.setText("");
        this.drWideUnconnected.setText("");
        this.drWideUnconnectedRule.setText("");
        this.drMultiConnected.setText("");
        this.drMultiConnectedRule.setText("");
        this.drMultiUnconnected.setText("");
        this.drMultiUnconnectedRule.setText("");
        this.drNormalEdge.setText("");
        this.drNormalEdgeRule.setText("");
        int layer1 = this.designRulesGetSelectedLayer(this.designRulesFromList);
        int layer2 = this.designRulesGetSelectedLayer(this.designRulesToList);
        if (layer1 >= 0 && layer2 >= 0) {
            if (layer1 > layer2) {
                int temp = layer1;
                layer1 = layer2;
                layer2 = temp;
            }
            int dindex = (layer1 + 1) * (layer1 / 2) + (layer1 & 1) * ((layer1 + 1) / 2);
            if (this.drRules.conList[dindex = layer2 + this.drRules.numLayers * layer1 - dindex] >= 0.0) {
                this.drNormalConnected.setText(this.drRules.conList[dindex].toString());
            }
            if (this.drRules.unConList[dindex] >= 0.0) {
                this.drNormalUnconnected.setText(this.drRules.unConList[dindex].toString());
            }
            if (this.drRules.conListWide[dindex] >= 0.0) {
                this.drWideConnected.setText(this.drRules.conListWide[dindex].toString());
            }
            if (this.drRules.unConListWide[dindex] >= 0.0) {
                this.drWideUnconnected.setText(this.drRules.unConListWide[dindex].toString());
            }
            if (this.drRules.conListMulti[dindex] >= 0.0) {
                this.drMultiConnected.setText(this.drRules.conListMulti[dindex].toString());
            }
            if (this.drRules.unConListMulti[dindex] >= 0.0) {
                this.drMultiUnconnected.setText(this.drRules.unConListMulti[dindex].toString());
            }
            if (this.drRules.edgeList[dindex] >= 0.0) {
                this.drNormalEdge.setText(this.drRules.edgeList[dindex].toString());
            }
            this.drNormalConnectedRule.setText(this.drRules.conListRules[dindex]);
            this.drNormalUnconnectedRule.setText(this.drRules.unConListRules[dindex]);
            this.drWideConnectedRule.setText(this.drRules.conListWideRules[dindex]);
            this.drWideUnconnectedRule.setText(this.drRules.unConListWideRules[dindex]);
            this.drMultiConnectedRule.setText(this.drRules.conListMultiRules[dindex]);
            this.drMultiUnconnectedRule.setText(this.drRules.unConListMultiRules[dindex]);
            this.drNormalEdgeRule.setText(this.drRules.edgeListRules[dindex]);
        }
        this.designRulesUpdating = false;
    }

    public void term() {
        if (this.designRulesFactoryReset) {
            DRC.resetDRCDates();
            DRCRules rules = this.curTech.getFactoryDesignRules();
            if (rules instanceof MOSRules) {
                this.drRules = (MOSRules)rules;
            }
        }
        DRC.setRules(this.curTech, this.drRules);
    }

    private void initComponents() {
        this.drLayerOrNode = new ButtonGroup();
        this.designRules = new JPanel();
        this.jLabel35 = new JLabel();
        this.drTechName = new JLabel();
        this.drLayers = new JRadioButton();
        this.drNodes = new JRadioButton();
        this.drFromList = new JScrollPane();
        this.jLabel37 = new JLabel();
        this.drShowOnlyLinesWithRules = new JCheckBox();
        this.drToList = new JScrollPane();
        this.jLabel38 = new JLabel();
        this.jLabel39 = new JLabel();
        this.drMinWidth = new JTextField();
        this.drMinWidthRule = new JTextField();
        this.drMinHeight = new JTextField();
        this.jLabel40 = new JLabel();
        this.jLabel41 = new JLabel();
        this.jLabel42 = new JLabel();
        this.jLabel43 = new JLabel();
        this.jLabel44 = new JLabel();
        this.jLabel45 = new JLabel();
        this.jLabel46 = new JLabel();
        this.jLabel47 = new JLabel();
        this.jLabel48 = new JLabel();
        this.jLabel49 = new JLabel();
        this.jLabel50 = new JLabel();
        this.jLabel51 = new JLabel();
        this.jLabel52 = new JLabel();
        this.jLabel53 = new JLabel();
        this.drNormalConnected = new JTextField();
        this.drNormalConnectedRule = new JTextField();
        this.drNormalUnconnected = new JTextField();
        this.drNormalUnconnectedRule = new JTextField();
        this.drNormalEdge = new JTextField();
        this.drNormalEdgeRule = new JTextField();
        this.drWideLimit = new JTextField();
        this.drWideConnected = new JTextField();
        this.drWideConnectedRule = new JTextField();
        this.drWideUnconnected = new JTextField();
        this.drWideUnconnectedRule = new JTextField();
        this.drMultiConnected = new JTextField();
        this.drMultiConnectedRule = new JTextField();
        this.drMultiUnconnected = new JTextField();
        this.drMultiUnconnectedRule = new JTextField();
        this.factoryReset = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Tool Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DesignRulesTab.this.closeDialog(evt);
            }
        });
        this.designRules.setLayout(new GridBagLayout());
        this.jLabel35.setText("Technology:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.designRules.add((Component)this.jLabel35, gridBagConstraints);
        this.drTechName.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = 17;
        this.designRules.add((Component)this.drTechName, gridBagConstraints);
        this.drLayers.setText("Layers:");
        this.drLayerOrNode.add(this.drLayers);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.designRules.add((Component)this.drLayers, gridBagConstraints);
        this.drNodes.setText("Nodes:");
        this.drLayerOrNode.add(this.drNodes);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.designRules.add((Component)this.drNodes, gridBagConstraints);
        this.drFromList.setPreferredSize(new Dimension(75, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.5;
        this.designRules.add((Component)this.drFromList, gridBagConstraints);
        this.jLabel37.setText("To Layer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.designRules.add((Component)this.jLabel37, gridBagConstraints);
        this.drShowOnlyLinesWithRules.setText("Show only lines with rules");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.designRules.add((Component)this.drShowOnlyLinesWithRules, gridBagConstraints);
        this.drToList.setPreferredSize(new Dimension(150, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        this.designRules.add((Component)this.drToList, gridBagConstraints);
        this.jLabel38.setText("Minimum Width:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        this.designRules.add((Component)this.jLabel38, gridBagConstraints);
        this.jLabel39.setText("Minimum Height:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        this.designRules.add((Component)this.jLabel39, gridBagConstraints);
        this.drMinWidth.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        this.designRules.add((Component)this.drMinWidth, gridBagConstraints);
        this.drMinWidthRule.setColumns(9);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        this.designRules.add((Component)this.drMinWidthRule, gridBagConstraints);
        this.drMinHeight.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 11;
        this.designRules.add((Component)this.drMinHeight, gridBagConstraints);
        this.jLabel40.setText("Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.designRules.add((Component)this.jLabel40, gridBagConstraints);
        this.jLabel41.setText("Rule");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.designRules.add((Component)this.jLabel41, gridBagConstraints);
        this.jLabel42.setText("Normal:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        this.designRules.add((Component)this.jLabel42, gridBagConstraints);
        this.jLabel43.setText("Distance");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.designRules.add((Component)this.jLabel43, gridBagConstraints);
        this.jLabel44.setText("Rule");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.designRules.add((Component)this.jLabel44, gridBagConstraints);
        this.jLabel45.setText("When connected:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 14, 4, 0);
        this.designRules.add((Component)this.jLabel45, gridBagConstraints);
        this.jLabel46.setText("Not connected:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 14, 4, 0);
        this.designRules.add((Component)this.jLabel46, gridBagConstraints);
        this.jLabel47.setText("Edge:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 14, 4, 0);
        this.designRules.add((Component)this.jLabel47, gridBagConstraints);
        this.jLabel48.setText("Wide (when bigger than this):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        this.designRules.add((Component)this.jLabel48, gridBagConstraints);
        this.jLabel49.setText("When connected:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 14, 4, 0);
        this.designRules.add((Component)this.jLabel49, gridBagConstraints);
        this.jLabel50.setText("Not connected:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 14, 4, 0);
        this.designRules.add((Component)this.jLabel50, gridBagConstraints);
        this.jLabel51.setText("Multiple cuts:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        this.designRules.add((Component)this.jLabel51, gridBagConstraints);
        this.jLabel52.setText("When connected:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 14, 4, 0);
        this.designRules.add((Component)this.jLabel52, gridBagConstraints);
        this.jLabel53.setText("Not connected:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 14, 4, 0);
        this.designRules.add((Component)this.jLabel53, gridBagConstraints);
        this.drNormalConnected.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.designRules.add((Component)this.drNormalConnected, gridBagConstraints);
        this.drNormalConnectedRule.setColumns(9);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.designRules.add((Component)this.drNormalConnectedRule, gridBagConstraints);
        this.drNormalUnconnected.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.designRules.add((Component)this.drNormalUnconnected, gridBagConstraints);
        this.drNormalUnconnectedRule.setColumns(9);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.designRules.add((Component)this.drNormalUnconnectedRule, gridBagConstraints);
        this.drNormalEdge.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.designRules.add((Component)this.drNormalEdge, gridBagConstraints);
        this.drNormalEdgeRule.setColumns(9);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.designRules.add((Component)this.drNormalEdgeRule, gridBagConstraints);
        this.drWideLimit.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.designRules.add((Component)this.drWideLimit, gridBagConstraints);
        this.drWideConnected.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.designRules.add((Component)this.drWideConnected, gridBagConstraints);
        this.drWideConnectedRule.setColumns(9);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.designRules.add((Component)this.drWideConnectedRule, gridBagConstraints);
        this.drWideUnconnected.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.designRules.add((Component)this.drWideUnconnected, gridBagConstraints);
        this.drWideUnconnectedRule.setColumns(9);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.designRules.add((Component)this.drWideUnconnectedRule, gridBagConstraints);
        this.drMultiConnected.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.designRules.add((Component)this.drMultiConnected, gridBagConstraints);
        this.drMultiConnectedRule.setColumns(9);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.designRules.add((Component)this.drMultiConnectedRule, gridBagConstraints);
        this.drMultiUnconnected.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.designRules.add((Component)this.drMultiUnconnected, gridBagConstraints);
        this.drMultiUnconnectedRule.setColumns(9);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.designRules.add((Component)this.drMultiUnconnectedRule, gridBagConstraints);
        this.factoryReset.setText("Factory Reset");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 3;
        this.designRules.add((Component)this.factoryReset, gridBagConstraints);
        this.getContentPane().add((Component)this.designRules, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class DRCDocumentListener
    implements DocumentListener {
        DesignRulesTab dialog;

        DRCDocumentListener(DesignRulesTab dialog) {
            this.dialog = dialog;
        }

        public void changedUpdate(DocumentEvent e) {
            this.dialog.designRulesEditChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            this.dialog.designRulesEditChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            this.dialog.designRulesEditChanged();
        }
    }
}

