/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.logicaleffort;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.logicaleffort.LENetlister2;
import com.sun.electric.tool.logicaleffort.LENetwork;
import com.sun.electric.tool.logicaleffort.LENodable;
import com.sun.electric.tool.logicaleffort.LEPin;
import com.sun.electric.tool.logicaleffort.LETool;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CachedCell {
    private Cell cell;
    private Map lenodables;
    private Map cellnodables;
    private boolean containsSizableGates;
    private Map localNetworks;
    private Boolean contextFree;
    private static final boolean DEBUG = false;

    protected CachedCell(Cell cell, Netlist netlist) {
        this.cell = cell;
        this.lenodables = new HashMap();
        this.localNetworks = new HashMap();
        this.cellnodables = new HashMap();
        this.containsSizableGates = false;
        this.contextFree = null;
        if (netlist != null) {
            Iterator it = netlist.getNetworks();
            while (it.hasNext()) {
                Network jnet = (Network)it.next();
                LENetwork net = new LENetwork(jnet.describe());
                this.localNetworks.put(jnet, net);
            }
        }
    }

    protected boolean isContainsSizableGates() {
        return this.containsSizableGates;
    }

    protected LENodable getLENodable(Nodable no) {
        return (LENodable)this.lenodables.get(no);
    }

    protected Iterator getLENodables() {
        return this.lenodables.values().iterator();
    }

    protected CellNodable getCellNodable(Nodable no) {
        return (CellNodable)this.cellnodables.get(no);
    }

    protected Iterator getCellNodables() {
        return this.cellnodables.values().iterator();
    }

    protected Map getLocalNetworks() {
        return this.localNetworks;
    }

    protected void add(Nodable no, LENodable leno) {
        if (leno.isLeGate()) {
            this.containsSizableGates = true;
        }
        Iterator it = leno.getPins().iterator();
        while (it.hasNext()) {
            LEPin pin = (LEPin)it.next();
            Network jnet = pin.getNetwork();
            LENetwork net = (LENetwork)this.localNetworks.get(jnet);
            net.add(pin);
        }
        this.lenodables.put(no, leno);
    }

    protected void add(Nodable no, LENetlister2.LECellInfo info, CachedCell subCell, LENetlister2.LECellInfo subCellInfo, LENetlister2.NetlisterConstants constants) {
        CellNodable ceno = new CellNodable();
        ceno.no = no;
        ceno.subCell = subCell;
        ceno.mfactorVar = LETool.getMFactor(no);
        this.cellnodables.put(no, ceno);
        if (subCell.isContainsSizableGates()) {
            this.containsSizableGates = true;
            return;
        }
        if (!subCell.isContextFree(constants)) {
            ceno.subCell = subCell = subCell.copy();
        }
        Iterator it = subCell.getLocalNetworks().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Network subJNet = (Network)entry.getKey();
            LENetwork subLENet = (LENetwork)entry.getValue();
            Network localJNet = subCellInfo.getNetworkInParent(subJNet);
            if (localJNet == null) continue;
            LENetwork net = (LENetwork)this.localNetworks.get(localJNet);
            if (net == null) {
                net = new LENetwork(localJNet.describe());
                this.localNetworks.put(localJNet, net);
            }
            net.add(subLENet);
        }
    }

    protected boolean isContextFree(LENetlister2.NetlisterConstants constants) {
        if (this.contextFree == null) {
            if (this.isContainsSizableGates()) {
                this.contextFree = new Boolean(false);
            } else {
                boolean cf = this.isContextFreeRecurse(VarContext.globalContext, 1.0f, constants);
                this.contextFree = new Boolean(cf);
            }
        }
        return this.contextFree;
    }

    private boolean isContextFreeRecurse(VarContext context, float mfactor, LENetlister2.NetlisterConstants constants) {
        Iterator<Object> it = this.lenodables.values().iterator();
        while (it.hasNext()) {
            LENodable leno = (LENodable)it.next();
            boolean b = leno.setOnlyContext(context, null, mfactor, 0.0f, constants);
            if (b) continue;
            return false;
        }
        it = this.cellnodables.entrySet().iterator();
        while (it.hasNext()) {
            boolean b;
            Map.Entry entry = (Map.Entry)it.next();
            Nodable no = (Nodable)entry.getKey();
            CellNodable ceno = (CellNodable)entry.getValue();
            float subCellMFactor = mfactor;
            if (ceno.mfactorVar != null) {
                Object retVal = context.evalVar(ceno.mfactorVar);
                if (retVal == null) {
                    return false;
                }
                subCellMFactor *= VarContext.objectToFloat(retVal, 1.0f);
            }
            if ((b = ceno.subCell.isContextFree(constants)) || ceno.subCell.isContextFreeRecurse(context.push(no), subCellMFactor, constants)) continue;
            return false;
        }
        return true;
    }

    private CachedCell copy() {
        Iterator nit;
        Map.Entry entry;
        CachedCell copy = new CachedCell(this.cell, null);
        HashMap<LENetwork, LENetwork> origSubNetsToCopySubNets = new HashMap<LENetwork, LENetwork>();
        Iterator it = this.cellnodables.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            Nodable no = (Nodable)entry.getKey();
            CellNodable ceno = (CellNodable)entry.getValue();
            CellNodable cenoCopy = new CellNodable();
            cenoCopy.no = ceno.no;
            cenoCopy.mfactorVar = ceno.mfactorVar;
            cenoCopy.subCell = ceno.subCell.copy();
            copy.cellnodables.put(no, cenoCopy);
            nit = ceno.subCell.localNetworks.entrySet().iterator();
            while (nit.hasNext()) {
                Map.Entry netentry = nit.next();
                Network jnet = (Network)netentry.getKey();
                LENetwork origNet = (LENetwork)netentry.getValue();
                LENetwork copyNet = (LENetwork)cenoCopy.subCell.localNetworks.get(jnet);
                origSubNetsToCopySubNets.put(origNet, copyNet);
            }
        }
        it = this.localNetworks.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            Network jnet = (Network)entry.getKey();
            LENetwork net = (LENetwork)entry.getValue();
            LENetwork netCopy = new LENetwork(net.getName());
            nit = net.getSubNets();
            while (nit.hasNext()) {
                LENetwork subnet = (LENetwork)nit.next();
                LENetwork copySubNet = (LENetwork)origSubNetsToCopySubNets.get(subnet);
                netCopy.add(copySubNet);
            }
            copy.localNetworks.put(jnet, netCopy);
        }
        it = this.lenodables.values().iterator();
        while (it.hasNext()) {
            LENodable leno = (LENodable)((Object)it.next());
            LENodable lenoCopy = leno.copy();
            copy.add(leno.getNodable(), lenoCopy);
        }
        copy.containsSizableGates = this.containsSizableGates;
        copy.contextFree = this.contextFree;
        return copy;
    }

    protected void printContents(String indent, PrintStream out) {
        Map.Entry entry;
        out.println(indent + "CachedCell " + this.cell.describe() + " contents:");
        Iterator<Object> it = this.lenodables.values().iterator();
        while (it.hasNext()) {
            LENodable leno = (LENodable)it.next();
            out.println(leno.printOneLine(indent + "  "));
        }
        it = this.localNetworks.entrySet().iterator();
        while (it.hasNext()) {
            entry = (Map.Entry)it.next();
            Network jnet = (Network)entry.getKey();
            LENetwork net = (LENetwork)entry.getValue();
            net.print(indent + "  ", out);
        }
        it = this.cellnodables.entrySet().iterator();
        while (it.hasNext()) {
            entry = (Map.Entry)it.next();
            Nodable no = (Nodable)entry.getKey();
            CellNodable ceno = (CellNodable)entry.getValue();
            boolean subCachable = ceno.subCell.isContextFree(null);
            System.out.println(indent + indent + "contains subCachedCell for " + ceno.subCell.cell.describe() + " (" + (subCachable ? "cachable" : "not cachable") + ")");
        }
    }

    protected static class CellNodable {
        Nodable no;
        CachedCell subCell;
        Variable mfactorVar;

        protected CellNodable() {
        }
    }
}

