/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.hierarchy;

import com.sun.electric.database.change.Undo;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.ui.TopLevel;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;

public class Library
extends ElectricObject {
    public static final Variable.Key FONT_ASSOCIATIONS;
    private static final int LIBCHANGEDMAJOR = 1;
    private static final int READFROMDISK = 4;
    private static final int LIBCHANGEDMINOR = 64;
    private static final int HIDDENLIBRARY = 128;
    private String libName;
    private URL libFile;
    private Version version;
    private ArrayList cells;
    private Pref curCellPref;
    private int userBits;
    private int flagBits;
    private List referencedLibs;
    private static Preferences prefs;
    private static List libraries;
    private static Library curLib;
    static final /* synthetic */ boolean $assertionsDisabled;

    private Library() {
        if (prefs == null) {
            prefs = Preferences.userNodeForPackage(this.getClass());
        }
        this.setLinked(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Library newInstance(String libName, URL libFile) {
        Library existingLibrary;
        if (libName == null || libName.equals("")) {
            System.out.println("Error: '" + libName + "' is not a valid name");
            return null;
        }
        String legalName = libName.replace(' ', '-');
        if (!legalName.equalsIgnoreCase(libName)) {
            System.out.println("Warning: library renamed to '" + legalName + "'");
        }
        if ((existingLibrary = Library.findLibrary(legalName)) != null) {
            System.out.println("Error: library '" + legalName + "' already exists");
            return existingLibrary;
        }
        Library lib = new Library();
        lib.cells = new ArrayList();
        lib.curCellPref = null;
        lib.libName = legalName;
        lib.libFile = libFile;
        lib.referencedLibs = new ArrayList();
        lib.setLinked(true);
        List list = libraries;
        synchronized (list) {
            libraries.add(lib);
        }
        Undo.setNextChangeQuiet(false);
        Undo.newObject(lib);
        return lib;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean kill() {
        Library newCurLib = null;
        if (curLib == this) {
            Iterator it = Library.getLibraries();
            while (it.hasNext()) {
                Library lib = (Library)it.next();
                if (lib == curLib || lib.isHidden()) continue;
                newCurLib = lib;
                break;
            }
            if (newCurLib == null) {
                System.out.println("Cannot delete the last library");
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot delete the last " + this.toString(), "Close library", 1);
                return false;
            }
        }
        if (!libraries.contains(this)) {
            System.out.println("Cannot delete library " + this);
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot delete " + this.toString(), "Close library", 0);
            return false;
        }
        boolean referenced = false;
        Iterator it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            if (lib == this) continue;
            Iterator cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = (Cell)cIt.next();
                Iterator nIt = cell.getNodes();
                while (nIt.hasNext()) {
                    Cell subCell;
                    NodeInst ni = (NodeInst)nIt.next();
                    if (!(ni.getProto() instanceof Cell) || (subCell = (Cell)ni.getProto()).getLibrary() != this) continue;
                    JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot delete library " + this.getName() + " because one of its cells (" + subCell.describe() + ") is being used (by " + cell.libDescribe() + ")", "Close library", 0);
                    referenced = true;
                    break;
                }
                if (!referenced) continue;
                break;
            }
            if (!referenced) continue;
            break;
        }
        if (referenced) {
            return false;
        }
        this.erase();
        List list = libraries;
        synchronized (list) {
            libraries.remove(this);
        }
        if (newCurLib != null) {
            newCurLib.setCurrent();
        }
        this.setLinked(false);
        Undo.setNextChangeQuiet(false);
        Undo.killObject(this);
        return true;
    }

    public void erase() {
        Iterator it = this.getCells();
        while (it.hasNext()) {
            Cell c = (Cell)it.next();
            c.kill();
        }
        this.cells.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCell(Cell c) {
        ArrayList arrayList = this.cells;
        synchronized (arrayList) {
            if (this.cells.contains(c)) {
                System.out.println("Tried to re-add a cell to a library: " + c);
                return;
            }
            this.cells.add(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCell(Cell c) {
        ArrayList arrayList = this.cells;
        synchronized (arrayList) {
            if (!this.cells.contains(c)) {
                System.out.println("Tried to remove a non-existant Cell from a library: " + c);
                return;
            }
            this.cells.remove(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LibraryDependency addReferencedLib(Library lib) {
        List list = this.referencedLibs;
        synchronized (list) {
            if (this.referencedLibs.contains(lib)) {
                return null;
            }
        }
        ArrayList libDependencies = new ArrayList();
        if (lib.isReferencedLib(this, libDependencies)) {
            LibraryDependency d = new LibraryDependency();
            d.startLib = lib;
            d.finalRefLib = this;
            Library startLib = lib;
            Iterator itLib = libDependencies.iterator();
            while (itLib.hasNext()) {
                Library refLib = (Library)itLib.next();
                boolean found = false;
                Iterator itCell = startLib.getCells();
                while (itCell.hasNext()) {
                    Cell c = (Cell)itCell.next();
                    Iterator it = c.getNodes();
                    while (it.hasNext()) {
                        Cell cc;
                        NodeInst ni = (NodeInst)it.next();
                        NodeProto np = ni.getProto();
                        if (!(np instanceof Cell) || (cc = (Cell)np).getLibrary() != refLib) continue;
                        d.dependencies.add(c);
                        d.dependencies.add(cc);
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    break;
                }
                if (!found) {
                    System.out.println("ERROR: Library.addReferencedLib dependency trace failed inexplicably");
                }
                startLib = refLib;
            }
            return d;
        }
        List list2 = this.referencedLibs;
        synchronized (list2) {
            this.referencedLibs.add(lib);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReferencedLib(Library lib) {
        if (lib == this) {
            return;
        }
        List list = this.referencedLibs;
        synchronized (list) {
            if (!$assertionsDisabled && !this.referencedLibs.contains(lib)) {
                throw new AssertionError();
            }
        }
        boolean refFound = false;
        Iterator itCell = this.getCells();
        while (itCell.hasNext()) {
            Cell c = (Cell)itCell.next();
            Iterator it = c.getNodes();
            while (it.hasNext()) {
                Cell cc;
                NodeInst ni = (NodeInst)it.next();
                NodeProto np = ni.getProto();
                if (!(np instanceof Cell) || (cc = (Cell)np).getLibrary() != lib) continue;
                refFound = true;
                break;
            }
            if (!refFound) continue;
            break;
        }
        if (!refFound) {
            List list2 = this.referencedLibs;
            synchronized (list2) {
                this.referencedLibs.remove(lib);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean referencesLib(Library lib) {
        List list = this.referencedLibs;
        synchronized (list) {
            if (this.referencedLibs.contains(lib)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isReferencedLib(Library lib, List libDepedencies) {
        ArrayList reflibsCopy = new ArrayList();
        List list = this.referencedLibs;
        synchronized (list) {
            if (this.referencedLibs.contains(lib)) {
                libDepedencies.add(lib);
                return true;
            }
            reflibsCopy.addAll(this.referencedLibs);
        }
        Iterator it = reflibsCopy.iterator();
        while (it.hasNext()) {
            Library reflib = (Library)it.next();
            if (libDepedencies.contains(reflib)) continue;
            libDepedencies.add(reflib);
            if (reflib.isReferencedLib(lib, libDepedencies)) {
                return true;
            }
            libDepedencies.remove(reflib);
        }
        return false;
    }

    public boolean isActuallyLinked() {
        return libraries.contains(this);
    }

    public int checkAndRepair(boolean repair, ErrorLogger errorLogger) {
        int errorCount = 0;
        Iterator it = this.getCells();
        while (it.hasNext()) {
            Cell cell = (Cell)it.next();
            errorCount += cell.checkAndRepair(repair, errorLogger);
        }
        if (errorCount != 0 && repair) {
            this.setChangedMajor();
            this.setChangedMinor();
        }
        return errorCount;
    }

    public void setChangedMajor() {
        this.userBits |= 1;
    }

    public void clearChangedMajor() {
        this.userBits &= 0xFFFFFFFE;
    }

    public boolean isChangedMajor() {
        return (this.userBits & 1) != 0;
    }

    public void setChangedMinor() {
        this.userBits |= 0x40;
    }

    public void clearChangedMinor() {
        this.userBits &= 0xFFFFFFBF;
    }

    public boolean isChangedMinor() {
        return (this.userBits & 0x40) != 0;
    }

    public void setFromDisk() {
        this.userBits |= 4;
    }

    public void clearFromDisk() {
        this.userBits &= 0xFFFFFFFB;
    }

    public boolean isFromDisk() {
        return (this.userBits & 4) != 0;
    }

    public void setHidden() {
        this.userBits |= 0x80;
    }

    public void clearHidden() {
        this.userBits &= 0xFFFFFF7F;
    }

    public boolean isHidden() {
        return (this.userBits & 0x80) != 0;
    }

    public static Library getCurrent() {
        return curLib;
    }

    public void setCurrent() {
        curLib = this;
    }

    public int lowLevelGetUserBits() {
        return this.userBits;
    }

    public void lowLevelSetUserBits(int userBits) {
        this.userBits = userBits;
    }

    public static Set findReferenceInCell(Library elib) {
        TreeSet list = new TreeSet();
        for (int i = 0; i < libraries.size(); ++i) {
            Library l = (Library)libraries.get(i);
            if (l == elib) continue;
            for (int j = 0; j < l.cells.size(); ++j) {
                Cell cell = (Cell)l.cells.get(j);
                cell.findReferenceInCell(elib, list);
            }
        }
        return list;
    }

    public static Library findLibrary(String libName) {
        for (int i = 0; i < libraries.size(); ++i) {
            Library l = (Library)libraries.get(i);
            if (!l.getName().equalsIgnoreCase(libName)) continue;
            return l;
        }
        return null;
    }

    public static void clearChangeLocks() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator getLibraries() {
        ArrayList librariesCopy = new ArrayList();
        List list = libraries;
        synchronized (list) {
            librariesCopy.addAll(libraries);
        }
        return librariesCopy.iterator();
    }

    public static int getNumLibraries() {
        return libraries.size();
    }

    public static Iterator getVisibleLibraries() {
        return new VisibleLibraryIterator();
    }

    public static int getNumVisibleLibraries() {
        int numVis = 0;
        Iterator it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            if (lib.isHidden()) continue;
            ++numVis;
        }
        return numVis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getVisibleLibrariesSortedByName() {
        ArrayList sortedList = new ArrayList();
        List list = libraries;
        synchronized (list) {
            VisibleLibraryIterator it = new VisibleLibraryIterator();
            while (it.hasNext()) {
                sortedList.add(it.next());
            }
        }
        Collections.sort(sortedList, new TextUtils.LibrariesByName());
        return sortedList;
    }

    public String getName() {
        return this.libName;
    }

    public boolean setName(String libName) {
        if (this.libName.equals(libName)) {
            return true;
        }
        Library already = Library.findLibrary(libName);
        if (already != null) {
            System.out.println("Already a library called " + already.getName());
            return true;
        }
        Name oldName = Name.findName(this.libName);
        this.lowLevelRename(libName);
        Undo.renameObject(this, oldName, 0);
        return false;
    }

    public void lowLevelRename(String libName) {
        this.libName = libName;
        String newLibFile = TextUtils.getFilePath(this.libFile) + libName;
        String extension = TextUtils.getExtension(this.libFile);
        if (extension.length() > 0) {
            newLibFile = newLibFile + "." + extension;
        }
        this.libFile = TextUtils.makeURLToFile(newLibFile);
    }

    public URL getLibFile() {
        return this.libFile;
    }

    public void setLibFile(URL libFile) {
        this.libFile = libFile;
    }

    public String toString() {
        return "Library " + this.libName;
    }

    private void getCurCellPref() {
        if (this.curCellPref == null) {
            this.curCellPref = Pref.makeStringPref("CurrentCellLibrary" + this.libName, prefs, "");
        }
    }

    public Cell getCurCell() {
        this.getCurCellPref();
        String cellName = this.curCellPref.getString();
        if (cellName.length() == 0) {
            return null;
        }
        Cell cell = this.findNodeProto(cellName);
        if (cell == null) {
            this.curCellPref.setString("");
        }
        return cell;
    }

    public void setCurCell(Cell curCell) {
        this.getCurCellPref();
        String cellName = "";
        if (curCell != null) {
            cellName = curCell.noLibDescribe();
        }
        this.curCellPref.setString(cellName);
    }

    public Cell findNodeProto(String name) {
        if (name == null) {
            return null;
        }
        CellName n = CellName.parseName(name);
        if (n == null) {
            return null;
        }
        Cell onlyWithName = null;
        Iterator it = this.cells.iterator();
        while (it.hasNext()) {
            Cell c = (Cell)it.next();
            if (!n.getName().equalsIgnoreCase(c.getName())) continue;
            onlyWithName = c;
            if (n.getView() != c.getView() || n.getVersion() > 0 && n.getVersion() != c.getVersion() || n.getVersion() == 0 && c.getNewestVersion() != c) continue;
            return c;
        }
        if (n.getView() == View.UNKNOWN && onlyWithName != null) {
            return onlyWithName;
        }
        return null;
    }

    boolean contains(Cell cell) {
        return this.cells.contains(cell);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getCells() {
        ArrayList cellsCopy = new ArrayList();
        ArrayList arrayList = this.cells;
        synchronized (arrayList) {
            cellsCopy.addAll(this.cells);
        }
        return cellsCopy.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCellsSortedByName() {
        ArrayList sortedList = new ArrayList();
        ArrayList arrayList = this.cells;
        synchronized (arrayList) {
            Iterator it = this.getCells();
            while (it.hasNext()) {
                sortedList.add(it.next());
            }
        }
        Collections.sort(sortedList, new TextUtils.CellsByName());
        return sortedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCellsSortedByFullName() {
        ArrayList sortedList = new ArrayList();
        ArrayList arrayList = this.cells;
        synchronized (arrayList) {
            Iterator it = this.getCells();
            while (it.hasNext()) {
                sortedList.add(it.next());
            }
        }
        Collections.sort(sortedList, new TextUtils.CellsByName());
        return sortedList;
    }

    public static List getCellsSortedByName(List cellList) {
        ArrayList sortedList = new ArrayList();
        sortedList.addAll(cellList);
        Collections.sort(sortedList, new TextUtils.CellsByName());
        return sortedList;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    static {
        $assertionsDisabled = !Library.class.desiredAssertionStatus();
        FONT_ASSOCIATIONS = ElectricObject.newKey("LIB_font_associations");
        prefs = null;
        libraries = new ArrayList();
        curLib = null;
    }

    private static class VisibleLibraryIterator
    implements Iterator {
        private Iterator uit = Library.getLibraries();
        private Library nextLib = this.nextLibrary();

        VisibleLibraryIterator() {
        }

        private Library nextLibrary() {
            while (this.uit.hasNext()) {
                Library lib = (Library)this.uit.next();
                if (lib.isHidden()) continue;
                return lib;
            }
            return null;
        }

        public boolean hasNext() {
            return this.nextLib != null;
        }

        public Object next() {
            if (this.nextLib == null) {
                return this.uit.next();
            }
            Library lib = this.nextLib;
            this.nextLib = this.nextLibrary();
            return lib;
        }

        public void remove() {
            throw new UnsupportedOperationException("VisibleLibraryIterator.remove()");
        }
    }

    public static class LibraryDependency {
        private List dependencies = new ArrayList();
        private Library startLib;
        private Library finalRefLib;

        private LibraryDependency() {
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("Library " + this.startLib.getName() + " depends on Library " + this.finalRefLib.getName() + " through the following references:\n");
            Iterator it = this.dependencies.iterator();
            while (it.hasNext()) {
                Cell libCell = (Cell)it.next();
                Cell instance = (Cell)it.next();
                buf.append("   " + libCell.libDescribe() + " instantiates " + instance.libDescribe() + "\n");
            }
            return buf.toString();
        }
    }
}

