/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.network.JNetwork;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.tool.Listener;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.routing.AutoStitch;
import com.sun.electric.tool.routing.MimicStitch;
import com.sun.electric.tool.user.Highlight;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractButton;

public class Routing
extends Listener {
    private Activity current;
    private Activity past = null;
    private boolean checkAutoStitch = false;
    public static Routing tool = new Routing();
    private static Pref cacheAutoStitchOn = Pref.makeBooleanPref("AutoStitchOn", Routing.tool.prefs, false);
    private static Pref cacheMimicStitchOn = Pref.makeBooleanPref("MimicStitchOn", Routing.tool.prefs, false);
    private static Pref cacheMimicStitchCanUnstitch = Pref.makeBooleanPref("MimicStitchCanUnstitch", Routing.tool.prefs, false);
    private static Pref cacheMimicStitchInteractive = Pref.makeBooleanPref("MimicStitchInteractive", Routing.tool.prefs, false);
    private static Pref cacheMimicStitchMatchPorts = Pref.makeBooleanPref("MimicStitchMatchPorts", Routing.tool.prefs, false);
    private static Pref cacheMimicStitchMatchNumArcs = Pref.makeBooleanPref("MimicStitchMatchNumArcs", Routing.tool.prefs, false);
    private static Pref cacheMimicStitchMatchNodeSize = Pref.makeBooleanPref("MimicStitchMatchNodeSize", Routing.tool.prefs, false);
    private static Pref cacheMimicStitchMatchNodeType = Pref.makeBooleanPref("MimicStitchMatchNodeType", Routing.tool.prefs, true);
    private static Pref cacheMimicStitchNoOtherArcsSameDir = Pref.makeBooleanPref("MimicStitchNoOtherArcsSameDir", Routing.tool.prefs, true);
    private static Pref cachePreferredRoutingArc = Pref.makeStringPref("PreferredRoutingArc", Routing.tool.prefs, "");

    private Routing() {
        super("routing");
    }

    public void init() {
        this.setOn();
    }

    public void startBatch(Tool tool, boolean undoRedo) {
        this.current = new Activity();
        this.checkAutoStitch = false;
    }

    public void endBatch() {
        if (this.current == null) {
            return;
        }
        if (this.current.numCreatedArcs > 0 || this.current.numCreatedNodes > 0 || this.current.numDeletedArcs > 0 || this.current.numDeletedNodes > 0) {
            this.past = this.current;
            if (Routing.isMimicStitchOn()) {
                MimicStitch.mimicStitch(false);
                return;
            }
        }
        if (this.checkAutoStitch && Routing.isAutoStitchOn()) {
            AutoStitch.autoStitch(false, false);
        }
    }

    public void modifyNodeInst(NodeInst ni, double oCX, double oCY, double oSX, double oSY, int oRot) {
        this.checkAutoStitch = true;
    }

    public void modifyNodeInsts(NodeInst[] nis, double[] oCX, double[] oCY, double[] oSX, double[] oSY, int[] oRot) {
        this.checkAutoStitch = true;
    }

    public void newObject(ElectricObject obj) {
        if (obj instanceof NodeInst) {
            this.checkAutoStitch = true;
            if (this.current.numCreatedNodes < 3) {
                this.current.createdNodes[this.current.numCreatedNodes++] = (NodeInst)obj;
            }
        } else if (obj instanceof ArcInst && this.current.numCreatedArcs < 3) {
            this.current.createdArcs[this.current.numCreatedArcs++] = (ArcInst)obj;
        }
    }

    public void killObject(ElectricObject obj) {
        if (obj instanceof NodeInst) {
            if (this.current.numDeletedNodes < 2) {
                this.current.deletedNodes[this.current.numDeletedNodes++] = (NodeInst)obj;
            }
        } else if (obj instanceof ArcInst) {
            ArcInst ai = (ArcInst)obj;
            if (this.current.numDeletedArcs < 3) {
                this.current.deletedArcs[this.current.numDeletedArcs++] = ai;
            }
            this.current.deletedNodes[0] = ai.getHead().getPortInst().getNodeInst();
            this.current.deletedPorts[0] = ai.getHead().getPortInst().getPortProto();
            this.current.deletedNodes[1] = ai.getTail().getPortInst().getNodeInst();
            this.current.deletedPorts[1] = ai.getTail().getPortInst().getPortProto();
            this.current.numDeletedNodes = 2;
        }
    }

    public void mimicSelected() {
        ArcInst ai = (ArcInst)Highlight.getOneElectricObject(ArcInst.class);
        if (ai == null) {
            return;
        }
        this.past = new Activity();
        this.past.createdArcs[this.past.numCreatedArcs++] = ai;
        MimicStitch.mimicStitch(false);
    }

    public static void unrouteCurrent() {
        Set nets = Highlight.getHighlightedNetworks();
        if (nets.size() == 0) {
            System.out.println("Must select networks to unroute");
            return;
        }
        Highlight.clear();
        Highlight.finished();
        Iterator it = nets.iterator();
        while (it.hasNext()) {
            JNetwork net = (JNetwork)it.next();
            if (!Routing.ro_unroutenet(net)) continue;
            return;
        }
    }

    public static boolean ro_unroutenet(JNetwork net) {
        return false;
    }

    public Activity getLastActivity() {
        return this.past;
    }

    public static void toggleEnableAutoStitching(ActionEvent e) {
        AbstractButton b = (AbstractButton)e.getSource();
        if (b.isSelected()) {
            Routing.setAutoStitchOn(true);
            System.out.println("Auto-stitching enabled");
        } else {
            Routing.setAutoStitchOn(false);
            System.out.println("Auto-stitching disabled");
        }
    }

    public static void toggleEnableMimicStitching(ActionEvent e) {
        AbstractButton b = (AbstractButton)e.getSource();
        if (b.isSelected()) {
            Routing.setMimicStitchOn(true);
            System.out.println("Mimic-stitching enabled");
        } else {
            Routing.setMimicStitchOn(false);
            System.out.println("Mimic-stitching disabled");
        }
    }

    public static boolean isAutoStitchOn() {
        return cacheAutoStitchOn.getBoolean();
    }

    public static void setAutoStitchOn(boolean on) {
        cacheAutoStitchOn.setBoolean(on);
    }

    public static boolean isMimicStitchOn() {
        return cacheMimicStitchOn.getBoolean();
    }

    public static void setMimicStitchOn(boolean on) {
        cacheMimicStitchOn.setBoolean(on);
    }

    public static boolean isMimicStitchCanUnstitch() {
        return cacheMimicStitchCanUnstitch.getBoolean();
    }

    public static void setMimicStitchCanUnstitch(boolean on) {
        cacheMimicStitchCanUnstitch.setBoolean(on);
    }

    public static boolean isMimicStitchInteractive() {
        return cacheMimicStitchInteractive.getBoolean();
    }

    public static void setMimicStitchInteractive(boolean on) {
        cacheMimicStitchInteractive.setBoolean(on);
    }

    public static boolean isMimicStitchMatchPorts() {
        return cacheMimicStitchMatchPorts.getBoolean();
    }

    public static void setMimicStitchMatchPorts(boolean on) {
        cacheMimicStitchMatchPorts.setBoolean(on);
    }

    public static boolean isMimicStitchMatchNumArcs() {
        return cacheMimicStitchMatchNumArcs.getBoolean();
    }

    public static void setMimicStitchMatchNumArcs(boolean on) {
        cacheMimicStitchMatchNumArcs.setBoolean(on);
    }

    public static boolean isMimicStitchMatchNodeSize() {
        return cacheMimicStitchMatchNodeSize.getBoolean();
    }

    public static void setMimicStitchMatchNodeSize(boolean on) {
        cacheMimicStitchMatchNodeSize.setBoolean(on);
    }

    public static boolean isMimicStitchMatchNodeType() {
        return cacheMimicStitchMatchNodeType.getBoolean();
    }

    public static void setMimicStitchMatchNodeType(boolean on) {
        cacheMimicStitchMatchNodeType.setBoolean(on);
    }

    public static boolean isMimicStitchNoOtherArcsSameDir() {
        return cacheMimicStitchNoOtherArcsSameDir.getBoolean();
    }

    public static void setMimicStitchNoOtherArcsSameDir(boolean on) {
        cacheMimicStitchNoOtherArcsSameDir.setBoolean(on);
    }

    public static String getPreferredRoutingArc() {
        return cachePreferredRoutingArc.getString();
    }

    public static void setPreferredRoutingArc(String arcName) {
        cachePreferredRoutingArc.setString(arcName);
    }

    public static class Activity {
        int numCreatedArcs = 0;
        int numCreatedNodes = 0;
        ArcInst[] createdArcs = new ArcInst[3];
        NodeInst[] createdNodes = new NodeInst[3];
        int numDeletedArcs = 0;
        int numDeletedNodes = 0;
        ArcInst[] deletedArcs = new ArcInst[3];
        NodeInst[] deletedNodes = new NodeInst[2];
        PortProto[] deletedPorts = new PortProto[2];

        Activity() {
        }
    }
}

