/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.strategy;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.jemNets.Part;
import com.sun.electric.tool.ncc.jemNets.Port;
import com.sun.electric.tool.ncc.jemNets.Wire;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.lists.RecordList;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import com.sun.electric.tool.ncc.trees.NetObject;
import java.util.Iterator;
import java.util.TreeMap;

public class StratCount
extends Strategy {
    private static final int INDENT_WIDTH = 4;
    private static final int LABEL_WIDTH = 30;
    private static final int FIELD_WIDTH = 15;
    private int maxDepth;
    private int numInternalRecs;
    private NetObjStats numMismatchedNetObjs = new NetObjStats(0);
    private NetObjStats numRetiredNetObjs = new NetObjStats(0);
    private NetObjStats numActiveNetObjs = new NetObjStats(0);
    private NetObjStats numMismatchedLeafRecs = new NetObjStats(0);
    private NetObjStats numRetiredLeafRecs = new NetObjStats(0);
    private NetObjStats numActiveLeafRecs = new NetObjStats(0);
    private int numCircuits;
    private int totalEqGrpSize;
    private int numberOfWireConnections;
    private long numberOfWireConnectionsSquared;
    private int numberOfPartConnections;
    private String workingOnString;
    private NetObject.Type netObjType;
    private SizeHistogram sizeHistogram = new SizeHistogram();

    private StratCount(NccGlobals globals) {
        super(globals);
    }

    private static String spaces(int num) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < num; ++i) {
            b.append(" ");
        }
        return b.toString();
    }

    private static String rightJustifyInField(String s, int fieldWidth) {
        return StratCount.spaces(fieldWidth - s.length()) + s;
    }

    private static String leftJustifyInField(String s, int fieldWidth) {
        return s + StratCount.spaces(fieldWidth - s.length());
    }

    private void printLine(String label, NetObjStats stats) {
        this.globals.println(StratCount.spaces(4) + StratCount.leftJustifyInField(label, 30) + stats.toString());
    }

    private void printLine(String label, int data) {
        this.globals.println(StratCount.spaces(4) + StratCount.leftJustifyInField(label, 30) + StratCount.rightJustifyInField(String.valueOf(data), 15));
    }

    private void printLine(String label, double data) {
        data = Math.rint(data * 10.0) / 10.0;
        this.globals.println(StratCount.spaces(4) + StratCount.leftJustifyInField(label, 30) + StratCount.rightJustifyInField(String.valueOf(data), 15));
    }

    private void preamble(EquivRecord j) {
        this.workingOnString = j.nameString();
        this.startTime("StratCount", this.workingOnString);
    }

    private void preamble(RecordList j) {
        this.workingOnString = "a list of " + j.size();
        this.startTime("StratCount", this.workingOnString);
    }

    private void summary() {
        this.globals.println(StratCount.spaces(34) + StratCount.rightJustifyInField("Parts", 15) + StratCount.rightJustifyInField("Wires", 15) + StratCount.rightJustifyInField("Ports", 15));
        this.printLine("# mismatched EquivRecs", this.numMismatchedLeafRecs);
        this.printLine("# retired EquivRecs", this.numRetiredLeafRecs);
        this.printLine("# active EquivRecs", this.numActiveLeafRecs);
        this.printLine("# mismatched NetObjs", this.numMismatchedNetObjs);
        this.printLine("# retired NetObjs", this.numRetiredNetObjs);
        this.printLine("# active NetObjs", this.numActiveNetObjs);
        int numEquivRecs = this.numMismatchedLeafRecs.getSumForAllTypes() + this.numRetiredLeafRecs.getSumForAllTypes() + this.numActiveLeafRecs.getSumForAllTypes();
        this.globals.println("");
        this.sizeHistogram.print();
        this.globals.println("");
        this.printLine("# InternalRecords", this.numInternalRecs);
        this.printLine("# Circuits", this.numCircuits);
        this.printLine("max depth", this.maxDepth);
        float average = (float)this.totalEqGrpSize / (float)numEquivRecs;
        this.printLine("average size EquivRec", average);
        this.printLine("# pins", this.numberOfWireConnections);
        int diffPins = this.numberOfPartConnections - this.numberOfWireConnections;
        int numWires = this.numMismatchedNetObjs.get(NetObject.Type.WIRE) + this.numRetiredNetObjs.get(NetObject.Type.WIRE) + this.numActiveNetObjs.get(NetObject.Type.WIRE);
        int numParts = this.numMismatchedNetObjs.get(NetObject.Type.PART) + this.numRetiredNetObjs.get(NetObject.Type.PART) + this.numActiveNetObjs.get(NetObject.Type.PART);
        this.error(numWires != 0 && numParts != 0 && diffPins != 0, "#wirePins != #partPins: " + this.numberOfWireConnections + " != " + this.numberOfPartConnections);
        average = (float)this.numberOfWireConnections / (float)numWires;
        double rms = (float)this.numberOfWireConnectionsSquared / (float)numWires;
        rms = Math.sqrt(rms);
        this.printLine("average wire pins", average);
        this.printLine("rms wire pins", rms);
        this.elapsedTime();
    }

    public LeafList doFor(EquivRecord j) {
        if (j.isLeaf()) {
            this.doEquivRec(j);
        } else {
            ++this.numInternalRecs;
        }
        return super.doFor(j);
    }

    private void doEquivRec(EquivRecord er) {
        int erSize = er.maxSize();
        this.totalEqGrpSize += erSize;
        this.netObjType = er.getNetObjType();
        int numNetObjs = er.numNetObjs();
        if (er.isMismatched()) {
            this.numMismatchedLeafRecs.incr(this.netObjType, 1);
            this.numMismatchedNetObjs.incr(this.netObjType, numNetObjs);
            this.sizeHistogram.incr(this.netObjType, erSize);
        } else if (er.isRetired()) {
            this.numRetiredLeafRecs.incr(this.netObjType, 1);
            this.numRetiredNetObjs.incr(this.netObjType, numNetObjs);
            this.sizeHistogram.incr(this.netObjType, erSize);
        } else {
            this.numActiveLeafRecs.incr(this.netObjType, 1);
            this.numActiveNetObjs.incr(this.netObjType, numNetObjs);
            this.sizeHistogram.incr(this.netObjType, erSize);
        }
        this.numCircuits += er.numCircuits();
    }

    public Integer doFor(NetObject n) {
        this.error(n.getNetObjType() != this.netObjType, "mixed type leaf record");
        this.maxDepth = Math.max(this.maxDepth, this.getDepth());
        if (n instanceof Wire) {
            this.doFor((Wire)n);
        } else if (n instanceof Part) {
            this.doFor((Part)n);
        } else {
            this.error(!(n instanceof Port), "expecting Port");
        }
        return CODE_NO_CHANGE;
    }

    private void doFor(Wire w) {
        int n = w.numParts();
        this.numberOfWireConnections += n;
        float nf = n;
        this.numberOfWireConnectionsSquared = (long)((float)this.numberOfWireConnectionsSquared + nf * nf);
    }

    private void doFor(Part p) {
        this.numberOfPartConnections += p.getNumWiresConnected();
    }

    public static LeafList doYourJob(EquivRecord j, NccGlobals globals) {
        StratCount jsc = new StratCount(globals);
        jsc.preamble(j);
        LeafList el = jsc.doFor(j);
        jsc.summary();
        return el;
    }

    public static LeafList doYourJob(RecordList g, NccGlobals globals) {
        StratCount jsc = new StratCount(globals);
        jsc.preamble(g);
        if (g.size() != 0) {
            jsc.doFor(g);
            jsc.summary();
        }
        return new LeafList();
    }

    private class SizeHistogram {
        TreeMap sizeToStats = new TreeMap();

        private SizeHistogram() {
        }

        void incr(NetObject.Type type, int size) {
            Integer sz = new Integer(size);
            NetObjStats stats = (NetObjStats)this.sizeToStats.get(sz);
            if (stats == null) {
                stats = new NetObjStats(0);
                this.sizeToStats.put(sz, stats);
            }
            stats.incr(type, 1);
        }

        void print() {
            StratCount.this.globals.println(StratCount.spaces(4) + StratCount.leftJustifyInField("LeafRec size", 30) + StratCount.rightJustifyInField("#Part_Recs", 15) + StratCount.rightJustifyInField("#Wire_Recs", 15) + StratCount.rightJustifyInField("#Port_Recs", 15));
            Iterator it = this.sizeToStats.keySet().iterator();
            while (it.hasNext()) {
                Integer key = (Integer)it.next();
                NetObjStats stats = (NetObjStats)this.sizeToStats.get(key);
                StratCount.this.printLine(StratCount.rightJustifyInField(key.toString(), 7), stats);
            }
        }
    }

    private static class NetObjStats {
        private static final int NUM_TYPES = 3;
        int[] data = new int[3];

        NetObjStats(int initialVal) {
            for (int i = 0; i < 3; ++i) {
                this.data[i] = initialVal;
            }
        }

        void incr(NetObject.Type type, int delta) {
            int n = type.ordinal();
            this.data[n] = this.data[n] + delta;
        }

        int get(NetObject.Type type) {
            return this.data[type.ordinal()];
        }

        int getSumForAllTypes() {
            int sum = 0;
            for (int i = 0; i < 3; ++i) {
                sum += this.data[i];
            }
            return sum;
        }

        public String toString() {
            String out = "";
            for (int i = 0; i < 3; ++i) {
                String v = String.valueOf(this.data[i]);
                out = out + StratCount.rightJustifyInField(v, 15);
            }
            return out;
        }
    }
}

