dnl Copyright (C) 1993-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Bruno Haible, Marcus Daniels.

AC_PREREQ(2.13)

AC_DEFUN([CL_STRLEN],
[
# This is a bit tricky since strlen is a gcc2 built-in function, and
# gcc's criterion when to reject a prototype for it is extremely mysterious.
#   extern int strlen (char * s); extern unsigned int strlen (char * s);
# produces an error, while
#   extern unsigned int strlen (char * s); extern int strlen (char * s);
# compiles well.
if test -z "$cl_cv_proto_strlen_macro"; then
AC_EGREP_CPP([is a macro], [#include <string.h>
#ifdef strlen
is a macro
#endif
], cl_cv_proto_strlen_macro=yes, cl_cv_proto_strlen_macro=no)
fi
if test $cl_cv_proto_strlen_macro = no; then
CL_PROTO([strlen], [
CL_PROTO_RET([#define strlen foo
#include <string.h>
], [size_t strlen();], cl_cv_proto_strlen_ret, size_t, int)
CL_PROTO_CONST([#define strlen foo
#include <string.h>
], [$cl_cv_proto_strlen_ret strlen (char* s);],
[$cl_cv_proto_strlen_ret strlen();], cl_cv_proto_strlen_arg1)],
[extern $cl_cv_proto_strlen_ret strlen ($cl_cv_proto_strlen_arg1 char*);])
AC_DEFINE_UNQUOTED(RETSTRLENTYPE,$cl_cv_proto_strlen_ret)
AC_DEFINE_UNQUOTED(STRLEN_CONST,$cl_cv_proto_strlen_arg1)
fi
])
