"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.create = create;
function create() {
    return {
        name: 'vue-autoinsert-space',
        capabilities: {
            autoInsertionProvider: {
                triggerCharacters: ['}'],
                configurationSections: ['vue.autoInsert.bracketSpacing'],
            },
        },
        create() {
            return {
                provideAutoInsertSnippet(document, selection, change) {
                    if (document.languageId === 'html' || document.languageId === 'jade') {
                        if (change.text === '{}'
                            && document.getText().slice(change.rangeOffset - 1, change.rangeOffset + 3) === '{{}}'
                            && document.offsetAt(selection) === change.rangeOffset + 1) {
                            return ` $0 `;
                        }
                    }
                },
            };
        },
    };
}
//# sourceMappingURL=vue-autoinsert-space.js.map