/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.protocol;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.protocol.ClientMessage;
import org.eclipse.rap.rwt.internal.protocol.Operation;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.ServiceStore;
import org.eclipse.rap.rwt.internal.util.SharedInstanceBuffer;
import org.eclipse.rap.rwt.remote.OperationHandler;

public final class ProtocolUtil {
    private static final Pattern FONT_NAME_FILTER_PATTERN = Pattern.compile("\"|\\\\");
    private static final String CLIENT_MESSAGE = String.valueOf(ProtocolUtil.class.getName()) + "#clientMessage";
    private static final String CLIENT_MESSAGE_READ = String.valueOf(ProtocolUtil.class.getName()) + "#clientMsgRead";
    private static final SharedInstanceBuffer<String, String[]> parsedFonts = new SharedInstanceBuffer();

    private ProtocolUtil() {
    }

    public static ClientMessage getClientMessage() {
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        serviceStore.setAttribute(CLIENT_MESSAGE_READ, Boolean.TRUE);
        return (ClientMessage)serviceStore.getAttribute(CLIENT_MESSAGE);
    }

    public static void setClientMessage(ClientMessage clientMessage) {
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        serviceStore.setAttribute(CLIENT_MESSAGE, clientMessage);
    }

    public static boolean isClientMessageProcessed() {
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        return Boolean.TRUE.equals(serviceStore.getAttribute(CLIENT_MESSAGE_READ));
    }

    public static void handleOperation(OperationHandler handler, Operation operation) {
        if (operation instanceof Operation.SetOperation) {
            Operation.SetOperation setOperation = (Operation.SetOperation)operation;
            handler.handleSet(setOperation.getProperties());
        } else if (operation instanceof Operation.CallOperation) {
            Operation.CallOperation callOperation = (Operation.CallOperation)operation;
            handler.handleCall(callOperation.getMethodName(), callOperation.getParameters());
        } else if (operation instanceof Operation.NotifyOperation) {
            Operation.NotifyOperation notifyOperation = (Operation.NotifyOperation)operation;
            handler.handleNotify(notifyOperation.getEventName(), notifyOperation.getProperties());
        }
    }

    public static JsonValue readPropertyValue(String target, String property) {
        Operation.SetOperation operation = ProtocolUtil.getClientMessage().getLastSetOperationFor(target, property);
        return operation != null ? operation.getProperties().get(property) : null;
    }

    public static JsonValue readEventPropertyValue(String target, String eventName, String property) {
        Operation.NotifyOperation operation = ProtocolUtil.getClientMessage().getLastNotifyOperationFor(target, eventName);
        return operation != null ? operation.getProperties().get(property) : null;
    }

    public static boolean wasEventSent(String target, String eventName) {
        ClientMessage message = ProtocolUtil.getClientMessage();
        Operation.NotifyOperation operation = message.getLastNotifyOperationFor(target, eventName);
        return operation != null;
    }

    public static String[] parseFontName(final String name) {
        return parsedFonts.get(name, new SharedInstanceBuffer.IInstanceCreator<String[]>(){

            @Override
            public String[] createInstance() {
                return ProtocolUtil.parseFontNameInternal(name);
            }
        });
    }

    private static String[] parseFontNameInternal(String name) {
        String[] result = name.split(",");
        int i = 0;
        while (i < result.length) {
            result[i] = result[i].trim();
            Matcher matcher = FONT_NAME_FILTER_PATTERN.matcher(result[i]);
            result[i] = matcher.replaceAll("");
            ++i;
        }
        return result;
    }
}

