/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.NetworkChannel;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSessionContext;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SSLContext;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.SSLUtil;
import org.apache.tomcat.util.net.openssl.OpenSSLImplementation;
import org.apache.tomcat.util.net.openssl.ciphers.Cipher;

public abstract class AbstractJsseEndpoint<S>
extends AbstractEndpoint<S> {
    private String sslImplementationName = null;
    private int sniParseLimit = 65536;
    private SSLImplementation sslImplementation = null;

    public String getSslImplementationName() {
        return this.sslImplementationName;
    }

    public void setSslImplementationName(String s) {
        this.sslImplementationName = s;
    }

    public SSLImplementation getSslImplementation() {
        return this.sslImplementation;
    }

    public int getSniParseLimit() {
        return this.sniParseLimit;
    }

    public void setSniParseLimit(int sniParseLimit) {
        this.sniParseLimit = sniParseLimit;
    }

    @Override
    protected SSLHostConfig.Type getSslConfigType() {
        if (OpenSSLImplementation.class.getName().equals(this.sslImplementationName)) {
            return SSLHostConfig.Type.EITHER;
        }
        return SSLHostConfig.Type.JSSE;
    }

    protected void initialiseSsl() throws Exception {
        if (this.isSSLEnabled()) {
            this.sslImplementation = SSLImplementation.getInstance(this.getSslImplementationName());
            for (SSLHostConfig sslHostConfig : this.sslHostConfigs.values()) {
                this.createSSLContext(sslHostConfig);
            }
        }
    }

    @Override
    protected void createSSLContext(SSLHostConfig sslHostConfig) throws IllegalArgumentException {
        boolean firstCertificate = true;
        for (SSLHostConfigCertificate certificate : sslHostConfig.getCertificates(true)) {
            SSLContext sslContext;
            SSLUtil sslUtil = this.sslImplementation.getSSLUtil(certificate);
            if (firstCertificate) {
                firstCertificate = false;
                sslHostConfig.setEnabledProtocols(sslUtil.getEnabledProtocols());
                sslHostConfig.setEnabledCiphers(sslUtil.getEnabledCiphers());
            }
            try {
                sslContext = sslUtil.createSSLContext(this.negotiableProtocols);
                sslContext.init(sslUtil.getKeyManagers(), sslUtil.getTrustManagers(), null);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            SSLSessionContext sessionContext = sslContext.getServerSessionContext();
            if (sessionContext != null) {
                sslUtil.configureSessionContext(sessionContext);
            }
            certificate.setSslContext(sslContext);
        }
    }

    protected void destroySsl() throws Exception {
        if (this.isSSLEnabled()) {
            for (SSLHostConfig sslHostConfig : this.sslHostConfigs.values()) {
                this.releaseSSLContext(sslHostConfig);
            }
        }
    }

    @Override
    protected void releaseSSLContext(SSLHostConfig sslHostConfig) {
        for (SSLHostConfigCertificate certificate : sslHostConfig.getCertificates(true)) {
            SSLContext sslContext;
            if (certificate.getSslContext() == null || (sslContext = certificate.getSslContext()) == null) continue;
            sslContext.destroy();
        }
    }

    protected SSLEngine createSSLEngine(String sniHostName, List<Cipher> clientRequestedCiphers) {
        SSLHostConfig sslHostConfig = this.getSSLHostConfig(sniHostName);
        SSLHostConfigCertificate certificate = this.selectCertificate(sslHostConfig, clientRequestedCiphers);
        SSLContext sslContext = certificate.getSslContext();
        if (sslContext == null) {
            throw new IllegalStateException(sm.getString("endpoint.jsse.noSslContext", new Object[]{sniHostName}));
        }
        SSLEngine engine = sslContext.createSSLEngine();
        switch (sslHostConfig.getCertificateVerification()) {
            case NONE: {
                engine.setNeedClientAuth(false);
                engine.setWantClientAuth(false);
                break;
            }
            case OPTIONAL: 
            case OPTIONAL_NO_CA: {
                engine.setWantClientAuth(true);
                break;
            }
            case REQUIRED: {
                engine.setNeedClientAuth(true);
            }
        }
        engine.setUseClientMode(false);
        engine.setEnabledCipherSuites(sslHostConfig.getEnabledCiphers());
        engine.setEnabledProtocols(sslHostConfig.getEnabledProtocols());
        String honorCipherOrderStr = sslHostConfig.getHonorCipherOrder();
        if (honorCipherOrderStr != null) {
            boolean honorCipherOrder = Boolean.parseBoolean(honorCipherOrderStr);
            JreCompat.getInstance().setUseServerCipherSuitesOrder(engine, honorCipherOrder);
        }
        return engine;
    }

    private SSLHostConfigCertificate selectCertificate(SSLHostConfig sslHostConfig, List<Cipher> clientCiphers) {
        Set<SSLHostConfigCertificate> certificates = sslHostConfig.getCertificates(true);
        if (certificates.size() == 1) {
            return certificates.iterator().next();
        }
        LinkedHashSet<Cipher> serverCiphers = sslHostConfig.getCipherList();
        ArrayList<Cipher> candidateCiphers = new ArrayList<Cipher>();
        if (Boolean.parseBoolean(sslHostConfig.getHonorCipherOrder())) {
            candidateCiphers.addAll(serverCiphers);
            candidateCiphers.retainAll(clientCiphers);
        } else {
            candidateCiphers.addAll(clientCiphers);
            candidateCiphers.retainAll(serverCiphers);
        }
        for (Cipher candidate : candidateCiphers) {
            for (SSLHostConfigCertificate certificate : certificates) {
                if (!certificate.getType().isCompatibleWith(candidate.getAu())) continue;
                return certificate;
            }
        }
        return certificates.iterator().next();
    }

    @Override
    public boolean isAlpnSupported() {
        SSLImplementation sslImplementation;
        if (!this.isSSLEnabled()) {
            return false;
        }
        try {
            sslImplementation = SSLImplementation.getInstance(this.getSslImplementationName());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return sslImplementation.isAlpnSupported();
    }

    @Override
    public void init() throws Exception {
        this.testServerCipherSuitesOrderSupport();
        super.init();
    }

    private void testServerCipherSuitesOrderSupport() {
        if (!JreCompat.isJre8Available() && !OpenSSLImplementation.class.getName().equals(this.getSslImplementationName())) {
            for (SSLHostConfig sslHostConfig : this.sslHostConfigs.values()) {
                if (sslHostConfig.getHonorCipherOrder() == null) continue;
                throw new UnsupportedOperationException(sm.getString("endpoint.jsse.cannotHonorServerCipherOrder"));
            }
        }
    }

    @Override
    public void unbind() throws Exception {
        for (SSLHostConfig sslHostConfig : this.sslHostConfigs.values()) {
            for (SSLHostConfigCertificate certificate : sslHostConfig.getCertificates(true)) {
                certificate.setSslContext(null);
            }
        }
    }

    protected abstract NetworkChannel getServerSocket();

    @Override
    protected final InetSocketAddress getLocalAddress() throws IOException {
        NetworkChannel serverSock = this.getServerSocket();
        if (serverSock == null) {
            return null;
        }
        SocketAddress sa = serverSock.getLocalAddress();
        if (sa instanceof InetSocketAddress) {
            return (InetSocketAddress)sa;
        }
        return null;
    }
}

