/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.osgi.console.telnet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.eclipse.osgi.framework.console.ConsoleSession;
import org.eclipse.virgo.osgi.console.common.ConsoleInputStream;
import org.eclipse.virgo.osgi.console.supportability.ConsoleInputHandler;
import org.eclipse.virgo.osgi.console.telnet.Callback;
import org.eclipse.virgo.osgi.console.telnet.NegotiationFinishedCallback;
import org.eclipse.virgo.osgi.console.telnet.TelnetInputHandler;
import org.eclipse.virgo.osgi.console.telnet.TelnetOutputStream;
import org.osgi.framework.BundleContext;

public class TelnetConsoleSession
extends ConsoleSession {
    private final Socket s;
    private InputStream input;
    private final ConsoleInputStream in = new ConsoleInputStream();
    private final TelnetOutputStream out;
    protected boolean isTelnetNegotiationFinished = false;
    private Callback callback;
    private static final long TIMEOUT = 1000L;
    private static final long NEGOTIATION_TIMEOUT = 60000L;
    private final BundleContext context;

    public TelnetConsoleSession(Socket s, BundleContext context) throws IOException {
        this.out = new TelnetOutputStream(s.getOutputStream());
        this.out.autoSend();
        this.s = s;
        this.context = context;
        this.callback = new NegotiationFinishedCallback(this);
    }

    public synchronized void start() throws IOException {
        this.start(60000L);
    }

    public synchronized void start(long negotiationTimeout) throws IOException {
        TelnetInputHandler telnetInputHandler = new TelnetInputHandler(this.s.getInputStream(), this.in, this.out, this.callback);
        telnetInputHandler.start();
        long start = System.currentTimeMillis();
        while (!this.isTelnetNegotiationFinished && System.currentTimeMillis() - start < negotiationTimeout) {
            try {
                ((Object)((Object)this)).wait(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        ConsoleInputStream inp = new ConsoleInputStream();
        ConsoleInputHandler consoleInputHandler = new ConsoleInputHandler(this.in, inp, this.out, this.context);
        consoleInputHandler.getScanner().setBackspace(telnetInputHandler.getScanner().getBackspace());
        consoleInputHandler.getScanner().setDel(telnetInputHandler.getScanner().getDel());
        consoleInputHandler.getScanner().setCurrentEscapesToKey(telnetInputHandler.getScanner().getCurrentEscapesToKey());
        consoleInputHandler.getScanner().setEscapes(telnetInputHandler.getScanner().getEscapes());
        consoleInputHandler.start();
        this.input = inp;
    }

    public synchronized void telnetNegotiationFinished() {
        this.isTelnetNegotiationFinished = true;
        ((Object)((Object)this)).notify();
    }

    public synchronized InputStream getInput() {
        return this.input;
    }

    public synchronized OutputStream getOutput() {
        return this.out;
    }

    public synchronized void doClose() {
        if (this.s != null) {
            try {
                this.s.close();
            }
            catch (IOException iOException) {}
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException iOException) {}
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {}
        }
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (IOException iOException) {}
        }
    }
}

