/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.runtime.internal.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.virgo.ide.facet.core.FacetUtils;
import org.eclipse.virgo.ide.manifest.core.BundleManifestCorePlugin;
import org.eclipse.virgo.ide.manifest.core.BundleManifestUtils;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleServer;

public class OpenProjectManifestAction
implements IObjectActionDelegate {
    private IModule selectedModule;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        IProject project = this.selectedModule.getProject();
        if (FacetUtils.isBundleProject((IResource)project)) {
            this.openResource((IResource)BundleManifestUtils.locateManifest((IJavaProject)JavaCore.create((IProject)project), (boolean)false));
        } else if (FacetUtils.isParProject((IResource)project)) {
            this.openResource(project.findMember(BundleManifestCorePlugin.MANIFEST_FILE_LOCATION));
        } else {
            try {
                if (FacetUtils.hasNature((IResource)project, (String)"org.eclipse.jdt.core.javanature") && FacetedProjectFramework.hasProjectFacet((IProject)project, (String)"jst.web")) {
                    this.openResource((IResource)BundleManifestUtils.locateManifest((IJavaProject)JavaCore.create((IProject)project), (boolean)false));
                }
            }
            catch (CoreException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.virgo.ide.runtime.core", "Problem occurred while openeing project manifest.", (Throwable)e));
            }
        }
    }

    private void openResource(IResource resource) {
        if (resource instanceof IFile) {
            try {
                IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)((IFile)resource));
            }
            catch (PartInitException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.virgo.ide.runtime.core", "Problem occurred while opening project manifest.", (Throwable)e));
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object obj;
        this.selectedModule = null;
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof ModuleServer) {
            ModuleServer ms = (ModuleServer)obj;
            this.selectedModule = ms.module[ms.module.length - 1];
        }
    }
}

