/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.export;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.virgo.ide.export.AbstractProjectExportWizardPage;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.BundleManifestFactory;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class ParExportWizardPage
extends AbstractProjectExportWizardPage {
    protected ParExportWizardPage(IStructuredSelection selection) {
        super("parExportWizardPage", selection);
        this.setTitle("JAR File Specification");
        this.setDescription("Define which PAR project should be exported into the JAR.");
    }

    protected ViewerFilter getTreeViewerFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IPackageFragmentRoot) {
                    IPackageFragmentRoot root = (IPackageFragmentRoot)element;
                    return !root.isArchive() && !root.isExternal();
                }
                if (element instanceof IProject) {
                    IFacetedProject facetedProject;
                    block5: {
                        IProject project = (IProject)element;
                        try {
                            facetedProject = ProjectFacetsManager.create((IProject)project);
                            if (facetedProject != null) break block5;
                            return false;
                        }
                        catch (CoreException coreException) {
                            return false;
                        }
                    }
                    return facetedProject.hasProjectFacet(ProjectFacetsManager.getProjectFacet((String)"org.eclipse.virgo.server.par").getDefaultVersion());
                }
                return false;
            }
        };
    }

    protected String getExtension() {
        return ".par";
    }

    protected String getDestinationLabel() {
        return "PAR file:";
    }

    protected String getSymbolicName(BundleManifest bundleManifest) {
        return (String)bundleManifest.toDictionary().get("Application-SymbolicName");
    }

    protected String getVersion(BundleManifest bundleManifest) {
        return (String)bundleManifest.toDictionary().get("Application-Version");
    }

    protected BundleManifest getBundleManifest(IProject project) {
        Path path = new Path("META-INF/MANIFEST.MF");
        IFile manifestFile = (IFile)project.findMember((IPath)path);
        if (manifestFile != null) {
            try {
                return BundleManifestFactory.createBundleManifest((Reader)new InputStreamReader(manifestFile.getContents(true)));
            }
            catch (IOException iOException) {
            }
            catch (CoreException coreException) {}
        }
        return BundleManifestFactory.createBundleManifest();
    }
}

