/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.eclipse.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.util.CoreUtility;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.ClassPathDetector;
import org.eclipse.jdt.ui.wizards.JavaCapabilityConfigurationPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.virgo.ide.eclipse.wizards.NewJavaProjectWizardConstants;
import org.eclipse.virgo.ide.eclipse.wizards.NewJavaProjectWizardPageOneCOPY;

@Deprecated
public class NewJavaProjectWizardPageTwoCOPY
extends JavaCapabilityConfigurationPage {
    private static final String FILENAME_PROJECT = ".project";
    private static final String FILENAME_CLASSPATH = ".classpath";
    private final NewJavaProjectWizardPageOneCOPY fFirstPage;
    private URI fCurrProjectLocation;
    private IProject fCurrProject;
    private boolean fKeepContent;
    private File fDotProjectBackup;
    private File fDotClasspathBackup;
    private Boolean fIsAutobuild;
    private HashSet fOrginalFolders;

    private static URI getRealLocation(String projectName, URI location) {
        if (location == null) {
            try {
                URI rootLocation = ResourcesPlugin.getWorkspace().getRoot().getLocationURI();
                location = new URI(rootLocation.getScheme(), null, Path.fromPortableString((String)rootLocation.getPath()).append(projectName).toString(), null);
            }
            catch (URISyntaxException uRISyntaxException) {
                Assert.isTrue((boolean)false, (String)"Can't happen");
            }
        }
        return location;
    }

    public static boolean setAutoBuilding(boolean state) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription desc = workspace.getDescription();
        boolean isAutoBuilding = desc.isAutoBuilding();
        if (isAutoBuilding != state) {
            desc.setAutoBuilding(state);
            workspace.setDescription(desc);
        }
        return isAutoBuilding;
    }

    public NewJavaProjectWizardPageTwoCOPY(NewJavaProjectWizardPageOneCOPY mainPage) {
        this.fFirstPage = mainPage;
        this.fCurrProjectLocation = null;
        this.fCurrProject = null;
        this.fKeepContent = false;
        this.fDotProjectBackup = null;
        this.fDotClasspathBackup = null;
        this.fIsAutobuild = null;
    }

    private IStatus changeToNewProject() {
        class UpdateRunnable
        implements IRunnableWithProgress {
            public IStatus infoStatus = Status.OK_STATUS;

            UpdateRunnable() {
            }

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        if (NewJavaProjectWizardPageTwoCOPY.this.fIsAutobuild == null) {
                            NewJavaProjectWizardPageTwoCOPY.this.fIsAutobuild = NewJavaProjectWizardPageTwoCOPY.setAutoBuilding(false);
                        }
                        this.infoStatus = NewJavaProjectWizardPageTwoCOPY.this.updateProject(monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        throw new InterruptedException();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        }
        UpdateRunnable op = new UpdateRunnable();
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)op));
            return op.infoStatus;
        }
        catch (InvocationTargetException e) {
            String title = NewJavaProjectWizardConstants.NewJavaProjectWizardPageTwo_error_title;
            String message = NewJavaProjectWizardConstants.NewJavaProjectWizardPageTwo_error_message;
            ExceptionHandler.handle((InvocationTargetException)e, (Shell)this.getShell(), (String)title, (String)message);
        }
        catch (InterruptedException interruptedException) {}
        return null;
    }

    private void copyFile(File source, IFileStore target, IProgressMonitor monitor) throws IOException, CoreException {
        FileInputStream is = new FileInputStream(source);
        OutputStream os = target.openOutputStream(0, monitor);
        this.copyFile(is, os);
    }

    private void copyFile(IFileStore source, File target) throws IOException, CoreException {
        InputStream is = source.openInputStream(0, null);
        FileOutputStream os = new FileOutputStream(target);
        this.copyFile(is, os);
    }

    private void copyFile(InputStream is, OutputStream os) throws IOException {
        try {
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = is.read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
        }
        finally {
            try {
                is.close();
            }
            finally {
                os.close();
            }
        }
    }

    private File createBackup(IFileStore source, String name) throws CoreException {
        try {
            File bak = File.createTempFile("eclipse-" + name, ".bak");
            this.copyFile(source, bak);
            return bak;
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.jdt.ui", 4, Messages.format((String)NewJavaProjectWizardConstants.NewJavaProjectWizardPageTwo_problem_backup, (Object)name), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    protected IProject createProvisonalProject() {
        IStatus status = this.changeToNewProject();
        if (status != null && !status.isOK()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)NewJavaProjectWizardConstants.NewJavaProjectWizardPageTwo_error_title, null, (IStatus)status);
        }
        return this.fCurrProject;
    }

    private void deleteProjectFile(URI projectLocation) throws CoreException {
        IFileStore projectFile;
        IFileStore file = EFS.getStore((URI)projectLocation);
        if (file.fetchInfo().exists() && (projectFile = file.getChild(FILENAME_PROJECT)).fetchInfo().exists()) {
            projectFile.delete(0, null);
        }
    }

    private final void doRemoveProject(IProgressMonitor monitor) throws InvocationTargetException {
        boolean noProgressMonitor;
        boolean bl = noProgressMonitor = this.fCurrProjectLocation == null;
        if (monitor == null || noProgressMonitor) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NewJavaProjectWizardConstants.NewJavaProjectWizardPageTwo_operation_remove, 3);
        try {
            try {
                try {
                    boolean removeContent;
                    URI projLoc = this.fCurrProject.getLocationURI();
                    boolean bl2 = removeContent = !this.fKeepContent && this.fCurrProject.isSynchronized(2);
                    if (!removeContent) {
                        this.restoreExistingFolders(projLoc);
                    }
                    this.fCurrProject.delete(removeContent, false, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                    this.restoreExistingFiles(projLoc, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                finally {
                    NewJavaProjectWizardPageTwoCOPY.setAutoBuilding(this.fIsAutobuild);
                    this.fIsAutobuild = null;
                }
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
            this.fCurrProject = null;
            this.fKeepContent = false;
        }
    }

    private boolean hasExistingContent(URI realLocation) throws CoreException {
        IFileStore file = EFS.getStore((URI)realLocation);
        return file.fetchInfo().exists();
    }

    protected void initializeBuildPath(IJavaProject javaProject, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NewJavaProjectWizardConstants.NewJavaProjectWizardPageTwo_monitor_init_build_path, 2);
        try {
            IClasspathEntry[] entries = null;
            IPath outputLocation = null;
            IProject project = javaProject.getProject();
            if (this.fKeepContent) {
                if (!project.getFile(FILENAME_CLASSPATH).exists()) {
                    ClassPathDetector detector = new ClassPathDetector(this.fCurrProject, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                    entries = detector.getClasspath();
                    outputLocation = detector.getOutputLocation();
                    if (entries.length == 0) {
                        entries = null;
                    }
                } else {
                    monitor.worked(2);
                }
            } else {
                IClasspathEntry[] sourceClasspathEntries;
                ArrayList<IClasspathEntry> cpEntries = new ArrayList<IClasspathEntry>();
                IWorkspaceRoot root = project.getWorkspace().getRoot();
                IClasspathEntry[] iClasspathEntryArray = sourceClasspathEntries = this.fFirstPage.getSourceClasspathEntries();
                int n = sourceClasspathEntries.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry sourceClasspathEntrie = iClasspathEntryArray[n2];
                    IPath path = sourceClasspathEntrie.getPath();
                    if (path.segmentCount() > 1) {
                        IFolder folder = root.getFolder(path);
                        CoreUtility.createFolder((IFolder)folder, (boolean)true, (boolean)true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    cpEntries.add(sourceClasspathEntrie);
                    ++n2;
                }
                cpEntries.addAll(Arrays.asList(this.fFirstPage.getDefaultClasspathEntries()));
                entries = cpEntries.toArray(new IClasspathEntry[cpEntries.size()]);
                outputLocation = this.fFirstPage.getOutputLocation();
                if (outputLocation.segmentCount() > 1) {
                    IFolder folder = root.getFolder(outputLocation);
                    CoreUtility.createDerivedFolder((IFolder)folder, (boolean)true, (boolean)true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.init(javaProject, outputLocation, entries, false);
        }
        finally {
            monitor.done();
        }
    }

    public void performCancel() {
        if (this.fCurrProject != null) {
            this.removeProvisonalProject();
        }
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException, InterruptedException {
        try {
            String compliance;
            monitor.beginTask(NewJavaProjectWizardConstants.NewJavaProjectWizardPageTwo_operation_create, 3);
            if (this.fCurrProject == null) {
                this.updateProject((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            this.configureJavaProject((IProgressMonitor)new SubProgressMonitor(monitor, 2));
            if (!this.fKeepContent && (compliance = this.fFirstPage.getCompilerCompliance()) != null) {
                IJavaProject project = JavaCore.create((IProject)this.fCurrProject);
                Map options = project.getOptions(false);
                JavaCore.setComplianceOptions((String)compliance, (Map)options);
                JavaModelUtil.setDefaultClassfileOptions((Map)options, (String)compliance);
                project.setOptions(options);
            }
        }
        finally {
            monitor.done();
            this.fCurrProject = null;
            if (this.fIsAutobuild != null) {
                NewJavaProjectWizardPageTwoCOPY.setAutoBuilding(this.fIsAutobuild);
                this.fIsAutobuild = null;
            }
        }
    }

    private void rememberExisitingFolders(URI projectLocation) {
        this.fOrginalFolders = new HashSet();
        try {
            IFileStore[] children;
            IFileStore[] iFileStoreArray = children = EFS.getStore((URI)projectLocation).childStores(0, null);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore child = iFileStoreArray[n2];
                IFileInfo info = child.fetchInfo();
                if (info.isDirectory() && info.exists() && !this.fOrginalFolders.contains(child.getName())) {
                    this.fOrginalFolders.add(child);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    private void rememberExistingFiles(URI projectLocation) throws CoreException {
        this.fDotProjectBackup = null;
        this.fDotClasspathBackup = null;
        IFileStore file = EFS.getStore((URI)projectLocation);
        if (file.fetchInfo().exists()) {
            IFileStore classpathFile;
            IFileStore projectFile = file.getChild(FILENAME_PROJECT);
            if (projectFile.fetchInfo().exists()) {
                this.fDotProjectBackup = this.createBackup(projectFile, "project-desc");
            }
            if ((classpathFile = file.getChild(FILENAME_CLASSPATH)).fetchInfo().exists()) {
                this.fDotClasspathBackup = this.createBackup(classpathFile, "classpath-desc");
            }
        }
    }

    protected void removeProvisonalProject() {
        if (!this.fCurrProject.exists()) {
            this.fCurrProject = null;
            return;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                NewJavaProjectWizardPageTwoCOPY.this.doRemoveProject(monitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation(op));
        }
        catch (InvocationTargetException e) {
            String title = NewJavaProjectWizardConstants.NewJavaProjectWizardPageTwo_error_remove_title;
            String message = NewJavaProjectWizardConstants.NewJavaProjectWizardPageTwo_error_remove_message;
            ExceptionHandler.handle((InvocationTargetException)e, (Shell)this.getShell(), (String)title, (String)message);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void restoreExistingFiles(URI projectLocation, IProgressMonitor monitor) throws CoreException {
        int ticks = ((this.fDotProjectBackup != null ? 1 : 0) + (this.fDotClasspathBackup != null ? 1 : 0)) * 2;
        monitor.beginTask("", ticks);
        try {
            IFileStore projectFile = EFS.getStore((URI)projectLocation).getChild(FILENAME_PROJECT);
            projectFile.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (this.fDotProjectBackup != null) {
                this.copyFile(this.fDotProjectBackup, projectFile, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.jdt.ui", 4, NewJavaProjectWizardConstants.NewJavaProjectWizardPageTwo_problem_restore_project, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        try {
            IFileStore classpathFile = EFS.getStore((URI)projectLocation).getChild(FILENAME_CLASSPATH);
            classpathFile.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (this.fDotClasspathBackup != null) {
                this.copyFile(this.fDotClasspathBackup, classpathFile, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.jdt.ui", 4, NewJavaProjectWizardConstants.NewJavaProjectWizardPageTwo_problem_restore_classpath, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private void restoreExistingFolders(URI projectLocation) {
        try {
            IFileStore[] children;
            IFileStore[] iFileStoreArray = children = EFS.getStore((URI)projectLocation).childStores(0, null);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore child = iFileStoreArray[n2];
                IFileInfo info = child.fetchInfo();
                if (info.isDirectory() && info.exists() && !this.fOrginalFolders.contains(child)) {
                    child.delete(0, null);
                    this.fOrginalFolders.remove(child);
                }
                ++n2;
            }
            for (IFileStore deleted : this.fOrginalFolders) {
                deleted.mkdir(0, null);
            }
        }
        catch (CoreException e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    public void setVisible(boolean visible) {
        boolean isShownFirstTime;
        boolean bl = isShownFirstTime = visible && this.fCurrProject == null;
        if (visible) {
            if (isShownFirstTime) {
                this.createProvisonalProject();
            }
        } else if (this.getContainer().getCurrentPage() == this.fFirstPage) {
            this.removeProvisonalProject();
        }
        super.setVisible(visible);
        if (isShownFirstTime) {
            this.setFocus();
        }
    }

    private final IStatus updateProject(IProgressMonitor monitor) throws CoreException, InterruptedException {
        IStatus result = StatusInfo.OK_STATUS;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewJavaProjectWizardConstants.NewJavaProjectWizardPageTwo_operation_initialize, 7);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            String projectName = this.fFirstPage.getProjectName();
            this.fCurrProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            this.fCurrProjectLocation = this.fFirstPage.getProjectLocationURI();
            URI realLocation = NewJavaProjectWizardPageTwoCOPY.getRealLocation(projectName, this.fCurrProjectLocation);
            this.fKeepContent = this.hasExistingContent(realLocation);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (this.fKeepContent) {
                this.rememberExistingFiles(realLocation);
                this.rememberExisitingFolders(realLocation);
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            try {
                NewJavaProjectWizardPageTwoCOPY.createProject((IProject)this.fCurrProject, (URI)this.fCurrProjectLocation, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            }
            catch (CoreException e) {
                if (e.getStatus().getCode() == 567) {
                    result = new StatusInfo(1, Messages.format((String)NewJavaProjectWizardConstants.NewJavaProjectWizardPageTwo_DeleteCorruptProjectFile_message, (Object)e.getLocalizedMessage()));
                    this.deleteProjectFile(realLocation);
                    if (this.fCurrProject.exists()) {
                        this.fCurrProject.delete(true, null);
                    }
                    NewJavaProjectWizardPageTwoCOPY.createProject((IProject)this.fCurrProject, (URI)this.fCurrProjectLocation, null);
                }
                throw e;
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.initializeBuildPath(JavaCore.create((IProject)this.fCurrProject), (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            this.configureJavaProject((IProgressMonitor)new SubProgressMonitor(monitor, 3));
        }
        finally {
            monitor.done();
        }
        return result;
    }

    protected final boolean useNewSourcePage() {
        return true;
    }
}

