/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.eval;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.psystem.IRelationEvaluator;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.util.Clearable;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Timeline;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Timelines;
import org.eclipse.viatra.query.runtime.rete.misc.SimpleReceiver;
import org.eclipse.viatra.query.runtime.rete.network.ProductionNode;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.StandardNode;
import org.eclipse.viatra.query.runtime.rete.network.Supplier;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;
import org.eclipse.viatra.query.runtime.rete.single.AbstractUniquenessEnforcerNode;

public class RelationEvaluatorNode
extends StandardNode
implements Supplier,
Clearable {
    private final IRelationEvaluator evaluator;
    private Set<Tuple> cachedOutputs;
    private Supplier[] inputSuppliers;
    private BatchingReceiver[] inputReceivers;

    public RelationEvaluatorNode(ReteContainer container, IRelationEvaluator evaluator) {
        super(container);
        this.evaluator = evaluator;
        this.reteContainer.registerClearable(this);
    }

    public void clear() {
        this.cachedOutputs.clear();
    }

    public void connectToParents(List<Supplier> inputSuppliers) {
        this.inputSuppliers = new Supplier[inputSuppliers.size()];
        this.inputReceivers = new BatchingReceiver[inputSuppliers.size()];
        List inputArities = this.evaluator.getInputArities();
        if (inputArities.size() != inputSuppliers.size()) {
            throw new IllegalStateException(String.valueOf(this.evaluator.toString()) + " expects " + inputArities.size() + " inputs, but got " + inputSuppliers.size() + " input(s)!");
        }
        int i = 0;
        while (i < inputSuppliers.size()) {
            int currentExpectedInputArity = (Integer)inputArities.get(i);
            Supplier inputSupplier = inputSuppliers.get(i);
            if (!(inputSupplier instanceof ProductionNode)) {
                throw new IllegalStateException(String.valueOf(this.evaluator.toString()) + " expects each one of its suppliers to be instances of " + ProductionNode.class.getSimpleName() + " but got an instance of " + inputSupplier.getClass().getSimpleName() + "!");
            }
            int currentActualInputArity = ((ProductionNode)inputSupplier).getPosMapping().size();
            if (currentActualInputArity != currentExpectedInputArity) {
                throw new IllegalStateException(String.valueOf(this.evaluator.toString()) + " expects input arity " + currentExpectedInputArity + " at position " + i + " but got " + currentActualInputArity + "!");
            }
            BatchingReceiver inputReceiver = new BatchingReceiver((ProductionNode)inputSupplier, this.reteContainer);
            this.inputSuppliers[i] = inputSupplier;
            this.inputReceivers[i] = inputReceiver;
            this.reteContainer.connectAndSynchronize(inputSupplier, inputReceiver);
            this.reteContainer.getCommunicationTracker().registerDependency(inputReceiver, this);
            ++i;
        }
        ArrayList<Set<Tuple>> inputSets = new ArrayList<Set<Tuple>>();
        BatchingReceiver[] batchingReceiverArray = this.inputReceivers;
        int n = this.inputReceivers.length;
        int n2 = 0;
        while (n2 < n) {
            BatchingReceiver inputReceiver = batchingReceiverArray[n2];
            inputSets.add(inputReceiver.getTuples());
            ++n2;
        }
        this.cachedOutputs = this.evaluateRelation(inputSets);
    }

    @Override
    public void networkStructureChanged() {
        if (this.reteContainer.getCommunicationTracker().isInRecursiveGroup(this)) {
            throw new IllegalStateException(String.valueOf(this.toString()) + " cannot be used in recursive evaluation!");
        }
        super.networkStructureChanged();
    }

    @Override
    public void pullInto(Collection<Tuple> collector, boolean flush) {
        collector.addAll(this.cachedOutputs);
    }

    @Override
    public void pullIntoWithTimeline(Map<Tuple, Timeline<Timestamp>> collector, boolean flush) {
        Timeline timeline = Timelines.createFrom((Comparable)Timestamp.ZERO);
        for (Tuple output : this.cachedOutputs) {
            collector.put(output, (Timeline<Timestamp>)timeline);
        }
    }

    private Set<Tuple> evaluateRelation(List<Set<Tuple>> inputs) {
        try {
            return this.evaluator.evaluateRelation(inputs);
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception during the evaluation of " + this.evaluator.toString() + "!", e);
        }
    }

    private void batchUpdateCompleted() {
        ArrayList<Set<Tuple>> inputSets = new ArrayList<Set<Tuple>>();
        BatchingReceiver[] batchingReceiverArray = this.inputReceivers;
        int n = this.inputReceivers.length;
        int n2 = 0;
        while (n2 < n) {
            BatchingReceiver inputReceiver = batchingReceiverArray[n2];
            inputSets.add(inputReceiver.getTuples());
            ++n2;
        }
        Set<Tuple> newOutputs = this.evaluateRelation(inputSets);
        for (Tuple tuple : newOutputs) {
            if (this.cachedOutputs != null && this.cachedOutputs.remove(tuple)) continue;
            this.propagateUpdate(Direction.INSERT, tuple, Timestamp.ZERO);
        }
        if (this.cachedOutputs != null) {
            for (Tuple tuple : this.cachedOutputs) {
                this.propagateUpdate(Direction.DELETE, tuple, Timestamp.ZERO);
            }
        }
        this.cachedOutputs = newOutputs;
    }

    public class BatchingReceiver
    extends SimpleReceiver {
        private final ProductionNode source;

        private BatchingReceiver(ProductionNode source, ReteContainer container) {
            super(container);
            this.source = source;
        }

        private Set<Tuple> getTuples() {
            return ((AbstractUniquenessEnforcerNode)((Object)this.source)).getTuples();
        }

        @Override
        public void update(Direction direction, Tuple updateElement, Timestamp timestamp) {
            throw new UnsupportedOperationException("This receiver only supports batch-style operation!");
        }

        @Override
        public void batchUpdate(Collection<Map.Entry<Tuple, Integer>> updates, Timestamp timestamp) {
            assert (Timestamp.ZERO.equals(timestamp));
            RelationEvaluatorNode.this.batchUpdateCompleted();
        }
    }
}

