/**
 * 
 *   Copyright (c) 2010-2015, Csaba Debreceni, Istvan Rath and Daniel Varro
 *   This program and the accompanying materials are made available under the
 *   terms of the Eclipse Public License v. 2.0 which is available at
 *   http://www.eclipse.org/legal/epl-v20.html.
 *   
 *   SPDX-License-Identifier: EPL-2.0
 *  
 */
package org.eclipse.viatra.addon.viewers.runtime.model.patterns;

import org.eclipse.viatra.addon.viewers.runtime.model.patterns.Children;
import org.eclipse.viatra.addon.viewers.runtime.model.patterns.Param2containment;
import org.eclipse.viatra.addon.viewers.runtime.model.patterns.Param2edge;
import org.eclipse.viatra.addon.viewers.runtime.model.patterns.Param2item;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedPatternGroup;

/**
 * A pattern group formed of all public patterns defined in ViewersTraceabilityQueries.vql.
 * 
 * <p>Use the static instance as any {@link interface org.eclipse.viatra.query.runtime.api.IQueryGroup}, to conveniently prepare
 * a VIATRA Query engine for matching all patterns originally defined in file ViewersTraceabilityQueries.vql,
 * in order to achieve better performance than one-by-one on-demand matcher initialization.
 * 
 * <p> From package org.eclipse.viatra.addon.viewers.runtime.model.patterns, the group contains the definition of the following patterns: <ul>
 * <li>param2item</li>
 * <li>param2edge</li>
 * <li>param2containment</li>
 * <li>children</li>
 * </ul>
 * 
 * @see IQueryGroup
 * 
 */
@SuppressWarnings("all")
public final class ViewersTraceabilityQueries extends BaseGeneratedPatternGroup {
  /**
   * Access the pattern group.
   * 
   * @return the singleton instance of the group
   * @throws ViatraQueryRuntimeException if there was an error loading the generated code of pattern specifications
   * 
   */
  public static ViewersTraceabilityQueries instance() {
    if (INSTANCE == null) {
        INSTANCE = new ViewersTraceabilityQueries();
    }
    return INSTANCE;
  }
  
  private static ViewersTraceabilityQueries INSTANCE;
  
  private ViewersTraceabilityQueries() {
    querySpecifications.add(Param2item.instance());
    querySpecifications.add(Param2edge.instance());
    querySpecifications.add(Param2containment.instance());
    querySpecifications.add(Children.instance());
  }
  
  public Param2item getParam2item() {
    return Param2item.instance();
  }
  
  public Param2item.Matcher getParam2item(final ViatraQueryEngine engine) {
    return Param2item.Matcher.on(engine);
  }
  
  public Param2edge getParam2edge() {
    return Param2edge.instance();
  }
  
  public Param2edge.Matcher getParam2edge(final ViatraQueryEngine engine) {
    return Param2edge.Matcher.on(engine);
  }
  
  public Param2containment getParam2containment() {
    return Param2containment.instance();
  }
  
  public Param2containment.Matcher getParam2containment(final ViatraQueryEngine engine) {
    return Param2containment.Matcher.on(engine);
  }
  
  public Children getChildren() {
    return Children.instance();
  }
  
  public Children.Matcher getChildren(final ViatraQueryEngine engine) {
    return Children.Matcher.on(engine);
  }
}
