/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.patternlanguage.emf.ui.quickfix;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.viatra.query.patternlanguage.emf.vql.VQLImportSection;
import org.eclipse.viatra.query.tooling.core.project.ProjectGenerationHelper;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.ui.quickfix.XbaseQuickfixProvider;

public class EMFPatternLanguageQuickfixProvider
extends XbaseQuickfixProvider {
    @Fix(value="org.eclipse.viatra.query.patternlanguage.emf.validation.IssueCodes.identifier_as_keyword")
    public void escapeKeywordAsIdentifier(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Prefix Identifier", "Adds a ^ prefix to the identifier", null, new IModification(){

            public void apply(IModificationContext context) throws BadLocationException {
                IXtextDocument document = context.getXtextDocument();
                document.replace(issue.getOffset().intValue(), 0, "^");
            }
        });
    }

    @Fix(value="org.eclipse.viatra.query.patternlanguage.emf.validation.IssueCodes.missing_parameter_type")
    public void inferMissingParameterType(final Issue issue, IssueResolutionAcceptor acceptor) {
        String[] stringArray = issue.getData();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            final String data = stringArray[n2];
            if (data.startsWith("java:")) {
                final String typeName = data.substring("java:".length());
                acceptor.accept(issue, "Insert Java type '" + typeName + "'", "Declares the inferred type " + typeName + " for the variable.", null, new IModification(){

                    public void apply(IModificationContext context) throws Exception {
                        IXtextDocument document = context.getXtextDocument();
                        document.replace(issue.getOffset() + issue.getLength(), 0, " : java " + typeName);
                    }
                });
            } else {
                acceptor.accept(issue, "Insert EMF type '" + data + "'", "Declares the inferred type " + data + " for the variable. \n\n" + "Warning! When not matching the entire ResourceSet, \n" + "this might slightly change the results of the pattern; \n" + "look at the documentation of Query Scopes for details.", null, new IModification(){

                    public void apply(IModificationContext context) throws Exception {
                        IXtextDocument document = context.getXtextDocument();
                        document.replace(issue.getOffset() + issue.getLength(), 0, " : " + data);
                    }
                });
            }
            ++n2;
        }
    }

    @Fix(value="org.eclipse.viatra.query.patternlanguage.emf.validation.IssueCodes.parameter_type_ambiguous")
    public void addAmbiguousParameterType(final Issue issue, IssueResolutionAcceptor acceptor) {
        String[] stringArray = issue.getData();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            final String data = stringArray[n2];
            acceptor.accept(issue, "Insert type '" + data + "'", "Declares the inferred type " + data + " for the variable. \n\n" + "Warning! When not matching the entire ResourceSet, \n" + "this might slightly change the results of the pattern; \n" + "look at the documentation of Query Scopes for details.", null, new IModification(){

                public void apply(IModificationContext context) throws Exception {
                    IXtextDocument document = context.getXtextDocument();
                    document.replace(issue.getOffset() + issue.getLength(), 0, " : " + data);
                }
            });
            ++n2;
        }
    }

    @Fix(value="org.eclipse.viatra.query.patternlanguage.emf.validation.IssueCodes.missing_import")
    public void addMissingPackageImport(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Add missing import", "Add missing import", null, context -> {
            IXtextDocument document = context.getXtextDocument();
            Integer offset = (Integer)document.readOnly(state -> {
                VQLImportSection importSection = (VQLImportSection)Iterators.find((Iterator)state.getAllContents(), (Predicate)Predicates.instanceOf(VQLImportSection.class), null);
                ICompositeNode node = NodeModelUtils.getNode((EObject)importSection);
                return node.getTotalEndOffset();
            });
            if (offset != null) {
                StringBuilder sb = new StringBuilder();
                sb.append("\n");
                sb.append("import \"");
                sb.append(issue.getData()[0]);
                sb.append("\"");
                document.replace(offset.intValue(), 0, sb.toString());
            }
        });
    }

    @Fix(value="org.eclipse.viatra.query.patternlanguage.emf.validation.IssueCodes.missing_import_dependency")
    public void addDependency(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Add dependency", "Add the required bundle to the manifest.mf file.", null, (IModification)new AddDependency(issue));
    }

    @Fix(value="org.eclipse.viatra.query.patternlanguage.emf.validation.IssueCodes.no_iq_runtime_on_classpath")
    public void addLibrary(Issue issue, IssueResolutionAcceptor acceptor) {
        if (issue.getData().length > 1) {
            return;
        }
        acceptor.accept(issue, "Add dependency", String.format("Add the required bundle '%s' to the manifest.mf file.", issue.getData()[0]), null, (IModification)new AddDependency(issue));
    }

    @Fix(value="org.eclipse.viatra.query.patternlanguage.emf.validation.IssueCodes.local_variable_no_quantifying_reference")
    public void explainUsageCounting1(Issue issue, IssueResolutionAcceptor acceptor) {
        this.explainUsageCounting(issue, acceptor);
    }

    @Fix(value="org.eclipse.viatra.query.patternlanguage.emf.validation.IssueCodes.local_variable_no_positive_reference")
    public void explainUsageCounting2(Issue issue, IssueResolutionAcceptor acceptor) {
        this.explainUsageCounting(issue, acceptor);
    }

    @Fix(value="org.eclipse.viatra.query.patternlanguage.emf.validation.IssueCodes.local_variable_quantified_reference")
    public void explainUsageCounting3(Issue issue, IssueResolutionAcceptor acceptor) {
        this.explainUsageCounting(issue, acceptor);
    }

    @Fix(value="org.eclipse.viatra.query.patternlanguage.emf.validation.IssueCodes.symbolic_variable_never_referenced")
    public void explainUsageCounting4(Issue issue, IssueResolutionAcceptor acceptor) {
        this.explainUsageCounting(issue, acceptor);
    }

    private void explainUsageCounting(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Explain message", "", null, new IModification(){

            public void apply(IModificationContext context) throws Exception {
                IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
                helpSystem.displayHelp("org.eclipse.viatra.documentation.help.usagecounting");
            }
        });
    }

    private static final class AddDependency
    implements IModification {
        private final Issue issue;

        private AddDependency(Issue issue) {
            this.issue = issue;
        }

        public void apply(IModificationContext context) throws CoreException, BadLocationException {
            URI uriToProblem = this.issue.getUriToProblem();
            if (uriToProblem.isPlatform()) {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IFile file = root.getFile((IPath)new Path(uriToProblem.toPlatformString(true)));
                if (file.exists() && !file.isReadOnly()) {
                    ProjectGenerationHelper.ensureBundleDependencies((IProject)file.getProject(), Arrays.asList(this.issue.getData()));
                }
                IXtextDocument document = context.getXtextDocument();
                document.replace(this.issue.getOffset().intValue(), 1, document.get(this.issue.getOffset().intValue(), 1));
            }
        }
    }
}

