/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.core.widgets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.layout.PropertyStoreSupport;
import org.eclipse.gef4.layout.interfaces.ConnectionLayout;
import org.eclipse.gef4.layout.interfaces.EntityLayout;
import org.eclipse.gef4.layout.interfaces.NodeLayout;
import org.eclipse.gef4.layout.interfaces.SubgraphLayout;
import org.eclipse.gef4.zest.core.widgets.DefaultSubgraph;
import org.eclipse.gef4.zest.core.widgets.GraphConnection;
import org.eclipse.gef4.zest.core.widgets.GraphNode;
import org.eclipse.gef4.zest.core.widgets.InternalConnectionLayout;
import org.eclipse.gef4.zest.core.widgets.InternalLayoutContext;

class InternalNodeLayout
implements NodeLayout {
    private static final FigureListener figureListener = new FigureListener(){

        public void figureMoved(IFigure source) {
            GraphNode node = (GraphNode)((Object)figureToNode.get(source));
            if (node.getLayout().isMinimized() && source.getSize().equals(0, 0)) {
                source.setVisible(false);
            } else {
                source.setVisible(node.isVisible());
            }
        }
    };
    private static final HashMap<IFigure, GraphNode> figureToNode = new HashMap();
    private PropertyStoreSupport ps = new PropertyStoreSupport();
    private final GraphNode node;
    private final InternalLayoutContext layoutContext;
    private DefaultSubgraph subgraph;
    private boolean isDisposed = false;

    public InternalNodeLayout(GraphNode graphNode, InternalLayoutContext layoutContext) {
        this.setProperty("minimized", false);
        this.setProperty("movable", true);
        this.node = graphNode;
        this.layoutContext = layoutContext;
        graphNode.nodeFigure.addFigureListener(figureListener);
        figureToNode.put(graphNode.nodeFigure, graphNode);
    }

    public Point getLocation() {
        Object location = this.getProperty("location");
        if (location == null) {
            this.refreshLocation();
        }
        return ((Point)this.getProperty("location")).getCopy();
    }

    public org.eclipse.gef4.geometry.planar.Dimension getSize() {
        Object size = this.getProperty("size");
        if (size == null) {
            this.refreshSize();
        }
        return ((org.eclipse.gef4.geometry.planar.Dimension)this.getProperty("size")).getCopy();
    }

    public SubgraphLayout getSubgraph() {
        return this.subgraph;
    }

    public boolean isMovable() {
        return (Boolean)this.getProperty("movable");
    }

    public boolean isPrunable() {
        return this.layoutContext.isPruningEnabled();
    }

    public boolean isPruned() {
        return this.subgraph != null;
    }

    public boolean isResizable() {
        return (this.node.parent.getItem().getStyle() & 0x10) == 0;
    }

    public void prune(SubgraphLayout subgraph) {
        if (subgraph != null && !(subgraph instanceof DefaultSubgraph)) {
            throw new RuntimeException("InternalNodeLayout can be pruned only to instance of DefaultSubgraph.");
        }
        this.layoutContext.checkChangesAllowed();
        if (subgraph == this.subgraph) {
            return;
        }
        if (this.subgraph != null) {
            DefaultSubgraph subgraph2 = this.subgraph;
            this.subgraph = null;
            subgraph2.removeNodes(new NodeLayout[]{this});
        }
        if (subgraph != null) {
            this.subgraph = (DefaultSubgraph)subgraph;
            subgraph.addNodes(new NodeLayout[]{this});
        }
    }

    public void setLocation(double x, double y) {
        if (!this.layoutContext.isLayoutItemFiltered(this.getNode())) {
            this.layoutContext.checkChangesAllowed();
            this.internalSetLocation(x, y);
        }
    }

    private void internalSetLocation(double x, double y) {
        Object location = this.getProperty("location");
        if (location != null) {
            ((Point)location).setLocation(x, y);
        } else {
            this.setProperty("location", new Point(x, y));
        }
    }

    public void setSize(double width, double height) {
        this.layoutContext.checkChangesAllowed();
        this.internalSetSize(width, height);
    }

    private void internalSetSize(double width, double height) {
        Object size = this.getProperty("size");
        if (size != null) {
            ((org.eclipse.gef4.geometry.planar.Dimension)size).setSize(width, height);
        } else {
            this.setProperty("size", new org.eclipse.gef4.geometry.planar.Dimension(width, height));
        }
    }

    public void setMinimized(boolean minimized) {
        this.layoutContext.checkChangesAllowed();
        this.setProperty("minimized", minimized);
    }

    public boolean isMinimized() {
        return (Boolean)this.getProperty("minimized");
    }

    public NodeLayout[] getPredecessingNodes() {
        ConnectionLayout[] connections = this.getIncomingConnections();
        NodeLayout[] result = new NodeLayout[connections.length];
        int i = 0;
        while (i < connections.length) {
            result[i] = connections[i].getSource();
            if (result[i] == this) {
                result[i] = connections[i].getTarget();
            }
            ++i;
        }
        return result;
    }

    public NodeLayout[] getSuccessingNodes() {
        ConnectionLayout[] connections = this.getOutgoingConnections();
        NodeLayout[] result = new NodeLayout[connections.length];
        int i = 0;
        while (i < connections.length) {
            result[i] = connections[i].getTarget();
            if (result[i] == this) {
                result[i] = connections[i].getSource();
            }
            ++i;
        }
        return result;
    }

    public EntityLayout[] getSuccessingEntities() {
        if (this.isPruned()) {
            return new NodeLayout[0];
        }
        ArrayList<Object> result = new ArrayList<Object>();
        HashSet<SubgraphLayout> addedSubgraphs = new HashSet<SubgraphLayout>();
        NodeLayout[] successingNodes = this.getSuccessingNodes();
        int i = 0;
        while (i < successingNodes.length) {
            if (!successingNodes[i].isPruned()) {
                result.add(successingNodes[i]);
            } else {
                SubgraphLayout successingSubgraph = successingNodes[i].getSubgraph();
                if (successingSubgraph.isGraphEntity() && !addedSubgraphs.contains(successingSubgraph)) {
                    result.add(successingSubgraph);
                    addedSubgraphs.add(successingSubgraph);
                }
            }
            ++i;
        }
        return result.toArray(new EntityLayout[result.size()]);
    }

    public EntityLayout[] getPredecessingEntities() {
        if (this.isPruned()) {
            return new NodeLayout[0];
        }
        ArrayList<Object> result = new ArrayList<Object>();
        HashSet<SubgraphLayout> addedSubgraphs = new HashSet<SubgraphLayout>();
        NodeLayout[] predecessingNodes = this.getPredecessingNodes();
        int i = 0;
        while (i < predecessingNodes.length) {
            if (!predecessingNodes[i].isPruned()) {
                result.add(predecessingNodes[i]);
            } else {
                SubgraphLayout predecessingSubgraph = predecessingNodes[i].getSubgraph();
                if (predecessingSubgraph.isGraphEntity() && !addedSubgraphs.contains(predecessingSubgraph)) {
                    result.add(predecessingSubgraph);
                    addedSubgraphs.add(predecessingSubgraph);
                }
            }
            ++i;
        }
        return result.toArray(new EntityLayout[result.size()]);
    }

    public ConnectionLayout[] getIncomingConnections() {
        ArrayList<InternalConnectionLayout> result = new ArrayList<InternalConnectionLayout>();
        for (GraphConnection connection : this.node.getTargetConnections()) {
            if (this.layoutContext.isLayoutItemFiltered(connection)) continue;
            result.add(connection.getLayout());
        }
        for (GraphConnection connection : this.node.getSourceConnections()) {
            if (connection.isDirected() || this.layoutContext.isLayoutItemFiltered(connection)) continue;
            result.add(connection.getLayout());
        }
        return result.toArray(new ConnectionLayout[result.size()]);
    }

    public ConnectionLayout[] getOutgoingConnections() {
        ArrayList<InternalConnectionLayout> result = new ArrayList<InternalConnectionLayout>();
        for (GraphConnection connection : this.node.getSourceConnections()) {
            if (this.layoutContext.isLayoutItemFiltered(connection)) continue;
            result.add(connection.getLayout());
        }
        for (GraphConnection connection : this.node.getTargetConnections()) {
            if (connection.isDirected() || this.layoutContext.isLayoutItemFiltered(connection)) continue;
            result.add(connection.getLayout());
        }
        return result.toArray(new ConnectionLayout[result.size()]);
    }

    public double getPreferredAspectRatio() {
        return 0.0;
    }

    GraphNode getNode() {
        return this.node;
    }

    public Object[] getItems() {
        return new GraphNode[]{this.node};
    }

    void applyLayout() {
        if (this.isMinimized()) {
            this.node.setSize(0.0, 0.0);
            Object location = this.getProperty("location");
            if (location != null) {
                Point p = (Point)location;
                this.node.setLocation(p.x, p.y);
            }
        } else {
            this.node.setSize(-1.0, -1.0);
            Object location = this.getProperty("location");
            Object size = this.getProperty("size");
            if (location != null) {
                Point p = (Point)location;
                org.eclipse.gef4.geometry.planar.Dimension d = this.getSize();
                this.node.setLocation(p.x - d.width / 2.0, p.y - d.height / 2.0);
            }
            if (size != null) {
                org.eclipse.gef4.geometry.planar.Dimension d = (org.eclipse.gef4.geometry.planar.Dimension)size;
                Dimension currentSize = this.node.getSize();
                if (d.width != (double)currentSize.width || d.height != (double)currentSize.height) {
                    this.node.setSize(d.width, d.height);
                }
            }
        }
    }

    InternalLayoutContext getOwnerLayoutContext() {
        return this.layoutContext;
    }

    void refreshSize() {
        Dimension size = this.node.getSize();
        this.internalSetSize(size.width, size.height);
    }

    void refreshLocation() {
        org.eclipse.draw2d.geometry.Point location = this.node.getLocation();
        org.eclipse.gef4.geometry.planar.Dimension size = this.getSize();
        this.internalSetLocation((double)location.x + size.width / 2.0, (double)location.y + size.height / 2.0);
    }

    public String toString() {
        return String.valueOf(this.node.toString()) + "(layout)";
    }

    void dispose() {
        this.isDisposed = true;
        if (this.subgraph != null) {
            this.subgraph.removeNodes(new NodeLayout[]{this});
        }
        this.layoutContext.fireNodeRemovedEvent(this.node.getLayout());
        figureToNode.remove(this.node.nodeFigure);
    }

    boolean isDisposed() {
        return this.isDisposed;
    }

    public void setProperty(String name, Object value) {
        this.ps.setProperty(name, value);
    }

    public Object getProperty(String name) {
        return this.ps.getProperty(name);
    }
}

