/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.keywordhandler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ease.ui.scripts.repository.IScript;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ResourceChangeHandler
implements EventHandler,
IResourceChangeListener {
    private final Map<String, Collection<IScript>> fRegisteredScripts = new HashMap<String, Collection<IScript>>();

    private static List<String> createPattern(String fileMask) {
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = fileMask.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            result.add(token.startsWith("^") ? token : token.replaceAll("\\*", ".*"));
            ++n2;
        }
        return result;
    }

    public void handleEvent(Event event) {
        IScript script = (IScript)event.getProperty("script");
        String value = (String)event.getProperty("value");
        String oldValue = (String)event.getProperty("oldValue");
        if (oldValue != null) {
            for (String pattern : ResourceChangeHandler.createPattern(oldValue)) {
                if (!this.fRegisteredScripts.containsKey(pattern)) continue;
                Collection<IScript> scripts = this.fRegisteredScripts.get(pattern);
                scripts.remove(script);
                if (!scripts.isEmpty()) continue;
                this.fRegisteredScripts.remove(pattern);
            }
        }
        if (value != null) {
            for (String pattern : ResourceChangeHandler.createPattern(value)) {
                if (!this.fRegisteredScripts.containsKey(pattern)) {
                    this.fRegisteredScripts.put(pattern, new HashSet());
                }
                this.fRegisteredScripts.get(pattern).add(script);
            }
        }
        if (this.fRegisteredScripts.isEmpty()) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        } else {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            event.getDelta().accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    if (delta.getResource() instanceof IFile && this.getKind(delta.getKind()) != null) {
                        String location = "workspace:/" + delta.getResource().getFullPath().toPortableString();
                        for (Map.Entry<String, Collection<IScript>> entry : ResourceChangeHandler.this.fRegisteredScripts.entrySet()) {
                            if (!Pattern.matches(entry.getKey(), location)) continue;
                            for (IScript script : entry.getValue()) {
                                script.run(location, this.getKind(delta.getKind()));
                            }
                        }
                    }
                    return true;
                }

                private String getKind(int kind) {
                    switch (kind) {
                        case 1: {
                            return "added";
                        }
                        case 4: {
                            return "changed";
                        }
                        case 2: {
                            return "removed";
                        }
                    }
                    return null;
                }
            });
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }
}

