/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.LinkedList;
import java.util.List;

class ExtractPrototypeMemberDeclarations
implements CompilerPass {
    private String prototypeAlias = "JSCompiler_prototypeAlias";
    private final AbstractCompiler compiler;
    private final Pattern pattern;

    ExtractPrototypeMemberDeclarations(AbstractCompiler compiler, Pattern pattern) {
        this.compiler = compiler;
        this.pattern = pattern;
    }

    @Override
    public void process(Node externs, Node root) {
        GatherExtractionInfo extractionInfo = new GatherExtractionInfo();
        NodeTraversal.traverseEs6(this.compiler, root, extractionInfo);
        if (extractionInfo.shouldExtract()) {
            this.doExtraction(extractionInfo);
            this.compiler.reportCodeChange();
        }
    }

    private void doExtraction(GatherExtractionInfo info) {
        if (this.pattern == Pattern.USE_GLOBAL_TEMP) {
            Node injectionPoint = this.compiler.getNodeForCodeInsertion(null);
            Node var = NodeUtil.newVarNode(this.prototypeAlias, null).useSourceInfoIfMissingFromForTree(injectionPoint);
            injectionPoint.addChildrenToFront(var);
        }
        for (ExtractionInstance instance : info.instances) {
            this.extractInstance(instance);
        }
    }

    private void extractInstance(ExtractionInstance instance) {
        PrototypeMemberDeclaration first = instance.declarations.getFirst();
        String className = first.qualifiedClassName;
        if (this.pattern == Pattern.USE_GLOBAL_TEMP) {
            Node stmt = new Node(first.node.getType(), IR.assign(IR.name(this.prototypeAlias), NodeUtil.newQName(this.compiler, className + ".prototype", instance.parent, className + ".prototype"))).useSourceInfoIfMissingFromForTree(first.node);
            instance.parent.addChildBefore(stmt, first.node);
        } else if (this.pattern == Pattern.USE_IIFE) {
            Node block = IR.block();
            Node func = IR.function(IR.name(""), IR.paramList(IR.name(this.prototypeAlias)), block);
            Node call = IR.call(func, NodeUtil.newQName(this.compiler, className + ".prototype", instance.parent, className + ".prototype"));
            call.putIntProp(50, 1);
            Node stmt = new Node(first.node.getType(), call);
            stmt.useSourceInfoIfMissingFromForTree(first.node);
            instance.parent.addChildBefore(stmt, first.node);
            for (PrototypeMemberDeclaration declar : instance.declarations) {
                block.addChildToBack(declar.node.detachFromParent());
            }
        }
        for (PrototypeMemberDeclaration declar : instance.declarations) {
            this.replacePrototypeMemberDeclaration(declar);
        }
    }

    private void replacePrototypeMemberDeclaration(PrototypeMemberDeclaration declar) {
        Node assignment = declar.node.getFirstChild();
        Node lhs = assignment.getFirstChild();
        Node name = NodeUtil.newQName(this.compiler, this.prototypeAlias + "." + declar.memberName, declar.node, declar.memberName);
        Node accessNode = declar.lhs.getFirstFirstChild();
        String originalName = accessNode.getOriginalName();
        String className = originalName != null ? originalName : "?";
        NodeUtil.setDebugInformation(name.getFirstChild(), lhs, className + ".prototype");
        assignment.replaceChild(lhs, name);
    }

    private class ExtractionInstance {
        LinkedList<PrototypeMemberDeclaration> declarations = new LinkedList();
        private int delta = 0;
        private final Node parent;

        private ExtractionInstance(PrototypeMemberDeclaration head, Node parent) {
            this.parent = parent;
            this.declarations.add(head);
            this.delta = ExtractPrototypeMemberDeclarations.this.pattern.perExtractionOverhead + ExtractPrototypeMemberDeclarations.this.pattern.perMemberOverhead;
            for (Node cur = head.node.getNext(); cur != null; cur = cur.getNext()) {
                if (cur.isFunction()) continue;
                PrototypeMemberDeclaration prototypeMember = PrototypeMemberDeclaration.extractDeclaration(cur);
                if (prototypeMember == null || !head.isSameClass(prototypeMember)) break;
                this.declarations.add(prototypeMember);
                this.delta += ExtractPrototypeMemberDeclarations.this.pattern.perMemberOverhead;
            }
        }

        boolean isFavorable() {
            return this.delta <= 0;
        }
    }

    private class GatherExtractionInfo
    extends NodeTraversal.AbstractShallowCallback {
        private List<ExtractionInstance> instances = new LinkedList<ExtractionInstance>();
        private int totalDelta = Pattern.access$500(ExtractPrototypeMemberDeclarations.access$400(ExtractPrototypeMemberDeclarations.this));

        private GatherExtractionInfo() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!n.isScript() && !n.isBlock()) {
                return;
            }
            for (Node cur = n.getFirstChild(); cur != null; cur = cur.getNext()) {
                PrototypeMemberDeclaration prototypeMember = PrototypeMemberDeclaration.extractDeclaration(cur);
                if (prototypeMember == null) continue;
                ExtractionInstance instance = new ExtractionInstance(prototypeMember, n);
                cur = instance.declarations.getLast().node;
                if (!instance.isFavorable()) continue;
                this.instances.add(instance);
                this.totalDelta += instance.delta;
            }
        }

        private boolean shouldExtract() {
            return this.totalDelta < 0;
        }
    }

    static enum Pattern {
        USE_GLOBAL_TEMP("var t;".length(), "t=y.prototype;".length(), "t.y=".length() - "x[p].y=".length()),
        USE_IIFE(0, "(function(t){})(y.prototype);".length(), "t.y=".length() - "x.prototype.y=".length());

        private final int globalOverhead;
        private final int perExtractionOverhead;
        private final int perMemberOverhead;

        private Pattern(int globalOverHead, int perExtractionOverhead, int perMemberOverhead) {
            this.globalOverhead = globalOverHead;
            this.perExtractionOverhead = perExtractionOverhead;
            this.perMemberOverhead = perMemberOverhead;
        }

        static /* synthetic */ int access$500(Pattern x0) {
            return x0.globalOverhead;
        }
    }

    private static class PrototypeMemberDeclaration {
        final String memberName;
        final Node node;
        final String qualifiedClassName;
        final Node lhs;

        private PrototypeMemberDeclaration(Node lhs, Node node) {
            this.lhs = lhs;
            this.memberName = NodeUtil.getPrototypePropertyName(lhs);
            this.node = node;
            this.qualifiedClassName = NodeUtil.getPrototypeClassName(lhs).getQualifiedName();
        }

        private boolean isSameClass(PrototypeMemberDeclaration other) {
            return this.qualifiedClassName.equals(other.qualifiedClassName);
        }

        private static PrototypeMemberDeclaration extractDeclaration(Node n) {
            if (!NodeUtil.isPrototypePropertyDeclaration(n)) {
                return null;
            }
            Node lhs = n.getFirstFirstChild();
            return new PrototypeMemberDeclaration(lhs, n);
        }
    }
}

