/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.view.verify;

import java.text.DecimalFormat;
import java.text.Format;
import org.eclipse.trace4cps.analysis.mtl.MtlFormula;
import org.eclipse.trace4cps.analysis.mtl.MtlResult;
import org.eclipse.trace4cps.tl.VerificationResult;
import org.eclipse.trace4cps.ui.view.TraceView;

public class ParameterizedCheckNode {
    private static final Format FORMAT = new DecimalFormat("0000");
    private final TraceView view;
    private final MtlFormula phi;
    private final VerificationResult res;
    private final String name;

    public ParameterizedCheckNode(MtlFormula phi, VerificationResult res, TraceView v) {
        this.phi = phi;
        this.res = res;
        this.view = v;
        this.name = res.getName(phi) + "(" + FORMAT.format((int)res.getQuantifierValue(phi)) + ")";
    }

    public TraceView getTraceView() {
        return this.view;
    }

    public String getCheckName() {
        return this.name;
    }

    public MtlFormula getFormula() {
        return this.phi;
    }

    public MtlResult getMTLresult() {
        return this.res.getResult(this.phi);
    }

    public VerificationResult getResult() {
        return this.res;
    }
}

