/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.error;

import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titanium.error.ErrorHandler;
import org.eclipse.titanium.error.ErrorMessage;

public class GUIErrorHandler
implements ErrorHandler {
    private final StringBuilder collectedMessage = new StringBuilder();

    @Override
    public void reportException(String context, Exception exception) {
        ErrorMessage.show("Exception", exception.getMessage() + " (see error log for further information)", 1);
        ErrorReporter.logExceptionStackTrace((String)"", (Throwable)exception);
    }

    @Override
    public void reportErrorMessage(String text) {
        ErrorMessage.show("Error", text, 1);
    }

    @Override
    public void reportWarning(String text) {
        ErrorMessage.show("Warning", text, 4);
    }

    @Override
    public void reportInformation(String text) {
        ErrorMessage.show("Information", text, 2);
    }

    public void reportBadSetting(String windowTitle, String message, String buttonTitle, String prefPage) {
        ErrorMessage.show(windowTitle, message, buttonTitle, prefPage, 1);
    }

    @Override
    public void logError(String message) {
        this.collectedMessage.append(message).append('\n');
    }

    @Override
    public void writeMessageToLog() {
        if (this.collectedMessage.length() != 0) {
            ErrorReporter.logError((String)this.collectedMessage.toString());
            this.collectedMessage.setLength(0);
            this.collectedMessage.trimToSize();
            ErrorMessage.show("Error log", "Various errors happened! For details see the error log.", 1);
        }
    }

    @Override
    public void logException(Exception exception) {
        ErrorReporter.logExceptionStackTrace((String)"", (Throwable)exception);
    }
}

