/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views.msc.ui.core;

import org.eclipse.swt.graphics.Color;
import org.eclipse.titan.log.viewer.Activator;
import org.eclipse.titan.log.viewer.views.msc.ui.core.MSCNode;
import org.eclipse.titan.log.viewer.views.msc.ui.core.PortEventNode;
import org.eclipse.titan.log.viewer.views.msc.ui.view.IGC;

public class PortUnmapping
extends PortEventNode {
    public PortUnmapping(String sourcePort, String targetPort) {
        super(sourcePort, targetPort);
    }

    @Override
    public MSCNode.Type getType() {
        return MSCNode.Type.PORT_UNMAPPING;
    }

    @Override
    public void drawSymbol(IGC context, int x, int y, int direction) {
        context.setForeground((Color)Activator.getDefault().getCachedResource("COLOR_SOFT_BLUE"));
        context.setBackground((Color)Activator.getDefault().getCachedResource("COLOR_SOFT_BLUE"));
        context.fillPolygon(this.drawOuterPolygon(x, y, direction));
        context.setBackground((Color)Activator.getDefault().getCachedResource("COLOR_WHITE"));
        context.fillPolygon(this.drawInnerPolygon(x, y, direction));
        int tempX = x - this.getWidth();
        tempX = direction == 1 ? (tempX += 8) : (tempX -= 8);
        context.setBackground((Color)Activator.getDefault().getCachedResource("COLOR_SOFT_BLUE"));
        context.fillPolygon(this.drawOuterPolygon(tempX, y, direction));
        context.setBackground((Color)Activator.getDefault().getCachedResource("COLOR_WHITE"));
        context.fillPolygon(this.drawInnerPolygon(tempX, y, direction));
        this.setSymbolText(direction);
    }

    @Override
    public void drawSymbol(IGC context, int xLeft, int xRight, int yTop, int yBottom, int direction) {
        context.setForeground((Color)Activator.getDefault().getCachedResource("COLOR_SOFT_BLUE"));
        context.setBackground((Color)Activator.getDefault().getCachedResource("COLOR_SOFT_BLUE"));
        context.fillPolygon(this.drawOuterPolygon(xLeft, yBottom, direction));
        context.setBackground((Color)Activator.getDefault().getCachedResource("COLOR_WHITE"));
        context.fillPolygon(this.drawInnerPolygon(xLeft, yBottom, direction));
        context.setBackground((Color)Activator.getDefault().getCachedResource("COLOR_SOFT_BLUE"));
        context.fillPolygon(this.drawOuterPolygon(xLeft, yTop, direction));
        context.setBackground((Color)Activator.getDefault().getCachedResource("COLOR_WHITE"));
        context.fillPolygon(this.drawInnerPolygon(xLeft, yTop, direction));
        this.setSymbolText(direction);
    }

    private void setSymbolText(int direction) {
        if (this.sourcePort.contentEquals(this.targetPort)) {
            this.setName(this.sourcePort);
        } else if (direction == 1) {
            this.setName(this.sourcePort + " -> " + this.targetPort);
        } else {
            this.setName(this.targetPort + " <- " + this.sourcePort);
        }
    }

    private int[] drawInnerPolygon(int x, int y, int direction) {
        int[] pointsB = new int[]{x - direction * 8 / 2, y - 4 + 2, x - direction * 6, y, x - direction * 8 / 2, y + 4 - 2, x - direction * 2, y};
        return pointsB;
    }

    private int[] drawOuterPolygon(int x, int y, int direction) {
        int[] pointsA = new int[]{x - direction * 8 / 2, y - 4, x - direction * 8, y, x - direction * 8 / 2, y + 4, x, y};
        return pointsA;
    }
}

