/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor.contentassist;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.AllAnyContext;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.AssignmentContext;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.ClassExtendsContext;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.ClassModifierContext;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.ComponentContext;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.DocumentCommentContext;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.DotNotationChainContext;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.ExecuteContext;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.FriendContext;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.FunctionModifierContext;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.FunctionParamContext;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.FunctionParamModifierContext;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.ImportContext;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.ParameterizedContext;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.ProposalContext;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.ProposalContextInfo;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.SetverdictContext;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.WithAttributeEncodeTypeContext;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.WithAttributeExtensionContext;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.WithAttributeExtensionEncodeDecodeContext;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.WithAttributeExtensionEncodeDecodeOptionContext;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.WithAttributeExtensionPrintingContext;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.WithAttributeExtensionPrototypeContext;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.WithAttributeKeywordContext;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.WithAttributeModifierContext;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.WithAttributeVariantColonContext;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.WithAttributeVariantContext;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.WithAttributeVariantOptionContext;
import org.eclipse.ui.IEditorPart;

public class CompletionFinder {
    private static final String IDENTIFIER = "([A-Za-z][A-Za-z0-9_]*)";
    private static final String IDENTIFIERWITHDOT = "([A-Za-z][A-Za-z0-9_.]*)";
    private static final String ASSIGNOP = ":=";
    private static final String ATTRIBUTES = "([^;]+;)*";
    private static final String ATTRIBUTE_KEYWORD = "(encode|display|extension|variant|optional)";
    private static final String ATTRIBUTE_MODIFIER = "(override|\\@local)";
    private static final String ENCODE_DECODE_TYPE = "(BER|PER|XER|RAW|TEXT|JSON|OER)";
    private static final String DEFINITION = "\\s+([A-Za-z][A-Za-z0-9_]*)\\s+([A-Za-z][A-Za-z0-9_]*)\\s*:=";
    private static final String OPT_PARAMETER = "\\s*(\\([^)]*\\))?";
    private static final String WITH_ATTRIBUTE_START = "with\\s*\\{\\s*([^;]+;)*\\s*";
    private static final String EXTENSION_ATTRIBUTE = "((prototype|printing)\\s*\\(\\s*[a-z]+\\s*\\)|transparent|internal|address|provider|done|(encode|decode)\\s*\\(\\s*[A-Z]+\\s*(\\:\\s*[A-Z_]+\\s*)?\\))";
    private static final String EXTENSION_ATTRIBUTES = "(((prototype|printing)\\s*\\(\\s*[a-z]+\\s*\\)|transparent|internal|address|provider|done|(encode|decode)\\s*\\(\\s*[A-Z]+\\s*(\\:\\s*[A-Z_]+\\s*)?\\))\\s+)*";
    private static final String WITH_ATTRIBUTE_EXTENSION_START = "with\\s*\\{\\s*([^;]+;)*\\s*extension\\s*(override|\\@local)?\\s*\\\"\\s*(((prototype|printing)\\s*\\(\\s*[a-z]+\\s*\\)|transparent|internal|address|provider|done|(encode|decode)\\s*\\(\\s*[A-Z]+\\s*(\\:\\s*[A-Z_]+\\s*)?\\))\\s+)*";
    private static final String WITH_ATTRIBUTE_VARIANT_START = "with\\s*\\{\\s*([^;]+;)*\\s*variant\\s*(override|\\@local)?\\s*\\\"\\s*";
    private static final String ASSIGNMENT = "(var|const)\\s+([A-Za-z][A-Za-z0-9_]*)\\s+([A-Za-z][A-Za-z0-9_]*)\\s*:=\\s*(([A-Za-z][A-Za-z0-9_]*))?$";
    private static final String SINGLEASSIGNMENT = "()()\\s+([A-Za-z][A-Za-z0-9_.]*)\\s*:=\\s*(([A-Za-z][A-Za-z0-9_.]*))?$";
    private static final String FRIEND = "friend[\\s]+module[\\s]*(.*)";
    private static final String IMPORT = "import[\\s]+from([\\s]*$|[\\s+]+(([A-Za-z][A-Za-z0-9_]*)))";
    private static final String COMPONENT = "(system|mtc|runs[\\s]+on)((\\s+([A-Za-z][A-Za-z0-9_]*)$)|\\s*)";
    private static final String PARAMETER = "\\s*\\(([^)]*$)";
    private static final String SETVERDICT = "setverdict\\s*\\(([^)]*$)";
    private static final String EXECUTE = "execute\\s*\\(([^)]*$)";
    private static final String FUNCTION_MODIFIER = "function\\s+\\@([A-Za-z][A-Za-z0-9_]*)?$";
    private static final String FUNCTION_PARAM_MODIFIER = "function\\s+(\\@([a-z]+)\\s+)?([A-Za-z][A-Za-z0-9_]*)\\s*\\(\\s*([^,]*,\\s*)*\\@([A-Za-z][A-Za-z0-9_]*)?$";
    private static final String WITH_ATTRIBUTE_EXTENSION_PROTOTYPE = "with\\s*\\{\\s*([^;]+;)*\\s*extension\\s*(override|\\@local)?\\s*\\\"\\s*(((prototype|printing)\\s*\\(\\s*[a-z]+\\s*\\)|transparent|internal|address|provider|done|(encode|decode)\\s*\\(\\s*[A-Z]+\\s*(\\:\\s*[A-Z_]+\\s*)?\\))\\s+)*prototype\\s*\\(\\s*([A-Za-z][A-Za-z0-9_]*)?$";
    private static final String WITH_ATTRIBUTE_EXTENSION_PRINTING = "with\\s*\\{\\s*([^;]+;)*\\s*extension\\s*(override|\\@local)?\\s*\\\"\\s*(((prototype|printing)\\s*\\(\\s*[a-z]+\\s*\\)|transparent|internal|address|provider|done|(encode|decode)\\s*\\(\\s*[A-Z]+\\s*(\\:\\s*[A-Z_]+\\s*)?\\))\\s+)*printing\\s*\\(\\s*([A-Za-z][A-Za-z0-9_]*)?$";
    private static final String WITH_ATTRIBUTE_EXTENSION_ENCODE_DECODE = "with\\s*\\{\\s*([^;]+;)*\\s*extension\\s*(override|\\@local)?\\s*\\\"\\s*(((prototype|printing)\\s*\\(\\s*[a-z]+\\s*\\)|transparent|internal|address|provider|done|(encode|decode)\\s*\\(\\s*[A-Z]+\\s*(\\:\\s*[A-Z_]+\\s*)?\\))\\s+)*(encode|decode)\\s*\\(\\s*([A-Za-z][A-Za-z0-9_]*)?$";
    private static final String WITH_ATTRIBUTE_EXTENSION_ENCODE_DECODE_OPTION = "with\\s*\\{\\s*([^;]+;)*\\s*extension\\s*(override|\\@local)?\\s*\\\"\\s*(((prototype|printing)\\s*\\(\\s*[a-z]+\\s*\\)|transparent|internal|address|provider|done|(encode|decode)\\s*\\(\\s*[A-Z]+\\s*(\\:\\s*[A-Z_]+\\s*)?\\))\\s+)*(encode|decode)\\s*\\(\\s*(BER|PER|XER|RAW|TEXT|JSON|OER)\\s*\\:\\s*([A-Za-z][A-Za-z0-9_]*)?$";
    private static final String WITH_ATTRIBUTE_VARIANT_OPTION = "with\\s*\\{\\s*([^;]+;)*\\s*variant\\s*(override|\\@local)?\\s*\\\"\\s*([A-Za-z][A-Za-z0-9_]*)\\s*\\(\\s*([A-Za-z][A-Za-z0-9_]*)?$";
    private static final String WITH_ATTRIBUTE_VARIANT_COLON = "with\\s*\\{\\s*([^;]+;)*\\s*variant\\s*(override|\\@local)?\\s*\\\"\\s*([A-Za-z][A-Za-z0-9_]*)\\s*\\:\\s*([A-Za-z][A-Za-z0-9_]*)?$";
    private static final String FUNCTION_PARAM = "(([A-Za-z][A-Za-z0-9_]*)\\s*(\\([^)]*\\))?\\s*\\.)+\\s*([A-Za-z][A-Za-z0-9_]*)\\s*\\(\\s*([^,]*,\\s*)*([A-Za-z][A-Za-z0-9_]*)?$";
    private static final String PARAMETERIZED = "([A-Za-z][A-Za-z0-9_]*)\\s*\\(([^)]*$)";
    private static final String CLASS_MODIFIER = "type\\s+class\\s+\\@([A-Za-z][A-Za-z0-9_]*)?$";
    private static final String CLASS_EXTENDS = "type\\s+class\\s+(\\@([a-z]+)\\s+)?([A-Za-z][A-Za-z0-9_]*)\\s+extends\\s+(([A-Za-z][A-Za-z0-9_]*)(\\s*,\\s*([A-Za-z][A-Za-z0-9_]*))*)?";
    private static final String ALL_ANY = "(all|any)\\s*(component|port|timer)\\s*\\.\\s*([A-Za-z][A-Za-z0-9_]*)?$";
    private static final String DOT_NOTATION_CHAIN = "((([A-Za-z][A-Za-z0-9_]*)\\s*(\\([^)]*\\))?\\s*\\.)*\\s*([A-Za-z][A-Za-z0-9_]*)\\s*(\\([^)]*\\))?)\\s*\\.\\s*([A-Za-z][A-Za-z0-9_]*)?$";
    private static final String WITH_ATTRIBUTE_ENCODE_TYPE = "with\\s*\\{\\s*([^;]+;)*\\s*encode\\s*(override|\\@local)?\\s*\\\"([A-Za-z][A-Za-z0-9_]*)?$";
    private static final String WITH_ATTRIBUTE_EXTENSION = "with\\s*\\{\\s*([^;]+;)*\\s*extension\\s*(override|\\@local)?\\s*\\\"\\s*(((prototype|printing)\\s*\\(\\s*[a-z]+\\s*\\)|transparent|internal|address|provider|done|(encode|decode)\\s*\\(\\s*[A-Z]+\\s*(\\:\\s*[A-Z_]+\\s*)?\\))\\s+)*([A-Za-z][A-Za-z0-9_]*)?$";
    private static final String WITH_ATTRIBUTE_VARIANT = "with\\s*\\{\\s*([^;]+;)*\\s*variant\\s*(override|\\@local)?\\s*\\\"\\s*([A-Za-z][A-Za-z0-9_]*)?$";
    private static final String WITH_ATTRIBUTE_KEYWORD = "with\\s*\\{\\s*([A-Za-z][A-Za-z0-9_]*)?$";
    private static final String WITH_ATTRIBUTE_MODIFIER = "with\\s*\\{\\s*([^;]+;)*\\s*(encode|display|extension|variant|optional)\\s*\\@?([A-Za-z][A-Za-z0-9_]*)?$";
    private IEditorPart editor;
    private Module module;
    private Scope scope;
    private IDocument document;
    private IFile file;
    private int offset;
    private List<String> tokenList = new ArrayList<String>();
    private List<String> wsList = new ArrayList<String>();
    private static Map<Pattern, ContextType> contextMap = new LinkedHashMap<Pattern, ContextType>();

    public CompletionFinder(Module module) {
        this.module = module;
    }

    public ProposalContext findOnLeft(IEditorPart editor, int offset, IDocument document, IFile file) {
        this.editor = editor;
        this.document = document;
        this.file = file;
        this.offset = offset;
        int ofs = offset - 1;
        if (-1 == ofs) {
            return null;
        }
        StringBuilder left = new StringBuilder();
        StringBuilder specialStringSb = new StringBuilder();
        SpecialContext commentContext = this.getSpecialContext(specialStringSb);
        switch (commentContext) {
            case SimpleComment: {
                return null;
            }
            case DocComment: {
                return new DocumentCommentContext(new ProposalContextInfo(file, document, offset, specialStringSb.toString(), this.module, null));
            }
        }
        try {
            String ws = this.getWsStringAtOffset(ofs);
            if (ws.length() > 0) {
                this.wsList.add(ws);
                ofs -= ws.length();
                left.insert(0, ' ');
            }
            StringBuilder token = new StringBuilder();
            while (ofs >= 0) {
                char c = document.getChar(ofs);
                if (Character.isAlphabetic(c) || Character.isDigit(c) || c == ',' || c == ':' || c == '=' || c == '.' || c == '_' || c == '(' || c == ')' || c == '@' || c == '{' || c == '\"') {
                    token.insert(0, c);
                    if (-1 != --ofs) continue;
                    return this.getContext(left.toString());
                }
                if (CompletionFinder.isWhiteSpace(c)) {
                    ws = this.getWsStringAtOffset(ofs);
                    if (ws.length() <= 0) continue;
                    this.wsList.add(ws);
                    ofs -= ws.length();
                    left.insert(0, token.toString());
                    left.insert(0, " ");
                    token.setLength(0);
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        return this.getContext(left.toString());
    }

    private String getWsStringAtOffset(int offset) {
        StringBuilder wslist;
        block3: {
            wslist = new StringBuilder();
            do {
                char c;
                try {
                    c = this.document.getChar(offset);
                }
                catch (BadLocationException e) {
                    return wslist.toString();
                }
                if (!CompletionFinder.isWhiteSpace(c)) break block3;
                wslist.append(c);
            } while (--offset != -1);
            return wslist.toString();
        }
        return wslist.toString();
    }

    private ProposalContext getContext(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        for (Map.Entry<Pattern, ContextType> e : contextMap.entrySet()) {
            Pattern p = e.getKey();
            Matcher m = p.matcher(s);
            if (!m.find()) continue;
            ProposalContextInfo info = new ProposalContextInfo(this.file, this.document, this.offset, s, this.module, m);
            switch (e.getValue()) {
                case Assignment: {
                    return new AssignmentContext(info);
                }
                case Component: {
                    return new ComponentContext(info);
                }
                case Friend: {
                    return new FriendContext(info);
                }
                case Import: {
                    return new ImportContext(info);
                }
                case Setverdict: {
                    return new SetverdictContext(info);
                }
                case Execute: {
                    return new ExecuteContext(info);
                }
                case FunctionModifier: {
                    return new FunctionModifierContext(info);
                }
                case FunctionParamModifier: {
                    return new FunctionParamModifierContext(info);
                }
                case FunctionParam: {
                    return new FunctionParamContext(info);
                }
                case Parameterized: {
                    return new ParameterizedContext(info);
                }
                case ClassModifier: {
                    return new ClassModifierContext(info);
                }
                case ClassExtends: {
                    return new ClassExtendsContext(info);
                }
                case AllAny: {
                    return new AllAnyContext(info);
                }
                case DotNotationChain: {
                    return new DotNotationChainContext(info);
                }
                case WithAttributeEncodeType: {
                    return new WithAttributeEncodeTypeContext(info);
                }
                case WithAttributeExtension: {
                    return new WithAttributeExtensionContext(info);
                }
                case WithAttributeExtensionPrototype: {
                    return new WithAttributeExtensionPrototypeContext(info);
                }
                case WithAttributeExtensionPrinting: {
                    return new WithAttributeExtensionPrintingContext(info);
                }
                case WithAttributeExtensionEncodeDecode: {
                    return new WithAttributeExtensionEncodeDecodeContext(info);
                }
                case WithAttributeExtensionEncodeDecodeOption: {
                    return new WithAttributeExtensionEncodeDecodeOptionContext(info);
                }
                case WithAttributeVariant: {
                    return new WithAttributeVariantContext(info);
                }
                case WithAttributeVariantOption: {
                    return new WithAttributeVariantOptionContext(info);
                }
                case WithAttributeVariantColon: {
                    return new WithAttributeVariantColonContext(info);
                }
                case WithAttributeKeyword: {
                    return new WithAttributeKeywordContext(info);
                }
                case WithAttributeModifier: {
                    return new WithAttributeModifierContext(info);
                }
            }
            return null;
        }
        return null;
    }

    private static boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r';
    }

    private SpecialContext getSpecialContext(StringBuilder specialStringSb) {
        boolean inComment = false;
        boolean inString = false;
        boolean isLineComment = false;
        boolean isDocComment = false;
        int lastStartOffset = -1;
        String docText = null;
        try {
            docText = this.document.get(0, this.offset + 1);
        }
        catch (BadLocationException e1) {
            return SpecialContext.None;
        }
        for (int i = 0; i < this.offset; ++i) {
            char c2;
            char c = docText.charAt(i);
            boolean isEof = false;
            if (inString) {
                do {
                    if ((c2 = docText.charAt(i++)) == '\\') {
                        ++i;
                    }
                    if (i < this.offset) continue;
                    isEof = true;
                } while (c2 != '\"' && i < this.offset);
                if (isEof) continue;
                inString = false;
                --i;
                continue;
            }
            if (inComment) {
                if (isLineComment) {
                    do {
                        c2 = docText.charAt(i++);
                        if (i < this.offset) continue;
                        isEof = true;
                    } while (c2 != '\n' && i < this.offset);
                } else {
                    char c3;
                    do {
                        c2 = docText.charAt(i++);
                        if (i >= this.offset) {
                            isEof = true;
                        }
                        c3 = docText.charAt(i);
                    } while (i < this.offset && (c2 != '*' || c3 != '/'));
                }
                if (isEof) continue;
                inComment = false;
                --i;
                continue;
            }
            if (c == '/') {
                lastStartOffset = i;
                c2 = docText.charAt(i + 1);
                if (c2 == '*') {
                    inComment = true;
                    isLineComment = false;
                    ++i;
                } else if (c2 == '/') {
                    inComment = true;
                    isLineComment = true;
                    ++i;
                }
                if (!inComment) continue;
                c2 = docText.charAt(i + 1);
                if (c2 == '*') {
                    isDocComment = true;
                    ++i;
                    continue;
                }
                isDocComment = false;
                continue;
            }
            if (c != '\"') continue;
            lastStartOffset = i;
            inString = true;
        }
        if (lastStartOffset != -1) {
            specialStringSb.append(docText.substring(lastStartOffset, this.offset));
        }
        if (inComment) {
            if (isDocComment) {
                return SpecialContext.DocComment;
            }
            return SpecialContext.SimpleComment;
        }
        if (inString) {
            return SpecialContext.StringLiteral;
        }
        return SpecialContext.None;
    }

    public List<String> getTokenList() {
        return this.tokenList;
    }

    public List<String> getWsList() {
        return this.wsList;
    }

    static {
        contextMap.put(Pattern.compile(COMPONENT), ContextType.Component);
        contextMap.put(Pattern.compile(ASSIGNMENT), ContextType.Assignment);
        contextMap.put(Pattern.compile(SINGLEASSIGNMENT), ContextType.Assignment);
        contextMap.put(Pattern.compile(IMPORT), ContextType.Import);
        contextMap.put(Pattern.compile(FRIEND), ContextType.Friend);
        contextMap.put(Pattern.compile(SETVERDICT), ContextType.Setverdict);
        contextMap.put(Pattern.compile(EXECUTE), ContextType.Execute);
        contextMap.put(Pattern.compile(FUNCTION_MODIFIER), ContextType.FunctionModifier);
        contextMap.put(Pattern.compile(FUNCTION_PARAM_MODIFIER), ContextType.FunctionParamModifier);
        contextMap.put(Pattern.compile(WITH_ATTRIBUTE_EXTENSION_PROTOTYPE), ContextType.WithAttributeExtensionPrototype);
        contextMap.put(Pattern.compile(WITH_ATTRIBUTE_EXTENSION_PRINTING), ContextType.WithAttributeExtensionPrinting);
        contextMap.put(Pattern.compile(WITH_ATTRIBUTE_EXTENSION_ENCODE_DECODE), ContextType.WithAttributeExtensionEncodeDecode);
        contextMap.put(Pattern.compile(WITH_ATTRIBUTE_EXTENSION_ENCODE_DECODE_OPTION), ContextType.WithAttributeExtensionEncodeDecodeOption);
        contextMap.put(Pattern.compile(WITH_ATTRIBUTE_VARIANT_OPTION), ContextType.WithAttributeVariantOption);
        contextMap.put(Pattern.compile(WITH_ATTRIBUTE_VARIANT_COLON), ContextType.WithAttributeVariantColon);
        contextMap.put(Pattern.compile(FUNCTION_PARAM), ContextType.FunctionParam);
        contextMap.put(Pattern.compile(PARAMETERIZED), ContextType.Parameterized);
        contextMap.put(Pattern.compile(CLASS_MODIFIER), ContextType.ClassModifier);
        contextMap.put(Pattern.compile(CLASS_EXTENDS), ContextType.ClassExtends);
        contextMap.put(Pattern.compile(ALL_ANY), ContextType.AllAny);
        contextMap.put(Pattern.compile(DOT_NOTATION_CHAIN), ContextType.DotNotationChain);
        contextMap.put(Pattern.compile(WITH_ATTRIBUTE_ENCODE_TYPE), ContextType.WithAttributeEncodeType);
        contextMap.put(Pattern.compile(WITH_ATTRIBUTE_EXTENSION), ContextType.WithAttributeExtension);
        contextMap.put(Pattern.compile(WITH_ATTRIBUTE_VARIANT), ContextType.WithAttributeVariant);
        contextMap.put(Pattern.compile(WITH_ATTRIBUTE_KEYWORD), ContextType.WithAttributeKeyword);
        contextMap.put(Pattern.compile(WITH_ATTRIBUTE_MODIFIER), ContextType.WithAttributeModifier);
    }

    private static enum ContextType {
        Assignment,
        Component,
        Doccomment,
        Friend,
        Import,
        Setverdict,
        Execute,
        FunctionModifier,
        FunctionParamModifier,
        WithAttributeExtensionPrototype,
        WithAttributeExtensionPrinting,
        WithAttributeExtensionEncodeDecode,
        WithAttributeExtensionEncodeDecodeOption,
        WithAttributeVariantOption,
        WithAttributeVariantColon,
        FunctionParam,
        Parameterized,
        ClassModifier,
        ClassExtends,
        AllAny,
        DotNotationChain,
        WithAttributeEncodeType,
        WithAttributeExtension,
        WithAttributeVariant,
        WithAttributeKeyword,
        WithAttributeModifier;

    }

    private static enum SpecialContext {
        None,
        SimpleComment,
        DocComment,
        StringLiteral;

    }
}

