/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.commonFilters.ResourceExclusionHelper;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.core.TITANNature;
import org.eclipse.titan.designer.editors.IEditorWithCarretOffset;
import org.eclipse.titan.designer.editors.ttcn3editor.CallHierarchyNode;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class CallHierarchy {
    private final HashSet<Assignment.Assignment_type> filterAssignmentType = new HashSet();
    private static final String FILENOTIDENTIFIABLE = "The file related to the editor could not be identified.";
    private static final String EXCLUDEDFROMBUILD = "The name of the module in the file \"{0}\" could not be identified, the file is excluded from build.";
    private static final String NOTFOUNDMODULE = "The module in file \"{0}\" could not be found.";
    private static final String PROJECT_NOT_FOUND = "The project not fund for this file: \"{0}\".";
    private static final String SELECTED_ASSIGNMENT_NOT_FOUND = "The selected object is not a function or testcase or not found.";
    private static final String CALL_HIERARCY_BUILDING = "Call hierarchy view building in progress ...";
    private static final String CALL_HIERARCY_BUILDING_COMPLETE = "Call Hierarchy building complete on the \"{0}\".";
    private static final String STATUS_LINE_ERROR_ICON = "compiler_error_fresh.gif";
    private static final String STATUS_LINE_MESSAGE_ICON = "titan.gif";
    private static final int STATUS_LINE_LEVEL_MESSAGE = 0;
    private static final int STATUS_LINE_LEVEL_ERROR = 1;
    private IEditorPart targetEditor = null;
    private IProject currentProject = null;
    private ProjectSourceParser projectSourceParser = null;
    private Module selectedModule = null;
    private IStatusLineManager statusLineManager = null;
    private CallHierarchyNode currentNode = null;
    private static ArrayList<CallHierarchyNode> searchLog = new ArrayList();
    private static final int SEARCH_LOG_HISTORY_LONG = 15;

    public CallHierarchy() {
        this.filterAssignmentType.add(Assignment.Assignment_type.A_FUNCTION);
        this.filterAssignmentType.add(Assignment.Assignment_type.A_FUNCTION_RVAL);
        this.filterAssignmentType.add(Assignment.Assignment_type.A_FUNCTION_RTEMP);
        this.filterAssignmentType.add(Assignment.Assignment_type.A_EXT_FUNCTION);
        this.filterAssignmentType.add(Assignment.Assignment_type.A_EXT_FUNCTION_RVAL);
        this.filterAssignmentType.add(Assignment.Assignment_type.A_EXT_FUNCTION_RTEMP);
        this.filterAssignmentType.add(Assignment.Assignment_type.A_TESTCASE);
        this.initialization();
    }

    public boolean initialization() {
        this.targetEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (this.targetEditor == null) {
            return false;
        }
        if (this.statusLineManager == null) {
            this.statusLineManager = this.targetEditor.getEditorSite().getActionBars().getStatusLineManager();
        }
        if (this.statusLineManager == null) {
            return false;
        }
        this.statusLineManager.setErrorMessage(null);
        IFile selectedFile = (IFile)this.targetEditor.getEditorInput().getAdapter(IFile.class);
        if (selectedFile == null) {
            this.showStatusLineMessage(FILENOTIDENTIFIABLE, 1);
            return false;
        }
        if (!TITANNature.hasTITANNature(selectedFile.getProject())) {
            this.showStatusLineMessage("The project containing the selected file does not have the TITAN nature among its natures", 1);
            return false;
        }
        this.currentProject = selectedFile.getProject();
        if (this.currentProject == null) {
            this.showStatusLineMessage(MessageFormat.format(PROJECT_NOT_FOUND, selectedFile.getName()), 1);
            return false;
        }
        this.projectSourceParser = GlobalParser.getProjectSourceParser(selectedFile.getProject());
        if (ResourceExclusionHelper.isExcluded((IResource)selectedFile)) {
            this.showStatusLineMessage(MessageFormat.format(EXCLUDEDFROMBUILD, selectedFile.getFullPath()), 1);
            return false;
        }
        this.selectedModule = this.projectSourceParser.containedModule(selectedFile);
        if (this.selectedModule == null) {
            this.showStatusLineMessage(MessageFormat.format(NOTFOUNDMODULE, selectedFile.getName()), 1);
            return false;
        }
        return true;
    }

    public CallHierarchyNode functionCallFinder(ISelection selection) {
        int offset;
        boolean initializationStatus = this.initialization();
        if (!initializationStatus) {
            return null;
        }
        this.showStatusLineMessage(CALL_HIERARCY_BUILDING);
        IPreferencesService preferencesService = Platform.getPreferencesService();
        boolean reportDebugInformation = preferencesService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null);
        if (selection instanceof TextSelection && !selection.isEmpty() && !"".equals(((TextSelection)selection).getText())) {
            if (reportDebugInformation) {
                TITANDebugConsole.println("text selected: " + ((TextSelection)selection).getText());
            }
            TextSelection textSelection = (TextSelection)selection;
            offset = textSelection.getOffset() + textSelection.getLength();
        } else {
            offset = ((IEditorWithCarretOffset)this.targetEditor).getCarretOffset();
        }
        ReferenceFinder referenceFinder = new ReferenceFinder();
        boolean isDetected = referenceFinder.detectAssignmentDataByOffset(this.selectedModule, offset, this.targetEditor, true, reportDebugInformation, this.filterAssignmentType);
        if (!isDetected) {
            this.showStatusLineMessage(SELECTED_ASSIGNMENT_NOT_FOUND, 1);
            return null;
        }
        Assignment selectedAssignment = referenceFinder.assignment;
        if (!(selectedAssignment instanceof Definition)) {
            return null;
        }
        Definition selectedDefinition = (Definition)selectedAssignment;
        CallHierarchyNode node = new CallHierarchyNode(this.selectedModule, selectedDefinition);
        Map<Module, List<ReferenceFinder.Hit>> functionCalls = referenceFinder.findAllReferences(this.selectedModule, this.currentProject, null, false);
        for (Map.Entry<Module, List<ReferenceFinder.Hit>> functionCallsInModule : functionCalls.entrySet()) {
            Module currentModule = functionCallsInModule.getKey();
            for (ReferenceFinder.Hit functionCallHit : functionCallsInModule.getValue()) {
                node.addChild(currentModule, functionCallHit.reference);
            }
        }
        this.setCurrentNode(node);
        this.showStatusLineMessage(MessageFormat.format(CALL_HIERARCY_BUILDING_COMPLETE, this.currentNode.getName()));
        return node;
    }

    public CallHierarchyNode functionCallFinder(CallHierarchyNode node) {
        if (node == null) {
            return node;
        }
        if (node.getNodeDefinition() == null) {
            return node;
        }
        this.showStatusLineMessage(CALL_HIERARCY_BUILDING);
        boolean initializationStatus = this.initialization();
        if (!initializationStatus) {
            return null;
        }
        Set<String> modules = this.projectSourceParser.getKnownModuleNames();
        for (String moduleName : modules) {
            Module module = this.projectSourceParser.getModuleByName(moduleName);
            if (module == null) continue;
            FunctionCallVisitor functionCallVisitor = new FunctionCallVisitor(node.getNodeDefinition());
            module.accept(functionCallVisitor);
            Set<Reference> setOfCallreferences = functionCallVisitor.getFunctionCalls();
            for (Reference reference : setOfCallreferences) {
                node.addChild(module, reference);
            }
        }
        this.showStatusLineMessage(MessageFormat.format(CALL_HIERARCY_BUILDING_COMPLETE, this.currentNode.getName()));
        return node;
    }

    public void addToSearchLog(CallHierarchyNode selectedNode) {
        String selectedNodeName = selectedNode.getName();
        for (int i = 0; i < searchLog.size(); ++i) {
            if (!searchLog.get(i).getName().equals(selectedNodeName)) continue;
            searchLog.remove(searchLog.get(i));
            break;
        }
        searchLog.add(selectedNode);
        if (searchLog.size() > 15) {
            searchLog.remove(0);
        }
    }

    public ArrayList<CallHierarchyNode> getSearchLog() {
        return searchLog;
    }

    public void showStatusLineMessage(String message) {
        this.showStatusLineMessage(message, 0);
    }

    public void showStatusLineMessage(String message, int level) {
        if (this.statusLineManager == null) {
            return;
        }
        this.statusLineManager.setErrorMessage(null);
        if (level == 0) {
            this.statusLineManager.setMessage(ImageCache.getImage(STATUS_LINE_MESSAGE_ICON), message);
        }
        if (level == 1) {
            this.statusLineManager.setMessage(ImageCache.getImage(STATUS_LINE_ERROR_ICON), message);
        }
    }

    public IProject getCurrentProject() {
        return this.currentProject;
    }

    public CallHierarchyNode getCurrentNode() {
        return this.currentNode;
    }

    public void setCurrentNode(CallHierarchyNode newNode) {
        this.currentNode = newNode;
    }

    public void setStatusLineManager(IStatusLineManager newStatusLineManager) {
        this.statusLineManager = newStatusLineManager;
    }

    private class FunctionCallVisitor
    extends ASTVisitor {
        private final Assignment target;
        private final Set<Reference> setOfreferences = new HashSet<Reference>();

        public FunctionCallVisitor(Assignment target) {
            this.target = target;
            this.setOfreferences.clear();
        }

        public Set<Reference> getFunctionCalls() {
            return this.setOfreferences;
        }

        @Override
        public int visit(IVisitableNode node) {
            if (!(node instanceof Reference)) {
                return 3;
            }
            Reference reference = (Reference)node;
            Assignment referedAssignment = reference.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false);
            if (referedAssignment == null) {
                return 3;
            }
            if (!(referedAssignment instanceof Definition)) {
                return 3;
            }
            if (!referedAssignment.getFullName().equals(this.target.getFullName())) {
                return 3;
            }
            this.setOfreferences.add(reference);
            return 3;
        }
    }
}

