/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.asn1editor.actions;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.RewriteSessionEditProcessor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.titan.common.parsers.Interval;
import org.eclipse.titan.designer.editors.actions.AbstractIndentAction;
import org.eclipse.titan.designer.editors.asn1editor.ASN1Editor;
import org.eclipse.ui.IEditorPart;

public final class IndentAction
extends AbstractIndentAction {
    @Override
    protected IDocument getDocument() {
        IEditorPart editorPart = this.getTargetEditor();
        if (editorPart instanceof ASN1Editor) {
            return ((ASN1Editor)editorPart).getDocument();
        }
        return null;
    }

    @Override
    protected int lineIndentationLevel(IDocument document, int realStartOffset, int lineEndOffset, Interval startEnclosingInterval) throws BadLocationException {
        if (realStartOffset + 1 == lineEndOffset) {
            return 0;
        }
        if (Interval.interval_type.MULTILINE_COMMENT.equals((Object)startEnclosingInterval.getType()) || startEnclosingInterval.getStartOffset() == realStartOffset || Interval.interval_type.SINGLELINE_COMMENT.equals((Object)startEnclosingInterval.getType())) {
            return Math.max(0, startEnclosingInterval.getDepth() - 1);
        }
        if (startEnclosingInterval.getEndOffset() < lineEndOffset && !this.containsNonWhiteSpace(document.get(realStartOffset, Math.max(startEnclosingInterval.getEndOffset() - realStartOffset - 1, 0)))) {
            return Math.max(0, startEnclosingInterval.getDepth() - 1);
        }
        return startEnclosingInterval.getDepth();
    }

    @Override
    protected void performEdits(RewriteSessionEditProcessor processor) throws BadLocationException {
        processor.performEdits();
    }

    @Override
    protected ISelection getSelection() {
        IEditorPart editorPart = this.getTargetEditor();
        if (editorPart == null || !(editorPart instanceof ASN1Editor)) {
            return null;
        }
        return ((ASN1Editor)editorPart).getSelectionProvider().getSelection();
    }
}

