/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.core;

import java.io.File;
import java.net.URI;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.path.PathConverter;
import org.eclipse.titan.common.path.TITANPathUtilities;
import org.eclipse.titan.common.utils.Cygwin;
import org.eclipse.titan.designer.AST.MarkerHandler;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.GeneralConstants;
import org.eclipse.titan.designer.consoles.TITANConsole;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.core.ProjectBasedBuilder;
import org.eclipse.titan.designer.core.SymbolicLinkHandler;
import org.eclipse.titan.designer.core.TITANBuilderResourceDeltaVisitor;
import org.eclipse.titan.designer.core.TITANBuilderResourceVisitor;
import org.eclipse.titan.designer.core.TITANInstallationValidator;
import org.eclipse.titan.designer.core.TITANJob;
import org.eclipse.titan.designer.core.makefile.ExternalMakefileGenerator;
import org.eclipse.titan.designer.core.makefile.InternalMakefileGenerator;
import org.eclipse.titan.designer.decorators.TITANDecorator;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.license.LicenseValidator;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.GlobalProjectStructureTracker;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titan.designer.properties.IPropertyChangeListener;
import org.eclipse.titan.designer.properties.PropertyNotificationManager;
import org.eclipse.titan.designer.properties.data.MakeAttributesData;
import org.eclipse.titan.designer.properties.data.ProjectBuildPropertyData;
import org.eclipse.ui.progress.IProgressConstants;

public final class TITANBuilder
extends IncrementalProjectBuilder {
    private static final String TITAN_GIF = "titan.gif";
    public static final String BUILDER_ID = "org.eclipse.titan.designer.core.TITANBuilder";
    static final String EMPTY_STRING = "";
    static final String APOSTROPHE = "'";
    static final String TRUE = "true";
    static final String FALSE = "false";
    static final String ERROR = "error";
    static final String BUILD_PROCESS = "Build process";
    static final String MAKEFILEGENERATOR = "ttcn3_makefilegen";
    static final String BIN_DIRECTORY = "bin";
    static final String MAKE = "make";
    static final String DEP = "dep";
    static final String CHECK = "check";
    static final String CLEAN = "clean";
    static final String MAKE_CHECK = "make check";
    static final String MAKE_COMPILE = "make compile";
    static final String MAKE_DEP = "make dep";
    static final String MAKE_ALL = "make all";
    static final String MAKE_OBJECTS = "make objects";
    static final String MAKE_SHARED_OBJECTS = "make shared_objects";
    static final String MAKE_CLEAN = "make clean";
    static final String CREATE_DEPENDENCY = "Create dependency";
    static final String CREATE_MAKEFILE = "Create makefile";
    static final String MAKEFILE = "Makefile";
    static final String TEMPORARY_MAKEFILE = "Makefile.tmp";
    static final String REMOVE = "rm";
    static final String MOVE = "mv";
    static final String FORCE_EXECUTION = "-f";
    static final String RENAMING_MAKEFILE = "Renaming Makefile.tmp to Makefile";
    static final String RUNNING_UPDATER = "Running updater script";
    static final String REMOVING_MAKEFILE = "Removing Makefile";
    static final String REMOVING_TEMPORARY_MAKEFILE = "Removing Makefile.tmp";
    static final String REMOVING_EXECUTABLE = "Removing outdated executable";
    static final String REMOVE_COMPILE_FILE = "removing compile file";
    static final String BUILD_WITHOUT_MAKEFILE_ERROR = "The build process is not able to execute, as a Makefile was not found in the working directory and automatic Makefile generation is not enabled for project ";
    static final String CLEAN_WITHOUT_MAKEFILE_ERROR = "make clean for project {0} was not issued as the Makefile is missing.";
    static final String PROCESSINGUNITSTOUSENOTSET = "Note: The processing units to use property of this project is not set, but could enhance build speed.";
    static final String FEWPROCESSINGUNITTOUSESET = "Note: The build process is set to use only {0} parallel processing units, while there are {1} available.";
    private static final String MISSING_CYGWIN = "Build failed. No cygwin installation found.";
    private static IPropertyChangeListener listener = new IPropertyChangeListener(){

        @Override
        public void propertyChanged(final IResource resouce) {
            WorkspaceJob refreshJob = new WorkspaceJob("Refreshing built resources"){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    boolean proceedingOK = TITANBuilder.regenerateMakefile(resouce.getProject());
                    if (proceedingOK) {
                        proceedingOK = TITANBuilder.removeExecutable(resouce.getProject());
                    }
                    if (proceedingOK) {
                        TITANBuilder.invokeBuild(resouce.getProject());
                    }
                    return Status.OK_STATUS;
                }
            };
            refreshJob.setPriority(40);
            refreshJob.setUser(false);
            refreshJob.setSystem(true);
            refreshJob.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor(TITANBuilder.TITAN_GIF));
            refreshJob.schedule();
        }
    };

    private TITANBuilderResourceDeltaVisitor getDeltaVisitor(IResourceDelta delta) {
        TITANBuilderResourceDeltaVisitor visitor = new TITANBuilderResourceDeltaVisitor(delta);
        if (delta != null) {
            try {
                delta.accept((IResourceDeltaVisitor)visitor);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("While visiting resource delta: " + delta), (Throwable)e);
            }
        }
        return visitor;
    }

    public static boolean removeExecutable(IProject project) {
        return TITANBuilder.removeExecutable(project, new ArrayList<IProject>(), false);
    }

    private static boolean removeExecutable(IProject project, List<IProject> processedProjects, boolean sync) {
        if (!project.isAccessible()) {
            return false;
        }
        try {
            String targetExecutable = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "targetExecutable"));
            return TITANBuilder.removeExecutable(project, targetExecutable, processedProjects, sync);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)"Target executable setting could not be read", (Throwable)e);
            return false;
        }
    }

    public static boolean removeExecutable(IProject project, String targetExecutable, List<IProject> processedProjects) {
        return TITANBuilder.removeExecutable(project, targetExecutable, processedProjects, false);
    }

    public static boolean removeExecutable(IProject project, String targetExecutable, List<IProject> processedProjects, boolean sync) {
        IProject[] referencedProjects;
        if (!TITANBuilder.isBuilderEnabled(project)) {
            return true;
        }
        if (processedProjects.contains(project)) {
            return true;
        }
        processedProjects.add(project);
        String realTargetExecutable = targetExecutable;
        IPath workingDir = ProjectBasedBuilder.getProjectBasedBuilder(project).getWorkingDirectoryPath(false);
        if (workingDir == null || !workingDir.toFile().exists()) {
            return true;
        }
        if (EMPTY_STRING.equals(realTargetExecutable)) {
            realTargetExecutable = project.getName();
            if ("win32".equals(Platform.getOS())) {
                realTargetExecutable = realTargetExecutable + ".exe";
            }
        }
        if (realTargetExecutable != null && realTargetExecutable.length() > 0) {
            StringBuilder output;
            ArrayList<String> command = new ArrayList<String>();
            command.add(REMOVE);
            command.add(FORCE_EXECUTION);
            boolean reportDebugInformation = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", false, null);
            if (new File(realTargetExecutable).exists()) {
                output = new StringBuilder();
                command.add(APOSTROPHE + PathConverter.convert((String)realTargetExecutable, (boolean)reportDebugInformation, (StringBuilder)output) + APOSTROPHE);
                TITANDebugConsole.println(output);
            } else if (new File(workingDir.toOSString() + File.separatorChar + realTargetExecutable).exists()) {
                output = new StringBuilder();
                command.add(APOSTROPHE + PathConverter.convert((String)(workingDir.toOSString() + File.separatorChar + realTargetExecutable), (boolean)reportDebugInformation, (StringBuilder)output) + APOSTROPHE);
                TITANDebugConsole.println(output);
            } else {
                return true;
            }
            TITANJob job = new TITANJob(BUILD_PROCESS, new HashMap<String, IFile>(), workingDir.toFile(), project);
            job.setPriority(50);
            job.setUser(true);
            job.addCommand(command, REMOVING_EXECUTABLE);
            if (sync) {
                job.runInWorkspace((IProgressMonitor)new NullProgressMonitor());
            } else {
                job.setRule((ISchedulingRule)project);
                job.schedule();
            }
        }
        for (IProject tempProject : referencedProjects = ProjectBasedBuilder.getProjectBasedBuilder(project).getReferencingProjects()) {
            TITANBuilder.removeExecutable(tempProject, processedProjects, sync);
        }
        return true;
    }

    public static boolean removeMakefile(IProject project) {
        return TITANBuilder.removeMakefile(project, new ArrayList<IProject>());
    }

    private static boolean removeMakefile(IProject project, List<IProject> processedProjects) {
        IProject[] referencedProjects;
        if (!TITANBuilder.isBuilderEnabled(project)) {
            return true;
        }
        if (processedProjects.contains(project)) {
            return true;
        }
        processedProjects.add(project);
        IPath workingDir = ProjectBasedBuilder.getProjectBasedBuilder(project).getWorkingDirectoryPath(true);
        if (workingDir == null || !workingDir.toFile().exists()) {
            return true;
        }
        if (ProjectBuildPropertyData.useAutomaticMakefilegeneration(project)) {
            if (ProjectBuildPropertyData.useInternalMakefilegeneration(project)) {
                InternalMakefileGenerator makefileGenerator = new InternalMakefileGenerator(project);
                makefileGenerator.generateMakefile();
            } else {
                File file = new File(workingDir.toOSString() + File.separatorChar + MAKEFILE);
                if (file.exists()) {
                    file.delete();
                }
            }
        }
        for (IProject tempProject : referencedProjects = ProjectBasedBuilder.getProjectBasedBuilder(project).getReferencingProjects()) {
            TITANBuilder.removeMakefile(tempProject, processedProjects);
        }
        return true;
    }

    public static boolean regenerateMakefile(IProject project) {
        return TITANBuilder.regenerateMakefile(project, new ArrayList<IProject>());
    }

    private static boolean regenerateMakefile(IProject project, List<IProject> processedProjects) {
        IProject[] referencedProjects;
        if (!TITANBuilder.isBuilderEnabled(project)) {
            return true;
        }
        if (processedProjects.contains(project)) {
            return true;
        }
        processedProjects.add(project);
        IPath workingDir = ProjectBasedBuilder.getProjectBasedBuilder(project).getWorkingDirectoryPath(true);
        if (workingDir == null) {
            return false;
        }
        File wd = workingDir.toFile();
        if (!wd.exists() && !wd.mkdirs()) {
            ErrorReporter.logError((String)"The working folder could not be created");
            return false;
        }
        if (ProjectBuildPropertyData.useAutomaticMakefilegeneration(project)) {
            if (ProjectBuildPropertyData.useInternalMakefilegeneration(project)) {
                InternalMakefileGenerator makefileGenerator = new InternalMakefileGenerator(project);
                makefileGenerator.generateMakefile();
            } else {
                TITANJob buildJob = new TITANJob(BUILD_PROCESS, new HashMap<String, IFile>(), workingDir.toFile(), project);
                buildJob.setPriority(50);
                buildJob.setUser(true);
                buildJob.setRule((ISchedulingRule)project);
                List<String> command = ExternalMakefileGenerator.createMakefileGeneratorCommand(project);
                buildJob.addCommand(command, CREATE_MAKEFILE);
                buildJob.schedule();
            }
        }
        for (IProject tempProject : referencedProjects = ProjectBasedBuilder.getProjectBasedBuilder(project).getReferencingProjects()) {
            TITANBuilder.regenerateMakefile(tempProject, processedProjects);
        }
        return true;
    }

    public static void cleanProjectForRebuild(final IProject project, boolean sync) {
        if (project == null || project.getWorkspace() == null) {
            return;
        }
        WorkspaceJob refreshJob = new WorkspaceJob("Build"){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                try {
                    project.build(15, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    ErrorReporter.logExceptionStackTrace((String)("While cleaning `" + project.getName() + TITANBuilder.APOSTROPHE), (Throwable)e);
                }
                TITANBuilder.removeMakefile(project, new ArrayList());
                ProjectBasedBuilder.setForcedMakefileRebuild(project);
                ProjectBasedBuilder.setForcedBuild(project);
                try {
                    project.touch(null);
                }
                catch (CoreException e) {
                    ErrorReporter.logExceptionStackTrace((String)("While touching `" + project.getName() + TITANBuilder.APOSTROPHE), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        refreshJob.setPriority(30);
        refreshJob.setUser(false);
        refreshJob.setSystem(true);
        refreshJob.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor(TITAN_GIF));
        if (sync) {
            try {
                refreshJob.runInWorkspace((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
        } else {
            refreshJob.setRule((ISchedulingRule)project.getWorkspace().getRoot());
            refreshJob.schedule();
        }
    }

    public static void markProjectForRebuild(final IProject project) {
        if (project == null || project.getWorkspace() == null) {
            return;
        }
        WorkspaceJob refreshJob = new WorkspaceJob("Build"){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                ProjectBasedBuilder.setForcedMakefileRebuild(project);
                ProjectBasedBuilder.setForcedBuild(project);
                return Status.OK_STATUS;
            }
        };
        refreshJob.setPriority(30);
        refreshJob.setUser(false);
        refreshJob.setSystem(true);
        refreshJob.setRule((ISchedulingRule)project.getWorkspace().getRoot());
        refreshJob.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor(TITAN_GIF));
        refreshJob.schedule();
    }

    public static void invokeBuild(IProject project) {
        if (project == null || project.getWorkspace() == null) {
            return;
        }
        IWorkspaceDescription description = project.getWorkspace().getDescription();
        if (description != null && description.isAutoBuilding()) {
            TITANBuilder.invokeForcedBuild(project);
        } else {
            ErrorReporter.logWarning((String)"The automatic build is false change this and try again.");
        }
    }

    public static void invokeForcedBuild(final IProject project) {
        ISchedulingRule rule = ResourcesPlugin.getWorkspace().getRuleFactory().createRule((IResource)project);
        try {
            Job.getJobManager().beginRule(rule, null);
            if (project == null || project.getWorkspace() == null) {
                return;
            }
            WorkspaceJob refreshJob = new WorkspaceJob("Build"){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    try {
                        project.build(6, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        ErrorReporter.logExceptionStackTrace((String)("While building `" + project.getName() + TITANBuilder.APOSTROPHE), (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            refreshJob.setPriority(30);
            refreshJob.setUser(false);
            refreshJob.setSystem(true);
            refreshJob.setRule((ISchedulingRule)project.getWorkspace().getRoot());
            refreshJob.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor(TITAN_GIF));
            refreshJob.schedule();
        }
        finally {
            Job.getJobManager().endRule(rule);
        }
    }

    private void createMakefile(TITANJob buildJob) throws CoreException {
        boolean reportDebugInformation = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", false, null);
        if (ProjectBuildPropertyData.useInternalMakefilegeneration(this.getProject())) {
            InternalMakefileGenerator makefileGenerator = new InternalMakefileGenerator(this.getProject());
            makefileGenerator.generateMakefile();
        } else {
            List<String> command = ExternalMakefileGenerator.createMakefileGeneratorCommand(this.getProject());
            buildJob.addCommand(command, CREATE_MAKEFILE);
        }
        String makefileScript = this.getProject().getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "makefileUpdateScript"));
        if (makefileScript != null && makefileScript.length() > 0) {
            URI uri = TITANPathUtilities.resolvePathURI((String)makefileScript, (String)this.getProject().getLocation().toOSString());
            makefileScript = URIUtil.toPath((URI)uri).toOSString();
            ArrayList<String> command = new ArrayList<String>();
            command.add(REMOVE);
            command.add(FORCE_EXECUTION);
            command.add(TEMPORARY_MAKEFILE);
            buildJob.addCommand(command, REMOVING_TEMPORARY_MAKEFILE);
            StringBuilder output = new StringBuilder();
            command = new ArrayList();
            command.add(APOSTROPHE + PathConverter.convert((String)makefileScript, (boolean)reportDebugInformation, (StringBuilder)output) + APOSTROPHE);
            command.add(MAKEFILE);
            command.add(TEMPORARY_MAKEFILE);
            buildJob.addCommand(command, RUNNING_UPDATER);
            TITANDebugConsole.println(output);
            command = new ArrayList();
            command.add(MOVE);
            command.add(FORCE_EXECUTION);
            command.add(TEMPORARY_MAKEFILE);
            command.add(MAKEFILE);
            buildJob.addCommand(command, RENAMING_MAKEFILE);
        }
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        String buildLevel;
        boolean makefileWillExist;
        IMarker workingDirectories;
        IProject project = this.getProject();
        if (!TITANInstallationValidator.check(true)) {
            return project.getReferencedProjects();
        }
        if (!LicenseValidator.check()) {
            return project.getReferencedProjects();
        }
        if (Cygwin.isMissingInOSWin32()) {
            ErrorReporter.logError((String)MISSING_CYGWIN);
            return project.getReferencedProjects();
        }
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        boolean reportDebugInformation = store.getBoolean("org.eclipse.titan.designer.displayDebugInformation");
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        String consoleActionBeforeBuild = store.getString("org.eclipse.titan.designer.consoleActionBeforeBuild");
        if ("Print delimiter".equals(consoleActionBeforeBuild)) {
            String timeStamp = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss").format(Calendar.getInstance().getTime());
            TITANConsole.println("**************************************************************\n" + timeStamp + ": starting to build " + project.getName() + "\n**************************************************************");
        } else if ("Clear".equals(consoleActionBeforeBuild)) {
            TITANConsole.clearConsole();
        }
        if (store.getBoolean("org.eclipse.titan.designer.treatOnTheFlyErrorsasFatalForBuild")) {
            IMarker[] markers;
            for (IMarker marker : markers = project.findMarkers("org.eclipse.titan.designer.ontheflySyntacticMarker", true, 2)) {
                if (2 != marker.getAttribute("severity", 2)) continue;
                TITANConsole.println("Build failed because of syntactical errors");
                return project.getReferencedProjects();
            }
            for (IMarker marker : markers = project.findMarkers("org.eclipse.titan.designer.ontheflySemanticMarker", true, 2)) {
                if (2 != marker.getAttribute("severity", 2)) continue;
                TITANConsole.println("Build failed because of semantic errors");
                return project.getReferencedProjects();
            }
            for (IMarker marker : markers = project.findMarkers("org.eclipse.titan.designer.ontheflyMixedMarker", true, 2)) {
                if (2 != marker.getAttribute("severity", 2)) continue;
                TITANConsole.println("Build failed because of mixed errors");
                return project.getReferencedProjects();
            }
        }
        MarkerHandler.markMarkersForRemoval("org.eclipse.titan.designer.compilerErrorMarker", (IResource)project);
        if (!ProjectSourceParser.checkConfigurationRequirements(project, "org.eclipse.titan.designer.compilerErrorMarker")) {
            TITANConsole.println("Build failed because of build configuration error. See view 'Error Log' for details.");
            return project.getReferencedProjects();
        }
        if (!ProjectBasedBuilder.getProjectBasedBuilder(project).checkCodeSplittingEquality()) {
            TITANConsole.println("Build failed because of code splitting setting error.\nCode splitting settings shall be the same. See view 'Error Log' for details.");
            return project.getReferencedProjects();
        }
        MarkerHandler.removeAllMarkedMarkers((IResource)project);
        if (reportDebugInformation) {
            TITANDebugConsole.println("starting to build " + project.getName());
        }
        progress.beginTask("Build", 6);
        SubMonitor initialisationMonitor = progress.newChild(1);
        initialisationMonitor.beginTask("Checking prerequisites", 3);
        if (!TITANBuilder.isBuilderEnabled(project)) {
            initialisationMonitor.done();
            progress.done();
            if (reportDebugInformation) {
                TITANDebugConsole.println("Finished building " + project.getName() + " as the builder does not seem to be enabled.");
            }
            return project.getReferencedProjects();
        }
        initialisationMonitor.worked(1);
        IPath workingDir = ProjectBasedBuilder.getProjectBasedBuilder(project).getWorkingDirectoryPath(true);
        if (workingDir == null) {
            ErrorReporter.logError((String)"The working directory could not be created because it hasn't been defined yet");
            initialisationMonitor.done();
            progress.done();
            if (reportDebugInformation) {
                TITANDebugConsole.println("Finished building " + project.getName() + " as the working directory is not defined.");
            }
            return project.getReferencedProjects();
        }
        File file = new File(workingDir.toOSString());
        if (!file.exists()) {
            file.mkdirs();
        }
        for (IContainer workingDirectory : workingDirectories = ProjectBasedBuilder.getProjectBasedBuilder(project).getWorkingDirectoryResources(true)) {
            if (workingDirectory == null) continue;
            if (!workingDirectory.isSynchronized(0)) {
                workingDirectory.refreshLocal(0, null);
            }
            if (!workingDirectory.isAccessible() || workingDirectory.isDerived()) continue;
            try {
                workingDirectory.setDerived(true, null);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
        }
        String targetExecutable = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "targetExecutable"));
        if (targetExecutable != null && targetExecutable.length() != 0) {
            URI uri = TITANPathUtilities.resolvePathURI((String)targetExecutable, (String)project.getLocation().toOSString());
            IPath path = URIUtil.toPath((URI)uri);
            targetExecutable = (path = path.removeLastSegments(1)).toOSString();
            file = new File(targetExecutable);
            if (!file.exists() && !file.mkdirs()) {
                ErrorReporter.logError((String)"The folder to contain the generated executable could not be created");
            }
        }
        initialisationMonitor.worked(1);
        TITANBuilderResourceDeltaVisitor deltavisitor = this.getDeltaVisitor(this.getDelta(project));
        boolean mandatoryMakefileRebuild = deltavisitor.needsMakefileRebuild() || ProjectBasedBuilder.getForcedMakefileRebuild(project) != false;
        int nofChangedResources = deltavisitor.getChangedResources().size();
        if (ProjectBasedBuilder.getForcedBuild(project).booleanValue() || mandatoryMakefileRebuild) {
            ++nofChangedResources;
        }
        if (mandatoryMakefileRebuild) {
            IProject[] referencingProjects = ProjectBasedBuilder.getProjectBasedBuilder(project).getReferencingProjects();
            for (int i = 0; i < referencingProjects.length; ++i) {
                ProjectBasedBuilder.setForcedMakefileRebuild(referencingProjects[i]);
            }
        }
        ProjectBasedBuilder.clearForcedBuild(project);
        ProjectBasedBuilder.clearForcedMakefileRebuild(project);
        if (nofChangedResources == 0 && kind != 6) {
            initialisationMonitor.done();
            progress.done();
            if (reportDebugInformation) {
                TITANDebugConsole.println("Finished building " + project.getName() + " as there were no resource changes.");
            }
            return project.getReferencedProjects();
        }
        initialisationMonitor.worked(1);
        TITANBuilderResourceVisitor visitor = ProjectBasedBuilder.getProjectBasedBuilder(project).getResourceVisitor();
        Map<String, IFile> files = visitor.getFiles();
        initialisationMonitor.done();
        final TITANJob buildJob = new TITANJob(BUILD_PROCESS, files, workingDir.toFile(), project);
        buildJob.setPriority(50);
        buildJob.setUser(true);
        buildJob.setRule((ISchedulingRule)project);
        buildJob.removeCompilerMarkers();
        buildJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                try {
                    boolean buildSucceeded = buildJob.getResult().isOK();
                    TITANBuilder.this.getProject().setSessionProperty(GeneralConstants.PROJECT_UP_TO_DATE, (Object)buildSucceeded);
                    TITANDecorator.refreshSelectively((IResource)TITANBuilder.this.getProject());
                }
                catch (CoreException e) {
                    ErrorReporter.logExceptionStackTrace((String)("While setting `" + TITANBuilder.this.getProject().getName() + "' as up-to-date"), (Throwable)e);
                }
            }
        });
        if ("Are removed".equals(store.getString("org.eclipse.titan.designer.ontheflyMarkersAfterCompiler"))) {
            buildJob.removeOnTheFlyMarkers();
        }
        SubMonitor symboliclinkMonitor = progress.newChild(1);
        symboliclinkMonitor.beginTask("Refreshing symbolic links", 3);
        SymbolicLinkHandler.copyExternalFileToWorkingDirectory(files, workingDir.toOSString(), (IProgressMonitor)symboliclinkMonitor.newChild(1));
        boolean automaticMakefileGeneration = ProjectBuildPropertyData.useAutomaticMakefilegeneration(project);
        boolean useInternalMakefileGeneration = ProjectBuildPropertyData.useInternalMakefilegeneration(project);
        boolean useSymbolicLinks = ProjectBuildPropertyData.useSymbolicLinks(project);
        if (useSymbolicLinks) {
            SymbolicLinkHandler.addSymlinkRemovingCommandForRemovedFiles(workingDir.toOSString(), buildJob, deltavisitor.getLastTimeRemovedFiles(), (IProgressMonitor)symboliclinkMonitor.newChild(1));
            SymbolicLinkHandler.addSymlinkCreationCommand(files, workingDir.toOSString(), buildJob, deltavisitor.getLastTimeRemovedFiles(), (IProgressMonitor)symboliclinkMonitor.newChild(1), automaticMakefileGeneration);
        }
        symboliclinkMonitor.done();
        Map<String, IFile> filesOfReferencedProjects = ProjectBasedBuilder.getProjectBasedBuilder(project).getFilesofReferencedProjects();
        if (files.isEmpty() && visitor.getCentralStorageFiles().isEmpty() && filesOfReferencedProjects.isEmpty()) {
            buildJob.schedule();
            if (reportDebugInformation) {
                TITANDebugConsole.println("Finished building " + project.getName() + " as no files to build were found.");
            }
            return project.getReferencedProjects();
        }
        SubMonitor filepreparserMonitor = progress.newChild(1);
        filepreparserMonitor.beginTask("removing markers from files", files.size());
        if ("Are removed".equals(store.getString("org.eclipse.titan.designer.ontheflyMarkersAfterCompiler"))) {
            ArrayList<IFile> outdatedFiles = new ArrayList<IFile>();
            ArrayList<IFile> semanticallyOutdatedFiles = new ArrayList<IFile>();
            for (IFile tempFile : files.values()) {
                try {
                    if (tempFile.findMarkers("org.eclipse.titan.designer.ontheflySyntacticMarker", true, 2).length != 0 || tempFile.findMarkers("org.eclipse.titan.designer.ontheflyTaskMarker", true, 2).length != 0) {
                        outdatedFiles.add(tempFile);
                    }
                    if (tempFile.findMarkers("org.eclipse.titan.designer.ontheflySemanticMarker", true, 2).length != 0) {
                        semanticallyOutdatedFiles.add(tempFile);
                    }
                }
                catch (CoreException e) {
                    ErrorReporter.logExceptionStackTrace((String)("While deleting markers from `" + tempFile.getName() + APOSTROPHE), (Throwable)e);
                }
                filepreparserMonitor.worked(1);
            }
            if (!outdatedFiles.isEmpty()) {
                GlobalParser.getProjectSourceParser(project).reportOutdating(outdatedFiles);
            }
            if (!semanticallyOutdatedFiles.isEmpty()) {
                GlobalParser.getProjectSourceParser(project).reportSemanticOutdating(semanticallyOutdatedFiles);
            }
        }
        filepreparserMonitor.done();
        Path makefile = new Path(workingDir.toOSString() + File.separatorChar + MAKEFILE);
        boolean makefileExists = makefile.toFile().exists();
        boolean bl = makefileWillExist = automaticMakefileGeneration && (mandatoryMakefileRebuild || !makefileExists);
        if (makefileWillExist) {
            if (!useInternalMakefileGeneration) {
                IProject[] projects;
                for (IProject referencedProject : projects = project.getReferencedProjects()) {
                    if (ProjectBuildPropertyData.useSymbolicLinks(referencedProject)) continue;
                    ErrorReporter.logError((String)("Can not generate a makefile to project `" + project.getName() + "' with the external makefile generator as project `" + referencedProject.getName() + "' is set to build without generating symbolic links"));
                    return projects;
                }
            }
            this.createMakefile(buildJob);
        }
        if ((buildLevel = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "buildLevel"))) == null) {
            buildLevel = "Level 5 - Creating Executable Test Suite with dependency update";
            project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "buildLevel"), "Level 5 - Creating Executable Test Suite with dependency update");
        }
        buildLevel = MakeAttributesData.getBuildLevel(buildLevel);
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        IPreferencesService prefs = Platform.getPreferencesService();
        int processingUnitsToUse = prefs.getInt("org.eclipse.titan.designer", "org.eclipse.titan.designer.processingUnitsToUse", availableProcessors, null);
        if (makefileExists || makefileWillExist) {
            ArrayList<String> command = new ArrayList<String>();
            String makeFlags = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "makefileFlags"));
            String dynamicLinking = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "DynamicLinkingProperty"));
            String makeCommand = "default";
            if ("Level 5 - Creating Executable Test Suite with dependency update".equals(buildLevel)) {
                command.add(MAKE_DEP);
                makeCommand = MAKE_DEP;
                if (processingUnitsToUse > 1) {
                    command.add(" -j " + processingUnitsToUse);
                }
                buildJob.addCommand(command, makeCommand);
                command = new ArrayList();
                command.add(MAKE_ALL);
                makeCommand = MAKE_ALL;
            } else if ("Level 4.5 - Creating Executable Test Suite with heuristical dependency update".equals(buildLevel)) {
                if (GlobalProjectStructureTracker.dependencyChanged(project) || deltavisitor.getUnAnalyzedFileChanged()) {
                    command.add(MAKE_DEP);
                    makeCommand = MAKE_DEP;
                    if (processingUnitsToUse > 1) {
                        command.add(" -j " + processingUnitsToUse);
                    }
                    buildJob.addCommand(command, makeCommand);
                    command = new ArrayList();
                }
                command.add(MAKE_ALL);
                makeCommand = MAKE_ALL;
            } else if ("Level 4 - Creating Executable Test Suite".equals(buildLevel)) {
                command.add(MAKE);
                makeCommand = MAKE;
            } else if ("Level 3 - Creating object files with dependency update".equals(buildLevel)) {
                command.add(MAKE_DEP);
                makeCommand = MAKE_DEP;
                if (processingUnitsToUse > 1) {
                    command.add(" -j " + processingUnitsToUse);
                }
                buildJob.addCommand(command, makeCommand);
                command = new ArrayList();
                if (dynamicLinking != null && TRUE.equals(dynamicLinking)) {
                    command.add(MAKE_SHARED_OBJECTS);
                    makeCommand = MAKE_SHARED_OBJECTS;
                } else {
                    command.add(MAKE_OBJECTS);
                    makeCommand = MAKE_OBJECTS;
                }
            } else if ("Level 2.5 - Creating object files with heuristical dependency update".equals(buildLevel)) {
                if (GlobalProjectStructureTracker.dependencyChanged(project) || deltavisitor.getUnAnalyzedFileChanged()) {
                    command.add(MAKE_DEP);
                    makeCommand = MAKE_DEP;
                    if (processingUnitsToUse > 1) {
                        command.add(" -j " + processingUnitsToUse);
                    }
                    buildJob.addCommand(command, makeCommand);
                    command = new ArrayList();
                }
                if (dynamicLinking != null && TRUE.equals(dynamicLinking)) {
                    command.add(MAKE_SHARED_OBJECTS);
                    makeCommand = MAKE_SHARED_OBJECTS;
                } else {
                    command.add(MAKE_OBJECTS);
                    makeCommand = MAKE_OBJECTS;
                }
            } else if ("Level 2 - Creating object files".equals(buildLevel)) {
                if (dynamicLinking != null && TRUE.equals(dynamicLinking)) {
                    command.add(MAKE_SHARED_OBJECTS);
                    makeCommand = MAKE_SHARED_OBJECTS;
                } else {
                    command.add(MAKE_OBJECTS);
                    makeCommand = MAKE_OBJECTS;
                }
            } else if ("Level 1 - TTCN3 -> C++ compilation".equals(buildLevel)) {
                command.add(MAKE_COMPILE);
                makeCommand = MAKE_COMPILE;
            } else if ("Level 0 - Semantic Check".equals(buildLevel)) {
                command.add(MAKE_CHECK);
                makeCommand = MAKE_CHECK;
            } else {
                command.add(MAKE_DEP);
                makeCommand = MAKE_DEP;
                if (processingUnitsToUse > 1) {
                    command.add(" -j " + processingUnitsToUse);
                }
                buildJob.addCommand(command, makeCommand);
                command = new ArrayList();
                command.add(MAKE_ALL);
                makeCommand = MAKE_ALL;
            }
            if (processingUnitsToUse > 1) {
                command.add(" -j " + processingUnitsToUse);
            }
            if (processingUnitsToUse < availableProcessors) {
                TITANConsole.println(MessageFormat.format(FEWPROCESSINGUNITTOUSESET, processingUnitsToUse, availableProcessors));
            }
            if (makeFlags != null && !EMPTY_STRING.equals(makeFlags) && makeFlags.length() > 0) {
                command.add(makeFlags);
            }
            buildJob.addCommand(command, makeCommand);
        } else {
            TITANConsole.println(BUILD_WITHOUT_MAKEFILE_ERROR + project.getName());
            ErrorReporter.logError((String)(BUILD_WITHOUT_MAKEFILE_ERROR + project.getName()));
        }
        IStatus status = buildJob.runInWorkspace((IProgressMonitor)progress.newChild(3));
        try {
            project.setSessionProperty(GeneralConstants.PROJECT_UP_TO_DATE, (Object)status.isOK());
            TITANDecorator.refreshSelectively((IResource)project);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While setting project `" + project.getName() + "' up-to-date"), (Throwable)e);
        }
        if (reportDebugInformation) {
            TITANDebugConsole.println("Finished building " + project.getName());
        }
        progress.done();
        if ((buildJob.foundErrors() || progress.isCanceled()) && (kind == 6 || kind == 10)) {
            final IProject project2 = project;
            WorkspaceJob op = new WorkspaceJob("Touching the project"){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    try {
                        project2.touch(null);
                    }
                    catch (CoreException e) {
                        ErrorReporter.logExceptionStackTrace((String)("While touching project `" + project2.getName() + TITANBuilder.APOSTROPHE), (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            op.setPriority(20);
            op.setRule((ISchedulingRule)project2.getWorkspace().getRoot());
            op.setSystem(true);
            op.setUser(false);
            op.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor(TITAN_GIF));
            op.schedule();
        }
        return project.getReferencedProjects();
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        if (!TITANBuilder.isBuilderEnabled(this.getProject())) {
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        progress.setTaskName("Cleaning");
        this.getProject().touch((IProgressMonitor)progress.newChild(1));
        IPath workingDir = ProjectBasedBuilder.getProjectBasedBuilder(this.getProject()).getWorkingDirectoryPath(true);
        if (workingDir == null) {
            progress.done();
            return;
        }
        Path makefile = new Path(workingDir.toOSString() + File.separatorChar + MAKEFILE);
        boolean makefileExists = makefile.toFile().exists();
        if (makefileExists) {
            TITANBuilderResourceVisitor visitor = ProjectBasedBuilder.getProjectBasedBuilder(this.getProject()).getResourceVisitor();
            TITANJob titanJob = new TITANJob(MAKE_CLEAN, visitor.getFiles(), workingDir.toFile(), this.getProject());
            titanJob.setPriority(50);
            titanJob.setUser(true);
            titanJob.setRule((ISchedulingRule)this.getProject());
            ArrayList<String> command = new ArrayList<String>();
            command.add(MAKE_CLEAN);
            titanJob.addCommand(command, MAKE_CLEAN);
            titanJob.runInWorkspace((IProgressMonitor)progress.newChild(1));
        } else {
            TITANConsole.println(MessageFormat.format(CLEAN_WITHOUT_MAKEFILE_ERROR, this.getProject().getName()));
            ErrorReporter.logError((String)MessageFormat.format(CLEAN_WITHOUT_MAKEFILE_ERROR, this.getProject().getName()));
        }
        progress.done();
    }

    public static boolean isBuilderEnabled(IProject project) {
        IProjectDescription description;
        if (!project.isAccessible()) {
            return false;
        }
        try {
            description = project.getDescription();
        }
        catch (CoreException e) {
            return false;
        }
        ICommand[] cmds = description.getBuildSpec();
        for (int i = 0; i < cmds.length; ++i) {
            if (!BUILDER_ID.equals(cmds[i].getBuilderName())) continue;
            return true;
        }
        return false;
    }

    static {
        PropertyNotificationManager.addListener(listener);
    }
}

