/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Real_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class MultiplyExpression
extends Expression_Value {
    private static final String FIRSTOPERANDERROR = "The first operand of the `*' operation should be an integer or float value";
    private static final String SECONDOPERANDERROR = "The second operand of the `*' operation should be an integer or float value";
    private static final String SAMEOPERANDERROR = "The operands of operation `*' should be of the same type";
    private final Value value1;
    private final Value value2;

    public MultiplyExpression(Value value1, Value value2) {
        this.value1 = value1;
        this.value2 = value2;
        if (value1 != null) {
            value1.setFullNameParent(this);
        }
        if (value2 != null) {
            value2.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.MULTIPLY_OPERARTION;
    }

    @Override
    public boolean checkExpressionSelfReference(CompilationTimeStamp timestamp, Assignment lhs) {
        if (this.value1 != null && this.value1.checkExpressionSelfReferenceValue(timestamp, lhs)) {
            return true;
        }
        return this.value2 != null && this.value2.checkExpressionSelfReferenceValue(timestamp, lhs);
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append('(').append(this.value1.createStringRepresentation());
        builder.append(" * ");
        builder.append(this.value2.createStringRepresentation()).append(')');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.value1 != null) {
            this.value1.setMyScope(scope);
        }
        if (this.value2 != null) {
            this.value2.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        super.setCodeSection(codeSection);
        if (this.value1 != null) {
            this.value1.setCodeSection(codeSection);
        }
        if (this.value2 != null) {
            this.value2.setCodeSection(codeSection);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.value1 == child) {
            return builder.append(".<operand1>");
        }
        if (this.value2 == child) {
            return builder.append(".<operand2>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.value1 == null) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        this.value1.setLoweridToReference(timestamp);
        IType.Type_type tempType = this.value1.getExpressionReturntype(timestamp, expectedValue);
        switch (tempType) {
            case TYPE_INTEGER: 
            case TYPE_REAL: {
                return tempType;
            }
            case TYPE_UNDEFINED: {
                return tempType;
            }
        }
        this.getValueRefdLast(timestamp, expectedValue, null);
        this.setIsErroneous(true);
        return IType.Type_type.TYPE_UNDEFINED;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.value1 == null || this.value2 == null) {
            return true;
        }
        return this.value1.isUnfoldable(timestamp, expectedValue, referenceChain) || this.value2.isUnfoldable(timestamp, expectedValue, referenceChain);
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        IType.Type_type tempType1 = null;
        IType.Type_type tempType2 = null;
        if (this.value1 != null) {
            this.value1.setLoweridToReference(timestamp);
            tempType1 = this.value1.getExpressionReturntype(timestamp, expectedValue);
            switch (tempType1) {
                case TYPE_INTEGER: {
                    this.value1.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    break;
                }
                case TYPE_REAL: {
                    this.value1.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    break;
                }
                case TYPE_UNDEFINED: {
                    this.setIsErroneous(true);
                    break;
                }
                default: {
                    this.value1.getLocation().reportSemanticError(FIRSTOPERANDERROR);
                    this.setIsErroneous(true);
                }
            }
        }
        if (this.value2 != null) {
            this.value2.setLoweridToReference(timestamp);
            tempType2 = this.value2.getExpressionReturntype(timestamp, expectedValue);
            switch (tempType2) {
                case TYPE_INTEGER: {
                    this.value2.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    break;
                }
                case TYPE_REAL: {
                    this.value2.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    break;
                }
                case TYPE_UNDEFINED: {
                    this.setIsErroneous(true);
                    break;
                }
                default: {
                    this.value2.getLocation().reportSemanticError(SECONDOPERANDERROR);
                    this.setIsErroneous(true);
                }
            }
        }
        if (this.value1 != null && this.value2 != null && !this.getIsErroneous(timestamp)) {
            if (this.value1.getIsErroneous(timestamp) || this.value2.getIsErroneous(timestamp)) {
                this.setIsErroneous(true);
                return;
            }
            if (tempType1 != tempType2) {
                this.location.reportSemanticError(SAMEOPERANDERROR);
                this.setIsErroneous(true);
            }
        }
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        block16: {
            IValue last2;
            IValue last1;
            block15: {
                if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
                    return this.lastValue;
                }
                this.isErroneous = false;
                this.lastTimeChecked = timestamp;
                this.lastValue = this;
                if (this.value1 == null || this.value2 == null) {
                    return this.lastValue;
                }
                this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
                if (this.getIsErroneous(timestamp)) {
                    return this.lastValue;
                }
                last1 = this.value1.getValueRefdLast(timestamp, referenceChain);
                last2 = this.value2.getValueRefdLast(timestamp, referenceChain);
                if (last1.getIsErroneous(timestamp) || last2.getIsErroneous(timestamp)) {
                    this.setIsErroneous(true);
                    return this.lastValue;
                }
                if (!this.isUnfoldable(timestamp, referenceChain)) break block15;
                if (last1.isUnfoldable(timestamp) || last2.isUnfoldable(timestamp)) {
                    return this.lastValue;
                }
                switch (last1.getValuetype()) {
                    case INTEGER_VALUE: {
                        Integer_Value zero = new Integer_Value(0L);
                        if (((Integer_Value)last1).equals(zero) || ((Integer_Value)last2).equals(zero)) {
                            this.lastValue = zero;
                            this.lastValue.copyGeneralProperties(this);
                            break;
                        }
                        break block16;
                    }
                    case REAL_VALUE: {
                        if (Double.compare(((Real_Value)last1).getValue(), 0.0) == 0 || Double.compare(((Real_Value)last2).getValue(), 0.0) == 0) {
                            this.lastValue = new Real_Value(0.0);
                            this.lastValue.copyGeneralProperties(this);
                            break;
                        }
                        break block16;
                    }
                    default: {
                        this.setIsErroneous(true);
                        break;
                    }
                }
                break block16;
            }
            switch (last1.getValuetype()) {
                case INTEGER_VALUE: {
                    this.lastValue = ((Integer_Value)last1).multiply((Integer_Value)last2);
                    this.lastValue.copyGeneralProperties(this);
                    break;
                }
                case REAL_VALUE: {
                    double f1 = ((Real_Value)last1).getValue();
                    double f2 = ((Real_Value)last2).getValue();
                    this.lastValue = new Real_Value(f1 * f2);
                    this.lastValue.copyGeneralProperties(this);
                    break;
                }
                default: {
                    this.setIsErroneous(true);
                }
            }
        }
        return this.lastValue;
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this)) {
            if (this.value1 != null) {
                referenceChain.markState();
                this.value1.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
            if (this.value2 != null) {
                referenceChain.markState();
                this.value2.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.value1 != null) {
            this.value1.updateSyntax(reparser, false);
            reparser.updateLocation(this.value1.getLocation());
        }
        if (this.value2 != null) {
            this.value2.updateSyntax(reparser, false);
            reparser.updateLocation(this.value2.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.value1 != null) {
            this.value1.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.value2 != null) {
            this.value2.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.value1 != null && !this.value1.accept(v)) {
            return false;
        }
        return this.value2 == null || this.value2.accept(v);
    }

    @Override
    public void reArrangeInitCode(JavaGenData aData, StringBuilder source, Module usageModule) {
        if (this.value1 != null) {
            this.value1.reArrangeInitCode(aData, source, usageModule);
        }
        if (this.value2 != null) {
            this.value2.reArrangeInitCode(aData, source, usageModule);
        }
    }

    @Override
    public boolean canGenerateSingleExpression() {
        return this.value1.canGenerateSingleExpression() && this.value2.canGenerateSingleExpression();
    }

    @Override
    public void generateCodeExpressionExpression(JavaGenData aData, ExpressionStruct expression) {
        this.value1.generateCodeExpressionMandatory(aData, expression, true);
        expression.expression.append(".mul( ");
        if (this.value2.isUnfoldable(CompilationTimeStamp.getBaseTimestamp())) {
            this.value2.generateCodeExpressionMandatory(aData, expression, false);
        } else {
            IValue refdLast = this.value2.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), null);
            refdLast.generateCodeExpression(aData, expression, false);
        }
        expression.expression.append(" )");
    }
}

