/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types.subtypes;

import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.LimitType;

public final class CharLimit
extends LimitType {
    public static final CharLimit MAXIMUM = new CharLimit('\u007f');
    public static final CharLimit MINIMUM = new CharLimit('\u0000');
    private final char value;

    CharLimit(char v) {
        this.value = v;
    }

    @Override
    public LimitType decrement() {
        return new CharLimit((char)(this.value - '\u0001'));
    }

    @Override
    public LimitType.Type getType() {
        return LimitType.Type.CHAR;
    }

    @Override
    public LimitType increment() {
        return new CharLimit((char)(this.value + '\u0001'));
    }

    @Override
    public boolean isAdjacent(LimitType other) {
        CharLimit cl = (CharLimit)other;
        return this.value + '\u0001' == cl.value;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.value);
    }

    @Override
    public int compareTo(LimitType o) {
        CharLimit cl = (CharLimit)o;
        if (this.value < cl.value) {
            return -1;
        }
        if (this.value == cl.value) {
            return 0;
        }
        return 1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CharLimit)) {
            return false;
        }
        CharLimit other = (CharLimit)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        return this.value;
    }
}

