/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.DocumentComment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NamedBridgeScope;
import org.eclipse.titan.designer.AST.NamingConventionHelper;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.IParameterisedAssignment;
import org.eclipse.titan.designer.AST.TTCN3.definitions.VisibilityModifier;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.PatternString;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.UnivCharString_Pattern_Template;
import org.eclipse.titan.designer.AST.TTCN3.types.Array_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.editors.controls.HoverContentType;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverContent;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3CodeSkeletons;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.IdentifierReparser;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;
import org.eclipse.ui.IEditorPart;

public final class Def_Template
extends Definition
implements IParameterisedAssignment {
    private static final String FULLNAMEPART1 = ".<type>";
    private static final String FULLNAMEPART2 = ".<formal_parameter_list>";
    private static final String FULLNAMEPART3 = ".<derived_reference>";
    public static final String PORTNOTALLOWED = "Template can not be defined for port type `{0}''";
    public static final String TEMPLATEREFERENCEEXPECTEDINMODIFIES = "Reference to a template was expected in the `modifies'' definition instead of {0}";
    public static final String IMCOMPATIBLEBASETYPE = "The modified template has different type than the base template `{0}'': `{1}'' was expected instead of `{2}''";
    public static final String FEWERFORMALPARAMETERS = "The modified template has fewer formal parameters than base template `{0}'': at least {1} parameter was expected instead of {2}";
    public static final String DIFFERENTPARAMETERKINDS = "The kind of parameter is not the same as in base template `{0}'': {1} was expected instead of {2}";
    public static final String INCOMPATIBLEBASEPARAMETERTYPE = "The type of parameter is not the same as in base template `{0}'': `{1}'' was expected instead of `{2}''";
    public static final String DIFFERENTPARAMETERNAMES = "The name of parameter is not the same as in base template `{0}'': `{1}'' was expected instead of `{2}''";
    public static final String CIRCULARBASETEMPLATES = "Circular chain of base templates: `{0}''";
    public static final String CIRCULAREMBEDDEDRECURSION = "Embedded circular recursion chain: `{0}''";
    private static final String WITHTEMPRESTNOTALLOWED = "Formal parameter with template restriction `{0}'' not allowed here";
    private static final String WITHOUTTEMPRESTNOTALLOWED = "Formal parameter without template restriction not allowed here";
    private static final String NOBASETEMPLATEPARFORDASH = "Not used symbol (`-') doesn't have the corresponding default parameter in the base template";
    private static final String NOBASETEMPLATEFORDASH = "Only modified templates are allowed to use the not used symbol (`-') as the default parameter";
    private static final String PARAMETRIZED_LOCAL_TEMPLATE = "Code generation for parameterized local template `{0}'' is not yet supported";
    private static final String TRAITMEMBERS = "Trait class type `{0}'' cannot have template members";
    private static final String KIND = " template";
    private final Type type;
    private final TemplateRestriction.Restriction_type templateRestriction;
    private boolean generateRestrictionCheck = false;
    private final FormalParameterList formalParList;
    private final Reference derivedReference;
    private final TTCN3Template body;
    private ITTCN3Template realBody;
    private Def_Template baseTemplate;
    private CompilationTimeStamp recursiveDerivationChecked;
    private NamedBridgeScope bridgeScope = null;
    private final FormalParameter.parameterEvaluationType evaluationType;

    public Def_Template(TemplateRestriction.Restriction_type templateRestriction, Identifier identifier, Type type, FormalParameterList formalParList, Reference derivedReference, TTCN3Template body, FormalParameter.parameterEvaluationType evaluationType) {
        super(identifier);
        this.templateRestriction = templateRestriction;
        this.type = type;
        this.formalParList = formalParList;
        this.derivedReference = derivedReference;
        this.body = body;
        this.evaluationType = evaluationType;
        if (type != null) {
            type.setOwnertype(IType.TypeOwner_type.OT_TEMPLATE_DEF, this);
            type.setFullNameParent(this);
        }
        if (formalParList != null) {
            formalParList.setMyDefinition(this);
        }
        if (derivedReference != null) {
            derivedReference.setFullNameParent(this);
        }
        if (body != null) {
            body.setFullNameParent(this);
            body.setMyDefinition(this);
        }
    }

    @Override
    public Assignment.Assignment_type getAssignmentType() {
        return Assignment.Assignment_type.A_TEMPLATE;
    }

    public static String getKind() {
        return KIND;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.type == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.formalParList == child) {
            return builder.append(FULLNAMEPART2);
        }
        if (this.derivedReference == child) {
            return builder.append(FULLNAMEPART3);
        }
        return builder;
    }

    @Override
    public FormalParameterList getFormalParameterList() {
        return this.formalParList;
    }

    @Override
    public String getAssignmentName() {
        return "template";
    }

    @Override
    public String getDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getAssignmentName()).append(" `");
        if (this.isLocal()) {
            builder.append(this.identifier.getDisplayName());
        } else {
            builder.append(this.getFullName());
        }
        builder.append('\'');
        return builder.toString();
    }

    @Override
    public String getOutlineIcon() {
        return "template.gif";
    }

    @Override
    public int category() {
        int result = super.category();
        if (this.type != null) {
            result += this.type.category();
        }
        return result;
    }

    @Override
    public String getOutlineText() {
        StringBuilder text = new StringBuilder(this.identifier.getDisplayName());
        if (this.formalParList == null || this.lastTimeChecked == null) {
            return text.toString();
        }
        text.append('(');
        for (int i = 0; i < this.formalParList.getNofParameters(); ++i) {
            FormalParameter parameter;
            if (i != 0) {
                text.append(", ");
            }
            if (Assignment.Assignment_type.A_PAR_TIMER.semanticallyEquals((parameter = this.formalParList.getParameterByIndex(i)).getRealAssignmentType())) {
                text.append("timer");
                continue;
            }
            Type parameterType = parameter.getType(this.lastTimeChecked);
            if (parameterType == null) {
                text.append("Unknown type");
                continue;
            }
            text.append(parameterType.getTypename());
        }
        text.append(')');
        return text.toString();
    }

    @Override
    public ITTCN3Template getSetting(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked == null) {
            this.check(timestamp);
        }
        return this.realBody;
    }

    @Override
    public IType getType(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.type;
    }

    public ITTCN3Template getTemplate(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked == null) {
            this.check(timestamp);
        }
        return this.realBody;
    }

    public FormalParameterList getFormalParameterList(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked == null) {
            this.check(timestamp);
        }
        return this.formalParList;
    }

    @Override
    public void setMyScope(Scope scope) {
        if (this.bridgeScope != null && this.bridgeScope.getParentScope() == scope) {
            return;
        }
        this.bridgeScope = new NamedBridgeScope();
        this.bridgeScope.setParentScope(scope);
        scope.addSubScope(this.getLocation(), this.bridgeScope);
        this.bridgeScope.setScopeMacroName(this.identifier.getDisplayName());
        super.setMyScope(this.bridgeScope);
        if (this.type != null) {
            this.type.setMyScope(this.bridgeScope);
        }
        if (this.formalParList != null) {
            this.formalParList.setMyScope(this.bridgeScope);
            this.bridgeScope.addSubScope(this.formalParList.getLocation(), this.formalParList);
            if (this.body != null) {
                this.body.setMyScope(this.formalParList);
            }
        } else if (this.body != null) {
            this.body.setMyScope(this.bridgeScope);
        }
        if (this.derivedReference != null) {
            this.derivedReference.setMyScope(this.bridgeScope);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.check(timestamp, null);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.isUsed = false;
        if (this.isLocal()) {
            NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionlocalTemplate", this.identifier, this);
        } else {
            NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionGlobalTemplate", this.identifier, this);
        }
        NamingConventionHelper.checkNameContents(this.identifier, this.getMyScope().getModuleScope().getIdentifier(), this.getDescription());
        if (this.type == null) {
            return;
        }
        this.type.setGenName("_T_", this.getGenName());
        this.type.check(timestamp, refChain);
        if (this.withAttributesPath != null) {
            this.withAttributesPath.checkGlobalAttributes(timestamp, true);
            this.withAttributesPath.checkAttributes(timestamp, this.type.getTypeRefdLast(timestamp, refChain).getTypetype());
        }
        if (this.body == null) {
            return;
        }
        IType lastType = this.type.getTypeRefdLast(timestamp);
        switch (lastType.getTypetype()) {
            case TYPE_PORT: {
                this.location.reportSemanticError(MessageFormat.format(PORTNOTALLOWED, lastType.getFullName()));
                break;
            }
        }
        this.body.setMyGovernor(this.type);
        this.realBody = this.body;
        if (this.body.getTemplatetype() == ITTCN3Template.Template_type.CSTR_PATTERN && lastType.getTypetype() == IType.Type_type.TYPE_UCHARSTRING) {
            this.realBody = this.body.setTemplatetype(timestamp, ITTCN3Template.Template_type.USTR_PATTERN);
            if (this.realBody instanceof UnivCharString_Pattern_Template) {
                ((UnivCharString_Pattern_Template)this.realBody).getPatternstring().setPatterntype(PatternString.PatternType.UNIVCHARSTRING_PATTERN);
            }
        }
        if (this.formalParList != null) {
            this.formalParList.reset();
            this.checkDefault(timestamp);
            this.formalParList.check(timestamp, this.getAssignmentType());
            if (this.isLocal()) {
                this.location.reportSemanticError(MessageFormat.format(PARAMETRIZED_LOCAL_TEMPLATE, this.getIdentifier()));
            }
        }
        ITTCN3Template tempBody = this.type.checkThisTemplateRef(timestamp, this.realBody);
        this.checkModified(timestamp);
        this.checkRecursiveDerivation(timestamp);
        if (this.myScope.isClassScope() && this.myScope.getScopeClass().isTrait()) {
            this.location.reportSemanticError(MessageFormat.format(TRAITMEMBERS, this.myScope.getScopeClass().getTypename()));
        }
        tempBody.checkThisTemplateGeneric(timestamp, this.type, this.derivedReference != null, true, true, true, this.hasImplicitOmitAttribute(timestamp), null);
        if (tempBody.get_needs_conversion()) {
            this.body.set_needs_conversion();
        }
        this.checkErroneousAttributes(timestamp);
        ReferenceChain tempReferenceChain = ReferenceChain.getInstance(CIRCULAREMBEDDEDRECURSION, true);
        tempReferenceChain.add(this);
        tempBody.checkRecursions(timestamp, tempReferenceChain);
        tempReferenceChain.release();
        if (this.templateRestriction != TemplateRestriction.Restriction_type.TR_NONE) {
            this.generateRestrictionCheck = TemplateRestriction.check(timestamp, this, tempBody, null);
            if (this.formalParList != null && this.templateRestriction != TemplateRestriction.Restriction_type.TR_PRESENT) {
                int nofFps = this.formalParList.getNofParameters();
                block11: for (int i = 0; i < nofFps; ++i) {
                    FormalParameter fp = this.formalParList.getParameterByIndex(i);
                    if (fp.getAssignmentType() != Assignment.Assignment_type.A_PAR_TEMP_IN) continue;
                    TemplateRestriction.Restriction_type fpTemplateRestriction = fp.getTemplateRestriction();
                    switch (this.templateRestriction) {
                        case TR_VALUE: 
                        case TR_OMIT: {
                            switch (fpTemplateRestriction) {
                                case TR_VALUE: 
                                case TR_OMIT: {
                                    continue block11;
                                }
                                case TR_PRESENT: {
                                    fp.getLocation().reportSemanticError(MessageFormat.format(WITHTEMPRESTNOTALLOWED, fpTemplateRestriction.getDisplayName()));
                                    continue block11;
                                }
                                case TR_NONE: {
                                    fp.getLocation().reportSemanticError(WITHOUTTEMPRESTNOTALLOWED);
                                    continue block11;
                                }
                            }
                            continue block11;
                        }
                    }
                }
            }
        }
        if (this.formalParList != null) {
            this.formalParList.setGenName(this.getGenName());
        }
        this.body.setGenNameRecursive(this.getGenName());
        this.body.setCodeSection(GovernedSimple.CodeSectionType.CS_POST_INIT);
    }

    private void checkDefault(CompilationTimeStamp timestamp) {
        int i;
        if (this.derivedReference == null) {
            if (this.formalParList != null && this.formalParList.hasNotusedDefaultValue()) {
                this.formalParList.getLocation().reportSemanticError(NOBASETEMPLATEFORDASH);
            }
            return;
        }
        Assignment assignment = this.derivedReference.getRefdAssignment(timestamp, false, null);
        if (assignment == null) {
            return;
        }
        if (Assignment.Assignment_type.A_TEMPLATE != assignment.getAssignmentType()) {
            this.derivedReference.getLocation().reportSemanticError(MessageFormat.format(TEMPLATEREFERENCEEXPECTEDINMODIFIES, assignment.getDescription()));
            return;
        }
        Def_Template base = (Def_Template)assignment;
        base.check(timestamp);
        FormalParameterList baseParameters = base.getFormalParameterList(timestamp);
        int nofBaseFps = baseParameters == null ? 0 : baseParameters.getNofParameters();
        int nofLocalFps = this.formalParList == null ? 0 : this.formalParList.getNofParameters();
        int minFps = nofLocalFps < nofBaseFps ? nofLocalFps : nofBaseFps;
        for (i = 0; i < minFps; ++i) {
            FormalParameter baseFp = baseParameters.getParameterByIndex(i);
            FormalParameter localFp = this.formalParList.getParameterByIndex(i);
            if (!localFp.hasNotusedDefaultValue()) continue;
            if (baseFp.hasDefaultValue()) {
                localFp.setDefaultValue(baseFp.getDefaultParameter());
                continue;
            }
            localFp.getLocation().reportSemanticError(NOBASETEMPLATEPARFORDASH);
        }
        for (i = nofBaseFps; i < nofLocalFps; ++i) {
            FormalParameter localFp = this.formalParList.getParameterByIndex(i);
            if (!localFp.hasNotusedDefaultValue()) continue;
            localFp.getLocation().reportSemanticError(NOBASETEMPLATEPARFORDASH);
        }
    }

    private void checkModified(CompilationTimeStamp timestamp) {
        int minFps;
        int nofLocalFps;
        if (this.derivedReference == null) {
            return;
        }
        Assignment assignment = this.derivedReference.getRefdAssignment(timestamp, false, null);
        if (assignment == null) {
            return;
        }
        if (Assignment.Assignment_type.A_TEMPLATE != assignment.getAssignmentType()) {
            this.derivedReference.getLocation().reportSemanticError(MessageFormat.format(TEMPLATEREFERENCEEXPECTEDINMODIFIES, assignment.getDescription()));
            return;
        }
        this.baseTemplate = (Def_Template)assignment;
        this.baseTemplate.check(timestamp);
        IType baseType = this.baseTemplate.getType(timestamp);
        TypeCompatibilityInfo infoBase = new TypeCompatibilityInfo(this.type, baseType, true);
        if (!this.type.isCompatible(timestamp, baseType, infoBase, null, null)) {
            if (infoBase.getSubtypeError() == null) {
                if (infoBase.getErrorStr() == null) {
                    this.type.getLocation().reportSemanticError(MessageFormat.format(IMCOMPATIBLEBASETYPE, this.baseTemplate.getFullName(), baseType.getFullName(), this.type.getFullName()));
                } else {
                    this.getLocation().reportSemanticError(infoBase.getErrorStr());
                }
            } else {
                this.getLocation().reportSemanticError(infoBase.getSubtypeError());
            }
        } else if (infoBase.getNeedsConversion()) {
            this.body.set_needs_conversion();
        }
        FormalParameterList baseParameters = this.baseTemplate.getFormalParameterList(timestamp);
        int nofBaseFps = baseParameters == null ? 0 : baseParameters.getNofParameters();
        int n = nofLocalFps = this.formalParList == null ? 0 : this.formalParList.getNofParameters();
        if (nofLocalFps < nofBaseFps) {
            this.location.reportSemanticError(MessageFormat.format(FEWERFORMALPARAMETERS, this.baseTemplate.getFullName(), nofBaseFps, nofLocalFps));
            minFps = nofLocalFps;
        } else {
            minFps = nofBaseFps;
        }
        for (int i = 0; i < minFps; ++i) {
            TypeCompatibilityInfo infoPar;
            Type localFpType;
            Type baseFpType;
            FormalParameter baseFormalpar = baseParameters.getParameterByIndex(i);
            FormalParameter localFormalpar = this.formalParList.getParameterByIndex(i);
            if (!baseFormalpar.getAssignmentType().semanticallyEquals(localFormalpar.getAssignmentType())) {
                localFormalpar.getLocation().reportSemanticError(MessageFormat.format(DIFFERENTPARAMETERKINDS, this.baseTemplate.getFullName(), baseFormalpar.getAssignmentName(), localFormalpar.getAssignmentName()));
            }
            if (!(baseFpType = baseFormalpar.getType(timestamp)).isCompatible(timestamp, localFpType = localFormalpar.getType(timestamp), infoPar = new TypeCompatibilityInfo(this.type, baseType, true), null, null)) {
                if (infoPar.getSubtypeError() == null) {
                    if (infoPar.getErrorStr() == null) {
                        localFpType.getLocation().reportSemanticError(MessageFormat.format(INCOMPATIBLEBASEPARAMETERTYPE, this.baseTemplate.getFullName(), baseFpType.getTypename(), localFpType.getTypename()));
                    } else {
                        this.getLocation().reportSemanticError(infoPar.getErrorStr());
                    }
                } else {
                    this.getLocation().reportSemanticError(infoPar.getSubtypeError());
                }
            } else if (infoPar.getNeedsConversion()) {
                this.body.set_needs_conversion();
            }
            Identifier baseFormalparId = baseFormalpar.getIdentifier();
            Identifier localFormalparId = localFormalpar.getIdentifier();
            if (baseFormalparId.equals(localFormalparId)) continue;
            localFormalpar.getLocation().reportSemanticError(MessageFormat.format(DIFFERENTPARAMETERNAMES, this.baseTemplate.getFullName(), baseFormalparId.getDisplayName(), localFormalparId.getDisplayName()));
        }
        this.body.setBaseTemplate(this.baseTemplate.getTemplate(timestamp));
    }

    private void checkRecursiveDerivation(CompilationTimeStamp timestamp) {
        if (this.recursiveDerivationChecked != null && !this.recursiveDerivationChecked.isLess(timestamp)) {
            return;
        }
        if (this.baseTemplate != null) {
            ReferenceChain tempReferenceChain = ReferenceChain.getInstance(CIRCULARBASETEMPLATES, true);
            tempReferenceChain.add(this);
            Def_Template iterator = this.baseTemplate;
            while (iterator != null && (iterator.recursiveDerivationChecked == null || iterator.recursiveDerivationChecked.isLess(timestamp)) && tempReferenceChain.add(iterator)) {
                iterator.recursiveDerivationChecked = timestamp;
                iterator = iterator.baseTemplate;
            }
            tempReferenceChain.release();
        }
        this.recursiveDerivationChecked = timestamp;
    }

    @Override
    public void postCheck() {
        super.postCheck();
    }

    @Override
    public String getProposalKind() {
        StringBuilder builder = new StringBuilder();
        if (this.type != null) {
            this.type.getProposalDescription(builder);
        }
        builder.append(KIND);
        return builder.toString();
    }

    @Override
    public String getProposalDescription() {
        StringBuilder nameBuilder = new StringBuilder(this.identifier.getDisplayName());
        if (this.formalParList != null) {
            nameBuilder.append('(');
            this.formalParList.getAsProposalDesriptionPart(nameBuilder);
            nameBuilder.append(')');
        }
        return nameBuilder.toString();
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int index) {
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (subrefs.size() <= index) {
            return;
        }
        if (subrefs.size() == index + 1 && this.identifier.getName().toLowerCase(Locale.ENGLISH).startsWith(subrefs.get(index).getId().getName().toLowerCase(Locale.ENGLISH))) {
            if (this.formalParList != null) {
                StringBuilder patternBuilder = new StringBuilder(this.identifier.getDisplayName());
                patternBuilder.append('(');
                this.formalParList.getAsProposalPart(patternBuilder);
                patternBuilder.append(')');
                propCollector.addTemplateProposal(this.identifier.getDisplayName(), new Template(this.getProposalDescription(), "", propCollector.getContextIdentifier(), patternBuilder.toString(), false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            }
            super.addProposal(propCollector, index);
        } else if (subrefs.size() > index + 1 && this.type != null && this.identifier.getName().equals(subrefs.get(index).getId().getName())) {
            this.type.addProposal(propCollector, index + 1);
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int index) {
        List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
        if (subrefs.size() > index && this.identifier.getName().equals(subrefs.get(index).getId().getName())) {
            if (subrefs.size() > index + 1 && this.type != null) {
                this.type.addDeclaration(declarationCollector, index + 1);
            } else if (subrefs.size() == index + 1) {
                declarationCollector.addDeclaration(this);
            }
        }
    }

    @Override
    public TemplateRestriction.Restriction_type getTemplateRestriction() {
        return this.templateRestriction;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            this.lastTimeChecked = null;
            boolean enveloped = false;
            Location temporalIdentifier = this.identifier.getLocation();
            if (reparser.envelopsDamage(temporalIdentifier) || reparser.isExtending(temporalIdentifier)) {
                reparser.extendDamagedRegion(temporalIdentifier);
                IdentifierReparser r = new IdentifierReparser(reparser);
                int result = r.parseAndSetNameChanged();
                this.identifier = r.getIdentifier();
                if (result == 0 && this.identifier != null) {
                    enveloped = true;
                } else {
                    this.removeBridge();
                    throw new ReParseException(result);
                }
            }
            if (this.type != null) {
                if (enveloped) {
                    this.type.updateSyntax(reparser, false);
                    reparser.updateLocation(this.type.getLocation());
                } else if (reparser.envelopsDamage(this.type.getLocation())) {
                    try {
                        this.type.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.type.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (this.formalParList != null) {
                if (enveloped) {
                    this.formalParList.updateSyntax(reparser, false);
                    reparser.updateLocation(this.formalParList.getLocation());
                } else if (reparser.envelopsDamage(this.formalParList.getLocation())) {
                    try {
                        this.formalParList.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.formalParList.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (this.derivedReference != null) {
                if (enveloped) {
                    this.derivedReference.updateSyntax(reparser, false);
                    reparser.updateLocation(this.derivedReference.getLocation());
                } else if (reparser.envelopsDamage(this.derivedReference.getLocation())) {
                    try {
                        this.derivedReference.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.derivedReference.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (this.body != null) {
                if (enveloped) {
                    this.body.updateSyntax(reparser, false);
                    reparser.updateLocation(this.body.getLocation());
                } else if (reparser.envelopsDamage(this.body.getLocation())) {
                    try {
                        this.body.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.body.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (this.withAttributesPath != null) {
                if (enveloped) {
                    this.withAttributesPath.updateSyntax(reparser, false);
                    reparser.updateLocation(this.withAttributesPath.getLocation());
                } else if (reparser.envelopsDamage(this.withAttributesPath.getLocation())) {
                    try {
                        this.withAttributesPath.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.withAttributesPath.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (!enveloped) {
                this.removeBridge();
                throw new ReParseException();
            }
            return;
        }
        reparser.updateLocation(this.identifier.getLocation());
        if (this.type != null) {
            this.type.updateSyntax(reparser, false);
            reparser.updateLocation(this.type.getLocation());
        }
        if (this.formalParList != null) {
            this.formalParList.updateSyntax(reparser, false);
            reparser.updateLocation(this.formalParList.getLocation());
        }
        if (this.derivedReference != null) {
            this.derivedReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.derivedReference.getLocation());
        }
        if (this.body != null) {
            this.body.updateSyntax(reparser, false);
            reparser.updateLocation(this.body.getLocation());
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    private void removeBridge() {
        if (this.bridgeScope != null) {
            this.bridgeScope.remove();
            this.bridgeScope = null;
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.type != null) {
            this.type.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.formalParList != null) {
            this.formalParList.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.derivedReference != null) {
            this.derivedReference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.body != null) {
            this.body.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.type != null && !this.type.accept(v)) {
            return false;
        }
        if (this.formalParList != null && !this.formalParList.accept(v)) {
            return false;
        }
        if (this.derivedReference != null && !this.derivedReference.accept(v)) {
            return false;
        }
        return this.body == null || this.body.accept(v);
    }

    public FormalParameter.parameterEvaluationType get_eval_type() {
        return this.evaluationType;
    }

    @Override
    public void generateCode(JavaGenData aData, boolean cleanUp) {
        String genName = this.getGenName();
        StringBuilder source = new StringBuilder();
        if (!this.isLocal()) {
            if (VisibilityModifier.Private.equals((Object)this.getVisibilityModifier())) {
                source.append("\tprivate");
            } else {
                source.append("\tpublic");
            }
            source.append(" static ");
        }
        String typeName = this.type.getGenNameTemplate(aData, source);
        if (this.formalParList == null) {
            if (this.type.getTypetype().equals((Object)IType.Type_type.TYPE_ARRAY)) {
                Array_Type arrayType = (Array_Type)this.type;
                StringBuilder sbforTemp = aData.getCodeForType(arrayType.getGenNameOwn());
                arrayType.generateCodeValue(aData, sbforTemp);
                arrayType.generateCodeTemplate(aData, sbforTemp);
            }
            source.append(MessageFormat.format("{0} {1} = new {0}();\n", typeName, genName));
            if (this.baseTemplate != null && this.baseTemplate.myScope.getModuleScopeGen() == this.myScope.getModuleScopeGen()) {
                this.getLocation().update_location_object(aData, aData.getPostInit());
                this.baseTemplate.body.generateCodeInit(aData, aData.getPostInit(), this.body.get_lhs_name());
                if (this.body.get_needs_conversion()) {
                    ExpressionStruct tempExpr = new ExpressionStruct();
                    String tempId2 = this.type.generateConversion(aData, this.baseTemplate.getType(CompilationTimeStamp.getBaseTimestamp()), this.baseTemplate.getGenNameFromScope(aData, aData.getPostInit(), ""), false, tempExpr);
                    tempExpr.openMergeExpression(aData.getPostInit());
                    aData.getPostInit().append(MessageFormat.format("{0}.operator_assign({1});\n", genName, tempId2));
                } else {
                    aData.getPostInit().append(MessageFormat.format("{0}.operator_assign({1});\n", genName, this.baseTemplate.getGenNameFromScope(aData, aData.getPostInit(), "")));
                }
            }
            if (this.body != null) {
                this.getLocation().update_location_object(aData, aData.getPostInit());
                this.body.generateCodeInit(aData, aData.getPostInit(), this.body.get_lhs_name());
                if (this.templateRestriction != TemplateRestriction.Restriction_type.TR_NONE && this.generateRestrictionCheck) {
                    TemplateRestriction.generateRestrictionCheckCode(aData, aData.getPostInit(), this.location, genName, this.templateRestriction);
                }
            }
            aData.addGlobalVariable(genName, source.toString());
        } else {
            StringBuilder sb = aData.getSrc();
            StringBuilder formalParameters = this.formalParList.generateCode(aData);
            source.append(MessageFormat.format("{0} {1}({2}) '{'\n", typeName, genName, formalParameters));
            this.getLocation().create_location_object(aData, source, "TEMPLATE", this.getIdentifier().getDisplayName());
            if (aData.getAddSourceInfo()) {
                source.append("\t\ttry {\n");
            }
            if (this.baseTemplate == null) {
                if (this.type.getTypetype().equals((Object)IType.Type_type.TYPE_ARRAY)) {
                    Array_Type arrayType = (Array_Type)this.type;
                    StringBuilder sbforTemp = aData.getCodeForType(arrayType.getGenNameOwn());
                    arrayType.generateCodeValue(aData, sbforTemp);
                    arrayType.generateCodeTemplate(aData, sbforTemp);
                }
                source.append(MessageFormat.format("\t\tfinal {0} ret_val = new {0}();\n", typeName));
            } else {
                source.append(MessageFormat.format("\t\tfinal {0} ret_val = new {0}({1}", typeName, this.baseTemplate.getGenNameFromScope(aData, source, "")));
                if (this.baseTemplate.formalParList != null) {
                    source.append('(');
                    for (int i = 0; i < this.baseTemplate.formalParList.getNofParameters(); ++i) {
                        if (i > 0) {
                            source.append(", ");
                        }
                        source.append(this.formalParList.getParameterByIndex(i).getIdentifier().getName());
                    }
                    source.append(')');
                }
                source.append(");\n");
            }
            if (this.body != null) {
                this.body.generateCodeInit(aData, source, "ret_val");
                if (this.templateRestriction != TemplateRestriction.Restriction_type.TR_NONE && this.generateRestrictionCheck) {
                    TemplateRestriction.generateRestrictionCheckCode(aData, source, this.location, "ret_val", this.templateRestriction);
                }
            }
            source.append("\t\treturn ret_val;\n");
            if (aData.getAddSourceInfo()) {
                source.append("\t\t} finally {\n");
                this.getLocation().release_location_object(aData, source);
                source.append("\t\t}\n");
            }
            source.append("\t}\n\n");
            sb.append((CharSequence)source);
        }
    }

    @Override
    public void generateCodeString(JavaGenData aData, StringBuilder source) {
        String genName = this.getGenName();
        if (this.formalParList == null) {
            String typeName = this.type.getGenNameTemplate(aData, source);
            if (this.baseTemplate == null) {
                if (this.type.getTypetype().equals((Object)IType.Type_type.TYPE_ARRAY)) {
                    Array_Type arrayType = (Array_Type)this.type;
                    StringBuilder sb = aData.getCodeForType(arrayType.getGenNameOwn());
                    arrayType.generateCodeValue(aData, sb);
                    arrayType.generateCodeTemplate(aData, sb);
                }
                if (this.body != null && this.body.hasSingleExpression()) {
                    source.append(MessageFormat.format("{0} {1} = new {0}({2});\n", typeName, genName, this.body.getSingleExpression(aData, false)));
                } else {
                    source.append(MessageFormat.format("{0} {1} = new {0}();\n", typeName, genName));
                    if (this.body != null) {
                        this.body.generateCodeInit(aData, source, genName);
                    }
                }
            } else {
                if (this.body != null && this.body.get_needs_conversion()) {
                    ExpressionStruct tempExpr = new ExpressionStruct();
                    String tempId2 = this.type.generateConversion(aData, this.baseTemplate.getType(CompilationTimeStamp.getBaseTimestamp()), this.baseTemplate.getGenNameFromScope(aData, source, ""), false, tempExpr);
                    tempExpr.openMergeExpression(source);
                    source.append(MessageFormat.format("{0} {1} = new {0}({2});\n", typeName, genName, tempId2));
                } else {
                    source.append(MessageFormat.format("{0} {1} = new {0}({2});\n", typeName, genName, this.baseTemplate.getGenNameFromScope(aData, source, "")));
                }
                if (this.body != null) {
                    this.body.generateCodeInit(aData, source, genName);
                }
            }
        } else {
            source.append(MessageFormat.format("Code generation for parameterized local template `{0}' is not supported", this.identifier.getDisplayName()));
        }
        if (this.templateRestriction != TemplateRestriction.Restriction_type.TR_NONE && this.generateRestrictionCheck) {
            TemplateRestriction.generateRestrictionCheckCode(aData, source, this.location, genName, this.templateRestriction);
        }
    }

    @Override
    public Ttcn3HoverContent getHoverContent(IEditorPart editor) {
        super.getHoverContent(editor);
        DocumentComment dc = null;
        if (this.hasDocumentComment() && (dc = this.parseDocumentComment()).isDeprecated()) {
            this.hoverContent.addDeprecated();
        }
        IType assType = this.getType(this.getLastTimeChecked());
        this.hoverContent.addIcon(this.getOutlineIcon());
        this.hoverContent.addText("template ");
        this.hoverContent.addStyledText(assType != null ? assType.getTypename() : "<?>").addStyledText(" ").addStyledText(this.getFullNameForDocComment(), 1);
        this.hoverContent.closeHeader();
        if (dc != null) {
            dc.addDescsContent(this.hoverContent);
            dc.addParamsContent(this.hoverContent, this.formalParList);
            dc.addMembersContent(this.hoverContent);
            dc.addStatusContent(this.hoverContent);
            dc.addRemarksContent(this.hoverContent);
            dc.addSinceContent(this.hoverContent);
            dc.addVersionContent(this.hoverContent);
            dc.addAuthorsContent(this.hoverContent);
            dc.addReferenceContent(this.hoverContent);
            dc.addSeesContent(this.hoverContent);
            dc.addUrlsContent(this.hoverContent);
        } else if (this.formalParList != null && this.formalParList.getNofParameters() > 0) {
            this.hoverContent.addTag("Parameters");
            for (int i = 0; i < this.formalParList.getNofParameters(); ++i) {
                FormalParameter param = this.formalParList.getParameterByIndex(i);
                String paramType = param.getFormalParamType();
                StringBuilder sb = new StringBuilder(param.getIdentifier().getDisplayName());
                sb.append(" (").append(paramType != null ? paramType : "<?>").append(")");
                this.hoverContent.addIndentedText(sb.toString(), "");
            }
        }
        this.hoverContent.addContent(HoverContentType.INFO);
        return this.hoverContent;
    }

    @Override
    public String generateDocComment(String indentation) {
        String ind = indentation + " * ";
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n").append(ind).append("@desc").append("\n");
        if (this.formalParList != null && this.formalParList.getNofParameters() > 0) {
            for (int i = 0; i < this.formalParList.getNofParameters(); ++i) {
                FormalParameter param = this.formalParList.getParameterByIndex(i);
                sb.append(ind).append("@param").append(" ").append(param.getIdentifier().getDisplayName()).append("\n");
            }
        }
        sb.append(indentation).append(" */\n").append(indentation);
        return sb.toString();
    }
}

