/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASN1.ASN1Assignment;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Choice_Type;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Sequence_Type;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Set_Type;
import org.eclipse.titan.designer.AST.ASN1.types.Open_Type;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ArraySubReference;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.DocumentComment;
import org.eclipse.titan.designer.AST.Error_Setting;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IReferenceableElement;
import org.eclipse.titan.designer.AST.IReferencingElement;
import org.eclipse.titan.designer.AST.ISetting;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.NamedBridgeScope;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ActualParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Altstep;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Const;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Extfunction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ICommentable;
import org.eclipse.titan.designer.AST.TTCN3.definitions.IParameterisedAssignment;
import org.eclipse.titan.designer.AST.TTCN3.definitions.LazyFuzzyParamData;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.types.AbstractOfType;
import org.eclipse.titan.designer.AST.TTCN3.types.Anytype_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Array_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.ClassTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.types.Class_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.TTCN3.types.ComponentTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.SequenceOf_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Seq_Choice_BaseType;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.declarationsearch.Declaration;
import org.eclipse.titan.designer.editors.AstSyntaxHighlightTokens;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public class Reference
extends ASTNode
implements ILocateableNode,
IIncrementallyUpdateable,
IReferencingElement {
    private static final String STRINGELEMENTUNUSABLE = "Reference to a string element of type `{0}'' cannot be used in this context";
    private static final String VARIABLEXPECTED = "Reference to a variable or value parameter was expected instead of {0}";
    private static final String ALTSTEPEXPECTED = "Reference to an altstep was expected in the argument instead of {0}";
    private static final String THISORSUPEROUTSIDECLASS = "`{0}'' reference is only valid inside class bodies";
    private static final String FULLNAMEPART = ".<sub_reference";
    public static final String COMPONENTEXPECTED = "component type expected";
    public static final String CLASSEXPECTED = "class type expected";
    public static final String TYPEEXPECTED = "Type reference expected";
    public static final String ASN1SETTINGEXPECTED = "Reference to ASN.1 setting expected";
    private static final String INVALIDVALUEREFERENCE = "Reference to `value` is only allowed inside a dynamic template or property setter";
    private static final String VALUENOTSETTER = "Reference to `value` is not allowed in a property getter";
    protected Identifier modid;
    protected ArrayList<ISubReference> subReferences;
    private boolean refersToStringElement = false;
    protected boolean detectedModuleId = false;
    private boolean isErroneous;
    protected Assignment referredAssignment;
    protected CompilationTimeStamp lastTimeChecked;
    private boolean usedOnLeftSide = false;
    private boolean usedInIsbound = false;
    private Ref_Type reftype = Ref_Type.REF_BASIC;

    public Reference(Identifier modid) {
        this.modid = modid;
        this.detectedModuleId = modid != null;
        this.subReferences = new ArrayList();
    }

    public Reference(Identifier modid, Ref_Type reftype) {
        this(null);
        this.reftype = reftype;
    }

    public Reference(Identifier modid, List<ISubReference> subReferences) {
        this.modid = modid;
        this.detectedModuleId = modid != null;
        this.subReferences = new ArrayList<ISubReference>(subReferences);
        this.subReferences.trimToSize();
        for (int i = 0; i < subReferences.size(); ++i) {
            subReferences.get(i).setFullNameParent(this);
        }
    }

    public Reference(Identifier modid, Ref_Type reftype, List<ISubReference> subReferences) {
        this(modid, subReferences);
        this.reftype = reftype;
    }

    public Reference(Identifier modid, Identifier referencedId) {
        FieldSubReference fieldsubref = new FieldSubReference(referencedId);
        ArrayList<FieldSubReference> subrefs = new ArrayList<FieldSubReference>(1);
        subrefs.add(fieldsubref);
        this.modid = modid;
        this.detectedModuleId = modid != null;
        this.subReferences = new ArrayList(subrefs);
        this.subReferences.trimToSize();
        for (int i = 0; i < this.subReferences.size(); ++i) {
            this.subReferences.get(i).setFullNameParent(this);
        }
    }

    public Reference newInstance() {
        return new Reference(this.modid, this.reftype, this.subReferences);
    }

    public Assignment getAssOld() {
        return this.referredAssignment;
    }

    public void setBaseScope(Scope scope) {
        super.setMyScope(scope);
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        this.subReferences.trimToSize();
        for (int i = 0; i < this.subReferences.size(); ++i) {
            this.subReferences.get(i).setMyScope(scope);
        }
    }

    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        for (int i = 0; i < this.subReferences.size(); ++i) {
            this.subReferences.get(i).setCodeSection(codeSection);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        for (int i = 0; i < this.subReferences.size(); ++i) {
            if (child != this.subReferences.get(i)) continue;
            return builder.append(FULLNAMEPART).append(String.valueOf(i + 1)).append(">");
        }
        return builder;
    }

    @Override
    public void setLocation(Location location) {
    }

    @Override
    public Location getLocation() {
        Location temp;
        if (this.modid != null) {
            temp = new Location(this.modid.getLocation());
        } else if (!this.subReferences.isEmpty()) {
            temp = new Location(this.subReferences.get(0).getLocation());
        } else {
            return NULL_Location.INSTANCE;
        }
        if (!this.subReferences.isEmpty()) {
            temp.setEndOffset(this.subReferences.get(this.subReferences.size() - 1).getLocation().getEndOffset());
        }
        return temp;
    }

    public final CompilationTimeStamp getLastTimeChecked() {
        return this.lastTimeChecked;
    }

    public final boolean getIsErroneous(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.isErroneous;
        }
        return false;
    }

    public void setIsErroneous(boolean isErroneous) {
        this.isErroneous = isErroneous;
    }

    public boolean getUsedOnLeftHandSide() {
        return this.usedOnLeftSide;
    }

    public void setUsedOnLeftHandSide() {
        this.usedOnLeftSide = true;
    }

    public boolean getUsedInIsbound() {
        return this.usedInIsbound;
    }

    public void setUsedInIsbound() {
        this.usedInIsbound = true;
    }

    public Identifier getModuleIdentifier() {
        this.detectModid();
        return this.modid;
    }

    public Identifier getId() {
        this.detectModid();
        if (!this.subReferences.isEmpty()) {
            return this.subReferences.get(0).getId();
        }
        return null;
    }

    public List<ISubReference> getSubreferences() {
        return this.subReferences;
    }

    public List<ISubReference> getSubreferences(int from, int till) {
        ArrayList<ISubReference> result = new ArrayList<ISubReference>();
        int size = Math.min(this.subReferences.size() - 1, till);
        for (int i = Math.max(0, from); i <= size; ++i) {
            result.add(this.subReferences.get(i));
        }
        return result;
    }

    public void addSubReference(ISubReference subReference) {
        this.subReferences.add(subReference);
        subReference.setFullNameParent(this);
    }

    public ISubReference removeLastSubReference() {
        if (this.subReferences.isEmpty()) {
            return null;
        }
        ISubReference result = this.subReferences.remove(this.subReferences.size() - 1);
        if (this.subReferences.isEmpty() && this.modid != null) {
            this.subReferences.add(new FieldSubReference(this.modid));
            this.modid = null;
            this.detectedModuleId = false;
        }
        return result;
    }

    public boolean refersToStringElement() {
        return this.refersToStringElement;
    }

    public void setStringElementReferencing() {
        this.refersToStringElement = true;
    }

    public void clearStringElementReferencing() {
        this.refersToStringElement = false;
    }

    public void clear() {
        this.referredAssignment = null;
        this.lastTimeChecked = null;
    }

    public void detectModid() {
        if (this.detectedModuleId || this.modid != null) {
            return;
        }
        Identifier firstId = null;
        if (!this.subReferences.isEmpty() && ISubReference.Subreference_type.fieldSubReference.equals((Object)this.subReferences.get(0).getReferenceType())) {
            firstId = this.subReferences.get(0).getId();
            if (this.subReferences.size() > 1 && !ISubReference.Subreference_type.arraySubReference.equals((Object)this.subReferences.get(1).getReferenceType()) && this.myScope != null && !this.myScope.hasAssignmentWithId(CompilationTimeStamp.getBaseTimestamp(), firstId) && this.myScope.isValidModuleId(firstId)) {
                this.modid = firstId;
                this.subReferences.remove(0);
            }
        }
        this.detectedModuleId = true;
    }

    public ISetting getRefdSetting(CompilationTimeStamp timestamp) {
        Assignment assignment = this.getRefdAssignment(timestamp, true);
        if (assignment != null) {
            return assignment.getSetting(timestamp);
        }
        return new Error_Setting();
    }

    public Assignment getRefdAssignment(CompilationTimeStamp timestamp, boolean checkParameterList) {
        return this.getRefdAssignment(timestamp, checkParameterList, null);
    }

    private StatementBlock getValueStatementBlock() {
        for (Scope scope = this.getMyScope(); scope != null; scope = scope.getParentScope()) {
            StatementBlock block;
            if (!(scope instanceof StatementBlock) || (block = (StatementBlock)scope).getValueParamList() == null) continue;
            return (StatementBlock)scope;
        }
        return null;
    }

    public Assignment getRefdAssignment(CompilationTimeStamp timestamp, boolean checkParameterList, IReferenceChain referenceChain) {
        DocumentComment comment;
        String referingModuleName;
        StatementBlock statementBlock;
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp) && !checkParameterList) {
            return this.referredAssignment;
        }
        this.lastTimeChecked = timestamp;
        StatementBlock statementBlock2 = statementBlock = this.myScope != null ? this.myScope.getStatementBlockScope() : null;
        if (this.reftype == Ref_Type.REF_VALUE) {
            if (statementBlock != null && statementBlock.isInDynamicTemplate()) {
                this.referredAssignment = statementBlock.getDynamicTemplate().getDynamicFormalParameter();
            } else if (this.myScope != null && this.myScope.isInSetterScope()) {
                this.referredAssignment = this.myScope.getScopeSetter().getFormalParameter();
            } else {
                this.getLocation().reportSemanticError(INVALIDVALUEREFERENCE);
                this.isErroneous = true;
                return null;
            }
        }
        if (this.myScope == null || this.getId() == null) {
            return null;
        }
        boolean newChain = null == referenceChain;
        IReferenceChain tempReferenceChain = newChain ? ReferenceChain.getInstance("Circular reference chain: `{0}''", true) : referenceChain;
        this.isErroneous = false;
        this.detectedModuleId = false;
        this.detectModid();
        if (this.reftype == Ref_Type.REF_THIS || this.reftype == Ref_Type.REF_SUPER) {
            Scope s;
            for (s = this.myScope; s != null && s instanceof StatementBlock || s instanceof NamedBridgeScope || s instanceof FormalParameterList; s = s.getParentScope()) {
            }
            if (s == null) {
                return null;
            }
            if (!(s instanceof ClassTypeBody)) {
                this.getLocation().reportSemanticError(MessageFormat.format(THISORSUPEROUTSIDECLASS, this.reftype == Ref_Type.REF_THIS ? "this" : "super"));
                this.setIsErroneous(true);
                return null;
            }
            if (this.reftype == Ref_Type.REF_SUPER) {
                ClassTypeBody body = (ClassTypeBody)s;
                this.referredAssignment = body.getAssFromParents(timestamp, this);
            }
            if (this.reftype == Ref_Type.REF_THIS) {
                this.referredAssignment = s.getAssBySRef(timestamp, this, referenceChain);
            }
        } else if (this.referredAssignment == null) {
            this.referredAssignment = this.myScope.getAssBySRef(timestamp, this, referenceChain);
        }
        if (this.referredAssignment == null) {
            this.isErroneous = true;
            return this.referredAssignment;
        }
        this.referredAssignment.check(timestamp, tempReferenceChain);
        this.referredAssignment.setUsed();
        if (this.referredAssignment instanceof Definition && !((Definition)this.referredAssignment).referingHere.contains(referingModuleName = this.getMyScope().getModuleScope().getName())) {
            ((Definition)this.referredAssignment).referingHere.add(referingModuleName);
        }
        if (checkParameterList) {
            Def_Type defType;
            Type type;
            if (this.referredAssignment.getAssignmentType() == Assignment.Assignment_type.A_TYPE && !this.subReferences.isEmpty() && this.subReferences.get(0) instanceof ParameterisedSubReference && (type = (defType = (Def_Type)this.referredAssignment).getType(timestamp)).getTypetype() == IType.Type_type.TYPE_CLASS) {
                this.referredAssignment = type.getClassType().getConstructor(timestamp);
                if (this.referredAssignment == null) {
                    return null;
                }
            }
            FormalParameterList formalParameterList = null;
            if (this.referredAssignment instanceof IParameterisedAssignment) {
                formalParameterList = ((IParameterisedAssignment)((Object)this.referredAssignment)).getFormalParameterList();
            }
            if (formalParameterList == null) {
                if (!this.subReferences.isEmpty() && this.subReferences.get(0) instanceof ParameterisedSubReference) {
                    String message = MessageFormat.format("The referenced {0} cannot have actual parameters", this.referredAssignment.getDescription());
                    this.getLocation().reportSemanticError(message);
                    this.setIsErroneous(true);
                }
            } else if (!this.subReferences.isEmpty()) {
                ISubReference firstSubReference = this.subReferences.get(0);
                if (firstSubReference instanceof ParameterisedSubReference) {
                    formalParameterList.check(timestamp, this.referredAssignment.getAssignmentType());
                    this.isErroneous = ((ParameterisedSubReference)firstSubReference).checkParameters(timestamp, formalParameterList);
                } else if (!Assignment.Assignment_type.A_TEMPLATE.semanticallyEquals(this.referredAssignment.getAssignmentType()) || !formalParameterList.hasOnlyDefaultValues()) {
                    String message = MessageFormat.format("Reference to parameterized definition `{0}'' without actual parameter list", this.referredAssignment.getIdentifier().getDisplayName());
                    this.getLocation().reportSemanticError(message);
                    this.setIsErroneous(true);
                }
            }
        }
        boolean isDecorated = false;
        if (this.referredAssignment instanceof ICommentable && (comment = ((ICommentable)((Object)this.referredAssignment)).getDocumentComment()) != null && comment.isDeprecated()) {
            AstSyntaxHighlightTokens.addSyntaxDecoration(this.getLocation(), AstSyntaxHighlightTokens.SyntaxDecoration.Deprecated);
            isDecorated = true;
        }
        if (this.referredAssignment instanceof Definition && !isDecorated) {
            Definition definition = (Definition)this.referredAssignment;
            if (definition instanceof Def_Const) {
                AstSyntaxHighlightTokens.addSyntaxDecoration(this.getLocation(), AstSyntaxHighlightTokens.SyntaxDecoration.Constant);
                isDecorated = true;
            } else if (definition instanceof Def_Var) {
                AstSyntaxHighlightTokens.addSyntaxDecoration(this.getLocation(), AstSyntaxHighlightTokens.SyntaxDecoration.Variable);
                isDecorated = true;
            } else if (definition instanceof Def_Type) {
                AstSyntaxHighlightTokens.addSyntaxDecoration(this.getLocation(), AstSyntaxHighlightTokens.SyntaxDecoration.DefType);
                isDecorated = true;
            }
        }
        if (!isDecorated) {
            AstSyntaxHighlightTokens.removeSyntaxDecoration(this.getLocation());
        }
        this.referredAssignment.addReference(this);
        AstSyntaxHighlightTokens.removeSpecificSyntaxDecoration(this.referredAssignment.getIdentifier().getLocation(), AstSyntaxHighlightTokens.SyntaxDecoration.Unused);
        return this.referredAssignment;
    }

    public Declaration getReferencedDeclaration(ISubReference subReference) {
        Assignment ass = this.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false);
        if (ass == null) {
            return null;
        }
        if (subReference == null) {
            return Declaration.createInstance(ass.getMyScope().getModuleScope());
        }
        if (this.subReferences.size() == 1 || this.subReferences.get(0) == subReference) {
            return Declaration.createInstance(ass);
        }
        IType assignmentType = ass.getType(CompilationTimeStamp.getBaseTimestamp());
        if (assignmentType == null) {
            return null;
        }
        IType type = assignmentType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
        if (type instanceof IReferenceableElement) {
            IReferenceableElement iTypeWithComponents = (IReferenceableElement)((Object)type);
            return iTypeWithComponents.resolveReference(this, 1, subReference);
        }
        return Declaration.createInstance(ass);
    }

    public final Component_Type chkComponentypeReference(CompilationTimeStamp timestamp) {
        Assignment assignment = this.getRefdAssignment(timestamp, true);
        if (assignment != null) {
            if (Assignment.Assignment_type.A_TYPE.semanticallyEquals(assignment.getAssignmentType())) {
                IType type = assignment.getType(timestamp);
                if (type != null && (type = type.getTypeRefdLast(timestamp)) != null && !type.getIsErroneous(timestamp)) {
                    switch (type.getTypetype()) {
                        case TYPE_COMPONENT: {
                            return (Component_Type)type;
                        }
                        case TYPE_REFERENCED: {
                            return null;
                        }
                    }
                    this.getLocation().reportSemanticError(COMPONENTEXPECTED);
                    this.setIsErroneous(true);
                }
            } else {
                this.getLocation().reportSemanticError(TYPEEXPECTED);
                this.setIsErroneous(true);
            }
        }
        return null;
    }

    public final Class_Type chkClassReference(CompilationTimeStamp timestamp) {
        Assignment assignment = this.getRefdAssignment(timestamp, true);
        if (assignment != null) {
            if (Assignment.Assignment_type.A_TYPE.semanticallyEquals(assignment.getAssignmentType())) {
                IType type = assignment.getType(timestamp);
                if (type != null && (type = type.getTypeRefdLast(timestamp)) != null && !type.getIsErroneous(timestamp)) {
                    switch (type.getTypetype()) {
                        case TYPE_CLASS: {
                            return (Class_Type)type;
                        }
                    }
                    this.getLocation().reportSemanticError(CLASSEXPECTED);
                    this.setIsErroneous(true);
                }
            } else {
                this.getLocation().reportSemanticError(TYPEEXPECTED);
                this.setIsErroneous(true);
            }
        }
        return null;
    }

    public IType checkVariableReference(CompilationTimeStamp timestamp) {
        Type type;
        Assignment assignment = this.getRefdAssignment(timestamp, true);
        if (assignment == null) {
            return null;
        }
        switch (assignment.getAssignmentType()) {
            case A_PAR_VAL_IN: {
                ((FormalParameter)assignment).useAsLValue(this);
                type = ((FormalParameter)assignment).getType(timestamp);
                ((FormalParameter)assignment).setUsed();
                ((FormalParameter)assignment).setWritten();
                break;
            }
            case A_PAR_VAL: 
            case A_PAR_VAL_OUT: 
            case A_PAR_VAL_INOUT: {
                type = ((FormalParameter)assignment).getType(timestamp);
                ((FormalParameter)assignment).setUsed();
                ((FormalParameter)assignment).setWritten();
                break;
            }
            case A_VAR: {
                type = ((Def_Var)assignment).getType(timestamp);
                ((Def_Var)assignment).setUsed();
                ((Def_Var)assignment).setWritten();
                break;
            }
            default: {
                this.getLocation().reportSemanticError(MessageFormat.format(VARIABLEXPECTED, assignment.getDescription()));
                this.setIsErroneous(true);
                return null;
            }
        }
        IType result = type.getFieldType(timestamp, this, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null, false);
        if (result != null && this.subReferences != null && this.refersToStringElement()) {
            this.getLocation().reportSemanticError(MessageFormat.format(STRINGELEMENTUNUSABLE, result.getTypename()));
            this.setIsErroneous(true);
        }
        return result;
    }

    public final boolean checkActivateArgument(CompilationTimeStamp timestamp) {
        Assignment assignment = this.getRefdAssignment(timestamp, true);
        if (assignment == null) {
            return false;
        }
        if (!Assignment.Assignment_type.A_ALTSTEP.semanticallyEquals(assignment.getAssignmentType())) {
            this.getLocation().reportSemanticError(MessageFormat.format(ALTSTEPEXPECTED, assignment.getDescription()));
            this.setIsErroneous(true);
            return false;
        }
        if (this.myScope != null) {
            this.myScope.checkRunsOnScope(timestamp, assignment, (ILocateableNode)this, "activate");
        }
        if (!this.subReferences.isEmpty() && ISubReference.Subreference_type.parameterisedSubReference.equals((Object)this.subReferences.get(0).getReferenceType())) {
            ActualParameterList actualParameters = ((ParameterisedSubReference)this.subReferences.get(0)).getActualParameters();
            FormalParameterList formalParameterList = ((Def_Altstep)assignment).getFormalParameterList();
            if (formalParameterList != null) {
                return formalParameterList.checkActivateArgument(timestamp, actualParameters, assignment.getDescription());
            }
        }
        return false;
    }

    public final boolean hasUnfoldableIndexSubReference(CompilationTimeStamp timestamp) {
        for (ISubReference subReference : this.subReferences) {
            IValue value;
            if (!ISubReference.Subreference_type.arraySubReference.equals((Object)subReference.getReferenceType()) || (value = ((ArraySubReference)subReference).getValue()) == null || !(value = value.setLoweridToReference(timestamp)).isUnfoldable(timestamp)) continue;
            return true;
        }
        return false;
    }

    public boolean refersToSettingType(CompilationTimeStamp timestamp, ISetting.Setting_type settingType, IReferenceChain referenceChain) {
        if (this.myScope == null) {
            return ISetting.Setting_type.S_ERROR.equals((Object)settingType);
        }
        Assignment assignment = this.getRefdAssignment(timestamp, true);
        if (assignment == null) {
            return false;
        }
        if (!(assignment instanceof ASN1Assignment)) {
            this.getLocation().reportSemanticError(ASN1SETTINGEXPECTED);
            this.setIsErroneous(true);
            return false;
        }
        ASN1Assignment asnAssignment = (ASN1Assignment)assignment;
        switch (settingType) {
            case S_OC: {
                return asnAssignment.isAssignmentType(timestamp, Assignment.Assignment_type.A_OC, referenceChain);
            }
            case S_T: {
                return asnAssignment.isAssignmentType(timestamp, Assignment.Assignment_type.A_TYPE, referenceChain);
            }
            case S_O: {
                return asnAssignment.isAssignmentType(timestamp, Assignment.Assignment_type.A_OBJECT, referenceChain);
            }
            case S_V: {
                return asnAssignment.isAssignmentType(timestamp, Assignment.Assignment_type.A_CONST, referenceChain);
            }
            case S_OS: {
                return asnAssignment.isAssignmentType(timestamp, Assignment.Assignment_type.A_OS, referenceChain);
            }
            case S_VS: {
                return asnAssignment.isAssignmentType(timestamp, Assignment.Assignment_type.A_VS, referenceChain);
            }
            case S_ERROR: {
                return asnAssignment.getIsErroneous();
            }
        }
        return false;
    }

    public final String toString() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        StringBuilder builder = new StringBuilder();
        if (this.modid != null) {
            builder.append(this.modid.getDisplayName());
        }
        for (int i = 0; i < this.subReferences.size(); ++i) {
            this.subReferences.get(i).appendDisplayName(builder);
        }
        return builder.toString();
    }

    @Override
    public final void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.modid != null) {
            reparser.updateLocation(this.modid.getLocation());
        }
        for (ISubReference subreference : this.subReferences) {
            subreference.updateSyntax(reparser, false);
            reparser.updateLocation(subreference.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        for (int i = 0; i < this.subReferences.size(); ++i) {
            this.subReferences.get(i).findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.referredAssignment == null) {
            return;
        }
        if (referenceFinder.fieldId == null) {
            if (referenceFinder.assignment != this.referredAssignment) {
                return;
            }
            foundIdentifiers.add(new ReferenceFinder.Hit(this.getId(), this));
        } else {
            IType t = this.referredAssignment.getType(CompilationTimeStamp.getBaseTimestamp());
            if (t == null) {
                return;
            }
            ArrayList<IType> typeArray = new ArrayList<IType>();
            boolean success = t.getFieldTypesAsArray(this, 1, typeArray);
            if (!success) {
                return;
            }
            if (this.subReferences.size() > 0 && this.subReferences.size() != typeArray.size() + 1) {
                ErrorReporter.INTERNAL_ERROR();
                return;
            }
            for (int i = 1; i < this.subReferences.size(); ++i) {
                if (typeArray.get(i - 1) != referenceFinder.type || this.subReferences.get(i) instanceof ArraySubReference || !this.subReferences.get(i).getId().equals(referenceFinder.fieldId)) continue;
                foundIdentifiers.add(new ReferenceFinder.Hit(this.subReferences.get(i).getId()));
            }
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.modid != null && !this.modid.accept(v)) {
            return false;
        }
        if (this.subReferences != null) {
            for (int i = 0; i < this.subReferences.size(); ++i) {
                if (this.subReferences.get(i).accept(v)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Declaration getDeclaration() {
        return this.getReferencedDeclaration(null);
    }

    public void generateCode(JavaGenData aData, ExpressionStruct expression) {
        FormalParameterList formalParameterList;
        IType referedGovernor;
        boolean isTemplate;
        if (this.referredAssignment == null) {
            return;
        }
        switch (this.referredAssignment.getAssignmentType()) {
            case A_PAR_VAL_IN: 
            case A_PAR_VAL: 
            case A_PAR_VAL_OUT: 
            case A_PAR_VAL_INOUT: 
            case A_VAR: 
            case A_CONST: 
            case A_EXT_CONST: 
            case A_MODULEPAR: 
            case A_FUNCTION_RVAL: 
            case A_EXT_FUNCTION_RVAL: {
                isTemplate = false;
                referedGovernor = this.referredAssignment.getType(CompilationTimeStamp.getBaseTimestamp());
                break;
            }
            case A_MODULEPAR_TEMPLATE: 
            case A_TEMPLATE: 
            case A_VAR_TEMPLATE: 
            case A_PAR_TEMP_IN: 
            case A_PAR_TEMP_OUT: 
            case A_PAR_TEMP_INOUT: {
                isTemplate = true;
                referedGovernor = this.referredAssignment.getType(CompilationTimeStamp.getBaseTimestamp());
                break;
            }
            default: {
                isTemplate = false;
                referedGovernor = null;
            }
        }
        switch (this.referredAssignment.getAssignmentType()) {
            case A_FUNCTION_RVAL: 
            case A_FUNCTION: 
            case A_FUNCTION_RTEMP: {
                formalParameterList = ((Def_Function)this.referredAssignment).getFormalParameterList();
                break;
            }
            case A_EXT_FUNCTION_RVAL: 
            case A_EXT_FUNCTION: 
            case A_EXT_FUNCTION_RTEMP: {
                formalParameterList = ((Def_Extfunction)this.referredAssignment).getFormalParameterList();
                break;
            }
            case A_TEMPLATE: {
                formalParameterList = ((Def_Template)this.referredAssignment).getFormalParameterList();
                break;
            }
            case A_ALTSTEP: {
                formalParameterList = ((Def_Altstep)this.referredAssignment).getFormalParameterList();
                break;
            }
            default: {
                formalParameterList = null;
            }
        }
        if (this.subReferences.get(0) instanceof ParameterisedSubReference) {
            expression.expression.append(this.referredAssignment.getGenNameFromScope(aData, expression.expression, null));
            expression.expression.append("( ");
            ParameterisedSubReference temp = (ParameterisedSubReference)this.subReferences.get(0);
            temp.getActualParameters().generateCodeAlias(aData, expression, formalParameterList);
            expression.expression.append(" )");
        } else if (formalParameterList != null) {
            expression.expression.append(this.referredAssignment.getGenNameFromScope(aData, expression.expression, null));
            expression.expression.append("( ");
            for (int i = 0; i < formalParameterList.getNofParameters(); ++i) {
                if (i > 0) {
                    expression.expression.append(", ");
                }
                formalParameterList.getParameterByIndex(i).getDefaultValue().generateCode(aData, expression, formalParameterList.getParameterByIndex(i));
            }
            expression.expression.append(" )");
        } else if (LazyFuzzyParamData.inLazyOrFuzzy()) {
            expression.expression.append(LazyFuzzyParamData.addReferenceGenname(aData, expression.expression, this.referredAssignment));
        } else {
            expression.expression.append(this.referredAssignment.getGenNameFromScope(aData, expression.expression, null));
        }
        if (this.referredAssignment.getMyScope() instanceof ComponentTypeBody) {
            switch (this.referredAssignment.getAssignmentType()) {
                case A_VAR: 
                case A_VAR_TEMPLATE: 
                case A_PORT: 
                case A_TIMER: {
                    expression.expression.append(".get()");
                    break;
                }
            }
        }
        Reference.generateCode(aData, expression, this.subReferences, 1, isTemplate, false, referedGovernor);
    }

    public boolean hasSingleExpression() {
        FormalParameterList formalParameterList;
        if (this.referredAssignment == null) {
            ErrorReporter.INTERNAL_ERROR((String)("FATAL ERROR while generating code for reference `" + this.getFullName() + "''"));
            return false;
        }
        for (int i = 0; i < this.subReferences.size(); ++i) {
            ISubReference temp = this.subReferences.get(i);
            if (temp.hasSingleExpression(null)) continue;
            return false;
        }
        switch (this.referredAssignment.getAssignmentType()) {
            case A_FUNCTION_RVAL: 
            case A_FUNCTION: 
            case A_FUNCTION_RTEMP: {
                formalParameterList = ((Def_Function)this.referredAssignment).getFormalParameterList();
                break;
            }
            case A_EXT_FUNCTION_RVAL: 
            case A_EXT_FUNCTION: 
            case A_EXT_FUNCTION_RTEMP: {
                formalParameterList = ((Def_Extfunction)this.referredAssignment).getFormalParameterList();
                break;
            }
            case A_TEMPLATE: {
                formalParameterList = ((Def_Template)this.referredAssignment).getFormalParameterList();
                break;
            }
            case A_ALTSTEP: {
                formalParameterList = ((Def_Altstep)this.referredAssignment).getFormalParameterList();
                break;
            }
            default: {
                formalParameterList = null;
            }
        }
        if (formalParameterList != null) {
            if (this.subReferences.size() > 0 && !this.subReferences.get(0).hasSingleExpression(formalParameterList)) {
                return false;
            }
            for (int i = 0; i < formalParameterList.getNofParameters(); ++i) {
                if (formalParameterList.getParameterByIndex(i).getEvaluationType() == FormalParameter.parameterEvaluationType.NORMAL_EVAL) continue;
                return false;
            }
        }
        return true;
    }

    public void generateConstRef(JavaGenData aData, ExpressionStruct expression) {
        FormalParameterList formalParameterList;
        boolean isTemplate;
        if (this.referredAssignment == null) {
            return;
        }
        switch (this.referredAssignment.getAssignmentType()) {
            case A_PAR_VAL_IN: 
            case A_PAR_VAL: 
            case A_PAR_VAL_OUT: 
            case A_PAR_VAL_INOUT: 
            case A_VAR: 
            case A_CONST: 
            case A_EXT_CONST: 
            case A_MODULEPAR: 
            case A_FUNCTION_RVAL: 
            case A_EXT_FUNCTION_RVAL: {
                isTemplate = false;
                break;
            }
            case A_MODULEPAR_TEMPLATE: 
            case A_TEMPLATE: 
            case A_VAR_TEMPLATE: 
            case A_PAR_TEMP_IN: 
            case A_PAR_TEMP_OUT: 
            case A_PAR_TEMP_INOUT: {
                isTemplate = true;
                break;
            }
            default: {
                isTemplate = false;
            }
        }
        switch (this.referredAssignment.getAssignmentType()) {
            case A_FUNCTION_RVAL: 
            case A_FUNCTION: 
            case A_FUNCTION_RTEMP: {
                formalParameterList = ((Def_Function)this.referredAssignment).getFormalParameterList();
                break;
            }
            case A_EXT_FUNCTION_RVAL: 
            case A_EXT_FUNCTION: 
            case A_EXT_FUNCTION_RTEMP: {
                formalParameterList = ((Def_Extfunction)this.referredAssignment).getFormalParameterList();
                break;
            }
            case A_TEMPLATE: {
                formalParameterList = ((Def_Template)this.referredAssignment).getFormalParameterList();
                break;
            }
            case A_ALTSTEP: {
                formalParameterList = ((Def_Altstep)this.referredAssignment).getFormalParameterList();
                break;
            }
            default: {
                formalParameterList = null;
            }
        }
        IType referedGovernor = this.referredAssignment.getType(CompilationTimeStamp.getBaseTimestamp());
        if (this.subReferences.get(0) instanceof ParameterisedSubReference) {
            expression.expression.append(this.referredAssignment.getGenNameFromScope(aData, expression.expression, null));
            expression.expression.append("( ");
            ParameterisedSubReference temp = (ParameterisedSubReference)this.subReferences.get(0);
            ActualParameterList actualParameterList = temp.getActualParameters();
            if (actualParameterList != null) {
                actualParameterList.generateCodeAlias(aData, expression, formalParameterList);
            }
            expression.expression.append(" )");
        } else if (formalParameterList != null) {
            expression.expression.append(this.referredAssignment.getGenNameFromScope(aData, expression.expression, null));
            expression.expression.append("( ");
            for (int i = 0; i < formalParameterList.getNofParameters(); ++i) {
                if (i > 0) {
                    expression.expression.append(", ");
                }
                formalParameterList.getParameterByIndex(i).getDefaultValue().generateCode(aData, expression, formalParameterList.getParameterByIndex(i));
            }
            expression.expression.append(" )");
        } else if (LazyFuzzyParamData.inLazyOrFuzzy()) {
            expression.expression.append(LazyFuzzyParamData.addReferenceGenname(aData, expression.expression, this.referredAssignment));
        } else {
            expression.expression.append(this.referredAssignment.getGenNameFromScope(aData, expression.expression, null));
        }
        if (this.referredAssignment.getMyScope() instanceof ComponentTypeBody) {
            switch (this.referredAssignment.getAssignmentType()) {
                case A_VAR: 
                case A_VAR_TEMPLATE: 
                case A_PORT: 
                case A_TIMER: {
                    expression.expression.append(".get()");
                    break;
                }
            }
        }
        Reference.generateCode(aData, expression, this.subReferences, 1, isTemplate, true, referedGovernor);
    }

    public static void generateCode(JavaGenData aData, ExpressionStruct expression, ArrayList<ISubReference> subReferences, int startIndex, boolean isTemplate, boolean isConst, IType type) {
        block13: for (int i = startIndex; i < subReferences.size(); ++i) {
            long start;
            long j;
            long length;
            ISubReference subreference;
            if (type != null) {
                type = type.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
            }
            if (ISubReference.Subreference_type.fieldSubReference.equals((Object)(subreference = subReferences.get(i)).getReferenceType())) {
                Identifier id = ((FieldSubReference)subreference).getId();
                expression.expression.append(".");
                if (isConst) {
                    expression.expression.append("constGet_field_");
                } else {
                    expression.expression.append("get_field_");
                }
                expression.expression.append(FieldSubReference.getJavaGetterName(id.getName()));
                expression.expression.append("()");
                if (type == null) continue;
                CompField compField = null;
                switch (type.getTypetype()) {
                    case TYPE_TTCN3_CHOICE: 
                    case TYPE_TTCN3_SEQUENCE: 
                    case TYPE_TTCN3_SET: {
                        compField = ((TTCN3_Set_Seq_Choice_BaseType)type).getComponentByName(id.getName());
                        break;
                    }
                    case TYPE_ANYTYPE: {
                        compField = ((Anytype_Type)type).getComponentByName(id.getName());
                        break;
                    }
                    case TYPE_OPENTYPE: {
                        compField = ((Open_Type)type).getComponentByName(id);
                        break;
                    }
                    case TYPE_ASN1_SEQUENCE: {
                        compField = ((ASN1_Sequence_Type)type).getComponentByName(id);
                        break;
                    }
                    case TYPE_ASN1_SET: {
                        compField = ((ASN1_Set_Type)type).getComponentByName(id);
                        break;
                    }
                    case TYPE_ASN1_CHOICE: {
                        compField = ((ASN1_Choice_Type)type).getComponentByName(id);
                        break;
                    }
                    case TYPE_CLASS: {
                        return;
                    }
                    default: {
                        ErrorReporter.INTERNAL_ERROR((String)"FATAL ERROR while generating code for a reference.");
                        return;
                    }
                }
                if (i < subReferences.size() - 1 && compField != null && compField.isOptional() && !isTemplate) {
                    if (isConst) {
                        expression.expression.append(".constGet()");
                    } else {
                        expression.expression.append(".get()");
                    }
                }
                if (compField == null) {
                    ErrorReporter.INTERNAL_ERROR((String)MessageFormat.format("FATAL ERROR while generating code for a reference, type {0} does not have field with name {1}", type.getFullName(), id.getDisplayName()));
                    return;
                }
                type = compField.getType();
                continue;
            }
            if (!ISubReference.Subreference_type.arraySubReference.equals((Object)subreference.getReferenceType())) continue;
            Value value = ((ArraySubReference)subreference).getValue();
            IType pt = value.getExpressionGovernor(CompilationTimeStamp.getBaseTimestamp(), Expected_Value_type.EXPECTED_TEMPLATE);
            if ((pt = pt.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp())).getTypetype() == IType.Type_type.TYPE_ARRAY) {
                length = ((Array_Type)pt).getDimension().getSize();
                for (j = start = ((Array_Type)pt).getDimension().getOffset(); j < start + length; ++j) {
                    if (isConst) {
                        expression.expression.append(".constGet_at(");
                    } else {
                        expression.expression.append(".get_at(");
                    }
                    value.generateCodeExpressionMandatory(aData, expression, false);
                    expression.expression.append(MessageFormat.format(".constGet_at({0}))", j));
                }
            } else if (pt.getTypetype() == IType.Type_type.TYPE_SEQUENCE_OF) {
                length = ((SequenceOf_Type)pt).getSubtype().get_length_restriction();
                start = 0L;
                for (j = 0L; j < 0L + length; ++j) {
                    if (isConst) {
                        expression.expression.append(".constGet_at(");
                    } else {
                        expression.expression.append(".get_at(");
                    }
                    value.generateCodeExpressionMandatory(aData, expression, false);
                    expression.expression.append(MessageFormat.format(".constGet_at({0}))", j));
                }
            } else {
                if (isConst) {
                    expression.expression.append(".constGet_at(");
                } else {
                    expression.expression.append(".get_at(");
                }
                value.generateCodeExpressionMandatory(aData, expression, false);
                expression.expression.append(")");
            }
            if (type == null) continue;
            switch (type.getTypetype()) {
                case TYPE_SEQUENCE_OF: 
                case TYPE_SET_OF: {
                    type = ((AbstractOfType)type).getOfType();
                    continue block13;
                }
                case TYPE_ARRAY: {
                    type = ((Array_Type)type).getElementType();
                    continue block13;
                }
                default: {
                    type = null;
                }
            }
        }
    }

    public void generateCodeIsPresentBoundChosen(JavaGenData aData, ExpressionStruct expression, boolean isTemplate, Expression_Value.Operation_type optype, String field) {
        FormalParameterList formalParameterList;
        String ass_id;
        Assignment assignment = this.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false);
        String ass_id2 = ass_id = assignment.getGenNameFromScope(aData, expression.expression, null);
        switch (assignment.getAssignmentType()) {
            case A_FUNCTION_RVAL: 
            case A_FUNCTION: 
            case A_FUNCTION_RTEMP: {
                formalParameterList = ((Def_Function)assignment).getFormalParameterList();
                break;
            }
            case A_EXT_FUNCTION_RVAL: 
            case A_EXT_FUNCTION: 
            case A_EXT_FUNCTION_RTEMP: {
                formalParameterList = ((Def_Extfunction)assignment).getFormalParameterList();
                break;
            }
            case A_TEMPLATE: {
                formalParameterList = ((Def_Template)assignment).getFormalParameterList();
                break;
            }
            default: {
                formalParameterList = null;
            }
        }
        if (this.subReferences.size() > 0 && this.subReferences.get(0) instanceof ParameterisedSubReference) {
            ParameterisedSubReference subReference = (ParameterisedSubReference)this.subReferences.get(0);
            ExpressionStruct tempExpression = new ExpressionStruct();
            subReference.getActualParameters().generateCodeAlias(aData, tempExpression, formalParameterList);
            if (tempExpression.preamble.length() > 0) {
                expression.preamble.append((CharSequence)tempExpression.preamble);
            }
            ass_id2 = MessageFormat.format("{0}({1})", ass_id, tempExpression.expression);
        } else if (formalParameterList != null) {
            ExpressionStruct tempExpression = new ExpressionStruct();
            StringBuilder newId = new StringBuilder();
            newId.append(assignment.getGenNameFromScope(aData, tempExpression.expression, null));
            newId.append("( ");
            for (int i = 0; i < formalParameterList.getNofParameters(); ++i) {
                if (i > 0) {
                    tempExpression.expression.append(", ");
                }
                formalParameterList.getParameterByIndex(i).getDefaultValue().generateCode(aData, tempExpression, formalParameterList.getParameterByIndex(i));
            }
            if (tempExpression.preamble.length() > 0) {
                expression.preamble.append((CharSequence)tempExpression.preamble);
            }
            newId.append((CharSequence)tempExpression.expression);
            newId.append(" )");
            ass_id2 = newId.toString();
        }
        if (this.referredAssignment.getMyScope() instanceof ComponentTypeBody) {
            switch (this.referredAssignment.getAssignmentType()) {
                case A_VAR: 
                case A_VAR_TEMPLATE: 
                case A_PORT: 
                case A_TIMER: {
                    ass_id2 = ass_id2 + ".get()";
                    break;
                }
            }
        }
        if (this.subReferences.size() > 1) {
            String tempGeneralId = aData.getTemporaryVariableName();
            ExpressionStruct isboundExpression = new ExpressionStruct();
            isboundExpression.preamble.append(MessageFormat.format("boolean {0} = {1}.is_bound();\n", tempGeneralId, ass_id2));
            IType type = assignment.getType(CompilationTimeStamp.getBaseTimestamp());
            type.generateCodeIsPresentBoundChosen(aData, isboundExpression, this.subReferences, 1, tempGeneralId, ass_id2, isTemplate, optype, field, this.getMyScope());
            expression.preamble.append((CharSequence)isboundExpression.preamble);
            expression.preamble.append((CharSequence)isboundExpression.expression);
            expression.expression.append(tempGeneralId);
        } else {
            switch (optype) {
                case ISBOUND_OPERATION: {
                    expression.expression.append(MessageFormat.format("{0}.is_bound()", ass_id2));
                    break;
                }
                case ISVALUE_OPERATION: {
                    expression.expression.append(MessageFormat.format("{0}.is_value()", ass_id2));
                    break;
                }
                case ISPRESENT_OPERATION: {
                    expression.expression.append(MessageFormat.format("{0}.is_present({1})", ass_id2, isTemplate && aData.getAllowOmitInValueList() ? "true" : ""));
                    break;
                }
                case ISCHOOSEN_OPERATION: {
                    expression.expression.append(MessageFormat.format("{0}.ischosen({1})", ass_id2, field));
                    break;
                }
                default: {
                    ErrorReporter.INTERNAL_ERROR((String)("FATAL ERROR while generating code for reference `" + this.getFullName() + "''"));
                }
            }
        }
    }

    public Ref_Type getReferenceType() {
        return this.reftype;
    }

    public void setReferenceType(Ref_Type type) {
        this.reftype = type;
    }

    public static enum Ref_Side {
        REF_SIDE_ERROR,
        RHS_REF,
        LHS_REF,
        BOTH_SIDE_REF;

    }

    public static enum Ref_Type {
        REF_BASIC,
        REF_THIS,
        REF_SUPER,
        REF_VALUE;

    }
}

