/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.Object;

import java.text.MessageFormat;
import org.eclipse.titan.designer.AST.ASN1.IASN1Type;
import org.eclipse.titan.designer.AST.ASN1.Object.FieldSetting;
import org.eclipse.titan.designer.AST.ASN1.Object.FieldSpecification;
import org.eclipse.titan.designer.AST.ASN1.Object.FixedTypeValue_FieldSpecification;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class FieldSetting_Value
extends FieldSetting {
    private final IValue setting;

    public FieldSetting_Value(Identifier name, IValue setting) {
        super(name);
        this.setting = setting;
    }

    @Override
    public FieldSetting newInstance() {
        return new FieldSetting_Value(this.name.newInstance(), this.setting);
    }

    @Override
    public IValue getSetting() {
        return this.setting;
    }

    @Override
    public void check(CompilationTimeStamp timestamp, FieldSpecification fieldSpecification) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (!(fieldSpecification instanceof FixedTypeValue_FieldSpecification)) {
            this.getLocation().reportSemanticError("Value setting was expected");
            return;
        }
        FixedTypeValue_FieldSpecification fs = (FixedTypeValue_FieldSpecification)fieldSpecification;
        IASN1Type type = fs.getType();
        this.setting.setMyGovernor(type);
        IValue tempValue = type.checkThisValueRef(timestamp, this.setting);
        type.checkThisValue(timestamp, tempValue, null, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_CONSTANT, false, false, true, true, false));
        ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        this.setting.checkRecursions(timestamp, chain);
        chain.release();
        this.setting.setGenNameRecursive(this.setting.getGenNameOwn());
        this.setting.setCodeSection(GovernedSimple.CodeSectionType.CS_PRE_INIT);
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.name != null && !this.name.accept(v)) {
            return false;
        }
        return this.setting == null || this.setting.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData) {
        String genName = this.setting.get_lhs_name();
        IType type = this.setting.getMyGovernor();
        StringBuilder sb = aData.getSrc();
        StringBuilder source = new StringBuilder();
        String typeGeneratedName = type.getGenNameValue(aData, source);
        source.append(MessageFormat.format("\tpublic static final {0} {1}  = new {0}();\n", typeGeneratedName, genName));
        this.setting.generateCodeInit(aData, aData.getPreInit(), genName);
        sb.append((CharSequence)source);
    }
}

