/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.logging.context;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.types.Referenced_Type;
import org.eclipse.titanium.refactoring.logging.ContextLoggingRefactoring;
import org.eclipse.titanium.refactoring.logging.context.Context;

class FunctionContext
extends Context {
    private List<Identifier> paramIds;

    public FunctionContext(Def_Function func, ContextLoggingRefactoring.Settings settings) {
        super((IVisitableNode)func, settings);
    }

    public Def_Function getNode() {
        return (Def_Function)super.getNode();
    }

    @Override
    protected void process_internal() {
        Def_Function func = this.getNode();
        FormalParameterList fpl = func.getFormalParameterList();
        ParameterListVisitor vis = new ParameterListVisitor();
        fpl.accept((ASTVisitor)vis);
        this.paramIds = vis.getResult();
    }

    @Override
    protected List<String> createLogParts_internal(Set<String> idsAlreadyHandled) {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.paramIds == null) {
            return ret;
        }
        for (Identifier id : this.paramIds) {
            String idS = id.toString();
            if (idsAlreadyHandled.contains(idS)) continue;
            idsAlreadyHandled.add(idS);
            ret.add(this.formatLogPart(idS));
        }
        return ret;
    }

    private static class ParameterListVisitor
    extends ASTVisitor {
        private final List<Identifier> result = new ArrayList<Identifier>();

        private ParameterListVisitor() {
        }

        private List<Identifier> getResult() {
            return this.result;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof Identifier) {
                this.result.add((Identifier)node);
                return 1;
            }
            if (node instanceof Referenced_Type) {
                return 1;
            }
            if (node instanceof TemplateInstance) {
                return 1;
            }
            return 3;
        }
    }
}

