/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.logging.context;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.TTCN3.definitions.For_Loop_Definitions;
import org.eclipse.titan.designer.AST.TTCN3.statements.For_Statement;
import org.eclipse.titanium.refactoring.logging.ContextLoggingRefactoring;
import org.eclipse.titanium.refactoring.logging.context.Context;

class ForContext
extends Context {
    private List<Identifier> initialAssignmentIds;

    ForContext(For_Statement st, ContextLoggingRefactoring.Settings settings) {
        super((IVisitableNode)st, settings);
    }

    public For_Statement getNode() {
        return (For_Statement)super.getNode();
    }

    @Override
    protected void process_internal() {
        For_Statement st = this.getNode();
        ForVisitor vis = new ForVisitor();
        st.accept((ASTVisitor)vis);
        this.initialAssignmentIds = vis.getResult();
    }

    @Override
    protected List<String> createLogParts_internal(Set<String> idsAlreadyHandled) {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.initialAssignmentIds == null) {
            return ret;
        }
        for (Identifier id : this.initialAssignmentIds) {
            String idS = id.toString();
            if (idsAlreadyHandled.contains(idS)) continue;
            idsAlreadyHandled.add(idS);
            ret.add(this.formatLogPart(idS));
        }
        return ret;
    }

    private static class ForVisitor
    extends ASTVisitor {
        private final List<Identifier> result = new ArrayList<Identifier>();

        private ForVisitor() {
        }

        private List<Identifier> getResult() {
            return this.result;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof For_Statement) {
                return 3;
            }
            if (node instanceof For_Loop_Definitions) {
                For_Loop_Definitions flds = (For_Loop_Definitions)node;
                int count = flds.getNofAssignments();
                for (int i = 0; i < count; ++i) {
                    this.result.add(flds.getAssignmentByIndex(i).getIdentifier());
                }
            }
            return 1;
        }
    }
}

