/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.TitanInteger;
import org.eclipse.titan.runtime.core.TitanOctetString;
import org.eclipse.titan.runtime.core.TtcnError;

public class TitanOctetString_Element {
    private boolean bound_flag;
    private final TitanOctetString str_val;
    private final int nibble_pos;

    public TitanOctetString_Element(boolean par_bound_flag, TitanOctetString par_str_val, int par_nibble_pos) {
        this.bound_flag = par_bound_flag;
        this.str_val = par_str_val;
        this.nibble_pos = par_nibble_pos;
    }

    public boolean is_bound() {
        return this.bound_flag;
    }

    public boolean is_value() {
        return this.bound_flag;
    }

    public void must_bound(String errorMessage) {
        if (!this.bound_flag) {
            throw new TtcnError(errorMessage);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        byte digit = this.get_nibble();
        sb.append("0123456789ABCDEF?*".charAt(digit / 16));
        sb.append("0123456789ABCDEF?*".charAt(digit % 16));
        return sb.toString();
    }

    public TitanOctetString_Element operator_assign(TitanOctetString_Element otherValue) {
        otherValue.must_bound("Assignment of an unbound octetstring element.");
        this.bound_flag = true;
        this.str_val.set_nibble(this.nibble_pos, otherValue.str_val.get_nibble(otherValue.nibble_pos));
        return this;
    }

    public TitanOctetString_Element operator_assign(TitanOctetString otherValue) {
        otherValue.must_bound("Assignment of unbound octetstring value.");
        if (otherValue.get_value().length != 1) {
            throw new TtcnError("Assignment of a octetstring value with length other than 1 to a octetstring element.");
        }
        this.bound_flag = true;
        this.str_val.set_nibble(this.nibble_pos, otherValue.get_nibble(0));
        return this;
    }

    public boolean operator_equals(TitanOctetString_Element otherValue) {
        this.must_bound("Unbound left operand of octetstring element comparison.");
        otherValue.must_bound("Unbound right operand of octetstring comparison.");
        return this.str_val.get_nibble(this.nibble_pos) == otherValue.str_val.get_nibble(otherValue.nibble_pos);
    }

    public boolean operator_equals(TitanOctetString otherValue) {
        this.must_bound("Unbound left operand of octetstring element comparison.");
        otherValue.must_bound("Unbound right operand of octetstring element comparison.");
        if (otherValue.get_value().length != 1) {
            return false;
        }
        return this.str_val.get_nibble(this.nibble_pos) == otherValue.get_nibble(0);
    }

    public boolean operator_not_equals(TitanOctetString_Element otherValue) {
        return !this.operator_equals(otherValue);
    }

    public boolean operator_not_equals(TitanOctetString otherValue) {
        return !this.operator_equals(otherValue);
    }

    public TitanOctetString operator_concatenate(TitanOctetString other_value) {
        this.must_bound("Unbound left operand of octetstring element concatenation.");
        other_value.must_bound("Unbound right operand of octetstring concatenation.");
        byte[] src_ptr = other_value.get_value();
        int n_nibbles = src_ptr.length;
        byte[] dest_ptr = new byte[1 + n_nibbles];
        dest_ptr[0] = this.str_val.get_nibble(this.nibble_pos);
        System.arraycopy(src_ptr, 0, dest_ptr, 1, n_nibbles);
        return new TitanOctetString(dest_ptr);
    }

    public TitanOctetString operator_concatenate(TitanOctetString_Element other_value) {
        this.must_bound("Unbound left operand of octetstring element concatenation.");
        other_value.must_bound("Unbound right operand of octetstring element concatenation.");
        byte[] dest_ptr = new byte[]{this.str_val.get_nibble(this.nibble_pos), other_value.get_nibble()};
        return new TitanOctetString(dest_ptr);
    }

    public TitanOctetString not4b() {
        this.must_bound("Unbound octetstring element operand of operator not4b.");
        byte temp = this.str_val.get_nibble(this.nibble_pos);
        int digit1 = temp >> 4;
        int digit2 = temp & 0xF;
        int negDigit1 = ~digit1 & 0xF;
        int negDigit2 = ~digit2 & 0xF;
        return new TitanOctetString((byte)((negDigit1 << 4) + negDigit2));
    }

    public TitanOctetString and4b(TitanOctetString other_value) {
        this.must_bound("Left operand of operator and4b is an unbound octetstring element.");
        other_value.must_bound("Right operand of operator and4b is an unbound octetstring value.");
        if (other_value.get_value().length != 1) {
            throw new TtcnError("The octetstring operands of operator and4b must have the same length.");
        }
        byte result = (byte)(this.str_val.get_nibble(this.nibble_pos) & other_value.get_nibble(0));
        return new TitanOctetString(result);
    }

    public TitanOctetString and4b(TitanOctetString_Element other_value) {
        this.must_bound("Left operand of operator and4b is an unbound octetstring element.");
        other_value.must_bound("Right operand of operator and4b is an unbound octetstring element.");
        byte result = (byte)(this.str_val.get_nibble(this.nibble_pos) & other_value.str_val.get_nibble(other_value.nibble_pos));
        return new TitanOctetString(result);
    }

    public TitanOctetString or4b(TitanOctetString other_value) {
        this.must_bound("Left operand of operator or4b is an unbound octetstring element.");
        other_value.must_bound("Right operand of operator or4b is an unbound octetstring value.");
        if (other_value.get_value().length != 1) {
            throw new TtcnError("The octetstring operands of operator or4b must have the same length.");
        }
        byte result = (byte)(this.str_val.get_nibble(this.nibble_pos) | other_value.get_nibble(0));
        return new TitanOctetString(result);
    }

    public TitanOctetString or4b(TitanOctetString_Element other_value) {
        this.must_bound("Left operand of operator or4b is an unbound octetstring element.");
        other_value.must_bound("Right operand of operator or4b is an unbound octetstring element.");
        byte result = (byte)(this.str_val.get_nibble(this.nibble_pos) | other_value.str_val.get_nibble(other_value.nibble_pos));
        return new TitanOctetString(result);
    }

    public TitanOctetString xor4b(TitanOctetString other_value) {
        this.must_bound("Left operand of operator xor4b is an unbound octetstring element.");
        other_value.must_bound("Right operand of operator xor4b is an unbound octetstring value.");
        if (other_value.get_value().length != 1) {
            throw new TtcnError("The octetstring operands of operator xor4b must have the same length.");
        }
        byte result = (byte)(this.str_val.get_nibble(this.nibble_pos) ^ other_value.get_nibble(0));
        return new TitanOctetString(result);
    }

    public TitanOctetString xor4b(TitanOctetString_Element other_value) {
        this.must_bound("Left operand of operator xor4b is an unbound octetstring element.");
        other_value.must_bound("Right operand of operator xor4b is an unbound octetstring element.");
        byte result = (byte)(this.str_val.get_nibble(this.nibble_pos) ^ other_value.str_val.get_nibble(other_value.nibble_pos));
        return new TitanOctetString(result);
    }

    public TitanOctetString shift_left(int shift_count) {
        this.must_bound("Unbound octetstring element operand of shift left operator.");
        if (shift_count == 0) {
            return new TitanOctetString(this);
        }
        return new TitanOctetString(0);
    }

    public TitanOctetString shift_left(TitanInteger shift_count) {
        shift_count.must_bound("Unbound right operand of octetstring element shift left operator.");
        return this.shift_left(shift_count.get_int());
    }

    public TitanOctetString shift_right(int shift_count) {
        this.must_bound("Unbound octetstring element operand of shift right operator.");
        if (shift_count == 0) {
            return new TitanOctetString(this);
        }
        return new TitanOctetString(0);
    }

    public TitanOctetString shift_right(TitanInteger shift_count) {
        shift_count.must_bound("Unbound right operand of octetstring element shift right operator.");
        return this.shift_right(shift_count.get_int());
    }

    public TitanOctetString rotate_left(int rotate_count) {
        this.must_bound("Unbound octetstring element operand of rotate left operator.");
        return new TitanOctetString(this);
    }

    public TitanOctetString rotate_left(TitanInteger rotate_count) {
        rotate_count.must_bound("Unbound right operand of octetstring element rotate left operator.");
        return this.rotate_left(rotate_count.get_int());
    }

    public TitanOctetString rotate_right(int rotate_count) {
        this.must_bound("Unbound octetstring element operand of rotate right operator.");
        return new TitanOctetString(this);
    }

    public TitanOctetString rotate_right(TitanInteger rotate_count) {
        rotate_count.must_bound("Unbound right operand of octetstring element rotate left operator.");
        return this.rotate_right(rotate_count.get_int());
    }

    public byte get_nibble() {
        return this.str_val.get_nibble(this.nibble_pos);
    }

    public void log() {
        if (this.bound_flag) {
            TTCN_Logger.log_char('\'');
            TTCN_Logger.log_octet(this.str_val.get_nibble(this.nibble_pos));
            TTCN_Logger.log_event_str("'O");
        } else {
            TTCN_Logger.log_event_unbound();
        }
    }
}

