/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.search.FieldDeclarationMatch;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.internal.compiler.ast.CompactConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.search.matching.DOMASTNodeUtils;
import org.eclipse.jdt.internal.core.search.matching.DeclarationOfAccessedFieldsPattern;
import org.eclipse.jdt.internal.core.search.matching.FieldPattern;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.jdt.internal.core.search.matching.VariableLocator;
import org.eclipse.jdt.internal.core.search.matching.VariablePattern;

public class FieldLocator
extends VariableLocator {
    protected boolean isDeclarationOfAccessedFieldsPattern;

    public FieldLocator(FieldPattern pattern) {
        super(pattern);
        this.isDeclarationOfAccessedFieldsPattern = this.pattern instanceof DeclarationOfAccessedFieldsPattern;
    }

    @Override
    protected int fineGrain() {
        return this.pattern.fineGrain;
    }

    @Override
    public int match(org.eclipse.jdt.internal.compiler.ast.ASTNode node, MatchingNodeSet nodeSet) {
        int declarationsLevel = 0;
        if (this.pattern.findReferences && node instanceof ImportReference) {
            ImportReference importRef = (ImportReference)node;
            int length = importRef.tokens.length - 1;
            if (importRef.isStatic() && (importRef.bits & 0x20000) == 0 && this.matchesName(this.pattern.name, importRef.tokens[length])) {
                char[][] compoundName = new char[length][];
                System.arraycopy(importRef.tokens, 0, compoundName, 0, length);
                FieldPattern fieldPattern = (FieldPattern)this.pattern;
                char[] declaringType = CharOperation.concat((char[])fieldPattern.declaringQualification, (char[])fieldPattern.declaringSimpleName, (char)'.');
                if (this.matchesName(declaringType, CharOperation.concatWith((char[][])compoundName, (char)'.'))) {
                    declarationsLevel = this.pattern.mustResolve ? 2 : 3;
                }
            }
        }
        return nodeSet.addMatch(node, declarationsLevel);
    }

    @Override
    public int match(ASTNode node, MatchingNodeSet nodeSet, MatchLocator locator) {
        VariablePattern variablePattern;
        ImportDeclaration importRef;
        int declarationsLevel = 0;
        if (node instanceof EnumConstantDeclaration) {
            EnumConstantDeclaration enumConstant = (EnumConstantDeclaration)node;
            return this.match(enumConstant, nodeSet);
        }
        if (this.pattern.findReferences && node instanceof ImportDeclaration && (importRef = (ImportDeclaration)node).isStatic() && !importRef.isOnDemand() && this.matchesName(this.pattern.name, importRef.getName().toString().toCharArray()) && (variablePattern = this.pattern) instanceof FieldPattern) {
            FieldPattern fieldPattern = (FieldPattern)variablePattern;
            char[] declaringType = CharOperation.concat((char[])fieldPattern.declaringQualification, (char[])fieldPattern.declaringSimpleName, (char)'.');
            if (this.matchesName(declaringType, importRef.getName().toString().toCharArray())) {
                declarationsLevel = this.pattern.mustResolve ? 2 : 3;
            }
        }
        return nodeSet.addMatch(node, declarationsLevel);
    }

    @Override
    public int match(org.eclipse.jdt.internal.compiler.ast.FieldDeclaration node, MatchingNodeSet nodeSet) {
        int referencesLevel = 0;
        if (this.pattern.findReferences && this.pattern.writeAccess && !this.pattern.readAccess && node.initialization != null && this.matchesName(this.pattern.name, node.name)) {
            referencesLevel = this.pattern.mustResolve ? 2 : 3;
        }
        int declarationsLevel = 0;
        if (this.pattern.findDeclarations) {
            switch (node.getKind()) {
                case 1: 
                case 3: {
                    if (!this.matchesName(this.pattern.name, node.name) || !this.matchesTypeReference(((FieldPattern)this.pattern).typeSimpleName, node.type)) break;
                    declarationsLevel = this.pattern.mustResolve ? 2 : 3;
                }
            }
        }
        return nodeSet.addMatch((org.eclipse.jdt.internal.compiler.ast.ASTNode)node, referencesLevel >= declarationsLevel ? referencesLevel : declarationsLevel);
    }

    @Override
    public int match(VariableDeclaration node, MatchingNodeSet nodeSet, MatchLocator locator) {
        VariablePattern variablePattern;
        if (!this.pattern.findDeclarations && !this.isDeclarationOfAccessedFieldsPattern) {
            return 0;
        }
        if (node.getLocationInParent() != FieldDeclaration.FRAGMENTS_PROPERTY) {
            return 0;
        }
        int referencesLevel = 0;
        if (this.pattern.findReferences && this.pattern.writeAccess && !this.pattern.readAccess && node.getInitializer() != null && this.matchesName(this.pattern.name, node.getName().getIdentifier().toCharArray())) {
            referencesLevel = this.pattern.mustResolve ? 2 : 3;
        }
        int declarationsLevel = 0;
        if ((this.pattern.findDeclarations || this.isDeclarationOfAccessedFieldsPattern) && this.matchesName(this.pattern.name, node.getName().getIdentifier().toCharArray()) && (variablePattern = this.pattern) instanceof FieldPattern) {
            FieldPattern fieldPattern = (FieldPattern)variablePattern;
            if (this.matchesTypeReference(fieldPattern.typeSimpleName, ((FieldDeclaration)node.getParent()).getType())) {
                declarationsLevel = this.pattern.mustResolve ? 2 : 3;
            }
        }
        return nodeSet.addMatch(node, referencesLevel >= declarationsLevel ? referencesLevel : declarationsLevel);
    }

    private int match(EnumConstantDeclaration node, MatchingNodeSet nodeSet) {
        VariablePattern variablePattern;
        int referencesLevel = 0;
        if (this.pattern.findReferences && this.pattern.writeAccess && !this.pattern.readAccess && this.matchesName(this.pattern.name, node.getName().getIdentifier().toCharArray())) {
            referencesLevel = this.pattern.mustResolve ? 2 : 3;
        }
        int declarationsLevel = 0;
        if (this.pattern.findDeclarations && this.matchesName(this.pattern.name, node.getName().getIdentifier().toCharArray()) && (variablePattern = this.pattern) instanceof FieldPattern) {
            FieldPattern fieldPattern = (FieldPattern)variablePattern;
            if (this.matchesName(fieldPattern.typeSimpleName, ((EnumDeclaration)node.getParent()).getName().getIdentifier().toCharArray())) {
                declarationsLevel = this.pattern.mustResolve ? 2 : 3;
            }
        }
        return nodeSet.addMatch(node, referencesLevel >= declarationsLevel ? referencesLevel : declarationsLevel);
    }

    @Override
    protected int matchContainer() {
        if (this.pattern.findReferences || this.pattern.fineGrain != 0) {
            return 15;
        }
        return 2;
    }

    private int matchLocal(LocalVariableBinding field, boolean matchName) {
        if (field == null) {
            return 1;
        }
        if (matchName && !this.matchesName(this.pattern.name, field.readableName())) {
            return 0;
        }
        FieldPattern fieldPattern = (FieldPattern)this.pattern;
        int declaringLevel = this.resolveLevelForType(fieldPattern.declaringSimpleName, fieldPattern.declaringQualification, (TypeBinding)field.getEnclosingMethod().declaringClass);
        return declaringLevel;
    }

    protected int matchField(FieldBinding field, boolean matchName) {
        int typeLevel;
        if (field == null) {
            return 1;
        }
        if (matchName && !this.matchesName(this.pattern.name, field.readableName())) {
            return 0;
        }
        FieldPattern fieldPattern = (FieldPattern)this.pattern;
        ReferenceBinding receiverBinding = field.declaringClass;
        if (receiverBinding == null) {
            if (field == ArrayBinding.ArrayLength) {
                return fieldPattern.declaringQualification == null && fieldPattern.declaringSimpleName == null ? 3 : 0;
            }
            return 1;
        }
        int declaringLevel = this.resolveLevelForType(fieldPattern.declaringSimpleName, fieldPattern.declaringQualification, (TypeBinding)receiverBinding);
        if (declaringLevel == 0) {
            return 0;
        }
        if (fieldPattern.declaringSimpleName == null) {
            return declaringLevel;
        }
        FieldBinding fieldBinding = field;
        if (field instanceof ParameterizedFieldBinding) {
            fieldBinding = ((ParameterizedFieldBinding)field).originalField;
        }
        return declaringLevel > (typeLevel = this.resolveLevelForType(fieldBinding.type)) ? typeLevel : declaringLevel;
    }

    protected int matchField(IVariableBinding field, boolean matchName) {
        VariablePattern variablePattern;
        int ret;
        if (field == null) {
            return 1;
        }
        if (!field.isField()) {
            return 0;
        }
        if (matchName && !this.matchesName(this.pattern.name, field.getName().toCharArray())) {
            return 0;
        }
        FieldPattern fieldPattern = (FieldPattern)this.pattern;
        ITypeBinding receiverBinding = field.getDeclaringClass();
        if (receiverBinding == null) {
            if (field == ArrayBinding.ArrayLength) {
                return fieldPattern.declaringQualification == null && fieldPattern.declaringSimpleName == null ? 3 : 0;
            }
            int mode = fieldPattern.getMatchMode();
            if (mode == 0) {
                return 0;
            }
            return 1;
        }
        int declaringLevel = this.resolveLevelForType(fieldPattern.declaringSimpleName, fieldPattern.declaringQualification, receiverBinding);
        if (declaringLevel == 0) {
            return 0;
        }
        if (fieldPattern.declaringSimpleName == null) {
            VariablePattern variablePattern2;
            if (this.isDeclarationOfAccessedFieldsPattern && (variablePattern2 = this.pattern) instanceof DeclarationOfAccessedFieldsPattern) {
                DeclarationOfAccessedFieldsPattern doafp = (DeclarationOfAccessedFieldsPattern)variablePattern2;
                IJavaElement je = field.getJavaElement();
                if (je != null) {
                    doafp.knownFields.add((Object)je);
                }
            } else {
                return declaringLevel;
            }
            return 0;
        }
        int typeLevel = this.resolveLevelForType(field.getType());
        int n = ret = declaringLevel > typeLevel ? typeLevel : declaringLevel;
        if (this.isDeclarationOfAccessedFieldsPattern && (variablePattern = this.pattern) instanceof DeclarationOfAccessedFieldsPattern) {
            DeclarationOfAccessedFieldsPattern doafp = (DeclarationOfAccessedFieldsPattern)variablePattern;
            IJavaElement je = field.getJavaElement();
            if (je != null) {
                doafp.knownFields.add((Object)je);
            }
        } else {
            return ret;
        }
        return 0;
    }

    @Override
    protected void matchLevelAndReportImportRef(ImportReference importRef, Binding binding, MatchLocator locator) throws CoreException {
        if (importRef.isStatic() && binding instanceof FieldBinding) {
            super.matchLevelAndReportImportRef(importRef, binding, locator);
        }
    }

    @Override
    protected int matchReference(Reference node, MatchingNodeSet nodeSet, boolean writeOnlyAccess) {
        if (node instanceof FieldReference) {
            if (this.matchesName(this.pattern.name, ((FieldReference)node).token)) {
                return nodeSet.addMatch((org.eclipse.jdt.internal.compiler.ast.ASTNode)node, this.pattern.mustResolve ? 2 : 3);
            }
            return 0;
        }
        return super.matchReference(node, nodeSet, writeOnlyAccess);
    }

    @Override
    protected void matchReportReference(org.eclipse.jdt.internal.compiler.ast.ASTNode reference, IJavaElement element, Binding elementBinding, int accuracy, MatchLocator locator) throws CoreException {
        this.matchReportReference(reference, element, null, null, elementBinding, accuracy, locator);
    }

    @Override
    public int match(Name name, MatchingNodeSet nodeSet, MatchLocator locator) {
        if (this.pattern.findDeclarations) {
            return 0;
        }
        if (this.matchesName(this.pattern.name, name.toString().toCharArray())) {
            VariablePattern variablePattern;
            if (this.isDeclarationOfAccessedFieldsPattern && (variablePattern = this.pattern) instanceof DeclarationOfAccessedFieldsPattern) {
                DeclarationOfAccessedFieldsPattern doafp = (DeclarationOfAccessedFieldsPattern)variablePattern;
                if (doafp.enclosingElement != null) {
                    IJavaElement je;
                    if (!DOMASTNodeUtils.isWithinRange(name, doafp.enclosingElement)) {
                        return 0;
                    }
                    IBinding b = name.resolveBinding();
                    IJavaElement iJavaElement = je = b == null ? null : b.getJavaElement();
                    if (je != null && doafp.knownFields.includes((Object)je)) {
                        doafp.knownFields.remove((Object)je);
                        ISourceReference sr = je instanceof ISourceReference ? (ISourceReference)((Object)je) : null;
                        IResource r = null;
                        ISourceRange srg = null;
                        String elName = je.getElementName();
                        try {
                            srg = sr.getSourceRange();
                            IJavaElement ancestor = je.getAncestor(5);
                            r = ancestor == null ? null : ancestor.getCorrespondingResource();
                        }
                        catch (JavaModelException ancestor) {
                            // empty catch block
                        }
                        if (srg != null) {
                            int accuracy = this.pattern.mustResolve ? 2 : 3;
                            FieldDeclarationMatch fdMatch = new FieldDeclarationMatch(je, accuracy, srg.getOffset() + srg.getLength() - elName.length() - 1, elName.length(), locator.getParticipant(), r);
                            try {
                                locator.report(fdMatch);
                            }
                            catch (CoreException coreException) {
                                // empty catch block
                            }
                        }
                    }
                    return 0;
                }
            }
            return nodeSet.addMatch(name, this.pattern.mustResolve ? 2 : 3);
        }
        return 0;
    }

    @Override
    protected void matchReportReference(org.eclipse.jdt.internal.compiler.ast.ASTNode reference, IJavaElement element, IJavaElement localElement, IJavaElement[] otherElements, Binding elementBinding, int accuracy, MatchLocator locator) throws CoreException {
        if (this.isDeclarationOfAccessedFieldsPattern) {
            if (accuracy != 0) {
                return;
            }
            DeclarationOfAccessedFieldsPattern declPattern = (DeclarationOfAccessedFieldsPattern)this.pattern;
            while (element != null && !declPattern.enclosingElement.equals(element)) {
                element = element.getParent();
            }
            if (element != null) {
                if (reference instanceof FieldReference) {
                    this.reportDeclaration(((FieldReference)reference).binding, locator, declPattern.knownFields);
                } else if (reference instanceof QualifiedNameReference) {
                    QualifiedNameReference qNameRef = (QualifiedNameReference)reference;
                    Binding nameBinding = qNameRef.binding;
                    if (nameBinding instanceof FieldBinding) {
                        this.reportDeclaration((FieldBinding)nameBinding, locator, declPattern.knownFields);
                    }
                    int otherMax = qNameRef.otherBindings == null ? 0 : qNameRef.otherBindings.length;
                    int i = 0;
                    while (i < otherMax) {
                        this.reportDeclaration(qNameRef.otherBindings[i], locator, declPattern.knownFields);
                        ++i;
                    }
                } else if (reference instanceof SingleNameReference && ((SingleNameReference)reference).binding instanceof FieldBinding) {
                    this.reportDeclaration((FieldBinding)((SingleNameReference)reference).binding, locator, declPattern.knownFields);
                }
            }
        } else if (reference instanceof ImportReference) {
            ImportReference importRef = (ImportReference)reference;
            long[] positions = importRef.sourcePositions;
            int lastIndex = importRef.tokens.length - 1;
            int start = (int)(positions[lastIndex] >>> 32);
            int end = (int)positions[lastIndex];
            this.match = locator.newFieldReferenceMatch(element, localElement, elementBinding, accuracy, start, end - start + 1, (org.eclipse.jdt.internal.compiler.ast.ASTNode)importRef);
            locator.report(this.match);
        } else if (reference instanceof FieldReference) {
            FieldReference fieldReference = (FieldReference)reference;
            long position = fieldReference.nameSourcePosition;
            int start = (int)(position >>> 32);
            int end = (int)position;
            this.match = locator.newFieldReferenceMatch(element, localElement, elementBinding, accuracy, start, end - start + 1, (org.eclipse.jdt.internal.compiler.ast.ASTNode)fieldReference);
            locator.report(this.match);
        } else if (reference instanceof SingleNameReference) {
            int offset = reference.sourceStart;
            this.match = locator.newFieldReferenceMatch(element, localElement, elementBinding, accuracy, offset, reference.sourceEnd - offset + 1, reference);
            locator.report(this.match);
        } else if (reference instanceof QualifiedNameReference) {
            int indexOfFirstFieldBinding;
            QualifiedNameReference qNameRef = (QualifiedNameReference)reference;
            int length = qNameRef.tokens.length;
            SearchMatch[] matches = new SearchMatch[length];
            Binding nameBinding = qNameRef.binding;
            int n = indexOfFirstFieldBinding = qNameRef.indexOfFirstFieldBinding > 0 ? qNameRef.indexOfFirstFieldBinding - 1 : 0;
            if (this.matchesName(this.pattern.name, qNameRef.tokens[indexOfFirstFieldBinding]) && !(nameBinding instanceof LocalVariableBinding)) {
                FieldBinding fieldBinding;
                FieldBinding fieldBinding2 = fieldBinding = nameBinding instanceof FieldBinding ? (FieldBinding)nameBinding : null;
                if (fieldBinding == null) {
                    matches[indexOfFirstFieldBinding] = locator.newFieldReferenceMatch(element, localElement, elementBinding, accuracy, -1, -1, reference);
                } else {
                    switch (this.matchField(fieldBinding, false)) {
                        case 3: {
                            matches[indexOfFirstFieldBinding] = locator.newFieldReferenceMatch(element, localElement, elementBinding, 0, -1, -1, reference);
                            break;
                        }
                        case 1: {
                            this.match = locator.newFieldReferenceMatch(element, localElement, elementBinding, 1, -1, -1, reference);
                            if (fieldBinding.type != null && fieldBinding.type.isParameterizedType() && this.pattern.hasTypeArguments()) {
                                this.updateMatch((ParameterizedTypeBinding)fieldBinding.type, this.pattern.getTypeArguments(), locator);
                            }
                            matches[indexOfFirstFieldBinding] = this.match;
                        }
                    }
                }
            }
            int i = indexOfFirstFieldBinding + 1;
            while (i < length) {
                char[] token = qNameRef.tokens[i];
                if (this.matchesName(this.pattern.name, token)) {
                    FieldBinding otherBinding;
                    FieldBinding fieldBinding = otherBinding = qNameRef.otherBindings == null ? null : qNameRef.otherBindings[i - (indexOfFirstFieldBinding + 1)];
                    if (otherBinding == null) {
                        matches[i] = locator.newFieldReferenceMatch(element, localElement, elementBinding, accuracy, -1, -1, reference);
                    } else {
                        switch (this.matchField(otherBinding, false)) {
                            case 3: {
                                matches[i] = locator.newFieldReferenceMatch(element, localElement, elementBinding, 0, -1, -1, reference);
                                break;
                            }
                            case 1: {
                                this.match = locator.newFieldReferenceMatch(element, localElement, elementBinding, 1, -1, -1, reference);
                                if (otherBinding.type != null && otherBinding.type.isParameterizedType() && this.pattern.hasTypeArguments()) {
                                    this.updateMatch((ParameterizedTypeBinding)otherBinding.type, this.pattern.getTypeArguments(), locator);
                                }
                                matches[i] = this.match;
                            }
                        }
                    }
                }
                ++i;
            }
            locator.reportAccurateFieldReference(matches, qNameRef);
        }
    }

    @Override
    protected void updateMatch(ParameterizedTypeBinding parameterizedBinding, char[][][] patternTypeArguments, MatchLocator locator) {
        if (locator.unitScope == null) {
            return;
        }
        this.updateMatch(parameterizedBinding, patternTypeArguments, false, 0, locator);
        if (!this.match.isExact()) {
            this.match.setRule(0);
        }
    }

    protected void reportDeclaration(FieldBinding fieldBinding, MatchLocator locator, SimpleSet knownFields) throws CoreException {
        if (fieldBinding == ArrayBinding.ArrayLength) {
            return;
        }
        ReferenceBinding declaringClass = fieldBinding.declaringClass;
        IType type = locator.lookupType(declaringClass);
        if (type == null) {
            return;
        }
        char[] bindingName = fieldBinding.name;
        IField field = type.getField(new String(bindingName));
        if (knownFields.addIfNotIncluded((Object)field) == null) {
            return;
        }
        IResource resource = type.getResource();
        boolean isBinary = type.isBinary();
        IBinaryType info = null;
        if (isBinary) {
            if (resource == null) {
                resource = type.getJavaProject().getProject();
            }
            info = locator.getBinaryInfo((ClassFile)type.getClassFile(), resource);
            locator.reportBinaryMemberDeclaration(resource, field, (Binding)fieldBinding, info, 0);
        } else {
            ClassScope scope;
            if (declaringClass instanceof ParameterizedTypeBinding) {
                declaringClass = ((ParameterizedTypeBinding)declaringClass).genericType();
            }
            if ((scope = ((SourceTypeBinding)declaringClass).scope) != null) {
                TypeDeclaration typeDecl = scope.referenceContext;
                org.eclipse.jdt.internal.compiler.ast.FieldDeclaration fieldDecl = null;
                org.eclipse.jdt.internal.compiler.ast.FieldDeclaration[] fieldDecls = typeDecl.fields;
                int length = fieldDecls == null ? 0 : fieldDecls.length;
                int i = 0;
                while (i < length) {
                    if (CharOperation.equals((char[])bindingName, (char[])fieldDecls[i].name)) {
                        fieldDecl = fieldDecls[i];
                        break;
                    }
                    ++i;
                }
                if (fieldDecl != null) {
                    int offset = fieldDecl.sourceStart;
                    this.match = new FieldDeclarationMatch(((JavaElement)((Object)field)).resolved((Binding)fieldBinding), 0, offset, fieldDecl.sourceEnd - offset + 1, locator.getParticipant(), resource);
                    locator.report(this.match);
                }
            }
        }
    }

    @Override
    protected int referenceType() {
        return 8;
    }

    @Override
    public int resolveLevel(org.eclipse.jdt.internal.compiler.ast.ASTNode possiblelMatchingNode) {
        if (this.pattern.findReferences || this.pattern.fineGrain != 0) {
            if (possiblelMatchingNode instanceof FieldReference) {
                return this.matchField(((FieldReference)possiblelMatchingNode).binding, true);
            }
            if (possiblelMatchingNode instanceof NameReference) {
                return this.resolveLevel((NameReference)possiblelMatchingNode);
            }
        }
        if (possiblelMatchingNode instanceof org.eclipse.jdt.internal.compiler.ast.FieldDeclaration) {
            return this.matchField(((org.eclipse.jdt.internal.compiler.ast.FieldDeclaration)possiblelMatchingNode).binding, true);
        }
        return 0;
    }

    @Override
    public int resolveLevel(Binding binding) {
        if (binding == null) {
            return 1;
        }
        if (binding instanceof LocalVariableBinding && ((LocalVariableBinding)binding).declaringScope.referenceContext() instanceof CompactConstructorDeclaration) {
            return this.matchLocal((LocalVariableBinding)binding, true);
        }
        if (!(binding instanceof FieldBinding)) {
            return 0;
        }
        return this.matchField((FieldBinding)binding, true);
    }

    @Override
    public int resolveLevel(ASTNode node, IBinding binding, MatchLocator locator) {
        if (binding == null) {
            return 1;
        }
        if (binding instanceof IVariableBinding) {
            IVariableBinding variableBinding = (IVariableBinding)binding;
            if (variableBinding.isRecordComponent()) {
                if (!this.matchesName(this.pattern.name, variableBinding.getName().toCharArray())) {
                    return 0;
                }
                FieldPattern fieldPattern = (FieldPattern)this.pattern;
                return this.resolveLevelForType(fieldPattern.declaringSimpleName, fieldPattern.declaringQualification, variableBinding.getDeclaringMethod().getDeclaringClass());
            }
            if (variableBinding.isField()) {
                return this.matchField(variableBinding, true);
            }
        }
        return 0;
    }

    protected int resolveLevel(NameReference nameRef) {
        if (nameRef instanceof SingleNameReference) {
            return this.resolveLevel(nameRef.binding);
        }
        Binding binding = nameRef.binding;
        QualifiedNameReference qNameRef = (QualifiedNameReference)nameRef;
        FieldBinding fieldBinding = null;
        if (binding instanceof FieldBinding) {
            int level;
            fieldBinding = (FieldBinding)binding;
            char[] bindingName = fieldBinding.name;
            int lastDot = CharOperation.lastIndexOf((char)'.', (char[])bindingName);
            if (lastDot > -1) {
                bindingName = CharOperation.subarray((char[])bindingName, (int)(lastDot + 1), (int)bindingName.length);
            }
            if (this.matchesName(this.pattern.name, bindingName) && (level = this.matchField(fieldBinding, false)) != 0) {
                return level;
            }
        }
        int otherMax = qNameRef.otherBindings == null ? 0 : qNameRef.otherBindings.length;
        int i = 0;
        while (i < otherMax) {
            FieldBinding otherBinding;
            int level;
            char[] token = qNameRef.tokens[i + qNameRef.indexOfFirstFieldBinding];
            if (this.matchesName(this.pattern.name, token) && (level = this.matchField(otherBinding = qNameRef.otherBindings[i], false)) != 0) {
                return level;
            }
            ++i;
        }
        return 0;
    }

    protected int resolveLevelForType(TypeBinding typeBinding) {
        FieldPattern fieldPattern = (FieldPattern)this.pattern;
        TypeBinding fieldTypeBinding = typeBinding;
        if (fieldTypeBinding != null && fieldTypeBinding.isParameterizedType()) {
            fieldTypeBinding = typeBinding.erasure();
        }
        return this.resolveLevelForType(fieldPattern.typeSimpleName, fieldPattern.typeQualification, fieldPattern.getTypeArguments(), 0, fieldTypeBinding);
    }

    protected int resolveLevelForType(ITypeBinding typeBinding) {
        FieldPattern fieldPattern = (FieldPattern)this.pattern;
        ITypeBinding fieldTypeBinding = typeBinding;
        if (fieldTypeBinding != null && fieldTypeBinding.isParameterizedType()) {
            fieldTypeBinding = typeBinding.getErasure();
        }
        int fieldNameMatch = this.resolveLevelForType(fieldPattern.typeSimpleName, fieldPattern.typeQualification, fieldTypeBinding);
        return fieldNameMatch;
    }
}

