/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist;

import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.internal.codeassist.ExpectedTypes;

class DOMCompletionContext
extends CompletionContext {
    private final int offset;
    private final char[] token;
    private final IJavaElement enclosingElement;
    private final Supplier<Stream<IBinding>> bindingsAcquirer;
    private final ExpectedTypes expectedTypes;
    private boolean inJavadoc = false;
    private final ASTNode node;

    DOMCompletionContext(int offset, char[] token, IJavaElement enclosingElement, Supplier<Stream<IBinding>> bindingHaver, ExpectedTypes expectedTypes, ASTNode node) {
        this.offset = offset;
        this.enclosingElement = enclosingElement;
        this.token = token;
        this.bindingsAcquirer = bindingHaver;
        this.expectedTypes = expectedTypes;
        this.node = node;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public char[] getToken() {
        return this.token;
    }

    @Override
    public boolean isInJavadoc() {
        return this.inJavadoc;
    }

    public void setInJavadoc(boolean inJavadoc) {
        this.inJavadoc = inJavadoc;
    }

    @Override
    public IJavaElement getEnclosingElement() {
        return this.enclosingElement;
    }

    @Override
    public IJavaElement[] getVisibleElements(String typeSignature) {
        return (IJavaElement[])this.bindingsAcquirer.get().filter(binding -> DOMCompletionContext.matchesSignature(binding, typeSignature)).map(binding -> binding.getJavaElement()).filter(obj -> obj != null).toArray(IJavaElement[]::new);
    }

    public static boolean matchesSignature(IBinding binding, String typeSignature) {
        if (typeSignature == null) {
            return binding instanceof IVariableBinding || binding instanceof IMethodBinding;
        }
        if (binding instanceof IVariableBinding) {
            IVariableBinding variableBinding = (IVariableBinding)binding;
            return DOMCompletionContext.castCompatable(variableBinding.getType(), typeSignature);
        }
        if (binding instanceof IMethodBinding) {
            IMethodBinding methodBinding = (IMethodBinding)binding;
            return DOMCompletionContext.castCompatable(methodBinding.getReturnType(), typeSignature);
        }
        return false;
    }

    @Override
    public char[][] getExpectedTypesKeys() {
        return (char[][])this.expectedTypes.getExpectedTypes().stream().map(IBinding::getKey).map(String::toCharArray).toArray(n -> new char[n][]);
    }

    @Override
    public boolean isExtended() {
        return true;
    }

    @Override
    public int getTokenLocation() {
        ASTNode parent = this.node;
        while (parent != null) {
            if (parent instanceof ImportDeclaration) {
                return 8;
            }
            if (parent instanceof ClassInstanceCreation) {
                return 4;
            }
            if (parent instanceof Block) {
                return 2;
            }
            if (parent instanceof AbstractTypeDeclaration) {
                return 1;
            }
            parent = parent.getParent();
        }
        return super.getTokenLocation();
    }

    @Override
    public int getTokenStart() {
        return this.node.getStartPosition();
    }

    @Override
    public int getTokenEnd() {
        return this.node.getStartPosition() + this.node.getLength() - 1;
    }

    @Override
    public int getTokenKind() {
        if (this.node instanceof Name) {
            return 1;
        }
        if (this.node instanceof StringLiteral) {
            return 2;
        }
        return super.getTokenKind();
    }

    public boolean canUseDiamond(String[] parameterTypes, char[][] typeVariables) {
        char[][] expectedTypekeys = this.getExpectedTypesKeys();
        if (expectedTypekeys == null || expectedTypekeys.length == 0) {
            return true;
        }
        if (typeVariables != null) {
            String[] stringArray = parameterTypes;
            int n = parameterTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String parameterType = stringArray[n2];
                char[][] cArray = typeVariables;
                int n3 = typeVariables.length;
                int n4 = 0;
                while (n4 < n3) {
                    char[] typeVariable = cArray[n4];
                    if (CharOperation.equals((char[])parameterType.toCharArray(), (char[])typeVariable)) {
                        return false;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return true;
    }

    public boolean canUseDiamond(String[] parameterTypes, char[] fullyQualifiedTypeName) {
        IBinding iBinding;
        IBinding guessedType = null;
        char[][] expectedTypekeys = this.getExpectedTypesKeys();
        if (expectedTypekeys == null || expectedTypekeys.length == 0) {
            return true;
        }
        Optional<IBinding> potentialMatch = this.bindingsAcquirer.get().filter(binding -> {
            char[][] cArray2 = expectedTypekeys;
            int n = expectedTypekeys.length;
            int n2 = 0;
            while (n2 < n) {
                char[] expectedTypekey = cArray2[n2];
                if (CharOperation.equals((char[])expectedTypekey, (char[])binding.getKey().toCharArray())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }).findFirst();
        if (potentialMatch.isPresent() && (iBinding = potentialMatch.get()) instanceof ITypeBinding) {
            ITypeBinding match = (ITypeBinding)iBinding;
            guessedType = match;
        }
        if (guessedType != null && !guessedType.isRecovered()) {
            guessedType = guessedType.getErasure();
            ITypeBinding[] typeVars = guessedType.getTypeParameters();
            String[] stringArray = parameterTypes;
            int n = parameterTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String parameterType = stringArray[n2];
                ITypeBinding[] iTypeBindingArray = typeVars;
                int n3 = typeVars.length;
                int n4 = 0;
                while (n4 < n3) {
                    ITypeBinding typeVar = iTypeBindingArray[n4];
                    if (CharOperation.equals((char[])parameterType.toCharArray(), (char[])typeVar.getName().toCharArray())) {
                        return false;
                    }
                    ++n4;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    private static boolean castCompatable(ITypeBinding typeBinding, String sig2) {
        String sig1 = typeBinding.getKey().replace('/', '.');
        String sig1Raw = new String(Signature.getTypeErasure(sig1.toCharArray()));
        switch (sig1) {
            case "J": {
                return sig2.equals("J") || sig2.equals("D") || sig2.equals("F");
            }
            case "I": {
                return sig2.equals("J") || sig2.equals("I") || sig2.equals("D") || sig2.equals("F");
            }
            case "B": {
                return sig2.equals("J") || sig2.equals("I") || sig2.equals("B") || sig2.equals("D") || sig2.equals("F");
            }
            case "D": 
            case "F": {
                return sig2.equals("D") || sig2.equals("F");
            }
        }
        if (sig1.equals(sig2) || sig1Raw.equals(sig2)) {
            return true;
        }
        if (typeBinding.getSuperclass() != null && DOMCompletionContext.castCompatable(typeBinding.getSuperclass(), sig2)) {
            return true;
        }
        ITypeBinding[] iTypeBindingArray = typeBinding.getInterfaces();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding superInterface = iTypeBindingArray[n2];
            if (DOMCompletionContext.castCompatable(superInterface, sig2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

