/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.runner;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Vector;
import org.eclipse.jdt.internal.junit.runner.DefaultClassifier;
import org.eclipse.jdt.internal.junit.runner.FirstRunExecutionListener;
import org.eclipse.jdt.internal.junit.runner.IClassifiesThrowables;
import org.eclipse.jdt.internal.junit.runner.ITestIdentifier;
import org.eclipse.jdt.internal.junit.runner.ITestLoader;
import org.eclipse.jdt.internal.junit.runner.ITestReference;
import org.eclipse.jdt.internal.junit.runner.IVisitsTestTrees;
import org.eclipse.jdt.internal.junit.runner.JUnitMessages;
import org.eclipse.jdt.internal.junit.runner.MessageSender;
import org.eclipse.jdt.internal.junit.runner.RerunExecutionListener;
import org.eclipse.jdt.internal.junit.runner.TestExecution;
import org.eclipse.jdt.internal.junit.runner.TestIdMap;
import org.eclipse.jdt.internal.junit.runner.junit3.JUnit3TestLoader;

public class RemoteTestRunner
implements MessageSender,
IVisitsTestTrees {
    public static final String RERAN_FAILURE = "FAILURE";
    public static final String RERAN_ERROR = "ERROR";
    public static final String RERAN_OK = "OK";
    private String[] fTestClassNames;
    private String fTestName;
    private String[] fPackageNames;
    private String fUniqueId;
    private String[][] fIncludeExcludeTags = new String[2][];
    private TestExecution fExecution;
    private Socket fClientSocket;
    private PrintWriter fWriter;
    private BufferedReader fReader;
    private String fHost = "";
    private int fPort = -1;
    private boolean fDebugMode = false;
    private boolean fKeepAlive = false;
    private boolean fStopped = false;
    private Vector<RerunRequest> fRerunRequests = new Vector(10);
    private ReaderThread fReaderThread;
    private String fRerunTest;
    private final TestIdMap fIds = new TestIdMap();
    private String[] fFailureNames;
    private ITestLoader fLoader;
    private MessageSender fSender;
    private boolean fConsoleMode = false;

    public RemoteTestRunner() {
        this.setMessageSender(this);
    }

    public void setMessageSender(MessageSender sender) {
        this.fSender = sender;
    }

    public static void main(String[] args) {
        try {
            try {
                RemoteTestRunner testRunServer = new RemoteTestRunner();
                testRunServer.init(args);
                testRunServer.run();
            }
            catch (Throwable e) {
                e.printStackTrace();
                System.exit(0);
            }
        }
        finally {
            System.exit(0);
        }
    }

    protected void init(String[] args) {
        this.defaultInit(args);
    }

    protected ClassLoader getTestClassLoader() {
        return this.getClass().getClassLoader();
    }

    protected final void defaultInit(String[] args) {
        int i = 0;
        while (i < args.length) {
            if ("-classnames".equalsIgnoreCase(args[i]) || "-classname".equalsIgnoreCase(args[i])) {
                Vector<String> list = new Vector<String>();
                int j = i + 1;
                while (j < args.length) {
                    if (args[j].startsWith("-")) break;
                    list.add(args[j]);
                    ++j;
                }
                this.fTestClassNames = list.toArray(new String[list.size()]);
            } else if ("-test".equalsIgnoreCase(args[i])) {
                String testName = args[i + 1];
                int p = testName.indexOf(58);
                if (p == -1) {
                    throw new IllegalArgumentException("Testname not separated by '%'");
                }
                this.fTestName = testName.substring(p + 1);
                this.fTestClassNames = new String[]{testName.substring(0, p)};
                ++i;
            } else if ("-testnamefile".equalsIgnoreCase(args[i])) {
                String testNameFile = args[i + 1];
                try {
                    this.readTestNames(testNameFile);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Cannot read testname file.");
                }
                ++i;
            } else if ("-packagenamefile".equalsIgnoreCase(args[i])) {
                String pkgNameFile = args[i + 1];
                try {
                    this.readPackageNames(pkgNameFile);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Cannot read packagename file.");
                }
                ++i;
            } else if ("-testfailures".equalsIgnoreCase(args[i])) {
                String testFailuresFile = args[i + 1];
                try {
                    this.readFailureNames(testFailuresFile);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Cannot read testfailures file.");
                }
                ++i;
            } else if ("-port".equalsIgnoreCase(args[i])) {
                this.fPort = Integer.parseInt(args[i + 1]);
                ++i;
            } else if ("-host".equalsIgnoreCase(args[i])) {
                this.fHost = args[i + 1];
                ++i;
            } else if ("-rerun".equalsIgnoreCase(args[i])) {
                this.fRerunTest = args[i + 1];
                ++i;
            } else if ("-keepalive".equalsIgnoreCase(args[i])) {
                this.fKeepAlive = true;
            } else if ("-debugging".equalsIgnoreCase(args[i]) || "-debug".equalsIgnoreCase(args[i])) {
                this.fDebugMode = true;
            } else if ("-junitconsole".equalsIgnoreCase(args[i])) {
                this.fConsoleMode = true;
            } else if ("-testloaderclass".equalsIgnoreCase(args[i])) {
                String className = args[i + 1];
                this.createLoader(className);
                ++i;
            } else if ("-uniqueid".equalsIgnoreCase(args[i])) {
                this.fUniqueId = args[i + 1];
                ++i;
            } else if ("--include-tag".equalsIgnoreCase(args[i])) {
                String[] includeTags = this.fIncludeExcludeTags[0];
                if (includeTags == null) {
                    includeTags = new String[]{args[i + 1]};
                } else {
                    String[] tags = new String[includeTags.length + 1];
                    System.arraycopy(includeTags, 0, tags, 0, includeTags.length);
                    tags[includeTags.length] = args[i + 1];
                    includeTags = tags;
                }
                this.fIncludeExcludeTags[0] = includeTags;
                ++i;
            } else if ("--exclude-tag".equalsIgnoreCase(args[i])) {
                String[] excludeTags = this.fIncludeExcludeTags[1];
                if (excludeTags == null) {
                    excludeTags = new String[]{args[i + 1]};
                } else {
                    String[] tags = new String[excludeTags.length + 1];
                    System.arraycopy(excludeTags, 0, tags, 0, excludeTags.length);
                    tags[excludeTags.length] = args[i + 1];
                    excludeTags = tags;
                }
                this.fIncludeExcludeTags[1] = excludeTags;
                ++i;
            }
            ++i;
        }
        if (this.getTestLoader() == null) {
            this.initDefaultLoader();
        }
        if (this.fTestClassNames == null || this.fTestClassNames.length == 0) {
            if (this.fPackageNames == null || this.fPackageNames.length == 0) {
                throw new IllegalArgumentException(JUnitMessages.getString("RemoteTestRunner.error.classnamemissing"));
            }
            this.fTestClassNames = new String[0];
        }
        if (this.fPort == -1) {
            throw new IllegalArgumentException(JUnitMessages.getString("RemoteTestRunner.error.portmissing"));
        }
        if (this.fDebugMode) {
            System.out.println("keepalive " + this.fKeepAlive);
        }
    }

    public void initDefaultLoader() {
        this.createLoader(JUnit3TestLoader.class.getName());
    }

    public void createLoader(String className) {
        this.setLoader(this.createRawTestLoader(className));
    }

    protected ITestLoader createRawTestLoader(String className) {
        try {
            return (ITestLoader)this.loadTestLoaderClass(className).newInstance();
        }
        catch (Exception e) {
            StringWriter trace = new StringWriter();
            e.printStackTrace(new PrintWriter(trace));
            String message = JUnitMessages.getFormattedString("RemoteTestRunner.error.invalidloader", new Object[]{className, trace.toString()});
            throw new IllegalArgumentException(message);
        }
    }

    protected Class<?> loadTestLoaderClass(String className) throws ClassNotFoundException {
        return Class.forName(className);
    }

    public void setLoader(ITestLoader newInstance) {
        this.fLoader = newInstance;
    }

    private String[] readLines(String fileName) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(fileName)), StandardCharsets.UTF_8));){
            String line;
            Vector<String> list = new Vector<String>();
            while ((line = br.readLine()) != null) {
                list.add(line);
            }
            return list.toArray(new String[list.size()]);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void readPackageNames(String pkgNameFile) throws IOException {
        this.fPackageNames = this.readLines(pkgNameFile);
        if (this.fDebugMode) {
            System.out.println("Packages:");
            String[] stringArray = this.fPackageNames;
            int n = this.fPackageNames.length;
            int n2 = 0;
            while (n2 < n) {
                String fPackageName = stringArray[n2];
                System.out.println("    " + fPackageName);
                ++n2;
            }
        }
    }

    private void readTestNames(String testNameFile) throws IOException {
        this.fTestClassNames = this.readLines(testNameFile);
        if (this.fDebugMode) {
            System.out.println("Tests:");
            String[] stringArray = this.fTestClassNames;
            int n = this.fTestClassNames.length;
            int n2 = 0;
            while (n2 < n) {
                String fTestClassName = stringArray[n2];
                System.out.println("    " + fTestClassName);
                ++n2;
            }
        }
    }

    private void readFailureNames(String testFailureFile) throws IOException {
        this.fFailureNames = this.readLines(testFailureFile);
        if (this.fDebugMode) {
            System.out.println("Failures:");
            String[] stringArray = this.fFailureNames;
            int n = this.fFailureNames.length;
            int n2 = 0;
            while (n2 < n) {
                String fFailureName = stringArray[n2];
                System.out.println("    " + fFailureName);
                ++n2;
            }
        }
    }

    protected void run() {
        if (!this.connect()) {
            return;
        }
        if (this.fRerunTest != null) {
            this.rerunTest(new RerunRequest(Integer.parseInt(this.fRerunTest), this.fTestClassNames[0], this.fTestName));
            return;
        }
        FirstRunExecutionListener listener = this.firstRunExecutionListener();
        this.fExecution = new TestExecution(listener, this.getClassifier());
        this.runTests(this.fExecution);
        if (this.fKeepAlive) {
            this.waitForReruns();
        }
        this.shutDown();
    }

    public FirstRunExecutionListener firstRunExecutionListener() {
        return new FirstRunExecutionListener(this.fSender, this.fIds);
    }

    private synchronized void waitForReruns() {
        while (!this.fStopped) {
            try {
                this.wait();
                if (this.fStopped || this.fRerunRequests.size() <= 0) continue;
                RerunRequest r = this.fRerunRequests.remove(0);
                this.rerunTest(r);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void runFailed(String message, Exception exception) {
        System.err.println(message);
        if (exception != null) {
            exception.printStackTrace(System.err);
        }
    }

    protected Class<?>[] loadClasses(String[] testClassNames) {
        Vector classes = new Vector();
        String[] stringArray = testClassNames;
        int n = testClassNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Class<?> clazz = this.loadClass(name, this);
            if (clazz != null) {
                classes.add(clazz);
            }
            ++n2;
        }
        return classes.toArray(new Class[classes.size()]);
    }

    protected void notifyListenersOfTestEnd(TestExecution execution, long elapsedTime) {
        if (execution == null || execution.shouldStop()) {
            this.notifyTestRunStopped(elapsedTime);
        } else {
            this.notifyTestRunEnded(elapsedTime);
        }
    }

    private void runTests(String[] testClassNames, String testName, TestExecution execution) {
        ITestReference[] suites = this.fLoader.loadTests(this.loadClasses(testClassNames), testName, this.fFailureNames, this.fPackageNames, this.fIncludeExcludeTags, this.fUniqueId, this);
        int count = this.countTests(suites);
        this.notifyTestRunStarted(count);
        this.sendTrees(suites);
        long testStartTime = System.nanoTime();
        execution.run(suites);
        long elapsedTime = (System.nanoTime() - testStartTime) / 1000000L;
        this.notifyListenersOfTestEnd(execution, elapsedTime);
    }

    private void sendTrees(ITestReference[] suites) {
        long startTime = System.currentTimeMillis();
        if (this.fDebugMode) {
            System.out.print("start send tree...");
        }
        ITestReference[] iTestReferenceArray = suites;
        int n = suites.length;
        int n2 = 0;
        while (n2 < n) {
            ITestReference suite = iTestReferenceArray[n2];
            suite.sendTree(this);
            ++n2;
        }
        if (this.fDebugMode) {
            System.out.println("done send tree - time(ms): " + (System.currentTimeMillis() - startTime));
        }
    }

    private int countTests(ITestReference[] tests) {
        int count = 0;
        ITestReference[] iTestReferenceArray = tests;
        int n = tests.length;
        int n2 = 0;
        while (n2 < n) {
            ITestReference test = iTestReferenceArray[n2];
            if (test != null) {
                count += test.countTestCases();
            }
            ++n2;
        }
        return count;
    }

    public void rerunTest(RerunRequest r) {
        Class<?>[] classes = this.loadClasses(new String[]{r.fRerunClassName});
        ITestReference rerunTest1 = this.fLoader.loadTests(classes, r.fRerunTestName, null, null, this.fIncludeExcludeTags, this.fUniqueId, this)[0];
        RerunExecutionListener service = this.rerunExecutionListener();
        TestExecution execution = new TestExecution(service, this.getClassifier());
        ITestReference[] suites = new ITestReference[]{rerunTest1};
        execution.run(suites);
        this.notifyRerunComplete(r, service.getStatus());
    }

    public RerunExecutionListener rerunExecutionListener() {
        return new RerunExecutionListener(this.fSender, this.fIds);
    }

    protected IClassifiesThrowables getClassifier() {
        return new DefaultClassifier();
    }

    @Override
    public void visitTreeEntry(ITestIdentifier identifier, boolean hasChildren, int testCount, boolean isDynamicTest, String parentId) {
        String treeEntry = String.valueOf(this.getTestId(identifier)) + ',' + RemoteTestRunner.escapeText(identifier.getName()) + ',' + hasChildren + ',' + testCount + ',' + isDynamicTest + ',' + parentId + ',' + RemoteTestRunner.escapeText(identifier.getDisplayName()) + ',' + RemoteTestRunner.escapeText(identifier.getParameterTypes()) + ',' + RemoteTestRunner.escapeText(identifier.getUniqueId());
        this.notifyTestTreeEntry(treeEntry);
    }

    public static String escapeText(String s) {
        if (s.indexOf(44) < 0 && s.indexOf(92) < 0 && s.indexOf(13) < 0 && s.indexOf(10) < 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() + 10);
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case ',': {
                    sb.append("\\,");
                    break;
                }
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                case '\r': {
                    if (i + 1 < s.length() && s.charAt(i + 1) == '\n') {
                        ++i;
                    }
                    sb.append(' ');
                    break;
                }
                case '\n': {
                    sb.append(' ');
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public String getTestId(ITestIdentifier id) {
        return this.fIds.getTestId(id);
    }

    protected void stop() {
        if (this.fExecution != null) {
            this.fExecution.stop();
        }
    }

    protected boolean connect() {
        if (this.fConsoleMode) {
            this.fClientSocket = null;
            this.fWriter = new PrintWriter(System.out);
            this.fReader = new BufferedReader(new InputStreamReader(System.in));
            this.fReaderThread = new ReaderThread();
            this.fReaderThread.start();
            return true;
        }
        if (this.fDebugMode) {
            System.out.println("RemoteTestRunner: trying to connect" + this.fHost + ":" + this.fPort);
        }
        IOException exception = null;
        int i = 1;
        while (i < 20) {
            try {
                this.fClientSocket = new Socket(this.fHost, this.fPort);
                try {
                    this.fWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.fClientSocket.getOutputStream(), StandardCharsets.UTF_8)), false);
                }
                catch (UnsupportedEncodingException e1) {
                    this.fWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.fClientSocket.getOutputStream())), false);
                }
                try {
                    this.fReader = new BufferedReader(new InputStreamReader(this.fClientSocket.getInputStream(), StandardCharsets.UTF_8));
                }
                catch (UnsupportedEncodingException e1) {
                    this.fReader = new BufferedReader(new InputStreamReader(this.fClientSocket.getInputStream()));
                }
                this.fReaderThread = new ReaderThread();
                this.fReaderThread.start();
                return true;
            }
            catch (IOException e) {
                exception = e;
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
            }
        }
        this.runFailed(JUnitMessages.getFormattedString("RemoteTestRunner.error.connect", new String[]{this.fHost, Integer.toString(this.fPort)}), exception);
        return false;
    }

    private void shutDown() {
        block9: {
            block8: {
                if (this.fWriter != null) {
                    this.fWriter.close();
                    this.fWriter = null;
                }
                try {
                    if (this.fReaderThread != null) {
                        this.fReaderThread.interrupt();
                    }
                    if (this.fReader != null) {
                        this.fReader.close();
                        this.fReader = null;
                    }
                }
                catch (IOException e) {
                    if (!this.fDebugMode) break block8;
                    e.printStackTrace();
                }
            }
            try {
                if (this.fClientSocket != null) {
                    this.fClientSocket.close();
                    this.fClientSocket = null;
                }
            }
            catch (IOException e) {
                if (!this.fDebugMode) break block9;
                e.printStackTrace();
            }
        }
    }

    @Override
    public void sendMessage(String msg) {
        if (this.fWriter == null) {
            return;
        }
        this.fWriter.println(msg);
    }

    protected void notifyTestRunStarted(int testCount) {
        this.fSender.sendMessage("%TESTC  " + testCount + " " + "v2");
    }

    private void notifyTestRunEnded(long elapsedTime) {
        this.fSender.sendMessage("%RUNTIME" + elapsedTime);
        this.fSender.flush();
    }

    protected void notifyTestRunStopped(long elapsedTime) {
        this.fSender.sendMessage("%TSTSTP " + elapsedTime);
        this.fSender.flush();
    }

    protected void notifyTestTreeEntry(String treeEntry) {
        this.fSender.sendMessage("%TSTTREE" + treeEntry);
    }

    public void notifyRerunComplete(RerunRequest r, String status) {
        if (this.fPort != -1) {
            this.fSender.sendMessage("%TSTRERN" + r.fRerunTestId + " " + r.fRerunClassName + " " + r.fRerunTestName + " " + status);
            this.fSender.flush();
        }
    }

    @Override
    public void flush() {
        this.fWriter.flush();
    }

    private void runTests(TestExecution execution) {
        this.runTests(this.fTestClassNames, this.fTestName, execution);
    }

    public ITestLoader getTestLoader() {
        return this.fLoader;
    }

    public Class<?> loadClass(String className, RemoteTestRunner listener) {
        Class<?> clazz = null;
        try {
            clazz = this.getTestClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            listener.runFailed(JUnitMessages.getFormattedString("RemoteTestRunner.error.classnotfound", className), e);
        }
        return clazz;
    }

    static /* synthetic */ BufferedReader access$0(RemoteTestRunner remoteTestRunner) {
        return remoteTestRunner.fReader;
    }

    static /* synthetic */ void access$1(RemoteTestRunner remoteTestRunner, boolean bl) {
        remoteTestRunner.fStopped = bl;
    }

    static /* synthetic */ Vector access$2(RemoteTestRunner remoteTestRunner) {
        return remoteTestRunner.fRerunRequests;
    }

    private class ReaderThread
    extends Thread {
        public ReaderThread() {
            super("ReaderThread");
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 8[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private static class RerunRequest {
        String fRerunClassName;
        String fRerunTestName;
        int fRerunTestId;

        public RerunRequest(int testId, String className, String testName) {
            this.fRerunTestId = testId;
            this.fRerunClassName = className;
            this.fRerunTestName = testName;
        }
    }
}

