/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac;

import com.sun.tools.javac.api.ClientCodeWrapper;
import com.sun.tools.javac.file.FSInfo;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.util.Context;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.FileSystem;
import java.nio.file.spi.FileSystemProvider;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.tools.JavaFileManager;
import org.eclipse.core.runtime.ILog;
import org.eclipse.jdt.internal.javac.ZipFileSystemProviderWithCache;

public class CachingJarsJavaFileManager
extends JavacFileManager {
    private static final ZipFileSystemProviderWithCache zipCache = new ZipFileSystemProviderWithCache();

    public static void preRegister(Context context) {
        context.put(FSInfo.class, new FSInfo(){

            @Override
            public synchronized FileSystemProvider getJarFSProvider() {
                return zipCache;
            }
        });
        context.put(ClientCodeWrapper.class, new ClientCodeWrapper(context){

            @Override
            protected boolean isTrusted(Object o) {
                return super.isTrusted(o) || o.getClass().getClassLoader() == CachingJarsJavaFileManager.class.getClassLoader();
            }
        });
        context.put(JavaFileManager.class, c -> new CachingJarsJavaFileManager(c));
    }

    public CachingJarsJavaFileManager(Context context) {
        super(context, true, null);
        zipCache.register(this);
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.locations.close();
        this.resetOutputFilesWritten();
        zipCache.closeFileManager(System.identityHashCode(this));
    }

    Collection<FileSystem> listFilesystemsInArchiveContainers() {
        HashSet<FileSystem> res = new HashSet<FileSystem>();
        try {
            Field containerField = JavacFileManager.class.getDeclaredField("containers");
            containerField.setAccessible(true);
            Iterator iterator = containerField.get(this);
            if (iterator instanceof Map) {
                Map containersMap = (Map)((Object)iterator);
                for (Object o : containersMap.values()) {
                    if (!o.getClass().getName().equals(JavacFileManager.class.getName() + "$ArchiveContainer")) continue;
                    Field filesystemField = o.getClass().getDeclaredField("fileSystem");
                    filesystemField.setAccessible(true);
                    Object object = filesystemField.get(o);
                    if (!(object instanceof FileSystem)) continue;
                    FileSystem fs = (FileSystem)object;
                    res.add(fs);
                }
            }
        }
        catch (Exception ex) {
            ILog.get().error(ex.getMessage(), (Throwable)ex);
        }
        return res;
    }
}

