/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.ui.launcher;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swtbot.generator.framework.IRecorderDialog;
import org.eclipse.swtbot.generator.ui.GeneratorExtensionPointManager;
import org.eclipse.swtbot.generator.ui.Messages;

public class TestRecorderWizardPage
extends WizardPage {
    private ComboViewer combo;
    private Composite container;
    private Button newInstance;
    private Button currentInstance;

    protected TestRecorderWizardPage() {
        super(Messages.recorderDialogTitle);
        this.setDescription(Messages.recorderDescription);
        this.setTitle(Messages.recorderDialogTitle);
        URL imageUrl = null;
        try {
            imageUrl = new URL("platform:/plugin/org.eclipse.swtbot.generator/icons/swtbot_rec64.png");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        if (imageUrl != null) {
            this.setImageDescriptor(ImageDescriptor.createFromURL((URL)imageUrl));
        }
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.container.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        Label label1 = new Label(this.container, 0);
        label1.setText(Messages.recorderDialog);
        this.combo = new ComboViewer(this.container, 12);
        List dialogs = GeneratorExtensionPointManager.loadDialogs();
        this.combo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.combo.getControl().setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.combo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IRecorderDialog)element).getName();
            }
        });
        this.combo.setInput((Object)dialogs);
        this.combo.setSelection((ISelection)new StructuredSelection(dialogs.get(0)));
        Group eclipseGroup = new Group(this.container, 0);
        eclipseGroup.setText(Messages.eclipseGroup);
        layout = new GridLayout();
        eclipseGroup.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 2, true, false);
        gridData.horizontalSpan = 2;
        eclipseGroup.setLayoutData((Object)gridData);
        this.currentInstance = new Button((Composite)eclipseGroup, 16);
        this.currentInstance.setText(Messages.currentEclipseInstance);
        this.currentInstance.setSelection(true);
        this.newInstance = new Button((Composite)eclipseGroup, 16);
        this.newInstance.setText(Messages.newEclipseInstance);
        this.hookListeners();
        this.setControl((Control)this.container);
        this.setPageComplete(true);
    }

    private void hookListeners() {
        this.combo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                IStructuredSelection selection = (IStructuredSelection)arg0.getSelection();
                if (!selection.isEmpty()) {
                    TestRecorderWizardPage.this.setPageComplete(true);
                } else {
                    TestRecorderWizardPage.this.setPageComplete(false);
                }
            }
        });
    }

    public String getSelectedDialogId() {
        ISelection selection = this.combo.getSelection();
        if (!selection.isEmpty()) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            return ((IRecorderDialog)structuredSelection.getFirstElement()).getId();
        }
        return null;
    }

    public String getSelectedDialogName() {
        ISelection selection = this.combo.getSelection();
        if (!selection.isEmpty()) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            return ((IRecorderDialog)structuredSelection.getFirstElement()).getName();
        }
        return null;
    }

    public boolean runNewInstance() {
        return this.newInstance.getSelection();
    }
}

