/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.oprofile.launch.configuration;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.oprofile.core.Oprofile;
import org.eclipse.linuxtools.oprofile.core.OprofileCorePlugin;
import org.eclipse.linuxtools.oprofile.core.daemon.OpEvent;
import org.eclipse.linuxtools.oprofile.core.daemon.OpUnitMask;
import org.eclipse.linuxtools.oprofile.launch.OprofileLaunchMessages;
import org.eclipse.linuxtools.oprofile.launch.OprofileLaunchPlugin;
import org.eclipse.linuxtools.oprofile.launch.configuration.OprofileCounter;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class OprofileEventConfigTab
extends AbstractLaunchConfigurationTab {
    protected Button _defaultEventCheck;
    protected OprofileCounter[] _counters = OprofileCounter.getCounters(null);
    protected CounterSubTab[] _counterSubTabs;

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        this.setControl((Control)top);
        top.setLayout((Layout)new GridLayout());
        if (this.getTimerMode()) {
            Label timerModeLabel = new Label(top, 16384);
            timerModeLabel.setText(OprofileLaunchMessages.getString("tab.event.timermode.no.options"));
        } else {
            this.createVerticalSpacer(top, 1);
            this._defaultEventCheck = new Button(top, 32);
            this._defaultEventCheck.setText(OprofileLaunchMessages.getString("tab.event.defaultevent.button.text"));
            this._defaultEventCheck.setLayoutData((Object)new GridData());
            this._defaultEventCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    OprofileEventConfigTab.this._handleEnabledToggle();
                }
            });
            this.createVerticalSpacer(top, 1);
            OprofileCounter[] counters = OprofileCounter.getCounters(null);
            TabItem[] counterTabs = new TabItem[counters.length];
            this._counterSubTabs = new CounterSubTab[counters.length];
            TabFolder tabFolder = new TabFolder(top, 0);
            tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
            int i = 0;
            while (i < counters.length) {
                CounterSubTab currentTab;
                Composite c = new Composite((Composite)tabFolder, 0);
                this._counterSubTabs[i] = currentTab = new CounterSubTab(c, counters[i]);
                counterTabs[i] = new TabItem(tabFolder, 0);
                counterTabs[i].setControl((Control)c);
                counterTabs[i].setText(String.valueOf(OprofileLaunchMessages.getString("tab.event.counterTab.counterText")) + String.valueOf(i));
                ++i;
            }
        }
    }

    public void initializeFrom(ILaunchConfiguration config) {
        if (!this.getTimerMode()) {
            try {
                int i = 0;
                while (i < this._counters.length) {
                    this._counters[i].loadConfiguration(config);
                    ++i;
                }
                CounterSubTab[] counterSubTabArray = this._counterSubTabs;
                int n = this._counterSubTabs.length;
                int n2 = 0;
                while (n2 < n) {
                    CounterSubTab tab = counterSubTabArray[n2];
                    tab.initializeTab(config);
                    ++n2;
                }
                boolean enabledState = config.getAttribute("org.eclipse.linuxtools.oprofile.launch.oprofile.USE_DEFAULT_EVENT", true);
                this._defaultEventCheck.setSelection(enabledState);
                this.setEnabledState(!enabledState);
                this.updateLaunchConfigurationDialog();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isValid(ILaunchConfiguration config) {
        boolean valid;
        int numEnabledEvents;
        block9: {
            if (this.getTimerMode()) {
                return true;
            }
            numEnabledEvents = 0;
            valid = true;
            try {
                if (config.getAttribute("org.eclipse.linuxtools.oprofile.launch.oprofile.USE_DEFAULT_EVENT", false)) {
                    numEnabledEvents = 1;
                    break block9;
                }
                OprofileCounter[] counters = new OprofileCounter[this.getNumberOfCounters()];
                int i = 0;
                while (i < counters.length) {
                    counters[i] = new OprofileCounter(i);
                    counters[i].loadConfiguration(config);
                    if (counters[i].getEnabled()) {
                        ++numEnabledEvents;
                        if (counters[i].getEvent() == null) {
                            valid = false;
                            break;
                        }
                        int min = counters[i].getEvent().getMinCount();
                        if (counters[i].getCount() < min) {
                            valid = false;
                            break;
                        }
                        if (!this.checkEventSetupValidity(counters[i].getNumber(), counters[i].getEvent().getText(), counters[i].getEvent().getUnitMask().getMaskValue())) {
                            valid = false;
                            break;
                        }
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return numEnabledEvents > 0 && valid;
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        if (this.getTimerMode()) {
            config.setAttribute("org.eclipse.linuxtools.oprofile.launch.oprofile.USE_DEFAULT_EVENT", true);
        } else {
            config.setAttribute("org.eclipse.linuxtools.oprofile.launch.oprofile.USE_DEFAULT_EVENT", this._defaultEventCheck.getSelection());
            CounterSubTab[] counterSubTabArray = this._counterSubTabs;
            int n = this._counterSubTabs.length;
            int n2 = 0;
            while (n2 < n) {
                CounterSubTab cst = counterSubTabArray[n2];
                cst.performApply(config);
                ++n2;
            }
        }
        try {
            config.doSave();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        boolean useDefault = true;
        int i = 0;
        while (i < this._counters.length) {
            this._counters[i].saveConfiguration(config);
            if (this._counters[i].getEnabled()) {
                useDefault = false;
            }
            ++i;
        }
        config.setAttribute("org.eclipse.linuxtools.oprofile.launch.oprofile.USE_DEFAULT_EVENT", useDefault);
        try {
            config.doSave();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public String getName() {
        return OprofileLaunchMessages.getString("tab.event.name");
    }

    public Image getImage() {
        return OprofileLaunchPlugin.getImageDescriptor("icons/event_tab.gif").createImage();
    }

    private void _handleEnabledToggle() {
        this.setEnabledState(!this._defaultEventCheck.getSelection());
        this.updateLaunchConfigurationDialog();
    }

    private void setEnabledState(boolean state) {
        CounterSubTab[] counterSubTabArray = this._counterSubTabs;
        int n = this._counterSubTabs.length;
        int n2 = 0;
        while (n2 < n) {
            CounterSubTab cst = counterSubTabArray[n2];
            cst.setEnabledState(state);
            ++n2;
        }
    }

    protected boolean checkEventSetupValidity(int counter, String name, int maskValue) {
        return OprofileLaunchPlugin.getCache().checkEvent(counter, name, maskValue);
    }

    protected boolean getTimerMode() {
        return Oprofile.getTimerMode();
    }

    protected int getNumberOfCounters() {
        return Oprofile.getNumberOfCounters();
    }

    protected class CounterSubTab {
        private Button _enabledCheck;
        private Button _profileKernelCheck;
        private Button _profileUserCheck;
        private Label _countTextLabel;
        private Text _countText;
        private Label _eventDescLabel;
        private Text _eventDescText;
        private UnitMaskViewer _unitMaskViewer;
        private ListViewer _eventList;
        private OprofileCounter _counter;
        private ScrolledComposite _scrolledTop;
        private Composite _tabTopContainer;

        public CounterSubTab(Composite parent, OprofileCounter counter) {
            this._counter = counter;
            parent.setLayout((Layout)new GridLayout());
            ScrolledComposite scrolledContainer = new ScrolledComposite(parent, 768);
            scrolledContainer.setLayoutData((Object)new GridData(4, 4, true, true));
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            scrolledContainer.setLayout((Layout)layout);
            scrolledContainer.setExpandHorizontal(true);
            scrolledContainer.setExpandVertical(true);
            Composite tabTopContainer = new Composite((Composite)scrolledContainer, 0);
            scrolledContainer.setContent((Control)tabTopContainer);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            tabTopContainer.setLayout((Layout)layout);
            tabTopContainer.setLayoutData((Object)new GridData(4, 4, true, true));
            Composite topCellComp = new Composite(tabTopContainer, 0);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            topCellComp.setLayout((Layout)layout);
            topCellComp.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
            this.createTopCell(topCellComp);
            OprofileEventConfigTab.this.createVerticalSpacer(tabTopContainer, 2);
            Composite eventListComp = new Composite(tabTopContainer, 0);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            eventListComp.setLayout((Layout)layout);
            this.createLeftCell(eventListComp);
            Composite eventConfigComp = new Composite(tabTopContainer, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            eventConfigComp.setLayout((Layout)layout);
            eventConfigComp.setLayoutData((Object)new GridData(4, 4, true, false));
            this.createRightCell(eventConfigComp);
            GridData data = new GridData(4, 4, false, true);
            data.heightHint = eventConfigComp.getSize().x;
            eventListComp.setLayoutData((Object)data);
            this._scrolledTop = scrolledContainer;
            this._tabTopContainer = tabTopContainer;
        }

        private void createTopCell(Composite parent) {
            this._enabledCheck = new Button(parent, 32);
            this._enabledCheck.setText(OprofileLaunchMessages.getString("tab.event.counterSettings.enabled.button.text"));
            this._enabledCheck.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
            this._enabledCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    CounterSubTab.this._counter.setEnabled(CounterSubTab.this._enabledCheck.getSelection());
                    CounterSubTab.this._setEnabledState(CounterSubTab.this._counter.getEnabled());
                    OprofileEventConfigTab.this.updateLaunchConfigurationDialog();
                }
            });
            this._enabledCheck.setEnabled(false);
            this._eventDescLabel = new Label(parent, 0);
            this._eventDescLabel.setText(OprofileLaunchMessages.getString("tab.event.eventDescription.label.text"));
            this._eventDescLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this._eventDescText = new Text(parent, 2060);
            this._eventDescText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }

        private void createLeftCell(Composite parent) {
            this._eventList = new ListViewer(parent, 2820);
            this._eventList.getList().setLayoutData((Object)new GridData(16384, 4, false, true));
            this._eventList.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

                public String getText(Object element) {
                    OpEvent e = (OpEvent)element;
                    return e.getText();
                }

                public Image getImage(Object element) {
                    return null;
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            });
            this._eventList.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    OprofileCounter ctr = (OprofileCounter)inputElement;
                    return ctr.getValidEvents();
                }

                public void dispose() {
                }

                public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
                }
            });
            this._eventList.setInput((Object)this._counter);
            this._eventList.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent sce) {
                    CounterSubTab.this._handleEventListSelectionChange();
                }
            });
        }

        private void createRightCell(Composite parent) {
            this._profileKernelCheck = new Button(parent, 32);
            this._profileKernelCheck.setText(OprofileLaunchMessages.getString("tab.event.counterSettings.profileKernel.check.text"));
            this._profileKernelCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    CounterSubTab.this._handleProfileKernelToggle();
                }
            });
            this._profileUserCheck = new Button(parent, 32);
            this._profileUserCheck.setText(OprofileLaunchMessages.getString("tab.event.counterSettings.profileUser.check.text"));
            this._profileUserCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    CounterSubTab.this._handleProfileUserToggle();
                }
            });
            this._countTextLabel = new Label(parent, 0);
            this._countTextLabel.setText(OprofileLaunchMessages.getString("tab.event.counterSettings.count.label.text"));
            this._countText = new Text(parent, 2052);
            this._countText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this._countText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent me) {
                    CounterSubTab.this._handleCountTextModify();
                }
            });
            Composite unitMaskComp = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            unitMaskComp.setLayout((Layout)layout);
            unitMaskComp.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            this._unitMaskViewer = new UnitMaskViewer(unitMaskComp);
        }

        public void initializeTab(ILaunchConfiguration config) {
            this.setEnabledState(false);
            if (config != null) {
                this._counter.loadConfiguration(config);
            }
            boolean enabled = this._counter.getEnabled();
            this._enabledCheck.setSelection(enabled);
            if (this._counter.getEvent() == null) {
                this._counter.setEvent(this._counter.getValidEvents()[0]);
            }
            this._profileKernelCheck.setSelection(this._counter.getProfileKernel());
            this._profileUserCheck.setSelection(this._counter.getProfileUser());
            this._countText.setText(Integer.toString(this._counter.getCount()));
            this._eventDescText.setText(this._counter.getEvent().getTextDescription());
            this._unitMaskViewer.displayEvent(this._counter.getEvent());
            this._eventList.setSelection((ISelection)new StructuredSelection((Object)this._counter.getEvent()));
        }

        public void performApply(ILaunchConfigurationWorkingCopy config) {
            this._counter.saveConfiguration(config);
            try {
                config.doSave();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }

        public void setEnabledState(boolean state) {
            this._enabledCheck.setEnabled(state);
            if (state) {
                this._setEnabledState(this._counter.getEnabled());
            } else {
                this._setEnabledState(false);
            }
        }

        private void _setEnabledState(boolean state) {
            this._profileKernelCheck.setEnabled(state);
            this._profileUserCheck.setEnabled(state);
            this._countText.setEnabled(state);
            this._eventDescText.setEnabled(state);
            this._unitMaskViewer.setEnabled(state);
            this._eventList.getList().setEnabled(state);
        }

        private void _handleEventListSelectionChange() {
            int index = this._eventList.getList().getSelectionIndex();
            if (index != -1) {
                OpEvent event = (OpEvent)this._eventList.getElementAt(index);
                this._counter.setEvent(event);
                this._eventDescText.setText(event.getTextDescription());
                this._unitMaskViewer.displayEvent(event);
                int min = this._counter.getEvent().getMinCount();
                if (this._counter.getCount() < min) {
                    OprofileEventConfigTab.this.setErrorMessage(this.getMinCountErrorMessage(min));
                }
            }
            OprofileEventConfigTab.this.updateLaunchConfigurationDialog();
        }

        private void _handleProfileUserToggle() {
            this._counter.setProfileUser(this._profileUserCheck.getSelection());
            OprofileEventConfigTab.this.updateLaunchConfigurationDialog();
        }

        private void _handleProfileKernelToggle() {
            this._counter.setProfileKernel(this._profileKernelCheck.getSelection());
            OprofileEventConfigTab.this.updateLaunchConfigurationDialog();
        }

        private void _handleCountTextModify() {
            String errorMessage = null;
            try {
                try {
                    int count = Integer.parseInt(this._countText.getText());
                    this._counter.setCount(count);
                    int min = this._counter.getEvent().getMinCount();
                    if (count < min) {
                        errorMessage = this.getMinCountErrorMessage(min);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    errorMessage = OprofileLaunchMessages.getString("tab.event.counterSettings.count.invalid");
                    this._counter.setCount(-1);
                    OprofileEventConfigTab.this.setErrorMessage(errorMessage);
                    OprofileEventConfigTab.this.updateLaunchConfigurationDialog();
                }
            }
            finally {
                OprofileEventConfigTab.this.setErrorMessage(errorMessage);
                OprofileEventConfigTab.this.updateLaunchConfigurationDialog();
            }
        }

        private String getMinCountErrorMessage(int min) {
            String msg = OprofileLaunchMessages.getString("tab.event.counterSettings.count.too-small");
            Object[] args = new Object[]{min};
            return MessageFormat.format(msg, args);
        }

        private void resizeScrollContainer() {
            this._scrolledTop.setMinSize(this._tabTopContainer.computeSize(-1, -1));
        }

        protected class UnitMaskViewer {
            private Label _unitMaskLabel;
            private Composite _top;
            private Composite _maskListComp;
            private Button[] _unitMaskButtons;

            public UnitMaskViewer(Composite parent) {
                this._unitMaskLabel = new Label(parent, 0);
                this._unitMaskLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
                this._unitMaskLabel.setText(OprofileLaunchMessages.getString("unitmaskViewer.label.text"));
                this._unitMaskLabel.setVisible(true);
                Composite top = new Composite(parent, 0);
                top.setLayoutData((Object)new GridData(4, 4, true, true));
                GridLayout layout = new GridLayout();
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                top.setLayout((Layout)layout);
                this._top = top;
                this._maskListComp = null;
                this._unitMaskButtons = null;
            }

            private void _handleToggle(Button maskButton, int index) {
                OpUnitMask mask = CounterSubTab.this._counter.getUnitMask();
                if (mask != null) {
                    if (maskButton.getSelection()) {
                        mask.setMaskFromIndex(index);
                    } else {
                        mask.unSetMaskFromIndex(index);
                    }
                }
                OprofileEventConfigTab.this.updateLaunchConfigurationDialog();
            }

            public void displayEvent(OpEvent oe) {
                OpUnitMask mask = oe.getUnitMask();
                int totalMasks = mask.getNumMasks();
                if (this._maskListComp != null) {
                    this._maskListComp.dispose();
                }
                Composite newMaskComp = new Composite(this._top, 0);
                newMaskComp.setLayout((Layout)new GridLayout());
                newMaskComp.setLayoutData((Object)new GridData(16384, 4, false, true));
                this._maskListComp = newMaskComp;
                mask.setDefaultMaskValue();
                ArrayList<Button> maskButtons = new ArrayList<Button>();
                int i = 0;
                while (i < totalMasks) {
                    Button maskButton;
                    if (mask.getType() == -1) {
                        OprofileCorePlugin.showErrorDialog((String)"opxmlParse", null);
                        return;
                    }
                    if (mask.getType() == 1) {
                        maskButton = new Button(newMaskComp, 16);
                        maskButton.setEnabled(false);
                        maskButton.setText(mask.getText(i));
                        maskButton.setSelection(true);
                    } else {
                        final int maskButtonIndex = i;
                        boolean selected = mask.isMaskSetFromIndex(maskButtonIndex);
                        int buttonType = mask.getType() == 2 ? 16 : 32;
                        maskButton = new Button(newMaskComp, buttonType);
                        maskButton.setEnabled(true);
                        maskButton.setText(mask.getText(i));
                        maskButton.setSelection(selected);
                        maskButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent se) {
                                UnitMaskViewer.this._handleToggle((Button)se.getSource(), maskButtonIndex);
                            }
                        });
                        maskButtons.add(maskButton);
                    }
                    ++i;
                }
                this._unitMaskButtons = new Button[maskButtons.size()];
                maskButtons.toArray(this._unitMaskButtons);
                CounterSubTab.this.resizeScrollContainer();
            }

            public void setEnabled(boolean enabled) {
                if (this._unitMaskButtons != null) {
                    Button[] buttonArray = this._unitMaskButtons;
                    int n = this._unitMaskButtons.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Button b = buttonArray[n2];
                        b.setEnabled(enabled);
                        ++n2;
                    }
                }
            }
        }
    }
}

