/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.SDWidget;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.util.SDMessages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MinMaxDialog
extends Dialog {
    protected Label fMinLabel;
    protected Label fMaxLabel;
    protected Label fScaleLabel;
    protected Label fPrecisionLabel;
    protected Text fMinText;
    protected Text fMaxText;
    protected Text fScaleText;
    protected Text fPrecisionText;
    protected SDWidget fSdWidget;

    public MinMaxDialog(Shell shell, SDWidget viewer) {
        super(shell);
        this.fSdWidget = viewer;
    }

    protected GridData newGridData(int span) {
        GridData data = new GridData(1808);
        data.horizontalSpan = span;
        return data;
    }

    protected Control createDialogArea(Composite p) {
        p.getShell().setText(SDMessages._123);
        Composite parent = (Composite)super.createDialogArea(p);
        GridLayout parentLayout = new GridLayout();
        parentLayout.numColumns = 6;
        parent.setLayout((Layout)parentLayout);
        Group g1 = new Group(parent, 32);
        g1.setLayoutData((Object)this.newGridData(3));
        GridLayout g1layout = new GridLayout();
        g1layout.numColumns = 3;
        g1.setLayout((Layout)g1layout);
        this.fMinLabel = new Label((Composite)g1, 16);
        this.fMinLabel.setText(SDMessages._124);
        this.fMinLabel.setLayoutData((Object)this.newGridData(1));
        this.fMinText = new Text((Composite)g1, 2052);
        this.fMinText.setLayoutData((Object)this.newGridData(2));
        this.fMinText.setText(String.valueOf(this.fSdWidget.getFrame().getMinTime().getValue()));
        this.fMaxLabel = new Label((Composite)g1, 16);
        this.fMaxLabel.setText(SDMessages._125);
        this.fMaxLabel.setLayoutData((Object)this.newGridData(1));
        this.fMaxText = new Text((Composite)g1, 2052);
        this.fMaxText.setLayoutData((Object)this.newGridData(2));
        this.fMaxText.setText(String.valueOf(this.fSdWidget.getFrame().getMaxTime().getValue()));
        this.fScaleLabel = new Label((Composite)g1, 16);
        this.fScaleLabel.setText(SDMessages._136);
        this.fScaleLabel.setLayoutData((Object)this.newGridData(1));
        this.fScaleText = new Text((Composite)g1, 2052);
        this.fScaleText.setLayoutData((Object)this.newGridData(2));
        this.fScaleText.setText(String.valueOf(this.fSdWidget.getFrame().getMinTime().getScale()));
        this.fPrecisionLabel = new Label((Composite)g1, 16);
        this.fPrecisionLabel.setText(SDMessages._137);
        this.fPrecisionLabel.setLayoutData((Object)this.newGridData(1));
        this.fPrecisionText = new Text((Composite)g1, 2052);
        this.fPrecisionText.setLayoutData((Object)this.newGridData(2));
        this.fPrecisionText.setText(String.valueOf(this.fSdWidget.getFrame().getMinTime().getPrecision()));
        return parent;
    }

    protected void okPressed() {
        long min = 0L;
        long max = 0L;
        int scale = 0;
        int precision = 0;
        try {
            min = Long.parseLong(this.fMinText.getText());
            max = Long.parseLong(this.fMaxText.getText());
            scale = Integer.parseInt(this.fScaleText.getText());
            precision = Integer.parseInt(this.fPrecisionText.getText());
            this.fSdWidget.getFrame().setMax((ITmfTimestamp)new TmfTimestamp(max, scale, precision));
            this.fSdWidget.getFrame().setMin((ITmfTimestamp)new TmfTimestamp(min, scale, precision));
            this.fSdWidget.redraw();
            super.okPressed();
        }
        catch (Exception exception) {
            MessageDialog.openError((Shell)this.getShell(), (String)SDMessages._98, (String)SDMessages._99);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.createButton(parent, 1024, SDMessages._126, false);
        this.getButton(1024).addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MinMaxDialog.this.fSdWidget.getFrame().resetCustomMinMax();
                MinMaxDialog.this.fMinText.setText(String.valueOf(MinMaxDialog.this.fSdWidget.getFrame().getMinTime().getValue()));
                MinMaxDialog.this.fMaxText.setText(String.valueOf(MinMaxDialog.this.fSdWidget.getFrame().getMaxTime().getValue()));
                MinMaxDialog.this.fScaleText.setText(String.valueOf(MinMaxDialog.this.fSdWidget.getFrame().getMinTime().getScale()));
                MinMaxDialog.this.fPrecisionText.setText(String.valueOf(MinMaxDialog.this.fSdWidget.getFrame().getMinTime().getPrecision()));
                MinMaxDialog.this.fMaxText.getParent().layout(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }
}

